package com.tydic.dyc.agr.service;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.model.auditorder.AgrAuditOrderDo;
import com.tydic.dyc.agr.model.auditorder.IAgrAuditOrderModel;
import com.tydic.dyc.agr.model.common.AgrCommonOrderDo;
import com.tydic.dyc.agr.model.common.IUocCommonModel;
import com.tydic.dyc.agr.service.agr.AgrCreateAuditOrderServiceExt;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAuditOrderExtReqBO;
import com.tydic.dyc.agr.service.auditorder.bo.AgrCreateAuditOrderReqBO;
import com.tydic.dyc.agr.service.auditorder.bo.AgrCreateAuditOrderRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author yinletian
 * @date 2023/1/31
 */
@HTServiceImpl
public class AgrCreateAuditOrderServiceExtImpl implements AgrCreateAuditOrderServiceExt {
    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Override
    public AgrCreateAuditOrderRspBO createAuditOrder(AgrCreateAuditOrderExtReqBO auditOrderReqBO) {
        //1 参数校验
        this.validateAuditOrder(auditOrderReqBO);
        //2 组装数据
        AgrCommonOrderDo agrAuditOrderDo = JSONObject.parseObject(JSONObject.toJSONString(auditOrderReqBO), AgrCommonOrderDo.class);
        //3 保存数据
        this.iUocCommonModel.createAuditOrder(agrAuditOrderDo);
        AgrCreateAuditOrderRspBO rspBO = AgrRu.success(AgrCreateAuditOrderRspBO.class);
        rspBO.setAuditOrderId(agrAuditOrderDo.getAuditOrderId());
        return rspBO;
    }

    private void validateAuditOrder(AgrCreateAuditOrderExtReqBO auditOrderReqBO) {
        if (ObjectUtil.isEmpty(auditOrderReqBO)) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(auditOrderReqBO.getOrderId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[审批单id]不能为空");
        }
//        if (ObjectUtil.isNotEmpty(auditOrderReqBO.getUocApprovalObj())) {
//            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
//        }
//        auditOrderReqBO.getUocApprovalObj().forEach(
//                (agrUocApprovalObjBo) -> {
//                    if (ObjectUtil.isEmpty(agrUocApprovalObjBo.getObjBusiType())) {
//                        throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[审批对象业务类型]不能为空");
//                    }
//                    if (ObjectUtil.isEmpty(agrUocApprovalObjBo.getObjType())) {
//                        throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[审批对象类型]不能为空");
//                    }
//                    if (ObjectUtil.isEmpty(agrUocApprovalObjBo.getObjId())) {
//                        throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[对象id]不能为空");
//                    }
//                }
//        );

    }
}