package com.tydic.dyc.agr.service;

import com.tydic.dyc.agr.model.procinst.sub.UocTodo;
import com.tydic.dyc.agr.model.common.IUocCommonModel;
import com.tydic.dyc.agr.service.agr.AgrQryTodoListInfoService;
import com.tydic.dyc.agr.service.agr.bo.AgrQryTodoListInfoReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrQryTodoListInfoRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrTodoBo;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author yinletian
 * @date 2023/1/30
 */
@HTServiceImpl
public class AgrQryTodoListInfoServiceImpl implements AgrQryTodoListInfoService {
    @Autowired
    private IUocCommonModel uocCommonModel;
    @Override
    public AgrQryTodoListInfoRspBo qryTodoListInfo(AgrQryTodoListInfoReqBo uocQryTodoListInfoReqBo) {
        UocTodo uocTodo = new UocTodo();
        BeanUtils.copyProperties(uocQryTodoListInfoReqBo,uocTodo);
        List<UocTodo> todoListInfo = uocCommonModel.getTodoListInfo(uocTodo);
        AgrQryTodoListInfoRspBo rspBO = new AgrQryTodoListInfoRspBo();
        if (!CollectionUtils.isEmpty(todoListInfo)){
            List<AgrTodoBo> uocTodoBoList = AgrRu.jsl(todoListInfo, AgrTodoBo.class);
            rspBO.setUocTodoBoList(uocTodoBoList);
        }
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
