package com.tydic.dyc.agr.service;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.model.change.AgrChangeModel;
import com.tydic.dyc.agr.model.change.BkAgrBigChangeItemDataWhileDo;
import com.tydic.dyc.agr.model.log.AgrLogModel;
import com.tydic.dyc.agr.model.log.BkAgrBigDataLogDo;
import com.tydic.dyc.agr.model.log.BkAgrChangeBigDataLogDo;
import com.tydic.dyc.agr.service.agr.AgrAddChangeAgrSyncFromPriceStockService;
import com.tydic.dyc.agr.service.agr.bo.AgrAddChangeAgrSyncFromPriceStockReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAddChangeAgrSyncFromPriceStockRspBO;
import com.tydic.dyc.agr.service.agr.bo.BkAgrMateriaPriceItemBO;
import com.tydic.dyc.agr.utils.IdUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.constants.AgrConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * AGRSBK0008-价格库协议变更同步领域服务
 * @author zhanghengrui
 * @date 2023/1/31 13:44
 */
@HTServiceImpl
@Slf4j
public class AgrAddChangeAgrSyncFromPriceStockServiceImpl implements AgrAddChangeAgrSyncFromPriceStockService {

    @Autowired
    private AgrModel agrModel;
    @Autowired
    private AgrLogModel agrLogModel;
    @Autowired
    private AgrChangeModel agrChangeModel;

    @Override
    public AgrAddChangeAgrSyncFromPriceStockRspBO addChangeAgrSyncFromPriceStock(AgrAddChangeAgrSyncFromPriceStockReqBO agrAddChangeAgrSyncFromPriceStockReqBO) {

        log.info("商品调用入参："+ JSON.toJSONString(agrAddChangeAgrSyncFromPriceStockReqBO));

        // 校验
        BkAgrMainDo agrMainDo = new BkAgrMainDo();
        if (agrAddChangeAgrSyncFromPriceStockReqBO.getSyncType()==1){
            //查询协议是否为自营
            agrMainDo = new BkAgrMainDo();
            agrMainDo.setAgrId(agrAddChangeAgrSyncFromPriceStockReqBO.getAgrId());
            BkAgrMainDo agrMainBO = agrModel.qryMain(agrMainDo);
            if(!AgrConstant.IsAutarky.YES.equals( agrMainBO.getIsAutarky())){
                throw new ZTBusinessException("只有慧采自营才能销售价同步");
            }

        }

        // 校验是否同步完成
        Integer syncNum = agrLogModel.checkSyncStatus1(agrAddChangeAgrSyncFromPriceStockReqBO.getAgrId(), agrAddChangeAgrSyncFromPriceStockReqBO.getBatchUniqueId());

        if (syncNum.equals(agrAddChangeAgrSyncFromPriceStockReqBO.getTotalBatchCount())) throw new ZTBusinessException("同步完成");

        // 保存数据到变更临时表
        List<BkAgrBigChangeItemDataWhileDo> agrBigChangeItemDataWhileDo = new ArrayList<>();
        for (BkAgrMateriaPriceItemBO agrMateriaPriceItemBO : agrAddChangeAgrSyncFromPriceStockReqBO.getAgrMateriaPriceItemBOs()) {
            BkAgrBigChangeItemDataWhileDo bkAgrBigChangeItemDataWhileDo = new BkAgrBigChangeItemDataWhileDo();
            BeanUtils.copyProperties(agrMateriaPriceItemBO,bkAgrBigChangeItemDataWhileDo);
            bkAgrBigChangeItemDataWhileDo.setChangeType(2);
            bkAgrBigChangeItemDataWhileDo.setAgrId(agrAddChangeAgrSyncFromPriceStockReqBO.getAgrId());
            bkAgrBigChangeItemDataWhileDo.setBatchUniqueId(agrAddChangeAgrSyncFromPriceStockReqBO.getBatchUniqueId());
            bkAgrBigChangeItemDataWhileDo.setAgrBigChangeItemDataWhileId(IdUtil.nextId());
            agrBigChangeItemDataWhileDo.add(bkAgrBigChangeItemDataWhileDo);
        }
        agrChangeModel.saveData2Material(agrBigChangeItemDataWhileDo);

        // 日志表增加数据
        BkAgrBigDataLogDo bkAgrBigDataLogDo = new BkAgrBigDataLogDo();
        bkAgrBigDataLogDo.setAgrBigDataLogId(IdUtil.nextId());
        bkAgrBigDataLogDo.setBatchUniqueId(agrAddChangeAgrSyncFromPriceStockReqBO.getBatchUniqueId());
        bkAgrBigDataLogDo.setTotalBatchCount(agrAddChangeAgrSyncFromPriceStockReqBO.getTotalBatchCount());
        bkAgrBigDataLogDo.setNowBatchCount(agrAddChangeAgrSyncFromPriceStockReqBO.getNowBatchCount());
        bkAgrBigDataLogDo.setAgrId(agrAddChangeAgrSyncFromPriceStockReqBO.getAgrId().toString());
        bkAgrBigDataLogDo.setAgrCode(agrMainDo.getAgrCode());
        bkAgrBigDataLogDo.setContractCode(agrMainDo.getAgrCode());
        // 处理完成
        bkAgrBigDataLogDo.setDealStatus("2");
        bkAgrBigDataLogDo.setBatchOperType(agrAddChangeAgrSyncFromPriceStockReqBO.getSyncType()==2?3:4);
        bkAgrBigDataLogDo.setIsSysnEs(1);
        // 是否添加了主体
        bkAgrBigDataLogDo.setIsCopyMain(0);
        bkAgrBigDataLogDo.setCreateName(new Date().toString());
        agrLogModel.addLog(bkAgrBigDataLogDo);

        // 如果批次推送完成，那么写变更表，提供给定时任务同步
        if (syncNum+1==agrAddChangeAgrSyncFromPriceStockReqBO.getTotalBatchCount()){
            BkAgrChangeBigDataLogDo bkAgrChangeBigDataLogDo = new BkAgrChangeBigDataLogDo();
            bkAgrChangeBigDataLogDo.setAgrChangeBigDataLogId(IdUtil.nextId());
            bkAgrChangeBigDataLogDo.setAgrId(agrAddChangeAgrSyncFromPriceStockReqBO.getAgrId());
            // 待处理
            bkAgrChangeBigDataLogDo.setDealStatus("1");
            bkAgrChangeBigDataLogDo.setBatchUniqueId(agrAddChangeAgrSyncFromPriceStockReqBO.getBatchUniqueId());
            bkAgrChangeBigDataLogDo.setBatchOperType(agrAddChangeAgrSyncFromPriceStockReqBO.getSyncType()==2?new Byte("3"):new Byte("4"));
            bkAgrChangeBigDataLogDo.setAgrCode(agrMainDo.getAgrCode());
            bkAgrChangeBigDataLogDo.setContractCode(agrMainDo.getContractCode());
            bkAgrChangeBigDataLogDo.setCreateName(new Date().toString());
            agrLogModel.addChangeLog(bkAgrChangeBigDataLogDo);
        }

        // 同步es

        AgrAddChangeAgrSyncFromPriceStockRspBO rspBO = new AgrAddChangeAgrSyncFromPriceStockRspBO();
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
