package com.tydic.dyc.agr.model.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.common.AgrCommonOrderDo;
import com.tydic.dyc.agr.model.procinst.sub.UocTodo;
import com.tydic.dyc.agr.model.common.IUocCommonModel;

import com.tydic.dyc.agr.repository.AgrAuditOrderExtRepository;
import com.tydic.dyc.agr.repository.UocCommonRepository;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author yinletian
 * @date 2023/1/30
 */
@Service
public class IUocCommonModelImpl implements IUocCommonModel {
    @Autowired
    private UocCommonRepository uocCommonRepository;
    @Autowired
    private AgrAuditOrderExtRepository agrAuditOrderExtRepository;

    @Override
    public int saveTodoInfo(UocTodo uocTodo) {
        if (null == uocTodo) {
            throw new ZTBusinessException( "入参对象不能为空");
        }
        if (null == uocTodo.getTodoId()) {
            throw new ZTBusinessException( "入参待办ID不能为空");
        }
        if (null == uocTodo.getOrderId()) {
            throw new ZTBusinessException( "入参订单ID不能为空");
        }
        if (null == uocTodo.getBusiId()) {
            throw new ZTBusinessException( "入参业务ID不能为空");
        }

        return uocCommonRepository.saveTodoInfo(uocTodo);
    }

    @Override
    public int updateTodoById(UocTodo uocTodo) {
        if (null == uocTodo) {
            throw new ZTBusinessException( "入参对象不能为空");
        }
        //if (null == uocTodo.getTodoId()) {
        //    throw new ZTBusinessException( "入参待办ID不能为空");
        //}
        return uocCommonRepository.updateTodoById(uocTodo);
    }

    @Override
    public UocTodo getTodoInfo(UocTodo uocTodo) {
        if (null == uocTodo) {
            throw new ZTBusinessException( "入参对象不能为空");
        }
        return uocCommonRepository.getTodoInfo(uocTodo);
    }

    @Override
    public List<UocTodo> getTodoListInfo(UocTodo uocTodo) {
        return uocCommonRepository.getTodoListInfo(uocTodo);
    }

    @Override
    public void insertBatchTodo(List<UocTodo> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new ZTBusinessException( "入参对象列表不能为空");
        }
        for (UocTodo uocTodo : list) {
            if (null == uocTodo.getTodoId()) {
                throw new ZTBusinessException( "入参待办ID不能为空");
            }
            if (null == uocTodo.getOrderId()) {
                throw new ZTBusinessException( "入参订单ID不能为空");
            }
            if (null == uocTodo.getBusiId()) {
                throw new ZTBusinessException( "入参业务ID不能为空");
            }
        }
        uocCommonRepository.insertBatchTodo(list);
    }

    @Override
    public void createAuditOrder(AgrCommonOrderDo param0) {
        //1 参数校验
        this.validateAuditOrder(param0);

        // 2 保存审批单数据
        this.agrAuditOrderExtRepository.saveAuditOrder(param0);
    }

    /**
     * 参数校验
     */
    private void validateAuditOrder(AgrCommonOrderDo agrAuditOrderDo) {
        if (ObjectUtil.isEmpty(agrAuditOrderDo.getAuditOrderId())) {
            long agrId = IdUtil.nextId();
            agrAuditOrderDo.setAuditOrderId(agrId);
        }
        if (ObjectUtil.isEmpty(agrAuditOrderDo.getAuditOrderStatus())) {
            //设置默认的审批状态
            agrAuditOrderDo.setAuditOrderStatus(AgrCommConstant.AUDIT_ORDER_STATUS.WAIT_AUDIT);
        }
    }
}
