package com.tydic.dyc.agr.service;

import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.service.agr.AgrQryAgrUseSupListService;
import com.tydic.dyc.agr.service.agr.bo.AgrQryAgrUseSupListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrQryAgrUseSupListRspBO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @description AGRSBK0011-生效协议供应商列表查询领域服务实现类
 * @author Luokan
 * @date 2023/2/14
 **/
@HTServiceImpl
public class AgrQryAgrUseSupListServiceImpl implements AgrQryAgrUseSupListService {

    @Autowired
    private AgrModel agrModel;

    @Override
    public AgrQryAgrUseSupListRspBO qryAgrUseSupList(AgrQryAgrUseSupListReqBO reqBO) {
        AgrQryAgrUseSupListRspBO rsp = this.agrModel.qryAgrUseSupList(reqBO);
        rsp.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rsp.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rsp;
    }
}
