package com.tydic.dyc.agr.service;

import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.model.version.AgrVersionModel;
import com.tydic.dyc.agr.service.agr.AgrCancelAgrSyncService;
import com.tydic.dyc.agr.service.agr.bo.AgrCancelAgrSyncReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrCancelAgrSyncRspBO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.constants.AgrConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author yinletian
 * @date 2023/1/31
 */
@HTServiceImpl
public class AgrCancelAgrSyncServiceImpl implements AgrCancelAgrSyncService {
    @Autowired
    private AgrModel agrModel;
    @Autowired
    private AgrVersionModel agrVersionModel;

    @Override
    public AgrCancelAgrSyncRspBO cancelAgrSync(AgrCancelAgrSyncReqBO reqBO) {
        AgrCancelAgrSyncRspBO rspBO = new AgrCancelAgrSyncRspBO();

        //更新协议状态为已失效，
        BkAgrMainDo bkAgrMainDo = new BkAgrMainDo();
        bkAgrMainDo.setAgrCode(reqBO.getAgrCode());
        bkAgrMainDo.setAgrStatus(AgrConstant.APPROVE_STATUS.EXPIRED);
        agrModel.updateBy(bkAgrMainDo);
        agrVersionModel.updateStatus(reqBO.getAgrId());

        //查询该供应商协议编号下
        BkAgrMainDo mainDo = new BkAgrMainDo();
        mainDo.setAgrCode(reqBO.getAgrCode());
        BkAgrMainDo mainDo1 = agrModel.qryMain(mainDo);
        mainDo.setAgrSupOrgId(mainDo1.getAgrSupOrgId());
        List<BkAgrMainDo> bkAgrMainDos = agrModel.qryEffectAgr(mainDo);
        //是否全部失效
        if(!CollectionUtils.isEmpty(bkAgrMainDos)) rspBO.setAgrFlag(bkAgrMainDos.stream().allMatch(obj -> "EXPIRED".equals(obj.getAgrStatus())));

        reqBO.setOrderId(mainDo1.getAgrId());
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
