package com.tydic.dyc.agr.extService;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.bo.AgrTaskDealRspExtBO;
import com.tydic.dyc.agr.service.agr.AgrTaskDealServiceExt;
import com.tydic.dyc.agr.service.procinst.bo.AgrTaskDealReqBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrTaskDealRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author yinletian
 * @date 2023/3/17
 */
@Slf4j
@HTServiceImpl
public class AgrTaskExtServiceImpl implements AgrTaskExtService{

    @Autowired
    private AgrTaskDealServiceExt agrTaskDealServiceExt;
    @Resource(name = "agrCornJobSyncProvider")
    private ProxyMessageProducer proxyMessageProducer;

    @Override
    public AgrTaskDealRspBO dealTask(AgrTaskDealReqBO param0) {

        AgrTaskDealRspExtBO agrTaskDealRspBO = agrTaskDealServiceExt.dealTask(param0);

        if (agrTaskDealRspBO.getAgrChangeCronJobReqBO()!=null&&null!=agrTaskDealRspBO.getAgrChangeCronJobReqBO().getAgrId()) {
            log.info("发送mq:" + JSON.toJSONString(agrTaskDealRspBO.getAgrChangeCronJobReqBO()));
            ProxySendResult send = proxyMessageProducer.send(new ProxyMessage("AGR_CORN_JOB_TOPIC", "AGR", JSON.toJSONString(agrTaskDealRspBO.getAgrChangeCronJobReqBO())));
            log.info("mq发送完成:" + JSON.toJSONString(send));
        }

        return agrTaskDealRspBO;
    }
}
