package com.tydic.dyc.agr.model.agr.impl;

import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.repository.AgrRepository;
import com.tydic.dyc.agr.service.agr.bo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 协议领域
 * @author zhanghengrui
 * @date 2023/1/30 10:45
 */
@Service
public class AgrModelImpl implements AgrModel {

    @Autowired
    private AgrRepository agrRepository;

    @Override
    public AgrSaveOrSbumitAgrRspBO operAgr(AgrSaveOrSbumitAgrReqBO agrSaveOrSbumitAgrReqBO) {
        return agrRepository.operAgr(agrSaveOrSbumitAgrReqBO);
    }

    @Override
    public AgrQryAgrDetailRspBO qryAgrDetail(AgrQryAgrDetailReqBO agrQryAgrDetailReqBO) {
        return agrRepository.qryAgrDetail(agrQryAgrDetailReqBO);
    }

    @Override
    public AgrDeleteUselessAgrRspBO deleteUselessAgr(AgrDeleteUselessAgrReqBO agrDeleteUselessAgrReqBO) {

        return agrRepository.deleteUselessAgr(agrDeleteUselessAgrReqBO);
    }

    @Override
    public BkAgrMainDo qryMain(BkAgrMainDo bkAgrMainDo) {
        return agrRepository.qryMain(bkAgrMainDo);
    }

    @Override
    public void updateBy(BkAgrMainDo bkAgrMainDo) {
         agrRepository.updateBy(bkAgrMainDo);
    }

    @Override
    public AgrAddChangeAgrSyncRspBO addChangeAgrSync(AgrAddChangeAgrSyncReqBO agrAddChangeAgrSyncReqBO,Long agrId) {
        return agrRepository.addChangeAgrSync(agrAddChangeAgrSyncReqBO,agrId);
    }

    @Override
    public AgrAddChangeAgrSyncFromPriceStockRspBO addChangeAgrSyncFromPriceStock(AgrAddChangeAgrSyncFromPriceStockReqBO agrAddChangeAgrSyncFromPriceStockReqBO) {
        return null;
    }

    @Override
    public List<BkAgrMainDo> qryEffectAgr(BkAgrMainDo bkAgrMainDo) {
        return agrRepository.qryEffectAgr(bkAgrMainDo);
    }

    @Override
    public Integer updateMain(BkAgrMainDo bkAgrMainDo) {

        Date effDate = bkAgrMainDo.getEffDate();
        Date expDate = bkAgrMainDo.getExpDate();

        Date now = new Date();

        if (bkAgrMainDo.getAgrStatus().equals("changing")){
           bkAgrMainDo.setAgrStatus("CHANGE");
        } else if (now.before(expDate)&& now.after(effDate)){
            bkAgrMainDo.setAgrStatus("EFFECTIVE");
        }else if (now.after(expDate)){
            bkAgrMainDo.setAgrStatus("EXPIRED");
        }else{
            // 表示没有更新
            return -1;
        }

        agrRepository.updateAgrMainStatus(bkAgrMainDo);

        return 1;
    }

    @Override
    public void insertAgrMain(AgrMainBO agrMainBO) {
        agrRepository.insertAgrMain(agrMainBO);
    }

    @Override
    public void insertAgrPayConfig(AgrPayConfigBO agrPayConfigBO) {
        agrRepository.insertAgrPayConfig(agrPayConfigBO);
    }

    @Override
    public void insertAgrAppScope(AgrAppScopeBO agrAppScopeBO) {
        agrRepository.insertAgrAppScope(agrAppScopeBO);
    }

    @Override
    public void inserttAgrAppScopeBatch(List<AgrAppScopeBO> agrAppScopeBOS) {
        agrRepository.inserttAgrAppScopeBatch(agrAppScopeBOS);
    }


    @Override
    public void insertMateriaPriceItemList(List<AgrMateriaPriceItemBO> agrMainBO) {
        agrRepository.insertMateriaPriceItemList(agrMainBO);
    }

    @Override
    public AgrQryAgrUseSupListRspBO qryAgrUseSupList(AgrQryAgrUseSupListReqBO reqBO) {
        return this.agrRepository.qryAgrUseSupList(reqBO);
    }

    @Override
    public AgrQryAgrAppScopePageServiceRspBO qryAgrScopeList(AgrQryAgrAppScopePageServiceReqBO agrQryAgrVersionListReqBO) {
        return agrRepository.qryAgrScopeList(agrQryAgrVersionListReqBO);
    }

    @Override
    public void insertVersion(AgrMainBO agrMainBO) {
        agrRepository.insertVersion(agrMainBO);
    }
}
