package com.tydic.dyc.agr.model.change.impl;

import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.model.change.*;
import com.tydic.dyc.agr.repository.AgrChangeRepository;
import com.tydic.dyc.agr.repository.AgrRepository;
import com.tydic.dyc.agr.service.agr.bo.AgrChangeCronJobRspBO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author zhanghengrui
 * @date 2023/1/31 15:43
 */
@Service
public class AgrChangeModelImpl implements AgrChangeModel {

    @Autowired
    private AgrRepository agrRepository;
    @Autowired
    private AgrChangeRepository agrChangeRepository;

    @Override
    public List<BkAgrMateriaPriceItemDo>transDataFromChangeTemp2Main(Long agrId, Long batchUniqueId, List<BkAgrBigChangeItemDataWhileDo> bkWhileDos, Long agrHisId, AgrChangeCronJobRspBO agrChangeCronJobRspBO) {
        return agrRepository.transDataFromChangeTemp2Main(agrId,batchUniqueId, bkWhileDos,agrHisId,agrChangeCronJobRspBO);
    }

    @Override
    public Integer saveData2Material(List<BkAgrBigChangeItemDataWhileDo> agrBigChangeItemDataWhileDo) {
        return agrChangeRepository.saveData2Material(agrBigChangeItemDataWhileDo);
    }

    @Override
    public Integer saveDate2Main(AgrTransDataDo agrTransDataDo) {


        return agrChangeRepository.saveDate2Main(agrTransDataDo);
    }

    @Override
    public Integer addDataFromChangeTemp2Material(Long agrId, Long batchUniqueId, BkAgrMainDo bkAgrMainDo,AgrChangeCronJobRspBO agrChangeCronJobRspBO) {
        return agrChangeRepository.addDataFromChangeTemp2Material(agrId,batchUniqueId,bkAgrMainDo,agrChangeCronJobRspBO);
    }

    @Override
    public List<BkAgrBigChangeItemDataWhileDo> qryChangeMaterial(Long agrId, Long batchUniqueId) {
        return agrChangeRepository.qryChangeMaterial(agrId,batchUniqueId);
    }

    @Override
    public void transItemData(List<BkAgrBigChangeItemDataWhileDo> bkWhileDos,  String agrCode, AgrChangeCronJobRspBO agrChangeCronJobRspBO,Long agrHisId) {
        agrChangeRepository.transItemData(bkWhileDos,agrCode,agrChangeCronJobRspBO,agrHisId);
    }


}
