/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.model.change.AgrChangeModel;
import com.tydic.dyc.agr.model.log.AgrLogModel;
import com.tydic.dyc.agr.model.log.BkAgrBigDataLogDo;
import com.tydic.dyc.agr.model.materiaPrice.AgrMateriaPriceModel;
import com.tydic.dyc.agr.service.agr.AgrAddNewAgrSyncService;
import com.tydic.dyc.agr.service.agr.bo.AgrAddNewAgrSyncReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAddNewAgrSyncRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrMainBO;
import com.tydic.dyc.agr.service.agr.bo.AgrMateriaPriceItemBO;
import com.tydic.dyc.agr.service.agr.bo.AgrPayConfigBO;
import com.tydic.dyc.agr.utils.IdUtil;
import com.tydic.dyc.util.CommonUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrAddNewAgrSyncService"})
public class AgrAddNewAgrSyncServiceImpl
implements AgrAddNewAgrSyncService {
    private static final Logger log = LoggerFactory.getLogger(AgrAddNewAgrSyncServiceImpl.class);
    @Autowired
    private AgrModel agrModel;
    @Autowired
    private AgrLogModel agrLogModel;
    @Autowired
    private AgrChangeModel agrChangeModel;
    @Autowired
    private AgrMateriaPriceModel agrMateriaPriceModel;

    @PostMapping(value={"addNewAgrSync"})
    public AgrAddNewAgrSyncRspBO addNewAgrSync(@RequestBody AgrAddNewAgrSyncReqBO agrAddNewAgrSyncReqBO) {
        log.info("agrAddNewAgrSyncReqBO\u5165\u53c2{}", (Object)JSON.toJSONString((Object)agrAddNewAgrSyncReqBO));
        AgrAddNewAgrSyncRspBO rspBO = new AgrAddNewAgrSyncRspBO();
        BkAgrMainDo agrMainDo = new BkAgrMainDo();
        agrMainDo.setAgrCode(agrAddNewAgrSyncReqBO.getAgrCode());
        BkAgrMainDo agrMainBO = this.agrModel.qryMain(agrMainDo);
        if (agrMainBO != null && !StringUtils.isEmpty((Object)agrMainBO.getAgrCode()) && agrAddNewAgrSyncReqBO.getSyncType() == 2) {
            rspBO.setAgrId(agrMainBO.getAgrId());
            rspBO.setRespDesc("\u8be5\u5408\u540c\u5df2\u7ecf\u5b58\u5728");
            rspBO.setRespCode("8888");
            rspBO.setDelType(Long.valueOf(1L));
            return rspBO;
        }
        Integer syncNum = this.agrLogModel.checkSyncStatus(agrAddNewAgrSyncReqBO.getAgrCode(), agrAddNewAgrSyncReqBO.getBatchUniqueId());
        if (syncNum.equals(agrAddNewAgrSyncReqBO.getTotalBatchCount())) {
            throw new ZTBusinessException("\u540c\u6b65\u5b8c\u6210");
        }
        Long agrId = this.agrLogModel.getAgrBigDataLog(agrAddNewAgrSyncReqBO.getAgrCode(), agrAddNewAgrSyncReqBO.getBatchUniqueId());
        if (agrId == null) {
            agrId = IdUtil.nextId();
        }
        rspBO.setAgrId(agrId);
        BkAgrBigDataLogDo bkAgrBigDataLogDo = new BkAgrBigDataLogDo();
        bkAgrBigDataLogDo.setAgrBigDataLogId(IdUtil.nextId());
        bkAgrBigDataLogDo.setBatchUniqueId(agrAddNewAgrSyncReqBO.getBatchUniqueId());
        bkAgrBigDataLogDo.setTotalBatchCount(agrAddNewAgrSyncReqBO.getTotalBatchCount());
        bkAgrBigDataLogDo.setNowBatchCount(agrAddNewAgrSyncReqBO.getNowBatchCount());
        bkAgrBigDataLogDo.setAgrId(agrId + "");
        bkAgrBigDataLogDo.setAgrCode(agrAddNewAgrSyncReqBO.getAgrCode());
        bkAgrBigDataLogDo.setContractCode(agrAddNewAgrSyncReqBO.getAgrCode());
        bkAgrBigDataLogDo.setDealStatus("2");
        bkAgrBigDataLogDo.setBatchOperType(1);
        bkAgrBigDataLogDo.setIsCopyMain(agrAddNewAgrSyncReqBO.getSyncType() == 1 ? 1 : 0);
        bkAgrBigDataLogDo.setCreateName(new Date().toString());
        this.agrLogModel.addLog(bkAgrBigDataLogDo);
        this.addData(agrAddNewAgrSyncReqBO, agrId);
        if (syncNum + 1 == agrAddNewAgrSyncReqBO.getTotalBatchCount()) {
            rspBO.setSyncFinishFlag(Integer.valueOf(1));
            log.info("\u540c\u6b65es");
            rspBO.setPickerConfigNo("1");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setAgrId(agrId);
        return rspBO;
    }

    private void addData(AgrAddNewAgrSyncReqBO syncReqBO, Long agrId) {
        if (syncReqBO.getSyncType() == 2) {
            AgrMainBO agrAgrMainBO = syncReqBO.getAgrAgrMainBO();
            agrAgrMainBO.setAgrId(agrId);
            this.agrModel.insertAgrMain(agrAgrMainBO);
            List agrAppScopeBO = syncReqBO.getAgrAppScopeBO();
            agrAppScopeBO.forEach(obj -> {
                obj.setAgrId(agrId);
                obj.setAppScopeId(Long.valueOf(IdUtil.nextId()));
            });
            this.agrModel.inserttAgrAppScopeBatch(agrAppScopeBO);
            AgrPayConfigBO agrPayConfigBO = syncReqBO.getAgrPayConfigBO();
            agrPayConfigBO.setAgrId(agrId);
            agrPayConfigBO.setPayCfgId(Long.valueOf(IdUtil.nextId()));
            agrPayConfigBO.setPayObj(Integer.valueOf(0));
            agrPayConfigBO.setPaymentDays(agrAgrMainBO.getPaymentDays());
            this.agrModel.insertAgrPayConfig(syncReqBO.getAgrPayConfigBO());
        }
        List bos = syncReqBO.getAgrMateriaPriceItemBOs();
        bos.forEach(obj -> {
            obj.setAgrId(agrId);
            obj.setAgrMateriaPriceItemId(Long.valueOf(IdUtil.nextId()));
            obj.setKeyCode(CommonUtil.getKeyCode((AgrMateriaPriceItemBO)obj));
        });
        this.agrModel.insertMateriaPriceItemList(bos);
    }
}

