package com.tydic.dyc.agr.extService;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.dyc.agr.service.agr.AgrAddChangeAgrSyncService;
import com.tydic.dyc.agr.service.agr.bo.AgrAddChangeAgrSyncReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAddChangeAgrSyncRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;

/**
 * @author zhanghengrui
 * @date 2023/4/18 14:50
 */
@HTServiceImpl
@Slf4j
public class AgrAddChangeAgrSyncServiceExtImpl implements AgrAddChangeAgrSyncServiceExt{

    @Autowired
    private AgrAddChangeAgrSyncService agrAddChangeAgrSyncService;

    @Resource(name = "agrCornJobSyncProvider")
    private ProxyMessageProducer proxyMessageProducer;

    @Override
    public AgrAddChangeAgrSyncRspBO addChangeAgrSync(AgrAddChangeAgrSyncReqBO agrAddChangeAgrSyncReqBO) {

        AgrAddChangeAgrSyncRspBO rspBO = agrAddChangeAgrSyncService.addChangeAgrSync(agrAddChangeAgrSyncReqBO);

        if (null!=rspBO.getIsMq()&& rspBO.getIsMq()){
            log.info("协议变更-发送mq开始:" + JSON.toJSONString(rspBO.getAgrChangeCronJobReqBO()));
            ProxySendResult send = proxyMessageProducer.send(new ProxyMessage("AGR_CORN_JOB_TOPIC", "AGR", JSON.toJSONString(rspBO.getAgrChangeCronJobReqBO())));
            log.info("协议变更-发送mq完成:" + JSON.toJSONString(send));
        }

        return rspBO;
    }
}
