/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.repository.extension.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.authority.constants.AuthDicConstant;
import com.tydic.dyc.authority.model.extension.bo.BkAuthOrgDO;
import com.tydic.dyc.authority.repository.dao.SysAuthDistributeMapper;
import com.tydic.dyc.authority.repository.dao.SysOrgTagRelMapper;
import com.tydic.dyc.authority.repository.dao.SysUserInfoMapper;
import com.tydic.dyc.authority.repository.dao.SysUserTagRelMapper;
import com.tydic.dyc.authority.repository.dao.extension.BkAuthOrgTagRelMapper;
import com.tydic.dyc.authority.repository.dao.extension.BkAuthUserMapper;
import com.tydic.dyc.authority.repository.extension.BkAuthOrgRepository;
import com.tydic.dyc.authority.repository.po.SysAuthDistributePo;
import com.tydic.dyc.authority.repository.po.SysOrgTagRelPo;
import com.tydic.dyc.authority.repository.po.SysRoleInfoPo;
import com.tydic.dyc.authority.repository.po.SysUserInfoPo;
import com.tydic.dyc.authority.repository.po.SysUserTagRelPo;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BkAuthOrgRepositoryImpl
implements BkAuthOrgRepository {
    private static final Logger log = LoggerFactory.getLogger(BkAuthOrgRepositoryImpl.class);
    @Autowired
    private SysOrgTagRelMapper sysOrgTagRelMapper;
    @Autowired
    private BkAuthOrgTagRelMapper bkAuthOrgTagRelMapper;
    @Autowired
    private SysUserInfoMapper sysUserInfoMapper;
    @Autowired
    private BkAuthUserMapper bkAuthUserMapper;
    @Autowired
    private SysUserTagRelMapper sysUserTagRelMapper;
    @Value(value="${supDefaultRole:}")
    private String supDefaultRole;
    @Value(value="${purDefaultRole:}")
    private String purDefaultRole;
    @Autowired
    private SysAuthDistributeMapper sysAuthDistributeMapper;

    public void modifyOrgAndUserIdentity(BkAuthOrgDO modelReqBO) {
        int i;
        SysOrgTagRelPo qryTagPO = new SysOrgTagRelPo();
        qryTagPO.setOrgId(modelReqBO.getOrgId());
        List orgTagRelPoList = this.sysOrgTagRelMapper.getList(qryTagPO);
        if (ObjectUtil.isNotEmpty((Object)orgTagRelPoList) && (i = this.bkAuthOrgTagRelMapper.deleOrgTagByOrgId(modelReqBO.getOrgId())) < 1) {
            throw new BaseBusinessException("100100", "\u5220\u9664\u673a\u6784\u8d38\u6613\u8eab\u4efd\u5931\u8d25");
        }
        List insertOrgPOS = modelReqBO.getOrgIdentityInfos().stream().map(tagId -> {
            SysOrgTagRelPo sysOrgTagRelPo = new SysOrgTagRelPo();
            sysOrgTagRelPo.setOrgId(modelReqBO.getOrgId());
            sysOrgTagRelPo.setTagId(Long.valueOf(tagId));
            sysOrgTagRelPo.setTagStatus("1");
            sysOrgTagRelPo.setDelFlag("0");
            sysOrgTagRelPo.setRelId(Long.valueOf(IdUtil.nextId()));
            return sysOrgTagRelPo;
        }).collect(Collectors.toList());
        this.sysOrgTagRelMapper.insertBatch(insertOrgPOS);
        SysUserInfoPo queryPO = new SysUserInfoPo();
        queryPO.setOrgId(modelReqBO.getOrgId());
        List userInfoPos = this.sysUserInfoMapper.getList(queryPO);
        if (!CollectionUtils.isEmpty((Collection)userInfoPos)) {
            int n;
            int m;
            List<Long> userIds = userInfoPos.stream().map(SysUserInfoPo::getUserId).collect(Collectors.toList());
            int userTagCount = this.bkAuthUserMapper.selectUserTagByUserId(userIds);
            if (userTagCount > 0 && (m = this.bkAuthUserMapper.deleUserTagByUserId(userIds)) < 1) {
                throw new BaseBusinessException("100100", "\u5220\u9664\u7528\u6237\u8d38\u6613\u8eab\u4efd\u5931\u8d25");
            }
            int userRoleCount = this.bkAuthUserMapper.selectUserRoleByUserId(userIds);
            if (userRoleCount > 0 && (n = this.bkAuthUserMapper.deleUserRoleByUserId(userIds)) < 1) {
                throw new BaseBusinessException("100100", "\u5220\u9664\u7528\u6237\u89d2\u8272\u5931\u8d25");
            }
            ArrayList<SysUserTagRelPo> insertUserPOS = new ArrayList<SysUserTagRelPo>();
            for (Long userId : userIds) {
                for (String identityTag : modelReqBO.getOrgIdentityInfos()) {
                    List<SysAuthDistributePo> purRoleInfo;
                    SysUserTagRelPo sysUserTagRelPo = new SysUserTagRelPo();
                    sysUserTagRelPo.setUserId(userId);
                    sysUserTagRelPo.setTagId(Long.valueOf(identityTag));
                    sysUserTagRelPo.setRelId(Long.valueOf(IdUtil.nextId()));
                    sysUserTagRelPo.setIsDefalt("1");
                    sysUserTagRelPo.setDelFlag("0");
                    insertUserPOS.add(sysUserTagRelPo);
                    if ("2".equals(identityTag)) {
                        List<SysAuthDistributePo> supRoleInfo = this.createUserRoleInfo(userId, this.supDefaultRole);
                        if (CollectionUtils.isEmpty(supRoleInfo)) continue;
                        this.sysAuthDistributeMapper.insertBatch(supRoleInfo);
                        continue;
                    }
                    if (!"1".equals(identityTag) || CollectionUtils.isEmpty(purRoleInfo = this.createUserRoleInfo(userId, this.purDefaultRole))) continue;
                    this.sysAuthDistributeMapper.insertBatch(purRoleInfo);
                }
            }
            if (!CollectionUtils.isEmpty(insertUserPOS)) {
                this.sysUserTagRelMapper.insertBatch(insertUserPOS);
            }
        }
    }

    private List<SysRoleInfoPo> roleMapUtils(String defaultRoleStr) {
        String[] ListDefaultRole = defaultRoleStr.split("\\|");
        ArrayList<SysRoleInfoPo> umcRoleBos = new ArrayList<SysRoleInfoPo>();
        for (String defaultRole : ListDefaultRole) {
            List<String> defaultRoles = Arrays.asList(defaultRole.split(","));
            SysRoleInfoPo sysRoleBo = new SysRoleInfoPo();
            sysRoleBo.setRoleId(Long.valueOf(defaultRoles.get(0)));
            sysRoleBo.setRoleName(defaultRoles.get(1));
            umcRoleBos.add(sysRoleBo);
        }
        return umcRoleBos;
    }

    private List<SysAuthDistributePo> createUserRoleInfo(Long userId, String purDefaultRole) {
        ArrayList<SysAuthDistributePo> insertRolePOS = new ArrayList<SysAuthDistributePo>();
        List<SysRoleInfoPo> umcRoleBos = this.roleMapUtils(purDefaultRole);
        for (SysRoleInfoPo roleBo : umcRoleBos) {
            SysAuthDistributePo roleRelPo = new SysAuthDistributePo();
            roleRelPo.setAuthId(Long.valueOf(IdUtil.nextId()));
            roleRelPo.setRoleId(roleBo.getRoleId());
            roleRelPo.setUserId(userId);
            roleRelPo.setDisFlag(AuthDicConstant.ROLE_DIS_FLAG.USER);
            roleRelPo.setDelFlag("0");
            roleRelPo.setDisAgFlag(AuthDicConstant.DIS_AG_FLAG.ALL_AUTHORITY);
            roleRelPo.setManageLevel(Integer.valueOf(60));
            insertRolePOS.add(roleRelPo);
        }
        return insertRolePOS;
    }
}

