package com.tydic.dyc.agr.service.agr.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 *
 * @author zhanghengrui
 * @date 2023/2/1 21:24
 */
@Data
public class BkAgrPriceBo implements Serializable {
    private static final long serialVersionUID = -8024534706253294885L;

    /**
     *物料编码
     */
    private String materialCode;
    /**
     *明细变更类型（1 新增 2修改 3删除）
     */
    private Integer operItemType;
    /**
     *价格类型：1.统一价，2.区域价，3.专属价，4.阶梯价"
     */
    private Integer priceType;
    /**
     *一级地址编码
     */
    private Integer province;
    /**
     *一级地址名称
     */
    private String provinceName;
    /**
     *二级地址名称
     */
    private String cityName;
    /**
     *二级地址编码
     */
    private Integer city;
    /**
     *专属价机构单位编码
     */
    private Long orgId;
    /**
     *专属价机构单位名称
     */
    private String orgName;
    /**
     *数量起
     */
    private BigDecimal start;
    /**
     *数量止
     */
    private BigDecimal end;
    /**
     *单价（含税）
     */
    private BigDecimal price;
    /**
     *税率
     */
    private BigDecimal rate;
    /**
     * 物料规格型号信息
     */
    private String model;
    /**
     * 最小起订量
     */
    private BigDecimal moq;
    /**
     * 备注
     */
    private String materialRemark;
    /**
     * 货期
     */
    private Integer preOnShelveDay;
    /**
     * 生产厂商
     */
    private String factory;

}
