/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import com.google.common.collect.Lists;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuStandardRelationMapper;
import com.tydic.commodity.estore.ability.bo.UccStandardSkuMaterialConfirmAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccStandardSkuMaterialConfirmAbilityRspBO;
import com.tydic.commodity.estore.atom.api.UccEditSkuProcessingStepsAtomService;
import com.tydic.commodity.estore.atom.api.UccEditSkuRelStatusAtomService;
import com.tydic.commodity.estore.busi.api.UccStandardSkuMaterialConfirmBusiService;
import com.tydic.commodity.po.UccSkuPo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccStandardSkuMaterialConfirmBusiServiceImpl
implements UccStandardSkuMaterialConfirmBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccStandardSkuMaterialConfirmBusiServiceImpl.class);
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuStandardRelationMapper uccSkuStandardRelationMapper;
    @Autowired
    private UccEditSkuRelStatusAtomService uccEditSkuRelStatusAtomService;
    @Autowired
    private UccEditSkuProcessingStepsAtomService uccEditSkuProcessingStepsAtomService;

    @Override
    public UccStandardSkuMaterialConfirmAbilityRspBO dealStandardSkuMaterialConfirm(UccStandardSkuMaterialConfirmAbilityReqBO reqBO) {
        UccStandardSkuMaterialConfirmAbilityRspBO rspBO = new UccStandardSkuMaterialConfirmAbilityRspBO();
        List stdSkuIds = reqBO.getStdSkuIds();
        List stdSkuPoList = this.uccSkuMapper.qeryBatchSkus(stdSkuIds);
        this.uccEditSkuRelStatusAtomService.editRelStatus(stdSkuIds);
        Long userId = reqBO.getUserId();
        Map<Long, List<UccSkuPo>> shopIdStdSkuPoMap = stdSkuPoList.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        for (Long supplierShopId : shopIdStdSkuPoMap.keySet()) {
            UccStatusChangeUpdateSpuAtomReqBO atomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
            atomReqBO.setSupplierShopId(supplierShopId);
            atomReqBO.setUserId(userId);
            List<UccSkuPo> uccStdSkuPoList = shopIdStdSkuPoMap.get(supplierShopId);
            List stdSkuStatusList = uccStdSkuPoList.stream().map(e -> {
                UccSkuUpdateStatusBO updateStatusBO = new UccSkuUpdateStatusBO();
                updateStatusBO.setSkuStatus(SkuStatusEnum.PUBLISHED_STATUS.getStatus());
                updateStatusBO.setSkuId(e.getSkuId());
                updateStatusBO.setOnShelveTime(e.getOnShelveTime());
                return updateStatusBO;
            }).collect(Collectors.toList());
            atomReqBO.setSkuStatusList(stdSkuStatusList);
            UccStatusChangeUpdateSpuAtomRspBO changeStdSkuResult = this.uccSkuStatusUpdatesAtomService.delaStatusChange(atomReqBO);
            if ("0000".equals(changeStdSkuResult.getRespCode())) continue;
            BeanUtil.copyProperties((Object)changeStdSkuResult, (Object)rspBO);
            return rspBO;
        }
        for (UccSkuPo uccStdSkuPo : stdSkuPoList) {
            List relSkuIds = this.uccSkuStandardRelationMapper.qryskuIdsByStdSkuIds((List)Lists.newArrayList((Object[])new Long[]{uccStdSkuPo.getSkuId()}));
            if (!CollectionUtils.isEmpty((Collection)relSkuIds)) {
                this.uccEditSkuProcessingStepsAtomService.editProcessingSteps(relSkuIds);
                List skuPoList = this.uccSkuMapper.qeryBatchSkus(relSkuIds);
                Map<Long, List<UccSkuPo>> shopIdSkuPoMap = skuPoList.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
                for (Long supplierShopId : shopIdSkuPoMap.keySet()) {
                    UccStatusChangeUpdateSpuAtomReqBO atomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
                    atomReqBO.setSupplierShopId(supplierShopId);
                    atomReqBO.setUserId(userId);
                    List<UccSkuPo> uccSkuPoList = shopIdSkuPoMap.get(supplierShopId);
                    List skuStatusList = uccSkuPoList.stream().map(e -> {
                        UccSkuUpdateStatusBO updateStatusBO = new UccSkuUpdateStatusBO();
                        updateStatusBO.setSkuStatus(SkuStatusEnum.PENDING_SHELF_STATUS.getStatus());
                        updateStatusBO.setSkuId(e.getSkuId());
                        updateStatusBO.setOnShelveTime(e.getOnShelveTime());
                        updateStatusBO.setMaterialId(uccStdSkuPo.getMaterialId());
                        updateStatusBO.setMaterialName(uccStdSkuPo.getMaterialName());
                        return updateStatusBO;
                    }).collect(Collectors.toList());
                    atomReqBO.setSkuStatusList(skuStatusList);
                    UccStatusChangeUpdateSpuAtomRspBO changeStdSkuResult = this.uccSkuStatusUpdatesAtomService.delaStatusChange(atomReqBO);
                    if ("0000".equals(changeStdSkuResult.getRespCode())) continue;
                    BeanUtil.copyProperties((Object)changeStdSkuResult, (Object)rspBO);
                    return rspBO;
                }
                continue;
            }
            log.warn("\u6807\u54c1" + reqBO.getStdSkuIds() + "\u4e0d\u5b58\u5728\u5355\u54c1");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

