/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.api.UccStandardSkuBindAbilityService;
import com.tydic.commodity.estore.ability.bo.UccStandardSkuBindAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccStandardSkuBindAbilityRspBO;
import com.tydic.commodity.estore.busi.api.UccStandardSkuBindBusiService;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/3.1.0/com.tydic.commodity.estore.ability.api.UccStandardSkuBindAbilityService"})
public class UccStandardSkuBindAbilityServiceImpl
implements UccStandardSkuBindAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccStandardSkuBindAbilityServiceImpl.class);
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccStandardSkuBindBusiService uccStandardSkuBindBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"dealStandardSkuBind"})
    public UccStandardSkuBindAbilityRspBO dealStandardSkuBind(@RequestBody UccStandardSkuBindAbilityReqBO reqBO) {
        UccStandardSkuBindAbilityRspBO rspBO = new UccStandardSkuBindAbilityRspBO();
        List bindList = reqBO.getBindList();
        if (CollectionUtil.isEmpty((Collection)bindList)) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u8981\u7ed1\u5b9a\u7684\u5217\u8868\u4e3a\u7a7a!");
            return rspBO;
        }
        boolean bool = bindList.stream().anyMatch(e -> ObjectUtil.isNull((Object)e.getSkuId()) || ObjectUtil.isNull((Object)e.getStdSkuId()));
        if (bool) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a!");
            return rspBO;
        }
        UccStandardSkuBindAbilityRspBO bindResult = this.uccStandardSkuBindBusiService.dealStandardSkuBind(reqBO);
        if (!"0000".equals(bindResult.getRespCode())) {
            BeanUtil.copyProperties((Object)bindResult, (Object)rspBO);
            return rspBO;
        }
        List idList = bindList.stream().reduce(new ArrayList(), (list, e) -> {
            list.add(e.getSkuId());
            list.add(e.getStdSkuId());
            return list;
        }, (a, b) -> null);
        List uccSkuPoList = this.uccSkuMapper.qeryBatchSkus(idList);
        Map shopIdSkuIdListMap = uccSkuPoList.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId, Collectors.mapping(UccSkuPo::getSkuId, Collectors.toList())));
        shopIdSkuIdListMap.forEach((k, v) -> {
            SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds(v);
            syncSceneCommodityToEsReqBO.setSupplierId(k);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
            }
        });
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

