/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.comb.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuPriceModifyAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuPriceModifyAtomServiceReqBo;
import com.tydic.commodity.busibase.atom.bo.UccSkuPriceModifyAtomServiceRspBo;
import com.tydic.commodity.dao.UccAddCoefficientMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.estore.busi.api.UccAddCoefficientDealBusiService;
import com.tydic.commodity.estore.busi.api.UccAddCoefficientUpdateService;
import com.tydic.commodity.estore.busi.bo.UccAddCoefficientUpdateServiceReqBo;
import com.tydic.commodity.estore.comb.api.UccAddCoefficientCombService;
import com.tydic.commodity.estore.comb.bo.UccAddCoefficientCombServiceReqBo;
import com.tydic.commodity.estore.comb.bo.UccAddCoefficientCombServiceRspBo;
import com.tydic.commodity.po.UccAddCoefficientPO;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UccAddCoefficientCombServiceImpl
implements UccAddCoefficientCombService {
    private static final Logger log = LoggerFactory.getLogger(UccAddCoefficientCombServiceImpl.class);
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccAddCoefficientMapper uccAddCoefficientMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccAddCoefficientUpdateService uccAddCoefficientUpdateService;
    @Autowired
    private UccAddCoefficientDealBusiService uccAddCoefficientDealBusiService;
    @Autowired
    private UccSkuPriceModifyAtomService uccSkuPriceModifyAtomService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Value(value="${LM_UCC_SYNC_TOPIC}")
    private String lmUccSyncTopic;
    @Value(value="${LM_UCC_SYNC_TAG}")
    private String lmUccSyncTag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UccAddCoefficientCombServiceRspBo dealAddCoefficient(UccAddCoefficientCombServiceReqBo reqBo) {
        UccAddCoefficientPO uccAddCoefficientPO = this.uccAddCoefficientMapper.getById(reqBo.getAddCoefficientId());
        if (UccConstants.UccAddCoefficientDealState.DEALING.equals(uccAddCoefficientPO.getDealStatus())) {
            try {
                List uccCommodityTypePos = this.uccCommodityTypeMapper.selectByCatId(reqBo.getCatalogId());
                ArrayList<Long> skuIdList = new ArrayList<Long>();
                if (CollectionUtils.isNotEmpty((Collection)uccCommodityTypePos)) {
                    for (UccCommodityTypePo uccCommodityTypePo : uccCommodityTypePos) {
                        this.deal(reqBo, uccCommodityTypePo, skuIdList);
                    }
                }
                this.syncEs(reqBo, skuIdList);
            }
            finally {
                this.updateDealState(reqBo);
            }
        }
        UccAddCoefficientCombServiceRspBo uccAddCoefficientCombServiceRspBo = new UccAddCoefficientCombServiceRspBo();
        uccAddCoefficientCombServiceRspBo.setRespCode("0000");
        uccAddCoefficientCombServiceRspBo.setRespDesc("\u6210\u529f");
        return uccAddCoefficientCombServiceRspBo;
    }

    private void syncEs(UccAddCoefficientCombServiceReqBo reqBo, List<Long> skuIds) {
        if (CollectionUtils.isNotEmpty(skuIds)) {
            int INCREMENT;
            int endIndex = INCREMENT = 200;
            if (skuIds.size() > INCREMENT) {
                int times = skuIds.size() % INCREMENT == 0 ? skuIds.size() / INCREMENT : skuIds.size() / INCREMENT + 1;
                int startIndex = 0;
                for (int i = 1; i <= times; ++i) {
                    this.sendMq(reqBo, skuIds.subList(startIndex, i == times ? skuIds.size() : endIndex));
                    startIndex += INCREMENT;
                    endIndex += INCREMENT;
                }
            } else {
                this.sendMq(reqBo, skuIds);
            }
        }
    }

    private void sendMq(UccAddCoefficientCombServiceReqBo reqBo, List<Long> subList) {
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setSkuIds(subList);
        syncSceneCommodityToEsReqBO.setSupplierId(reqBo.getSupplierId());
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_PRICE.intValue());
        try {
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(this.lmUccSyncTopic, this.lmUccSyncTag, JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u52a0\u4ef7\u63a8\u9001es\u5f02\u5e38--->", (Throwable)e);
        }
    }

    private void updateDealState(UccAddCoefficientCombServiceReqBo reqBo) {
        UccAddCoefficientUpdateServiceReqBo uccAddCoefficientUpdateServiceReqBo = new UccAddCoefficientUpdateServiceReqBo();
        uccAddCoefficientUpdateServiceReqBo.setId(reqBo.getAddCoefficientId());
        uccAddCoefficientUpdateServiceReqBo.setDealState(UccConstants.UccAddCoefficientDealState.DEAL_SUCCESS);
        this.uccAddCoefficientUpdateService.updateState(uccAddCoefficientUpdateServiceReqBo);
    }

    private void deal(UccAddCoefficientCombServiceReqBo reqBo, UccCommodityTypePo uccCommodityTypePo, List<Long> skuIdList) {
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setCommodityTypeId(uccCommodityTypePo.getCommodityTypeId());
        uccSkuPo.setSupplierShopId(reqBo.getSupplierShopId());
        Page page = new Page(1, 1000);
        List uccSkuPos = this.uccSkuMapper.getListPage(uccSkuPo, page);
        if (CollectionUtils.isNotEmpty((Collection)uccSkuPos)) {
            this.dealAddCoefficient(uccSkuPos, reqBo, skuIdList);
            if (page.getTotalPages() > 1) {
                for (int i = 2; i <= page.getTotalPages(); ++i) {
                    Page iPage = new Page(i, 1000);
                    List iUccSkuPos = this.uccSkuMapper.getListPage(uccSkuPo, iPage);
                    if (!CollectionUtils.isNotEmpty((Collection)iUccSkuPos)) continue;
                    this.dealAddCoefficient(iUccSkuPos, reqBo, skuIdList);
                }
            }
        }
    }

    private void dealAddCoefficient(List<UccSkuPo> uccSkuPos, UccAddCoefficientCombServiceReqBo reqBo, List<Long> skuIdList) {
        List skuIds = uccSkuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        UccSkuPriceModifyAtomServiceReqBo uccSkuPriceModifyAtomServiceReqBo = new UccSkuPriceModifyAtomServiceReqBo();
        uccSkuPriceModifyAtomServiceReqBo.setSkuIds(skuIds);
        uccSkuPriceModifyAtomServiceReqBo.setChangeType(UccConstants.SkuPriceChangeType.COEFFICIENT);
        uccSkuPriceModifyAtomServiceReqBo.setAddCoefficient(reqBo.getAddCoefficient());
        uccSkuPriceModifyAtomServiceReqBo.setAllowMarketPrice(reqBo.getAllowMarketPrice());
        UccSkuPriceModifyAtomServiceRspBo uccSkuPriceModifyAtomServiceRspBo = this.uccSkuPriceModifyAtomService.skuPriceChange(uccSkuPriceModifyAtomServiceReqBo);
        if (!"0000".equals(uccSkuPriceModifyAtomServiceRspBo.getRespCode())) {
            throw new BusinessException("8888", uccSkuPriceModifyAtomServiceRspBo.getRespDesc());
        }
        skuIdList.addAll(skuIds);
    }
}

