/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.extension.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.extension.bo.BkUmcAddressDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcAddressInfoDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcBatchQueryProvinceCityAreaCountyModelReqBO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcBatchQueryProvinceCityAreaCountyModelRspBO;
import com.tydic.dyc.umc.repository.dao.extension.BkUmcAddrAreaMapper;
import com.tydic.dyc.umc.repository.dao.extension.BkUmcAddrCityMapper;
import com.tydic.dyc.umc.repository.dao.extension.BkUmcAddrProvinceMapper;
import com.tydic.dyc.umc.repository.dao.extension.BkUmcAddrTownsMapper;
import com.tydic.dyc.umc.repository.extension.BkUmcAddressRepository;
import com.tydic.dyc.umc.repository.po.extension.BkUmcAddrAreaPO;
import com.tydic.dyc.umc.repository.po.extension.BkUmcAddrCityPO;
import com.tydic.dyc.umc.repository.po.extension.BkUmcAddrProvincePO;
import com.tydic.dyc.umc.repository.po.extension.BkUmcAddrTownsPO;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BkUmcAddressRepositoryImpl
implements BkUmcAddressRepository {
    private static final Logger log = LoggerFactory.getLogger(BkUmcAddressRepositoryImpl.class);
    @Autowired
    private BkUmcAddrProvinceMapper bkUmcAddrProvinceMapper;
    @Autowired
    private BkUmcAddrCityMapper bkUmcAddrCityMapper;
    @Autowired
    private BkUmcAddrAreaMapper bkUmcAddrAreaMapper;
    @Autowired
    private BkUmcAddrTownsMapper bkUmcAddrTownsMapper;

    public List<BkUmcAddressDO> verifyProvinceCityAddress(List<BkUmcAddressDO> bkUmcAddressDOS) {
        List<String> provinceNameList = bkUmcAddressDOS.stream().map(BkUmcAddressDO::getProvinceName).collect(Collectors.toList());
        List<BkUmcAddrProvincePO> bkUmcAddrProvincePOS = this.bkUmcAddrProvinceMapper.getListByProvinceName(provinceNameList);
        if (ObjectUtil.isEmpty(bkUmcAddrProvincePOS)) {
            throw new BaseBusinessException("200100", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u7701");
        }
        ArrayList<BkUmcAddressDO> list = new ArrayList<BkUmcAddressDO>();
        List<String> provinceCodes = bkUmcAddrProvincePOS.stream().map(BkUmcAddrProvincePO::getCode).collect(Collectors.toList());
        Map<String, String> addrProvinceMap = bkUmcAddrProvincePOS.stream().collect(Collectors.toMap(BkUmcAddrProvincePO::getName, BkUmcAddrProvincePO::getCode));
        List<BkUmcAddrCityPO> bkUmcAddrCityPOS = this.bkUmcAddrCityMapper.getListByProvinceCodeByGroup(provinceCodes);
        if (ObjectUtil.isEmpty(bkUmcAddrCityPOS)) {
            throw new BaseBusinessException("200100", "\u672a\u6839\u636e\u7701\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5e02");
        }
        Map addrCityMap = bkUmcAddrCityPOS.stream().collect(Collectors.toMap(BkUmcAddrCityPO::getName, Function.identity()));
        for (BkUmcAddressDO bkUmcAddressDO : bkUmcAddressDOS) {
            BkUmcAddressDO result;
            if (addrProvinceMap.containsKey(bkUmcAddressDO.getProvinceName()) && addrCityMap.containsKey(bkUmcAddressDO.getCityName())) {
                result = new BkUmcAddressDO();
                result.setIsCorrect(Boolean.valueOf(true));
                result.setProvinceName(bkUmcAddressDO.getProvinceName());
                result.setProvinceCode(addrProvinceMap.get(bkUmcAddressDO.getProvinceName()));
                result.setCityName(bkUmcAddressDO.getCityName());
                result.setCityCode(((BkUmcAddrCityPO)addrCityMap.get(bkUmcAddressDO.getCityName())).getCode());
                list.add(result);
                continue;
            }
            result = new BkUmcAddressDO();
            result.setIsCorrect(Boolean.valueOf(false));
            result.setProvinceName(bkUmcAddressDO.getProvinceName());
            result.setCityName(bkUmcAddressDO.getCityName());
            list.add(result);
        }
        return list;
    }

    public BkUmcBatchQueryProvinceCityAreaCountyModelRspBO batchQueryProvinceCityAreaCounty(BkUmcBatchQueryProvinceCityAreaCountyModelReqBO modelReqBO) {
        BkUmcBatchQueryProvinceCityAreaCountyModelRspBO modelRspBO = new BkUmcBatchQueryProvinceCityAreaCountyModelRspBO();
        if (!ObjectUtil.isEmpty((Object)modelReqBO.getProvinceList())) {
            List provinceDOS;
            BkUmcAddressInfoDO provinceDO;
            Map provincePOMap;
            ArrayList<Object> provinceList = new ArrayList<Object>();
            List<String> provinceNames = modelReqBO.getProvinceList().stream().map(BkUmcAddressInfoDO::getName).filter(e -> !StringUtils.isEmpty((Object)e)).collect(Collectors.toList());
            List<String> provinceCodes = modelReqBO.getProvinceList().stream().map(BkUmcAddressInfoDO::getCode).filter(e -> !StringUtils.isEmpty((Object)e)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(provinceNames)) {
                List<BkUmcAddrProvincePO> listByProvinceName = this.bkUmcAddrProvinceMapper.getListByProvinceName(provinceNames);
                if (!CollectionUtils.isEmpty(listByProvinceName)) {
                    provincePOMap = listByProvinceName.stream().collect(Collectors.toMap(BkUmcAddrProvincePO::getName, Function.identity()));
                    for (String provinceName2 : provinceNames) {
                        if (provincePOMap.containsKey(provinceName2)) {
                            provinceDO = new BkUmcAddressInfoDO();
                            provinceDO.setName(provinceName2);
                            provinceDO.setCode(((BkUmcAddrProvincePO)provincePOMap.get(provinceName2)).getCode());
                            provinceList.add(provinceDO);
                            continue;
                        }
                        provinceDO = new BkUmcAddressInfoDO();
                        provinceDO.setName(provinceName2);
                        provinceList.add(provinceDO);
                    }
                } else {
                    provinceDOS = provinceNames.stream().map(provinceName -> {
                        BkUmcAddressInfoDO provinceDO = new BkUmcAddressInfoDO();
                        provinceDO.setName(provinceName);
                        return provinceDO;
                    }).collect(Collectors.toList());
                    provinceList.addAll(provinceDOS);
                }
            }
            if (!CollectionUtils.isEmpty(provinceCodes)) {
                List<BkUmcAddrProvincePO> listByProvinceCode = this.bkUmcAddrProvinceMapper.getListByProvinceCode(provinceCodes);
                if (!CollectionUtils.isEmpty(listByProvinceCode)) {
                    provincePOMap = listByProvinceCode.stream().collect(Collectors.toMap(BkUmcAddrProvincePO::getCode, Function.identity()));
                    for (String provinceCode2 : provinceCodes) {
                        if (provincePOMap.containsKey(provinceCode2)) {
                            provinceDO = new BkUmcAddressInfoDO();
                            provinceDO.setCode(provinceCode2);
                            provinceDO.setName(((BkUmcAddrProvincePO)provincePOMap.get(provinceCode2)).getName());
                            provinceList.add(provinceDO);
                            continue;
                        }
                        provinceDO = new BkUmcAddressInfoDO();
                        provinceDO.setCode(provinceCode2);
                        provinceList.add(provinceDO);
                    }
                } else {
                    provinceDOS = provinceCodes.stream().map(provinceCode -> {
                        BkUmcAddressInfoDO provinceDO = new BkUmcAddressInfoDO();
                        provinceDO.setCode(provinceCode);
                        return provinceDO;
                    }).collect(Collectors.toList());
                    provinceList.addAll(provinceDOS);
                }
            }
            modelRspBO.setProvinceList(provinceList);
        }
        if (!ObjectUtil.isEmpty((Object)modelReqBO.getCityList())) {
            List cityDOS;
            BkUmcAddressInfoDO cityDO;
            Map cityPOMap;
            ArrayList<Object> cityList = new ArrayList<Object>();
            List<String> cityNames = modelReqBO.getCityList().stream().map(BkUmcAddressInfoDO::getName).filter(e -> !StringUtils.isEmpty((Object)e)).collect(Collectors.toList());
            List<String> cityCodes = modelReqBO.getCityList().stream().map(BkUmcAddressInfoDO::getCode).filter(e -> !StringUtils.isEmpty((Object)e)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(cityNames)) {
                List<BkUmcAddrCityPO> listByCityName = this.bkUmcAddrCityMapper.getListByCityName(cityNames);
                if (!CollectionUtils.isEmpty(listByCityName)) {
                    cityPOMap = listByCityName.stream().collect(Collectors.toMap(BkUmcAddrCityPO::getName, Function.identity()));
                    for (String cityName2 : cityNames) {
                        if (cityPOMap.containsKey(cityName2)) {
                            cityDO = new BkUmcAddressInfoDO();
                            cityDO.setName(cityName2);
                            cityDO.setCode(((BkUmcAddrCityPO)cityPOMap.get(cityName2)).getCode());
                            cityList.add(cityDO);
                            continue;
                        }
                        cityDO = new BkUmcAddressInfoDO();
                        cityDO.setName(cityName2);
                        cityList.add(cityDO);
                    }
                } else {
                    cityDOS = cityNames.stream().map(cityName -> {
                        BkUmcAddressInfoDO cityDO = new BkUmcAddressInfoDO();
                        cityDO.setName(cityName);
                        return cityDO;
                    }).collect(Collectors.toList());
                    cityList.addAll(cityDOS);
                }
            }
            if (!CollectionUtils.isEmpty(cityCodes)) {
                List<BkUmcAddrCityPO> listByCityCode = this.bkUmcAddrCityMapper.getListByCityCode(cityCodes);
                if (!CollectionUtils.isEmpty(listByCityCode)) {
                    cityPOMap = listByCityCode.stream().collect(Collectors.toMap(BkUmcAddrCityPO::getCode, Function.identity()));
                    for (String cityCode2 : cityCodes) {
                        if (cityPOMap.containsKey(cityCode2)) {
                            cityDO = new BkUmcAddressInfoDO();
                            cityDO.setCode(cityCode2);
                            cityDO.setName(((BkUmcAddrCityPO)cityPOMap.get(cityCode2)).getName());
                            cityList.add(cityDO);
                            continue;
                        }
                        cityDO = new BkUmcAddressInfoDO();
                        cityDO.setCode(cityCode2);
                        cityList.add(cityDO);
                    }
                } else {
                    cityDOS = cityCodes.stream().map(cityCode -> {
                        BkUmcAddressInfoDO cityDO = new BkUmcAddressInfoDO();
                        cityDO.setCode(cityCode);
                        return cityDO;
                    }).collect(Collectors.toList());
                    cityList.addAll(cityDOS);
                }
            }
            modelRspBO.setCityList(cityList);
        }
        if (!ObjectUtil.isEmpty((Object)modelReqBO.getAreaList())) {
            List areaDOS;
            BkUmcAddressInfoDO areaDO;
            Map areaPOMap;
            ArrayList<Object> areaList = new ArrayList<Object>();
            List<String> areaNames = modelReqBO.getAreaList().stream().map(BkUmcAddressInfoDO::getName).filter(e -> !StringUtils.isEmpty((Object)e)).collect(Collectors.toList());
            List<String> areaCodes = modelReqBO.getAreaList().stream().map(BkUmcAddressInfoDO::getCode).filter(e -> !StringUtils.isEmpty((Object)e)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(areaNames)) {
                List<BkUmcAddrAreaPO> listByAreaName = this.bkUmcAddrAreaMapper.getListByAreaName(areaNames);
                if (!CollectionUtils.isEmpty(listByAreaName)) {
                    areaPOMap = listByAreaName.stream().collect(Collectors.toMap(BkUmcAddrAreaPO::getName, Function.identity()));
                    for (String areaName2 : areaNames) {
                        if (areaPOMap.containsKey(areaName2)) {
                            areaDO = new BkUmcAddressInfoDO();
                            areaDO.setName(areaName2);
                            areaDO.setCode(((BkUmcAddrAreaPO)areaPOMap.get(areaName2)).getCode());
                            areaList.add(areaDO);
                            continue;
                        }
                        areaDO = new BkUmcAddressInfoDO();
                        areaDO.setName(areaName2);
                        areaList.add(areaDO);
                    }
                } else {
                    areaDOS = areaNames.stream().map(areaName -> {
                        BkUmcAddressInfoDO areaDO = new BkUmcAddressInfoDO();
                        areaDO.setName(areaName);
                        return areaDO;
                    }).collect(Collectors.toList());
                    areaList.addAll(areaDOS);
                }
            }
            if (!CollectionUtils.isEmpty(areaCodes)) {
                List<BkUmcAddrAreaPO> listByAreaCode = this.bkUmcAddrAreaMapper.getListByAreaCode(areaCodes);
                if (!CollectionUtils.isEmpty(listByAreaCode)) {
                    areaPOMap = listByAreaCode.stream().collect(Collectors.toMap(BkUmcAddrAreaPO::getCode, Function.identity()));
                    for (String areaCode2 : areaCodes) {
                        if (areaPOMap.containsKey(areaCode2)) {
                            areaDO = new BkUmcAddressInfoDO();
                            areaDO.setCode(areaCode2);
                            areaDO.setName(((BkUmcAddrAreaPO)areaPOMap.get(areaCode2)).getName());
                            areaList.add(areaDO);
                            continue;
                        }
                        areaDO = new BkUmcAddressInfoDO();
                        areaDO.setCode(areaCode2);
                        areaList.add(areaDO);
                    }
                } else {
                    areaDOS = areaCodes.stream().map(areaCode -> {
                        BkUmcAddressInfoDO areaDO = new BkUmcAddressInfoDO();
                        areaDO.setCode(areaCode);
                        return areaDO;
                    }).collect(Collectors.toList());
                    areaList.addAll(areaDOS);
                }
            }
            modelRspBO.setAreaList(areaList);
        }
        if (!ObjectUtil.isEmpty((Object)modelReqBO.getTownList())) {
            List townDOS;
            BkUmcAddressInfoDO townDO;
            ArrayList<Object> townList = new ArrayList<Object>();
            List<String> townNames = modelReqBO.getTownList().stream().map(BkUmcAddressInfoDO::getName).filter(e -> !StringUtils.isEmpty((Object)e)).collect(Collectors.toList());
            List<String> townCodes = modelReqBO.getTownList().stream().map(BkUmcAddressInfoDO::getCode).filter(e -> !StringUtils.isEmpty((Object)e)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(townNames)) {
                List<BkUmcAddrTownsPO> listByTownsName = this.bkUmcAddrTownsMapper.getListByTownsName(townNames);
                if (!CollectionUtils.isEmpty(listByTownsName)) {
                    Map townsPOMap = listByTownsName.stream().collect(Collectors.toMap(BkUmcAddrTownsPO::getName, Function.identity()));
                    for (String townName2 : townNames) {
                        if (townsPOMap.containsKey(townName2)) {
                            townDO = new BkUmcAddressInfoDO();
                            townDO.setName(townName2);
                            townDO.setCode(((BkUmcAddrTownsPO)townsPOMap.get(townName2)).getCode());
                            townList.add(townDO);
                            continue;
                        }
                        townDO = new BkUmcAddressInfoDO();
                        townDO.setName(townName2);
                        townList.add(townDO);
                    }
                } else {
                    townDOS = townNames.stream().map(townName -> {
                        BkUmcAddressInfoDO townDO = new BkUmcAddressInfoDO();
                        townDO.setName(townName);
                        return townDO;
                    }).collect(Collectors.toList());
                    townList.addAll(townDOS);
                }
            }
            if (!CollectionUtils.isEmpty(townCodes)) {
                List<BkUmcAddrTownsPO> listByTownsCode = this.bkUmcAddrTownsMapper.getListByTownsCode(townCodes);
                if (!CollectionUtils.isEmpty(listByTownsCode)) {
                    Map townPOMap = listByTownsCode.stream().collect(Collectors.toMap(BkUmcAddrTownsPO::getCode, Function.identity()));
                    for (String townCode2 : townCodes) {
                        if (townPOMap.containsKey(townCode2)) {
                            townDO = new BkUmcAddressInfoDO();
                            townDO.setCode(townCode2);
                            townDO.setName(((BkUmcAddrTownsPO)townPOMap.get(townCode2)).getName());
                            townList.add(townDO);
                            continue;
                        }
                        townDO = new BkUmcAddressInfoDO();
                        townDO.setCode(townCode2);
                        townList.add(townDO);
                    }
                } else {
                    townDOS = townCodes.stream().map(townCode -> {
                        BkUmcAddressInfoDO townDO = new BkUmcAddressInfoDO();
                        townDO.setCode(townCode);
                        return townDO;
                    }).collect(Collectors.toList());
                    townList.addAll(townDOS);
                }
            }
            modelRspBO.setTownList(townList);
        }
        return modelRspBO;
    }

    public List<BkUmcAddressInfoDO> queryAddressTree(BkUmcAddressDO modelReqBO) {
        List<Object> result = new ArrayList();
        ArrayList<String> parentCode = new ArrayList<String>();
        if ("province".equals(modelReqBO.getQueryRange())) {
            List<BkUmcAddrProvincePO> list = this.bkUmcAddrProvinceMapper.getList();
            result = UmcRu.jsl(list, BkUmcAddressInfoDO.class);
        } else if ("city".equals(modelReqBO.getQueryRange())) {
            parentCode.add(modelReqBO.getParentCode());
            List<BkUmcAddrCityPO> list = this.bkUmcAddrCityMapper.getListByProvinceCode(parentCode);
            result = list.stream().map(bkUmcAddrCityPO -> {
                BkUmcAddressInfoDO bkUmcAddressInfoDO = new BkUmcAddressInfoDO();
                bkUmcAddressInfoDO.setName(bkUmcAddrCityPO.getName());
                bkUmcAddressInfoDO.setCode(bkUmcAddrCityPO.getCode());
                bkUmcAddressInfoDO.setParentCode(bkUmcAddrCityPO.getProvinceCode());
                return bkUmcAddressInfoDO;
            }).collect(Collectors.toList());
        } else if ("area".equals(modelReqBO.getQueryRange())) {
            parentCode.add(modelReqBO.getParentCode());
            List<BkUmcAddrAreaPO> list = this.bkUmcAddrAreaMapper.getListByCityCode(parentCode);
            result = list.stream().map(bkUmcAddrAreaPO -> {
                BkUmcAddressInfoDO bkUmcAddressInfoDO = new BkUmcAddressInfoDO();
                bkUmcAddressInfoDO.setName(bkUmcAddrAreaPO.getName());
                bkUmcAddressInfoDO.setCode(bkUmcAddrAreaPO.getCode());
                bkUmcAddressInfoDO.setParentCode(bkUmcAddrAreaPO.getCityCode());
                return bkUmcAddressInfoDO;
            }).collect(Collectors.toList());
        } else if ("town".equals(modelReqBO.getQueryRange())) {
            parentCode.add(modelReqBO.getParentCode());
            List<BkUmcAddrTownsPO> list = this.bkUmcAddrTownsMapper.getListByAreaCode(parentCode);
            result = list.stream().map(bkUmcAddrTownsPO -> {
                BkUmcAddressInfoDO bkUmcAddressInfoDO = new BkUmcAddressInfoDO();
                bkUmcAddressInfoDO.setName(bkUmcAddrTownsPO.getName());
                bkUmcAddressInfoDO.setCode(bkUmcAddrTownsPO.getCode());
                bkUmcAddressInfoDO.setParentCode(bkUmcAddrTownsPO.getAreaCode());
                return bkUmcAddressInfoDO;
            }).collect(Collectors.toList());
        }
        return result;
    }
}

