/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.extension.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoRspBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgExtMap;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgTagRel;
import com.tydic.dyc.umc.model.extension.bo.BkUmcBatchQueryOrgInfoModelReqBO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcCheckSpuCustExistDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcOrgSummaryInfoDO;
import com.tydic.dyc.umc.repository.dao.UmcEnterpriseInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcOrgExtMapMapper;
import com.tydic.dyc.umc.repository.dao.UmcOrgInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcOrgTagRelMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserRoleRelMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserTagRelMapper;
import com.tydic.dyc.umc.repository.dao.extension.BkUmcOrgMapper;
import com.tydic.dyc.umc.repository.dao.extension.BkUmcUserMapper;
import com.tydic.dyc.umc.repository.dao.extension.UmcEnterpriseOrgMapper;
import com.tydic.dyc.umc.repository.dao.extension.UmcEnterpriseRegionMapper;
import com.tydic.dyc.umc.repository.extension.BkUmcOrgRepository;
import com.tydic.dyc.umc.repository.po.UmcEnterpriseInfoPo;
import com.tydic.dyc.umc.repository.po.UmcOrgExtMapPo;
import com.tydic.dyc.umc.repository.po.UmcOrgInfoPo;
import com.tydic.dyc.umc.repository.po.UmcOrgTagRelPo;
import com.tydic.dyc.umc.repository.po.UmcUserInfoPo;
import com.tydic.dyc.umc.repository.po.UmcUserRoleRelPo;
import com.tydic.dyc.umc.repository.po.UmcUserTagRelPo;
import com.tydic.dyc.umc.repository.po.extension.BkUmcCheckSpuCustExistPO;
import com.tydic.dyc.umc.repository.po.extension.BkUmcOrgSummaryInfoPO;
import com.tydic.dyc.umc.repository.po.extension.UmcEnterpriseOrgPO;
import com.tydic.dyc.umc.repository.po.extension.UmcEnterpriseRegionPO;
import com.tydic.dyc.umc.service.constant.BkUmcStatusConstant;
import com.tydic.dyc.umc.service.extension.bo.BkUmcIdentityModifyReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcOrgPathBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQryDepartListReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQryOrgTreeReqBO;
import com.tydic.dyc.umc.service.user.bo.UmcRoleBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BkUmcOrgRepositoryImpl
implements BkUmcOrgRepository {
    private static final Logger log = LoggerFactory.getLogger(BkUmcOrgRepositoryImpl.class);
    @Autowired
    private BkUmcOrgMapper bkUmcOrgMapper;
    @Autowired
    private UmcOrgTagRelMapper umcOrgTagRelMapper;
    @Autowired
    private BkUmcUserMapper bkUmcUserMapper;
    @Autowired
    private UmcUserInfoMapper umcUserInfoMapper;
    @Autowired
    private UmcUserTagRelMapper umcUserTagRelMapper;
    @Autowired
    protected UmcEnterpriseOrgMapper umcEnterpriseOrgMapper;
    @Autowired
    private UmcEnterpriseRegionMapper umcEnterpriseRegionMapper;
    @Value(value="${supDefaultRole:}")
    private String supDefaultRole;
    @Value(value="${purDefaultRole:}")
    private String purDefaultRole;
    @Autowired
    private UmcUserRoleRelMapper umcUserRoleRelMapper;
    @Autowired
    private UmcEnterpriseInfoMapper umcEnterpriseInfoMapper;
    @Autowired
    private UmcOrgInfoMapper umcOrgInfoMapper;
    @Autowired
    private UmcOrgExtMapMapper umcOrgExtMapMapper;
    private static final String CAPITAL = "capitalTransflag";
    private static final Long DEFAULT_TENANT_ID = 10000L;

    public List<BkUmcOrgSummaryInfoDO> batchQueryOrgInfo(BkUmcBatchQueryOrgInfoModelReqBO modelReqBO) {
        List<BkUmcOrgSummaryInfoPO> bkUmcOrgSummaryInfoPOS = new ArrayList<BkUmcOrgSummaryInfoPO>();
        if (ObjectUtil.isNotEmpty((Object)modelReqBO.getOrgIds())) {
            bkUmcOrgSummaryInfoPOS.addAll(this.bkUmcOrgMapper.batchQueryOrgInfoByOrgIds(modelReqBO.getOrgIds()));
        }
        if (ObjectUtil.isNotEmpty((Object)modelReqBO.getExtOrgCodes())) {
            bkUmcOrgSummaryInfoPOS.addAll(this.bkUmcOrgMapper.batchQueryOrgInfoByExtOrgCodes(modelReqBO.getExtOrgCodes()));
        }
        if (ObjectUtil.isNotEmpty((Object)modelReqBO.getExtSupIds())) {
            bkUmcOrgSummaryInfoPOS.addAll(this.bkUmcOrgMapper.batchQueryOrgInfoByExtSupId(modelReqBO.getExtSupIds()));
        }
        if (ObjectUtil.isNotEmpty((Object)modelReqBO.getOrgCodes())) {
            bkUmcOrgSummaryInfoPOS.addAll(this.bkUmcOrgMapper.batchQueryOrgInfoByOrgCodes(modelReqBO.getOrgCodes()));
        }
        if (ObjectUtil.isNotEmpty(bkUmcOrgSummaryInfoPOS)) {
            bkUmcOrgSummaryInfoPOS = bkUmcOrgSummaryInfoPOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<BkUmcOrgSummaryInfoPO>(Comparator.comparing(BkUmcOrgSummaryInfoPO::getOrgId))), ArrayList::new));
        }
        for (BkUmcOrgSummaryInfoPO bkUmcOrgSummaryInfoPO : bkUmcOrgSummaryInfoPOS) {
            UmcOrgExtMapPo qryBO = new UmcOrgExtMapPo();
            qryBO.setOrgId(bkUmcOrgSummaryInfoPO.getOrgId());
            qryBO.setDelFlag("0");
            qryBO.setFieldCode(CAPITAL);
            UmcOrgExtMapPo modelBy = this.umcOrgExtMapMapper.getModelBy(qryBO);
            if (!ObjectUtil.isNotEmpty((Object)modelBy)) continue;
            bkUmcOrgSummaryInfoPO.setCapitalTransflag(modelBy.getFieldValue());
        }
        return UmcRu.jsl(bkUmcOrgSummaryInfoPOS, BkUmcOrgSummaryInfoDO.class);
    }

    public List<BkUmcOrgSummaryInfoDO> batchQueryOrgIdentityList(BkUmcBatchQueryOrgInfoModelReqBO modelReqBO) {
        List<BkUmcOrgSummaryInfoPO> bkUmcOrgSummaryInfoPOS = this.bkUmcOrgMapper.batchQueryOrgIdentityList(modelReqBO.getOrgIds());
        return ObjectUtil.isNotEmpty(bkUmcOrgSummaryInfoPOS) ? UmcRu.jsl(bkUmcOrgSummaryInfoPOS, BkUmcOrgSummaryInfoDO.class) : new ArrayList();
    }

    public void updateOrgAndUserIdentity(BkUmcOrgSummaryInfoDO modelReqBO) {
        int i;
        UmcOrgTagRelPo qryTagPO = new UmcOrgTagRelPo();
        qryTagPO.setOrgId(modelReqBO.getOrgId());
        List<UmcOrgTagRelPo> tagRelMapperList = this.umcOrgTagRelMapper.getList(qryTagPO);
        if (ObjectUtil.isNotEmpty(tagRelMapperList) && (i = this.bkUmcOrgMapper.deleteIdentityByOrgId(modelReqBO.getOrgId())) < 1) {
            throw new BaseBusinessException("200100", "\u4f1a\u5458\u4e2d\u5fc3\u5220\u9664\u673a\u6784\u8d38\u6613\u8eab\u4efd\u5931\u8d25");
        }
        List<UmcOrgTagRelPo> insertOrgPOS = modelReqBO.getIdentityTags().stream().map(identityTag -> {
            UmcOrgTagRelPo umcOrgTagRelPo = new UmcOrgTagRelPo();
            umcOrgTagRelPo.setOrgId(modelReqBO.getOrgId());
            umcOrgTagRelPo.setTagId((String)identityTag);
            umcOrgTagRelPo.setTagStatus("1");
            umcOrgTagRelPo.setRelId(IdUtil.nextId());
            umcOrgTagRelPo.setDelFlag("0");
            return umcOrgTagRelPo;
        }).collect(Collectors.toList());
        this.umcOrgTagRelMapper.insertBatch(insertOrgPOS);
        UmcUserInfoPo queryPO = new UmcUserInfoPo();
        queryPO.setOrgId(modelReqBO.getOrgId());
        List<UmcUserInfoPo> userInfoPos = this.umcUserInfoMapper.getList(queryPO);
        if (!CollectionUtils.isEmpty(userInfoPos)) {
            int n;
            int m;
            List<Long> userIds = userInfoPos.stream().map(UmcUserInfoPo::getUserId).collect(Collectors.toList());
            int userTagCount = this.bkUmcUserMapper.selectUserTagByUserId(userIds);
            if (userTagCount > 0 && (m = this.bkUmcUserMapper.deleteIdentityByUserId(userIds)) < 1) {
                throw new BaseBusinessException("200100", "\u4f1a\u5458\u4e2d\u5fc3\u5220\u9664\u7528\u6237\u8d38\u6613\u8eab\u4efd\u5931\u8d25");
            }
            int userRoleCount = this.bkUmcUserMapper.selectUserRoleByUserId(userIds);
            if (userRoleCount > 0 && (n = this.bkUmcUserMapper.deleteRoleByUserId(userIds)) < 1) {
                throw new BaseBusinessException("200100", "\u4f1a\u5458\u4e2d\u5fc3\u5220\u9664\u7528\u6237\u89d2\u8272\u5931\u8d25");
            }
            ArrayList<UmcUserTagRelPo> insertUserPOS = new ArrayList<UmcUserTagRelPo>();
            for (Long userId : userIds) {
                for (String identityTag2 : modelReqBO.getIdentityTags()) {
                    List<UmcUserRoleRelPo> purRoleInfo;
                    UmcUserTagRelPo umcUserTagRelPo = new UmcUserTagRelPo();
                    umcUserTagRelPo.setUserId(userId);
                    umcUserTagRelPo.setTagId(identityTag2);
                    umcUserTagRelPo.setRelId(IdUtil.nextId());
                    umcUserTagRelPo.setIsDefalt(UmcStatusConstant.IsCreateDefaultAccount.YES.toString());
                    umcUserTagRelPo.setDelFlag("0");
                    insertUserPOS.add(umcUserTagRelPo);
                    if ("2".equals(identityTag2)) {
                        List<UmcUserRoleRelPo> supRoleInfo = this.createUserRoleInfo(userId, identityTag2, this.supDefaultRole);
                        if (CollectionUtils.isEmpty(supRoleInfo)) continue;
                        this.umcUserRoleRelMapper.insertBatch(supRoleInfo);
                        continue;
                    }
                    if (!"1".equals(identityTag2) || CollectionUtils.isEmpty(purRoleInfo = this.createUserRoleInfo(userId, identityTag2, this.purDefaultRole))) continue;
                    this.umcUserRoleRelMapper.insertBatch(purRoleInfo);
                }
            }
            if (!CollectionUtils.isEmpty(insertUserPOS)) {
                this.umcUserTagRelMapper.insertBatch(insertUserPOS);
            }
        }
    }

    public List<BkUmcOrgSummaryInfoDO> judgeOrgExistOrNot(BkUmcOrgSummaryInfoDO modelReqBO) {
        BkUmcOrgSummaryInfoPO qryPO = (BkUmcOrgSummaryInfoPO)UmcRu.js((Object)modelReqBO, BkUmcOrgSummaryInfoPO.class);
        List<BkUmcOrgSummaryInfoPO> bkUmcOrgSummaryInfoPOS = this.bkUmcOrgMapper.queryOrgByOrgName(qryPO);
        ArrayList<BkUmcOrgSummaryInfoDO> list = new ArrayList<BkUmcOrgSummaryInfoDO>();
        for (String orgName : modelReqBO.getOrgNames()) {
            BkUmcOrgSummaryInfoDO bkUmcOrgSummaryInfoDO = new BkUmcOrgSummaryInfoDO();
            bkUmcOrgSummaryInfoDO.setExistFlag(BkUmcStatusConstant.existFlag.NON_EXISTENCE);
            bkUmcOrgSummaryInfoDO.setOrgName(orgName);
            for (BkUmcOrgSummaryInfoPO bkUmcOrgSummaryInfoPO : bkUmcOrgSummaryInfoPOS) {
                if (!orgName.equals(bkUmcOrgSummaryInfoPO.getOrgName())) continue;
                bkUmcOrgSummaryInfoDO.setExistFlag(BkUmcStatusConstant.existFlag.EXISTENCE);
                bkUmcOrgSummaryInfoDO.setOrgId(bkUmcOrgSummaryInfoPO.getOrgId());
                bkUmcOrgSummaryInfoDO.setOrgCode(bkUmcOrgSummaryInfoPO.getOrgCode());
                bkUmcOrgSummaryInfoDO.setOrgName(bkUmcOrgSummaryInfoPO.getOrgName());
                break;
            }
            list.add(bkUmcOrgSummaryInfoDO);
        }
        return list;
    }

    public List<BkUmcOrgSummaryInfoDO> queryorgByCompanyId(Long companyId) {
        UmcOrgInfoPo qryBO = new UmcOrgInfoPo();
        qryBO.setCompanyId(companyId);
        List<UmcOrgInfoPo> list = this.umcOrgInfoMapper.getList(qryBO);
        return ObjectUtil.isNotEmpty(list) ? UmcRu.jsl(list, BkUmcOrgSummaryInfoDO.class) : new ArrayList();
    }

    public void createOrgInfoExtMap(UmcOrgExtMap umcOrgExtMap) {
        UmcOrgExtMapPo insertPO = (UmcOrgExtMapPo)UmcRu.js((Object)umcOrgExtMap, UmcOrgExtMapPo.class);
        insertPO.setTenantId(DEFAULT_TENANT_ID);
        this.umcOrgExtMapMapper.insert(insertPO);
    }

    public List<BkUmcOrgSummaryInfoDO> qryOrgListByOrgTag(BkUmcOrgSummaryInfoDO modelReqBO) {
        BkUmcOrgSummaryInfoPO qryPO = (BkUmcOrgSummaryInfoPO)UmcRu.js((Object)modelReqBO, BkUmcOrgSummaryInfoPO.class);
        List<BkUmcOrgSummaryInfoPO> bkUmcOrgSummaryInfoPOS = this.bkUmcOrgMapper.qryOrgListByOrgTag(qryPO);
        return ObjectUtil.isNotEmpty(bkUmcOrgSummaryInfoPOS) ? UmcRu.jsl(bkUmcOrgSummaryInfoPOS, BkUmcOrgSummaryInfoDO.class) : new ArrayList();
    }

    public BkUmcOrgSummaryInfoDO qryRegionByCompanyId(BkUmcOrgSummaryInfoDO modelReqBO) {
        UmcEnterpriseRegionPO regionPO;
        BkUmcOrgSummaryInfoDO rspBO = new BkUmcOrgSummaryInfoDO();
        List<BkUmcOrgSummaryInfoPO> summaryInfoPOS = this.bkUmcOrgMapper.batchQueryOrgInfoByOrgIds(Collections.singletonList(modelReqBO.getCompanyId()));
        if (ObjectUtil.isNotEmpty(summaryInfoPOS)) {
            BkUmcOrgSummaryInfoPO infoPO = summaryInfoPOS.get(0);
            rspBO.setRegionId(infoPO.getRegionId());
            rspBO.setRegionName(infoPO.getRegionName());
        }
        if (ObjectUtil.isNotEmpty((Object)(regionPO = this.umcEnterpriseRegionMapper.selectByPrimaryKey(rspBO.getRegionId()))) && "1".equals(regionPO.getRegionType())) {
            return rspBO;
        }
        List<UmcEnterpriseOrgPO> umcEnterpriseOrgPOS = this.umcEnterpriseOrgMapper.selectByRegion(regionPO.getRegionId());
        if (ObjectUtil.isNotEmpty(umcEnterpriseOrgPOS)) {
            List childOrgIds = umcEnterpriseOrgPOS.stream().map(UmcEnterpriseOrgPO::getOrgId).collect(Collectors.toList());
            rspBO.setChildOrgIds(childOrgIds);
        }
        return rspBO;
    }

    private List<UmcRoleBo> roleMapUtils(String defaultRoleStr) {
        List<String> ListDefaultRole = Arrays.asList(defaultRoleStr.split("\\|"));
        ArrayList<UmcRoleBo> umcRoleBos = new ArrayList<UmcRoleBo>();
        for (String defaultRole : ListDefaultRole) {
            List<String> defaultRoles = Arrays.asList(defaultRole.split(","));
            UmcRoleBo umcRoleBo = new UmcRoleBo();
            umcRoleBo.setRoleId(Long.valueOf(defaultRoles.get(0)));
            umcRoleBo.setRoleName(defaultRoles.get(1));
            umcRoleBos.add(umcRoleBo);
        }
        return umcRoleBos;
    }

    private List<UmcUserRoleRelPo> createUserRoleInfo(Long userId, String identityTag, String purDefaultRole) {
        ArrayList<UmcUserRoleRelPo> insertRolePOS = new ArrayList<UmcUserRoleRelPo>();
        List<UmcRoleBo> umcRoleBos = this.roleMapUtils(purDefaultRole);
        for (UmcRoleBo roleBo : umcRoleBos) {
            UmcUserRoleRelPo roleRelPo = new UmcUserRoleRelPo();
            roleRelPo.setRelId(IdUtil.nextId());
            roleRelPo.setUserId(userId);
            roleRelPo.setRoleId(roleBo.getRoleId());
            roleRelPo.setRoleName(roleBo.getRoleName());
            roleRelPo.setTagId(identityTag);
            roleRelPo.setTenantId(DEFAULT_TENANT_ID);
            roleRelPo.setDelFlag("0");
            insertRolePOS.add(roleRelPo);
        }
        return insertRolePOS;
    }

    public UmcOrgInfoRspBo getOrgInfoList(UmcOrgInfoQryBo qryBo) {
        UmcOrgInfoPo umcOrgInfoPo = (UmcOrgInfoPo)UmcRu.js((Object)qryBo, UmcOrgInfoPo.class);
        List<UmcOrgInfoPo> umcOrgInfoPoList = this.bkUmcOrgMapper.getList(umcOrgInfoPo);
        List enterpriseOrgList = new ArrayList(0);
        if (!CollectionUtils.isEmpty(umcOrgInfoPoList)) {
            enterpriseOrgList = UmcRu.jsl(umcOrgInfoPoList, UmcOrgInfo.class);
            for (UmcOrgInfo orgInfo : enterpriseOrgList) {
                UmcOrgTagRelPo enterpriseOrgTagRelPo = new UmcOrgTagRelPo();
                enterpriseOrgTagRelPo.setOrgId(orgInfo.getOrgId());
                List<UmcOrgTagRelPo> enterpriseOrgTagRelPoList = this.umcOrgTagRelMapper.getList(enterpriseOrgTagRelPo);
                if (CollectionUtils.isEmpty(enterpriseOrgTagRelPoList)) continue;
                List enterpriseOrgTagRelList = UmcRu.jsl(enterpriseOrgTagRelPoList, UmcOrgTagRel.class);
                orgInfo.setOrgTagRelList(enterpriseOrgTagRelList);
            }
        }
        UmcOrgInfoRspBo rspBo = new UmcOrgInfoRspBo();
        rspBo.setRows(enterpriseOrgList);
        return rspBo;
    }

    public List<BkUmcCheckSpuCustExistDO> checkSpuCustExist(BkUmcCheckSpuCustExistDO reqBO) {
        BkUmcCheckSpuCustExistPO existPO = (BkUmcCheckSpuCustExistPO)UmcRu.js((Object)reqBO, BkUmcCheckSpuCustExistPO.class);
        List<BkUmcCheckSpuCustExistPO> existPO1 = this.bkUmcOrgMapper.checkSpuCustExist(existPO);
        List<Object> rspBO = new ArrayList<BkUmcCheckSpuCustExistDO>();
        if (null != reqBO) {
            rspBO = UmcRu.jsl(existPO1, BkUmcCheckSpuCustExistDO.class);
        }
        return rspBO;
    }

    public void modifyIdentity(BkUmcIdentityModifyReqBO reqBO) {
        UmcOrgTagRelPo sysOrgTagRelAddPo = new UmcOrgTagRelPo();
        if (reqBO.getOperation() == 1) {
            this.deleteProfessTag(reqBO);
            sysOrgTagRelAddPo.setOrgId(reqBO.getChangeOrgId());
            sysOrgTagRelAddPo.setTagId("0");
            sysOrgTagRelAddPo.setTagStatus("1");
            sysOrgTagRelAddPo.setDelFlag("0");
            sysOrgTagRelAddPo.setRelId(IdUtil.nextId());
            sysOrgTagRelAddPo.setCreateOperId(reqBO.getUserId());
            sysOrgTagRelAddPo.setCreateTime(new Date());
            sysOrgTagRelAddPo.setCreateOperName(reqBO.getName());
            sysOrgTagRelAddPo.setTenantId(DEFAULT_TENANT_ID);
            this.umcOrgTagRelMapper.insert(sysOrgTagRelAddPo);
            UmcUserInfoPo queryPO = new UmcUserInfoPo();
            queryPO.setOrgId(reqBO.getChangeOrgId());
            List<UmcUserInfoPo> userInfoPos = this.umcUserInfoMapper.getList(queryPO);
            if (!CollectionUtils.isEmpty(userInfoPos)) {
                List<Long> userIds = userInfoPos.stream().map(UmcUserInfoPo::getUserId).collect(Collectors.toList());
                UmcUserTagRelPo where = new UmcUserTagRelPo();
                where.setUserIds(userIds);
                UmcUserTagRelPo set = new UmcUserTagRelPo();
                set.setIsDefalt(UmcStatusConstant.IsCreateDefaultAccount.YES.toString());
                this.umcUserTagRelMapper.updateBy(set, where);
                UmcUserTagRelPo delUserTag = new UmcUserTagRelPo();
                delUserTag.setUserIds(userIds);
                delUserTag.setTagId("0");
                this.umcUserTagRelMapper.delete(delUserTag);
                List<UmcUserTagRelPo> addUserTagRelList = userIds.stream().map(e -> {
                    UmcUserTagRelPo sysUserTagRelPo = new UmcUserTagRelPo();
                    sysUserTagRelPo.setUserId((Long)e);
                    sysUserTagRelPo.setIsDefalt(UmcStatusConstant.IsCreateDefaultAccount.NO.toString());
                    sysUserTagRelPo.setTagId("0");
                    sysUserTagRelPo.setRelId(IdUtil.nextId());
                    sysUserTagRelPo.setDelFlag("0");
                    sysUserTagRelPo.setCreateTime(new Date());
                    sysUserTagRelPo.setCreateOperId(reqBO.getUserId());
                    sysUserTagRelPo.setCreateOperName(reqBO.getName());
                    sysUserTagRelPo.setTenantId(DEFAULT_TENANT_ID);
                    return sysUserTagRelPo;
                }).collect(Collectors.toList());
                this.umcUserTagRelMapper.insertBatch(addUserTagRelList);
            }
        } else {
            this.deleteProfessTag(reqBO);
        }
        UmcOrgInfoPo where = new UmcOrgInfoPo();
        where.setOrgId(reqBO.getChangeOrgId());
        UmcOrgInfoPo set = new UmcOrgInfoPo();
        set.setUpdateOperId(reqBO.getUserId());
        set.setUpdateOperName(reqBO.getName());
        set.setUpdateTime(new Date());
        this.umcOrgInfoMapper.updateBy(set, where);
        UmcEnterpriseInfoPo where1 = new UmcEnterpriseInfoPo();
        where1.setOrgId(reqBO.getChangeOrgId());
        UmcEnterpriseInfoPo set1 = new UmcEnterpriseInfoPo();
        set1.setUpdateOperId(reqBO.getUserId());
        set1.setUpdateOperName(reqBO.getName());
        set1.setUpdateTime(new Date());
        this.umcEnterpriseInfoMapper.updateBy(set1, where1);
    }

    private void deleteProfessTag(BkUmcIdentityModifyReqBO reqBO) {
        UmcOrgTagRelPo delPo = new UmcOrgTagRelPo();
        delPo.setOrgId(reqBO.getChangeOrgId());
        delPo.setTagId("0");
        this.umcOrgTagRelMapper.delete(delPo);
        UmcUserInfoPo queryPO = new UmcUserInfoPo();
        queryPO.setOrgId(reqBO.getChangeOrgId());
        List<UmcUserInfoPo> userInfoPos = this.umcUserInfoMapper.getList(queryPO);
        if (!CollectionUtils.isEmpty(userInfoPos)) {
            List<Long> userIds = userInfoPos.stream().map(UmcUserInfoPo::getUserId).collect(Collectors.toList());
            UmcUserTagRelPo del = new UmcUserTagRelPo();
            del.setUserIds(userIds);
            del.setTagId("0");
            this.umcUserTagRelMapper.delete(del);
        }
    }

    public List<BkUmcOrgPathBO> queryOrgTree(BkUmcQryOrgTreeReqBO reqBO) {
        ArrayList<BkUmcOrgPathBO> orgPathResultList = new ArrayList<BkUmcOrgPathBO>();
        int maxDepth = 10;
        UmcOrgInfoPo orgInfo = this.findCompanyOrgRecursively(reqBO.getOrgId(), 0, 10);
        if (ObjectUtil.isEmpty((Object)orgInfo)) {
            throw new BaseBusinessException("161027", "\u672a\u67e5\u8be2\u5230\u4e0a\u7ea7\u673a\u6784\u4fe1\u606f\uff01");
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getType()) && reqBO.getType() == 2) {
            BkUmcOrgPathBO pathBO = new BkUmcOrgPathBO();
            pathBO.setOrgPath(orgInfo.getOrgTreePath());
            pathBO.setOrgId(orgInfo.getOrgId());
            orgPathResultList.add(pathBO);
        } else {
            UmcOrgInfoPo orgInfoPo = new UmcOrgInfoPo();
            orgInfoPo.setParentId(orgInfo.getOrgId());
            List<UmcOrgInfoPo> list = this.umcOrgInfoMapper.getList(orgInfoPo);
            if (!CollectionUtils.isEmpty(list)) {
                List pathBOS = list.stream().map(e -> {
                    BkUmcOrgPathBO pathBO = new BkUmcOrgPathBO();
                    pathBO.setOrgId(e.getOrgId());
                    pathBO.setOrgPath(e.getOrgTreePath());
                    return pathBO;
                }).collect(Collectors.toList());
                orgPathResultList.addAll(pathBOS);
            }
        }
        return orgPathResultList;
    }

    public List<Long> queryDepartList(BkUmcQryDepartListReqBO reqBO) {
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        int maxDepth = 10;
        UmcOrgInfoPo orgInfo = this.findCompanyOrgRecursively(reqBO.getOrgId(), 0, 10);
        if (ObjectUtil.isEmpty((Object)orgInfo)) {
            throw new BaseBusinessException("161027", "\u672a\u67e5\u8be2\u5230\u4e0a\u7ea7\u673a\u6784\u4fe1\u606f\uff01");
        }
        if (reqBO.getType() == 1) {
            UmcOrgInfoPo orgInfoPo = new UmcOrgInfoPo();
            orgInfoPo.setParentId(orgInfo.getOrgId());
            List<UmcOrgInfoPo> list = this.umcOrgInfoMapper.getList(orgInfoPo);
            if (!CollectionUtil.isEmpty(list)) {
                orgIdList.addAll(list.stream().map(UmcOrgInfoPo::getOrgId).collect(Collectors.toList()));
            }
        } else {
            List<Long> departIdByPathList = this.umcOrgInfoMapper.getDepartIdByPath(orgInfo);
            orgIdList.addAll(departIdByPathList);
        }
        return orgIdList;
    }

    private UmcOrgInfoPo findCompanyOrgRecursively(Long orgId, int currentDepth, int maxDepth) throws BaseBusinessException {
        if (currentDepth >= maxDepth) {
            throw new BaseBusinessException("161027", "\u673a\u6784\u5c42\u7ea7\u8fc7\u6df1\uff0c\u53ef\u80fd\u51fa\u73b0\u4e86\u5faa\u73af\u5f15\u7528");
        }
        UmcOrgInfoPo orgInfoPo = new UmcOrgInfoPo();
        orgInfoPo.setOrgId(orgId);
        UmcOrgInfoPo org = this.umcOrgInfoMapper.findOrg(orgInfoPo);
        if (ObjectUtil.isEmpty((Object)org)) {
            throw new BaseBusinessException("161027", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f\uff0cID: " + orgId);
        }
        if (UmcCommConstant.EnterpriseOrgType.TYPE_COMPANY.equals(org.getOrgType())) {
            return org;
        }
        if (org.getParentId() == null) {
            throw new BaseBusinessException("161027", "\u673a\u6784\u6ca1\u6709\u4e0a\u7ea7\u516c\u53f8");
        }
        return this.findCompanyOrgRecursively(org.getParentId(), currentDepth + 1, maxDepth);
    }
}

