/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.extension.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.extension.bo.BkUmcSupplierOrgInfoDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcSupplierOrgInfoListRspBO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcSupplierOrgQryBo;
import com.tydic.dyc.umc.repository.dao.UmcEnterpriseContactMapper;
import com.tydic.dyc.umc.repository.dao.UmcOrgInfoMapper;
import com.tydic.dyc.umc.repository.dao.extension.BkUmcOrgMapper;
import com.tydic.dyc.umc.repository.dao.extension.BkUmcSupplierAgreementRelationMapper;
import com.tydic.dyc.umc.repository.extension.BkUmcSupplierOrgRepository;
import com.tydic.dyc.umc.repository.po.UmcDycSupplierInfoQryPo;
import com.tydic.dyc.umc.repository.po.UmcSupplierInfoPo;
import com.tydic.dyc.umc.repository.po.extension.BkUmcOrgSummaryInfoPO;
import com.tydic.dyc.umc.repository.po.extension.BkUmcSupplierAgreementRelationPO;
import com.tydic.dyc.umc.repository.po.extension.BkUmcUserSummaryInfoPO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcEnterpriseOrgTreeBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BkUmcSupplierOrgRepositoryImpl
implements BkUmcSupplierOrgRepository {
    private static final Logger log = LoggerFactory.getLogger(BkUmcSupplierOrgRepositoryImpl.class);
    @Autowired
    private BkUmcOrgMapper bkUmcOrgMapper;
    @Autowired
    private BkUmcSupplierAgreementRelationMapper bkUmcSupplierAgreementRelationMapper;
    @Autowired
    private UmcEnterpriseContactMapper umcEnterpriseContactMapper;
    @Autowired
    private UmcOrgInfoMapper umcOrgInfoMapper;

    public BkUmcSupplierOrgInfoListRspBO querySupplierOrgList(BkUmcSupplierOrgQryBo qryBo) {
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        BkUmcOrgSummaryInfoPO bkUmcOrgSummaryInfoPO = (BkUmcOrgSummaryInfoPO)UmcRu.js((Object)qryBo, BkUmcOrgSummaryInfoPO.class);
        List<Object> bkUmcOrgSummaryInfoPOS = new ArrayList();
        bkUmcOrgSummaryInfoPOS = qryBo.getPageNo() == -1 ? this.bkUmcOrgMapper.querySupplierOrgList(bkUmcOrgSummaryInfoPO) : this.bkUmcOrgMapper.querySupplierOrgListPage(bkUmcOrgSummaryInfoPO, (Page<BkUmcUserSummaryInfoPO>)page);
        BkUmcSupplierOrgInfoListRspBO rspBO = new BkUmcSupplierOrgInfoListRspBO();
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(ObjectUtil.isNotEmpty(bkUmcOrgSummaryInfoPOS) ? UmcRu.jsl(bkUmcOrgSummaryInfoPOS, BkUmcSupplierOrgInfoDO.class) : new ArrayList());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public BkUmcSupplierOrgInfoDO querySupplierOrgAndUserDetails(BkUmcSupplierOrgInfoDO modelReqBO) {
        BkUmcOrgSummaryInfoPO bkUmcOrgSummaryInfoPO = null;
        if (!ObjectUtil.isEmpty((Object)modelReqBO.getOrgId())) {
            bkUmcOrgSummaryInfoPO = this.bkUmcOrgMapper.querySupplierOrgAndUserDetails(modelReqBO.getOrgId());
        }
        if (!StringUtils.isEmpty((Object)modelReqBO.getCreditNo())) {
            bkUmcOrgSummaryInfoPO = this.bkUmcOrgMapper.querySupplierOrgAndUserDetailsByCreditNo(modelReqBO.getCreditNo());
        }
        BkUmcSupplierOrgInfoDO bkUmcSupplierOrgInfoDO = (BkUmcSupplierOrgInfoDO)UmcRu.js((Object)bkUmcOrgSummaryInfoPO, BkUmcSupplierOrgInfoDO.class);
        return bkUmcSupplierOrgInfoDO;
    }

    public void syncSupplierAgreementRelation(BkUmcSupplierOrgInfoDO modelReqBO) {
        if ("01".equals(modelReqBO.getSyncType())) {
            BkUmcSupplierAgreementRelationPO queryPO = new BkUmcSupplierAgreementRelationPO();
            queryPO.setSupplierId(modelReqBO.getSupplierId());
            List<BkUmcSupplierAgreementRelationPO> list = this.bkUmcSupplierAgreementRelationMapper.queryList(queryPO);
            if (ObjectUtil.isEmpty(list)) {
                UmcDycSupplierInfoQryPo querContactPO = new UmcDycSupplierInfoQryPo();
                querContactPO.setOrgId(modelReqBO.getSupplierId());
                List<UmcSupplierInfoPo> contactList = this.umcOrgInfoMapper.supplierInfoQryList(querContactPO, (Page<UmcSupplierInfoPo>)new Page());
                if (ObjectUtil.isNotEmpty(contactList)) {
                    BkUmcSupplierAgreementRelationPO insertPO = new BkUmcSupplierAgreementRelationPO();
                    insertPO.setSupplierId(contactList.get(0).getSupplierId());
                    insertPO.setSupplierName(contactList.get(0).getSupplierName());
                    insertPO.setSupplierContactName(contactList.get(0).getConsignerName());
                    insertPO.setSupplierContactPhone(contactList.get(0).getPhoneNumber());
                    insertPO.setId(IdUtil.nextId());
                    int i = this.bkUmcSupplierAgreementRelationMapper.insert(insertPO);
                    if (i < 1) {
                        throw new BaseBusinessException("200100", "\u65b0\u589e\u4f9b\u5e94\u5546\u534f\u8bae\u5173\u8054\u5931\u8d25");
                    }
                }
            } else {
                log.info("\u672a\u67e5\u8be2\u5230\u5173\u8054\u5173\u7cfb,\u65b0\u589e\u4f9b\u5e94\u5546id\u4e3a" + modelReqBO.getSupplierId() + "\u7684\u8054\u7cfb\u4fe1\u606f");
            }
        } else if ("02".equals(modelReqBO.getSyncType())) {
            int i;
            BkUmcSupplierAgreementRelationPO queryPO = new BkUmcSupplierAgreementRelationPO();
            queryPO.setSupplierId(modelReqBO.getSupplierId());
            List<BkUmcSupplierAgreementRelationPO> list = this.bkUmcSupplierAgreementRelationMapper.queryList(queryPO);
            if (ObjectUtil.isNotEmpty(list) && (i = this.bkUmcSupplierAgreementRelationMapper.delete(modelReqBO.getSupplierId())) < 1) {
                throw new BaseBusinessException("200100", "\u5220\u9664\u4f9b\u5e94\u5546\u534f\u8bae\u5173\u8054\u5931\u8d25");
            }
        }
    }

    public BkUmcSupplierOrgInfoListRspBO queryAgreementSupplierList(BkUmcSupplierOrgQryBo qryBo) {
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        BkUmcSupplierAgreementRelationPO queryPO = (BkUmcSupplierAgreementRelationPO)UmcRu.js((Object)qryBo, BkUmcSupplierAgreementRelationPO.class);
        List<BkUmcSupplierAgreementRelationPO> bkUmcSupplierAgreementRelationPOS = this.bkUmcSupplierAgreementRelationMapper.queryListPage(queryPO, (Page<BkUmcSupplierAgreementRelationPO>)page);
        BkUmcSupplierOrgInfoListRspBO rspBO = new BkUmcSupplierOrgInfoListRspBO();
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(ObjectUtil.isNotEmpty(bkUmcSupplierAgreementRelationPOS) ? UmcRu.jsl(bkUmcSupplierAgreementRelationPOS, BkUmcSupplierOrgInfoDO.class) : new ArrayList());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public List<BkUmcEnterpriseOrgTreeBo> qrySup(BkUmcSupplierOrgQryBo qryBo) {
        BkUmcOrgSummaryInfoPO po = new BkUmcOrgSummaryInfoPO();
        po.setOrgName(qryBo.getOrgName());
        List<BkUmcOrgSummaryInfoPO> bkUmcOrgSummaryInfoPOS = this.bkUmcOrgMapper.qrySup(po);
        if (CollectionUtil.isNotEmpty(bkUmcOrgSummaryInfoPOS)) {
            return UmcRu.jsl(bkUmcOrgSummaryInfoPOS, BkUmcEnterpriseOrgTreeBo.class);
        }
        return null;
    }
}

