/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.extension.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.atom.common.extension.api.BkBatchPushTodoFunction;
import com.tydic.dyc.atom.common.extension.bo.BkBatchPushTodoReqBO;
import com.tydic.dyc.atom.common.extension.bo.BkBatchPushTodoRspBO;
import com.tydic.dyc.atom.common.extension.bo.BkPushTodoResultInfoBO;
import com.tydic.dyc.atom.common.extension.bo.NotifyBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.service.constant.BkUmcStatusConstant;
import com.tydic.dyc.umc.service.extension.api.BkUmcTodoService;
import com.tydic.dyc.umc.service.extension.api.BkUmcUserService;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchPushTodoReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchPushTodoRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryUserInfoReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryUserInfoRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcPushTodoInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcUserSummaryInfoBO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BkBatchPushTodoFunctionImpl
implements BkBatchPushTodoFunction {
    private static final Logger log = LoggerFactory.getLogger(BkBatchPushTodoFunctionImpl.class);
    @Value(value="${toDo.sendUrl:}")
    private String sendUrl;
    @Value(value="${toDo.sysCode:}")
    private String sysCode;
    @Value(value="${toDo.status:true}")
    private Boolean status;
    @Value(value="${PORTAL_ADDRESS:}")
    private String portalAddress;
    @Autowired
    private BkUmcTodoService bkUmcTodoService;
    @Autowired
    private BkUmcUserService bkUmcUserService;

    @Override
    public BkBatchPushTodoRspBO batchPushTodo(BkBatchPushTodoReqBO reqBO) {
        this.verifyParam(reqBO);
        List bkUmcPushTodoInfoBOS = reqBO.getTodoInfos().stream().map(bkPushTodoInfoBO -> {
            BkUmcPushTodoInfoBO bkUmcPushTodoInfoBO = new BkUmcPushTodoInfoBO();
            BeanUtils.copyProperties((Object)bkPushTodoInfoBO, (Object)bkUmcPushTodoInfoBO);
            return bkUmcPushTodoInfoBO;
        }).collect(Collectors.toList());
        BkUmcBatchPushTodoReqBO abilityReqBO = new BkUmcBatchPushTodoReqBO();
        abilityReqBO.setTodoInfos(bkUmcPushTodoInfoBOS);
        BkUmcBatchPushTodoRspBO abilityRspBO = this.bkUmcTodoService.batchPushTodo(abilityReqBO);
        if ("0000".equals(abilityRspBO.getRespCode())) {
            BkBatchPushTodoRspBO rspBO = new BkBatchPushTodoRspBO();
            List<BkPushTodoResultInfoBO> resultInfo = abilityRspBO.getResultInfo().stream().map(bkUmcPushTodoResultInfoBO -> {
                BkPushTodoResultInfoBO bkPushTodoResultInfoBO = new BkPushTodoResultInfoBO();
                BeanUtils.copyProperties((Object)bkUmcPushTodoResultInfoBO, (Object)bkPushTodoResultInfoBO);
                return bkPushTodoResultInfoBO;
            }).collect(Collectors.toList());
            if (this.status.booleanValue()) {
                List userIds = reqBO.getTodoInfos().stream().map(e -> Long.valueOf(e.getPendingUserId())).collect(Collectors.toList());
                BkUmcBatchQueryUserInfoReqBO userInfoReqBO = new BkUmcBatchQueryUserInfoReqBO();
                userInfoReqBO.setUserIds(userIds);
                log.info("\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)userInfoReqBO));
                BkUmcBatchQueryUserInfoRspBO userInfoRspBO = this.bkUmcUserService.batchQueryUserInfo(userInfoReqBO);
                log.info("\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)userInfoRspBO));
                Map<Long, String> userIdMap = userInfoRspBO.getUserInfos().stream().filter(e -> ObjectUtil.isNotEmpty((Object)e.getExtUserCode())).collect(Collectors.toMap(BkUmcUserSummaryInfoBO::getUserId, BkUmcUserSummaryInfoBO::getExtUserCode));
                Map<String, Long> PendingUserIdAndTodoIdMap = resultInfo.stream().collect(Collectors.toMap(BkPushTodoResultInfoBO::getPendingUserId, BkPushTodoResultInfoBO::getTodoId));
                List pushTodoInfoBOS = reqBO.getTodoInfos().stream().filter(e -> userIdMap.containsKey(Long.valueOf(e.getPendingUserId()))).collect(Collectors.toList());
                if (ObjectUtil.isEmpty(pushTodoInfoBOS)) {
                    log.info("\u672a\u67e5\u8be2\u5230" + userIds + "\u7684\u4e3b\u6570\u636eID\u4e0d\u63a8\u9001");
                    rspBO.setResultInfo(resultInfo);
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u6210\u529f");
                    return rspBO;
                }
                List<Map<String, String>> mapList = pushTodoInfoBOS.stream().map(bkPushTodoInfoBO -> {
                    NotifyBO notifyBO = new NotifyBO();
                    notifyBO.setUniid(((Long)PendingUserIdAndTodoIdMap.get(bkPushTodoInfoBO.getPendingUserId())).toString());
                    notifyBO.setTitle(bkPushTodoInfoBO.getTodoEvent());
                    String url = bkPushTodoInfoBO.getLinkUrl().contains("&") ? this.portalAddress + bkPushTodoInfoBO.getLinkUrl().replace("&", "&amp;") : this.portalAddress + bkPushTodoInfoBO.getLinkUrl();
                    notifyBO.setUrl(url + "&amp;isApproval=1");
                    notifyBO.setOwner((String)userIdMap.get(Long.valueOf(bkPushTodoInfoBO.getPendingUserId())));
                    notifyBO.setCreated(DateUtils.dateToStrLong((Date)new Date()));
                    notifyBO.setType(BkUmcStatusConstant.TodoOrDoneStatus.TODO.toString());
                    notifyBO.setStatus(BkUmcStatusConstant.TodoOrDoneStatus.TODO.toString());
                    notifyBO.setSender(bkPushTodoInfoBO.getCreateUserName());
                    notifyBO.setDepart(bkPushTodoInfoBO.getCreateOrgName());
                    if (bkPushTodoInfoBO.getCreateUserName().equals("\u7cfb\u7edf\u751f\u6210")) {
                        notifyBO.setSender("\u7cfb\u7edf");
                        notifyBO.setDepart("\u9ed8\u8ba4\u90e8\u95e8");
                    }
                    HashMap map = new HashMap();
                    BeanUtil.copyProperties((Object)notifyBO, map);
                    return map;
                }).collect(Collectors.toList());
                String xml = this.formatDataToXml(mapList);
                log.info("\u5f85\u529e\u8c03\u7528\u5730\u5740\uff1a{}", (Object)this.sendUrl);
                log.info("\u5f85\u529e\u7ec4\u88c5\u5165\u53c2\uff1a{}", (Object)xml);
                try {
                    String body = HttpRequest.post((String)this.sendUrl).body(xml).timeout(10000).execute().body();
                    log.info("\u8c03\u7528\u5f85\u529e\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)body);
                    if (!body.contains("\u53d1\u9001\u6210\u529f")) {
                        log.error("\u53d1\u9001\u5f85\u529e\u6d88\u606f\u5931\u8d25");
                    }
                }
                catch (Exception exception) {
                    log.error("\u53d1\u9001\u5f85\u529e\u6d88\u606f\u5931\u8d25" + exception.getMessage());
                }
            }
            rspBO.setResultInfo(resultInfo);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        throw new ZTBusinessException("\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + abilityRspBO.getRespCode() + "\u3011," + abilityRspBO.getRespDesc());
    }

    private void verifyParam(BkBatchPushTodoReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getTodoInfos())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        reqBO.getTodoInfos().forEach(bkPushTodoInfoBO -> {
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getTodoType())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[todoType]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getBelongModule())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[belongModule]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getTodoEvent())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[todoEvent]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getLinkUrl())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[linkUrl]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getCreateUserName())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[createUserName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingUserId())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingUserId]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingUserName())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingUserName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingOrgId())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingOrgId]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingOrgName())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingOrgName]\u4e3a\u7a7a");
            }
        });
    }

    public String formatDataToXml(List<Map<String, String>> mapList) {
        StringBuilder xml = new StringBuilder();
        xml.append("<todo_list>");
        xml.append("<header>");
        xml.append("<syscode>");
        xml.append(this.sysCode);
        xml.append("</syscode>");
        xml.append("</header>");
        for (Map<String, String> mapdData : mapList) {
            xml.append("<todo_info>");
            if (mapdData != null) {
                Set<Map.Entry<String, String>> set = mapdData.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    if (null == entry.getValue()) continue;
                    xml.append("<").append(entry.getKey()).append(">").append(entry.getValue()).append("</").append(entry.getKey()).append(">");
                }
            }
            xml.append("</todo_info>");
        }
        xml.append("</todo_list>");
        return xml.toString();
    }
}

