/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.extension.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.atom.common.extension.api.BkPushDoneFunction;
import com.tydic.dyc.atom.common.extension.bo.BkPushDoneReqBO;
import com.tydic.dyc.atom.common.extension.bo.BkPushDoneRspBO;
import com.tydic.dyc.atom.common.extension.bo.NotifyBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.service.constant.BkUmcStatusConstant;
import com.tydic.dyc.umc.service.extension.api.BkUmcTodoService;
import com.tydic.dyc.umc.service.extension.api.BkUmcUserService;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryUserInfoReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryUserInfoRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcPushDoneReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcPushDoneRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcUserSummaryInfoBO;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BkPushDoneFunctionImpl
implements BkPushDoneFunction {
    private static final Logger log = LoggerFactory.getLogger(BkPushDoneFunctionImpl.class);
    @Value(value="${toDo.sendUrl:}")
    private String sendUrl;
    @Value(value="${toDo.sysCode:}")
    private String sysCode;
    @Value(value="${toDo.status:}")
    private Boolean status;
    @Value(value="${PORTAL_ADDRESS:}")
    private String portalAddress;
    @Autowired
    private BkUmcTodoService bkUmcTodoService;
    @Autowired
    private BkUmcUserService bkUmcUserService;
    private final String cancel = "5";

    @Override
    public BkPushDoneRspBO pushDone(BkPushDoneReqBO reqBO) {
        this.verifyParam(reqBO);
        BkPushDoneRspBO rspBO = new BkPushDoneRspBO();
        BkUmcPushDoneReqBO abilityReqBO = new BkUmcPushDoneReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)abilityReqBO);
        BkUmcPushDoneRspBO abilityRspBO = this.bkUmcTodoService.pushDone(abilityReqBO);
        if ("0000".equals(abilityRspBO.getRespCode())) {
            if (this.status.booleanValue()) {
                List userIds = abilityRspBO.getTodoInfos().stream().map(e -> Long.valueOf(e.getPendingUserId())).collect(Collectors.toList());
                BkUmcBatchQueryUserInfoReqBO userInfoReqBO = new BkUmcBatchQueryUserInfoReqBO();
                userInfoReqBO.setUserIds(userIds);
                log.info("\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)userInfoReqBO));
                BkUmcBatchQueryUserInfoRspBO userInfoRspBO = this.bkUmcUserService.batchQueryUserInfo(userInfoReqBO);
                log.info("\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)userInfoRspBO));
                Map<Long, String> userIdMap = userInfoRspBO.getUserInfos().stream().filter(e -> ObjectUtil.isNotEmpty((Object)e.getExtUserCode())).collect(Collectors.toMap(BkUmcUserSummaryInfoBO::getUserId, BkUmcUserSummaryInfoBO::getExtUserCode));
                List bkUmcPushDoneInfoBOS = abilityRspBO.getTodoInfos().stream().filter(e -> userIdMap.containsKey(Long.valueOf(e.getPendingUserId()))).collect(Collectors.toList());
                if (ObjectUtil.isEmpty(bkUmcPushDoneInfoBOS)) {
                    log.info("\u672a\u67e5\u8be2\u5230" + userIds + "\u7684\u4e3b\u6570\u636eID\u4e0d\u63a8\u9001");
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u6210\u529f");
                    return rspBO;
                }
                List<Map<String, String>> mapList = bkUmcPushDoneInfoBOS.stream().map(bkUmcPushDoneInfoBO -> {
                    NotifyBO notifyBO = new NotifyBO();
                    notifyBO.setUniid(bkUmcPushDoneInfoBO.getId().toString());
                    notifyBO.setTitle(bkUmcPushDoneInfoBO.getTodoEvent());
                    String url = bkUmcPushDoneInfoBO.getLinkUrl().contains("&") ? this.portalAddress + bkUmcPushDoneInfoBO.getLinkUrl().replace("&", "&amp;") : this.portalAddress + bkUmcPushDoneInfoBO.getLinkUrl();
                    notifyBO.setUrl(url + "&amp;isApproval=2&amp;userId=" + bkUmcPushDoneInfoBO.getPendingUserId() + "&amp;todoId=" + bkUmcPushDoneInfoBO.getId() + "&amp;pendingUserId=" + bkUmcPushDoneInfoBO.getPendingUserId() + "&amp;haveDoneRelativeId=" + reqBO.getHaveDoneRelId());
                    notifyBO.setOwner((String)userIdMap.get(Long.valueOf(bkUmcPushDoneInfoBO.getPendingUserId())));
                    notifyBO.setCreated(DateUtils.dateToStrLong((Date)new Date()));
                    notifyBO.setType(BkUmcStatusConstant.TodoOrDoneStatus.DONE.toString());
                    if (BkUmcStatusConstant.TodoOrDoneStatus.CANCEL.equals(bkUmcPushDoneInfoBO.getTodoStatus()) || BkUmcStatusConstant.TodoOrDoneStatus.CANCEL.equals(bkUmcPushDoneInfoBO.getDealResult())) {
                        notifyBO.setStatus("5");
                    } else {
                        notifyBO.setStatus(BkUmcStatusConstant.TodoOrDoneStatus.DONE.toString());
                    }
                    notifyBO.setSender(bkUmcPushDoneInfoBO.getCreateUserName());
                    notifyBO.setDepart(bkUmcPushDoneInfoBO.getCreateOrgName());
                    if (bkUmcPushDoneInfoBO.getCreateUserName().equals("\u7cfb\u7edf\u751f\u6210")) {
                        notifyBO.setSender("\u7cfb\u7edf");
                        notifyBO.setDepart("\u9ed8\u8ba4\u90e8\u95e8");
                    }
                    HashMap map = new HashMap();
                    BeanUtil.copyProperties((Object)notifyBO, map);
                    return map;
                }).collect(Collectors.toList());
                String xml = this.formatDataToXml(mapList);
                log.info("\u5df2\u529e\u8c03\u7528\u5730\u5740\uff1a{}", (Object)this.sendUrl);
                log.info("\u5df2\u529e\u7ec4\u88c5\u5165\u53c2\uff1a{}", (Object)xml);
                try {
                    String body = HttpRequest.post((String)this.sendUrl).body(xml).timeout(10000).execute().body();
                    log.info("\u8c03\u7528\u5df2\u529e\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)body);
                    if (!body.contains("\u53d1\u9001\u6210\u529f")) {
                        log.error("\u53d1\u9001\u5df2\u529e\u6d88\u606f\u5931\u8d25");
                    }
                }
                catch (Exception exception) {
                    log.error("\u53d1\u9001\u5df2\u529e\u6d88\u606f\u5931\u8d25" + Arrays.toString(exception.getStackTrace()));
                }
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        throw new ZTBusinessException("\u63a8\u9001\u5df2\u529e\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + abilityRspBO.getRespCode() + "\u3011," + abilityRspBO.getRespDesc());
    }

    private void verifyParam(BkPushDoneReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getId()) && ObjectUtil.isEmpty((Object)reqBO.getBusiId())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5165\u53c2\u4e3a\u7a7a");
        }
    }

    public String formatDataToXml(List<Map<String, String>> mapList) {
        StringBuilder xml = new StringBuilder();
        xml.append("<todo_list>");
        xml.append("<header>");
        xml.append("<syscode>");
        xml.append(this.sysCode);
        xml.append("</syscode>");
        xml.append("</header>");
        for (Map<String, String> mapdData : mapList) {
            xml.append("<todo_info>");
            if (mapdData != null) {
                Set<Map.Entry<String, String>> set = mapdData.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    if (null == entry.getValue()) continue;
                    xml.append("<").append(entry.getKey()).append(">").append(entry.getValue()).append("</").append(entry.getKey()).append(">");
                }
            }
            xml.append("</todo_info>");
        }
        xml.append("</todo_list>");
        return xml.toString();
    }
}

