/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscBillRefundWriteRelationAtomService;
import com.tydic.fsc.busibase.atom.bo.FscBillRefundWriteRelationAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscBillRefundWriteRelationAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderWriteRelationMapper;
import com.tydic.fsc.dao.FscRefundChangeItemMapper;
import com.tydic.fsc.dao.FscRefundWriteRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderWriteRelationPO;
import com.tydic.fsc.po.FscRefundChangeItemPO;
import com.tydic.fsc.po.FscRefundWriteRelationPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@Deprecated
public class FscBillRefundWriteRelationAtomServiceImpl
implements FscBillRefundWriteRelationAtomService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscRefundChangeItemMapper fscRefundChangeItemMapper;
    @Autowired
    private FscOrderWriteRelationMapper fscOrderWriteRelationMapper;
    @Autowired
    private FscRefundWriteRelationMapper fscRefundWriteRelationMapper;

    @Override
    public FscBillRefundWriteRelationAtomRspBO dealRefundWriteRelation(FscBillRefundWriteRelationAtomReqBO reqBO) {
        FscBillRefundWriteRelationAtomRspBO rspBO = new FscBillRefundWriteRelationAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealRefundWrite(FscOrderRefundPO refundPO, List<FscRefundChangeItemPO> refundChangePOList) {
        FscRefundWriteRelationPO fscRefundWriteRelationPO = new FscRefundWriteRelationPO();
        fscRefundWriteRelationPO.setRefundId(refundPO.getRefundId());
        List<FscRefundWriteRelationPO> list = this.fscRefundWriteRelationMapper.getList(fscRefundWriteRelationPO);
        if (!CollectionUtils.isEmpty(list)) {
            return;
        }
        FscOrderWriteRelationPO fscOrderWriteRelationPO = new FscOrderWriteRelationPO();
        fscOrderWriteRelationPO.setFscOrderId(refundPO.getFscOrderId());
        List<FscOrderWriteRelationPO> writeOffList = this.fscOrderWriteRelationMapper.getRefundList(fscOrderWriteRelationPO);
        if (CollectionUtils.isEmpty(writeOffList)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u7ed3\u7b97\u5355\u6709\u6548\u6838\u9500\u4fe1\u606f\u4e3a\u7a7a!");
        }
        ArrayList<FscRefundWriteRelationPO> refundWriteRelationPOS = new ArrayList<FscRefundWriteRelationPO>(writeOffList.size());
        ArrayList<FscOrderWriteRelationPO> fscOrderWriteRelationPOS = new ArrayList<FscOrderWriteRelationPO>(writeOffList.size());
        Map<Long, List<FscOrderWriteRelationPO>> relationMap = writeOffList.stream().collect(Collectors.groupingBy(FscOrderWriteRelationPO::getClaimDetailId));
        for (FscRefundChangeItemPO changePO : refundChangePOList) {
            List<FscOrderWriteRelationPO> relationPOList = relationMap.get(changePO.getPreClaimDetailId());
            if (CollectionUtils.isEmpty(relationPOList)) {
                throw new FscBusinessException("198888", "\u67e5\u8be2\u7ed3\u7b97\u5355\u6709\u6548\u6838\u9500\u96c6\u5408\u4e3a\u7a7a!");
            }
            for (FscOrderWriteRelationPO writePO : relationPOList) {
                if (writePO.getWriteOffAmount().compareTo(BigDecimal.ZERO) <= 0) break;
                FscRefundWriteRelationPO refundWritePO = new FscRefundWriteRelationPO();
                BeanUtils.copyProperties((Object)writePO, (Object)refundWritePO);
                refundWritePO.setId(Sequence.getInstance().nextId());
                refundWritePO.setRefundId(refundPO.getRefundId());
                refundWritePO.setWriteOffId(writePO.getId());
                refundWritePO.setCreateTime(new Date());
                refundWritePO.setChangeItemId(changePO.getChangeItemId());
                refundWritePO.setDelFlag(FscConstants.DicDelFlag.NO);
                if (changePO.getChangeAmt().compareTo(writePO.getWriteOffAmount()) <= 0) {
                    refundWritePO.setAmount(changePO.getChangeAmt());
                } else if (changePO.getChangeAmt().compareTo(writePO.getWriteOffAmount()) > 0) {
                    refundWritePO.setAmount(writePO.getWriteOffAmount());
                }
                writePO.setWriteOffAmount(writePO.getWriteOffAmount().subtract(refundWritePO.getAmount()));
                refundWriteRelationPOS.add(refundWritePO);
                FscOrderWriteRelationPO orderWriteRelationPO = new FscOrderWriteRelationPO();
                orderWriteRelationPO.setId(writePO.getId());
                orderWriteRelationPO.setRefundAmt(refundWritePO.getAmount());
                fscOrderWriteRelationPOS.add(orderWriteRelationPO);
            }
        }
        int count = this.fscRefundWriteRelationMapper.insertBatch(refundWriteRelationPOS);
        if (count != refundWriteRelationPOS.size()) {
            throw new FscBusinessException("198888", "\u5b58\u50a8\u56de\u9000\u6838\u9500\u6570\u636e\u5931\u8d25!");
        }
        count = this.fscOrderWriteRelationMapper.updateRefundAmtBatchById(fscOrderWriteRelationPOS);
        if (count != fscOrderWriteRelationPOS.size()) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u6838\u9500\u884c\u6570\u636e\u4fe1\u606f\u5931\u8d25!");
        }
    }

    private void dealRefundWriteBack(FscBillRefundWriteRelationAtomReqBO reqBO) {
        FscRefundWriteRelationPO writeRelationPO = new FscRefundWriteRelationPO();
        writeRelationPO.setRefundId(reqBO.getRefundId());
        List<FscRefundWriteRelationPO> refundWriteRelationPOS = this.fscRefundWriteRelationMapper.getList(writeRelationPO);
        if (CollectionUtils.isEmpty(refundWriteRelationPOS)) {
            return;
        }
        HashMap<Long, BigDecimal> writeMap = new HashMap<Long, BigDecimal>();
        for (FscRefundWriteRelationPO fscRefundWriteRelationPO : refundWriteRelationPOS) {
            writeMap.merge(fscRefundWriteRelationPO.getWriteOffId(), fscRefundWriteRelationPO.getAmount(), BigDecimal::add);
        }
        ArrayList<FscOrderWriteRelationPO> fscOrderWriteRelationPOS = new ArrayList<FscOrderWriteRelationPO>(writeMap.size());
        for (Long id : writeMap.keySet()) {
            FscOrderWriteRelationPO orderWriteRelationPO = new FscOrderWriteRelationPO();
            orderWriteRelationPO.setId(id);
            orderWriteRelationPO.setRefundAmt(((BigDecimal)writeMap.get(id)).negate());
            fscOrderWriteRelationPOS.add(orderWriteRelationPO);
        }
        int n = this.fscOrderWriteRelationMapper.updateRefundAmtBatchById(fscOrderWriteRelationPOS);
        if (n != fscOrderWriteRelationPOS.size()) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u6838\u9500\u884c\u6570\u636e\u4fe1\u606f\u5931\u8d25!");
        }
        int n2 = this.fscRefundWriteRelationMapper.deleteByRefundId(reqBO.getRefundId());
        if (n2 != refundWriteRelationPOS.size()) {
            throw new FscBusinessException("198888", "\u5220\u9664\u56de\u9000\u6838\u9500\u6570\u636e\u5931\u8d25!");
        }
    }

    private void dealRefundWriteUpdate(FscBillRefundWriteRelationAtomReqBO reqBO, FscOrderRefundPO refundPO, List<FscRefundChangeItemPO> refundChangePOList) {
        this.dealRefundWriteBack(reqBO);
        this.dealRefundWrite(refundPO, refundChangePOList);
    }
}

