/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscFinancePlanItemBO;
import com.tydic.fsc.busibase.atom.api.FscFinanceOccupyRefundInfoAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomBankBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomDraftBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomSupplyBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceOccupyBankBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceOccupyBankReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceOccupyDraftBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceOccupyDraftReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceOccupyRspBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceOccupyCapitalBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceOccupyCapitalReqBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceOccupySupplyBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceOccupySupplyReqBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrDraftService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseBankService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseCapitalService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseSupplyService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinanceRollBackLogMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscPurchasePushLogMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.enums.FscFundsclaimBillTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscFinanceRollBackLogPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscPurchasePushLogPo;
import com.tydic.fsc.po.FscRefundFinancePO;
import com.tydic.fsc.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceOccupyRefundInfoAtomServiceImpl
implements FscFinanceOccupyRefundInfoAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceOccupyRefundInfoAtomServiceImpl.class);
    @Autowired
    private FscFinanceOccupyOrDraftService fscFinanceOccupyOrDraftService;
    @Autowired
    private FscFinanceOccupyOrReleaseBankService fscFinanceOccupyOrReleaseBankService;
    @Autowired
    private FscFinanceOccupyOrReleaseSupplyService fscFinanceOccupyOrReleaseSupplyService;
    @Autowired
    private FscFinanceOccupyOrReleaseCapitalService fscFinanceOccupyOrReleaseCapitalService;
    @Autowired
    private FscPurchasePushLogMapper fscPurchasePushLogMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinanceRollBackLogMapper fscFinanceRollBackLogMapper;

    @Override
    public FscFinanceOccupyRefundInfoAtomRspBO dealOccupyRefundInfo(FscFinanceOccupyRefundInfoAtomReqBO reqBO) {
        FscFinanceOccupyRefundInfoAtomRspBO rspBO = new FscFinanceOccupyRefundInfoAtomRspBO();
        ArrayList<FscPurchasePushLogPo> fscPurchasePushLogPoList = new ArrayList<FscPurchasePushLogPo>(1);
        try {
            String billtypeName = "";
            String extBizBilltype = "";
            if (reqBO.getRefundFlag() == 1) {
                billtypeName = FscFundsclaimBillTypeEnum.ADV_PAY_RE_BILL_TYPE_USED_CONTRACT.getDescription();
                extBizBilltype = FscFundsclaimBillTypeEnum.ADV_PAY_RE_BILL_TYPE_USED_CONTRACT.getName();
            } else {
                billtypeName = FscFundsclaimBillTypeEnum.PAY_RE_BILL_TYPE_USED_CONTRACT.getDescription();
                extBizBilltype = FscFundsclaimBillTypeEnum.PAY_RE_BILL_TYPE_USED_CONTRACT.getName();
            }
            this.occupyDraftInfo(reqBO, fscPurchasePushLogPoList, billtypeName, extBizBilltype);
            this.occupyBankInfo(reqBO, fscPurchasePushLogPoList, billtypeName, extBizBilltype);
            this.occupySupplyInfo(reqBO, fscPurchasePushLogPoList, billtypeName, extBizBilltype);
            this.occupyCapital(reqBO, fscPurchasePushLogPoList, billtypeName, extBizBilltype);
            this.addPushLog(fscPurchasePushLogPoList);
        }
        catch (Exception e) {
            this.saveNeedRollBackLog(reqBO, fscPurchasePushLogPoList);
            log.error("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u9000\u6b3e\u5360\u7528\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void occupyDraftInfo(FscFinanceOccupyRefundInfoAtomReqBO reqBO, List<FscPurchasePushLogPo> fscPurchasePushLogPoList, String billtypeName, String extBizBilltype) {
        if (ObjectUtil.isEmpty((Object)((Object)reqBO)) || CollectionUtils.isEmpty(reqBO.getDraftList())) {
            return;
        }
        ArrayList<FscFinanceOccupyDraftBO> draftList = new ArrayList<FscFinanceOccupyDraftBO>(1);
        for (FscFinanceOccupyRefundInfoAtomDraftBO atomDraftBO : reqBO.getDraftList()) {
            FscFinanceOccupyDraftBO fscFinanceOccupyDraftBO = new FscFinanceOccupyDraftBO();
            fscFinanceOccupyDraftBO.setCreateUser(reqBO.getUserName());
            fscFinanceOccupyDraftBO.setCreateUserName(reqBO.getName());
            fscFinanceOccupyDraftBO.setOrgId(reqBO.getFinanceOrgId());
            fscFinanceOccupyDraftBO.setOrgName(reqBO.getFinanceOrgName());
            fscFinanceOccupyDraftBO.setBizClaimAmt(atomDraftBO.getOccAmtLocal());
            fscFinanceOccupyDraftBO.setClaimTime(DateUtil.dateToStrLong((Date)atomDraftBO.getCreateTime()));
            fscFinanceOccupyDraftBO.setBilltypeName(billtypeName);
            fscFinanceOccupyDraftBO.setExtBizBilltype(extBizBilltype);
            fscFinanceOccupyDraftBO.setLedgerReceGuid(atomDraftBO.getGuid());
            fscFinanceOccupyDraftBO.setHeadGuid(String.valueOf(atomDraftBO.getDraftId()));
            fscFinanceOccupyDraftBO.setBillCode(reqBO.getObjNo());
            fscFinanceOccupyDraftBO.setClaimSource("2");
            draftList.add(fscFinanceOccupyDraftBO);
        }
        FscFinanceOccupyDraftReqBO fscFinanceOccupyDraftReqBO = new FscFinanceOccupyDraftReqBO();
        fscFinanceOccupyDraftReqBO.setDraftList(draftList);
        fscFinanceOccupyDraftReqBO.setDraftType(FscConstants.FinanceDraftType.DRAFT);
        FscFinanceOccupyRspBO fscFinanceOccupyRspBO = this.fscFinanceOccupyOrDraftService.occupyDraft(fscFinanceOccupyDraftReqBO);
        if (!"0000".equals(fscFinanceOccupyRspBO.getRespCode())) {
            throw new FscBusinessException("190000", "\u5360\u7528\u7968\u636e\u4fe1\u606f\u5931\u8d25");
        }
        fscPurchasePushLogPoList.add(this.setPushLog(reqBO.getObjId(), reqBO.getObjNo(), JSON.toJSONString((Object)fscFinanceOccupyDraftReqBO), JSON.toJSONString((Object)((Object)fscFinanceOccupyRspBO)), FscConstants.FscPurchasePushType.FINANCE_DRAFT));
        for (FscFinanceOccupyRefundInfoAtomDraftBO atomDraftBO : reqBO.getDraftList()) {
            atomDraftBO.setExtId(fscFinanceOccupyRspBO.getData().get(atomDraftBO.getGuid() + "-" + atomDraftBO.getDraftId()));
        }
        List addFscFinanceDraftInfoList = JSON.parseArray((String)JSON.toJSONString(reqBO.getDraftList()), FscFinanceDraftInfoPO.class);
        this.fscFinanceDraftInfoMapper.updateExtIdBatch(addFscFinanceDraftInfoList);
    }

    private void occupyBankInfo(FscFinanceOccupyRefundInfoAtomReqBO reqBO, List<FscPurchasePushLogPo> fscPurchasePushLogPoList, String billtypeName, String extBizBilltype) {
        if (ObjectUtil.isEmpty((Object)((Object)reqBO)) || CollectionUtils.isEmpty(reqBO.getBankList())) {
            return;
        }
        ArrayList<FscFinanceOccupyBankBO> bankList = new ArrayList<FscFinanceOccupyBankBO>(1);
        for (FscFinanceOccupyRefundInfoAtomBankBO atomBankBO : reqBO.getBankList()) {
            FscFinanceOccupyBankBO fscFinanceOccupyBankBO = new FscFinanceOccupyBankBO();
            fscFinanceOccupyBankBO.setFlowGuid(atomBankBO.getGuid());
            fscFinanceOccupyBankBO.setHeadGuid(String.valueOf(atomBankBO.getStatementId()));
            fscFinanceOccupyBankBO.setBillCode(reqBO.getObjNo());
            fscFinanceOccupyBankBO.setBizClaimAmt(atomBankBO.getOccAmtLocal());
            fscFinanceOccupyBankBO.setCreateUser(reqBO.getUserName());
            fscFinanceOccupyBankBO.setCreateUserName(reqBO.getName());
            fscFinanceOccupyBankBO.setClaimTime(DateUtil.dateToStrLong((Date)atomBankBO.getCreateTime()));
            fscFinanceOccupyBankBO.setOrgId(reqBO.getFinanceOrgId());
            fscFinanceOccupyBankBO.setOrgName(reqBO.getFinanceOrgName());
            fscFinanceOccupyBankBO.setBilltypeName(billtypeName);
            fscFinanceOccupyBankBO.setExtBizBilltype(extBizBilltype);
            fscFinanceOccupyBankBO.setClaimType("1");
            bankList.add(fscFinanceOccupyBankBO);
        }
        FscFinanceOccupyBankReqBO fscFinanceOccupyBankReqBO = new FscFinanceOccupyBankReqBO();
        fscFinanceOccupyBankReqBO.setBankList(bankList);
        FscFinanceOccupyRspBO fscFinanceOccupyRspBO = this.fscFinanceOccupyOrReleaseBankService.occupyBank(fscFinanceOccupyBankReqBO);
        if (!"0000".equals(fscFinanceOccupyRspBO.getRespCode())) {
            throw new FscBusinessException("190000", "\u5360\u7528\u6d41\u6c34\u4fe1\u606f\u5931\u8d25");
        }
        fscPurchasePushLogPoList.add(this.setPushLog(reqBO.getObjId(), reqBO.getObjNo(), JSON.toJSONString((Object)fscFinanceOccupyBankReqBO), JSON.toJSONString((Object)((Object)fscFinanceOccupyRspBO)), FscConstants.FscPurchasePushType.FINANCE_BANK));
        for (FscFinanceOccupyRefundInfoAtomBankBO atomBankBO : reqBO.getBankList()) {
            atomBankBO.setExtId(fscFinanceOccupyRspBO.getData().get(atomBankBO.getGuid() + "-" + atomBankBO.getStatementId()));
        }
        List addFscFinanceBankStatementList = JSON.parseArray((String)JSON.toJSONString(reqBO.getBankList()), FscFinanceBankStatementPO.class);
        this.fscFinanceBankStatementMapper.updateExtIdBatch(addFscFinanceBankStatementList);
    }

    private void occupySupplyInfo(FscFinanceOccupyRefundInfoAtomReqBO reqBO, List<FscPurchasePushLogPo> fscPurchasePushLogPoList, String billtypeName, String extBizBilltype) {
        if (ObjectUtil.isEmpty((Object)((Object)reqBO)) || CollectionUtils.isEmpty(reqBO.getSupplyList())) {
            return;
        }
        ArrayList<FscFinanceOccupySupplyBO> supplyList = new ArrayList<FscFinanceOccupySupplyBO>(1);
        for (FscFinanceOccupyRefundInfoAtomSupplyBO atomSupplyBO : reqBO.getSupplyList()) {
            FscFinanceOccupySupplyBO fscFinanceOccupySupplyBO = new FscFinanceOccupySupplyBO();
            fscFinanceOccupySupplyBO.setBizClaimAmount(atomSupplyBO.getOccAmtLocal());
            fscFinanceOccupySupplyBO.setHeadGuid(String.valueOf(atomSupplyBO.getDraftId()));
            fscFinanceOccupySupplyBO.setBillCode(reqBO.getObjNo());
            fscFinanceOccupySupplyBO.setClaimTime(DateUtil.dateToStrLong((Date)atomSupplyBO.getCreateTime()));
            fscFinanceOccupySupplyBO.setCreateUser(reqBO.getName());
            fscFinanceOccupySupplyBO.setCreateUserName(reqBO.getUserName());
            fscFinanceOccupySupplyBO.setLedgerSupplyGuid(atomSupplyBO.getGuid());
            fscFinanceOccupySupplyBO.setExtBizBillType(extBizBilltype);
            fscFinanceOccupySupplyBO.setExtBizTypeName(billtypeName);
            fscFinanceOccupySupplyBO.setOrgId(reqBO.getFinanceOrgId());
            fscFinanceOccupySupplyBO.setOrgName(reqBO.getFinanceOrgName());
            supplyList.add(fscFinanceOccupySupplyBO);
        }
        FscFinanceOccupySupplyReqBO fscFinanceOccupySupplyReqBO = new FscFinanceOccupySupplyReqBO();
        fscFinanceOccupySupplyReqBO.setSupplyList(supplyList);
        fscFinanceOccupySupplyReqBO.setDraftType(FscConstants.FinanceDraftType.SUPPLY);
        FscFinanceOccupyRspBO fscFinanceOccupyRspBO = this.fscFinanceOccupyOrReleaseSupplyService.occupySupply(fscFinanceOccupySupplyReqBO);
        if (!"0000".equals(fscFinanceOccupyRspBO.getRespCode())) {
            throw new FscBusinessException("190000", "\u5360\u7528\u4f9b\u5e94\u94fe\u91d1\u878d\u4fe1\u606f\u5931\u8d25");
        }
        fscPurchasePushLogPoList.add(this.setPushLog(reqBO.getObjId(), reqBO.getObjNo(), JSON.toJSONString((Object)fscFinanceOccupySupplyReqBO), JSON.toJSONString((Object)((Object)fscFinanceOccupyRspBO)), FscConstants.FscPurchasePushType.FINANCE_SUPPLY));
        for (FscFinanceOccupyRefundInfoAtomSupplyBO atomSupplyBO : reqBO.getSupplyList()) {
            atomSupplyBO.setExtId(fscFinanceOccupyRspBO.getData().get(atomSupplyBO.getGuid() + "-" + atomSupplyBO.getDraftId()));
        }
        List addFscFinanceDraftInfoList = JSON.parseArray((String)JSON.toJSONString(reqBO.getSupplyList()), FscFinanceDraftInfoPO.class);
        this.fscFinanceDraftInfoMapper.updateExtIdBatch(addFscFinanceDraftInfoList);
    }

    private void occupyCapital(FscFinanceOccupyRefundInfoAtomReqBO reqBO, List<FscPurchasePushLogPo> fscPurchasePushLogPoList, String billtypeName, String extBizBilltype) {
        if (ObjectUtil.isEmpty((Object)((Object)reqBO)) || CollectionUtils.isEmpty(reqBO.getPlanList())) {
            return;
        }
        FscRefundFinancePO fscRefundFinancePO = this.getRefundFinance(reqBO.getObjId());
        List<FscOrderFinancePO> orderFinance = this.getOrderFinanceList(reqBO.getObjId());
        ArrayList<FscFinanceOccupyCapitalBO> financeOccupyCapitalBOList = new ArrayList<FscFinanceOccupyCapitalBO>(1);
        for (FscFinancePlanItemBO financePlanItemBO : reqBO.getPlanList()) {
            FscFinanceOccupyCapitalBO financeOccupyCapitalBO = new FscFinanceOccupyCapitalBO();
            financeOccupyCapitalBO.setAmount(financePlanItemBO.getOccAmount());
            financeOccupyCapitalBO.setGuid(String.valueOf(financePlanItemBO.getCaptialId()));
            financeOccupyCapitalBO.setLedgerType(financePlanItemBO.getExt1());
            financeOccupyCapitalBO.setPlanDayItem(financePlanItemBO.getPlanItemCode());
            financeOccupyCapitalBO.setBillCode(reqBO.getObjNo());
            financeOccupyCapitalBO.setBizTypeCode(orderFinance.get(0).getBizTypeCode());
            financeOccupyCapitalBOList.add(financeOccupyCapitalBO);
        }
        FscFinanceOccupyCapitalReqBO fscFinanceOccupyCapitalReqBO = new FscFinanceOccupyCapitalReqBO();
        fscFinanceOccupyCapitalReqBO.setUnitCode(fscRefundFinancePO.getCashUnitCode());
        fscFinanceOccupyCapitalReqBO.setPeriod(reqBO.getPlanList().get(0).getPeriod());
        fscFinanceOccupyCapitalReqBO.setList(financeOccupyCapitalBOList);
        FscFinanceOccupyRspBO fscFinanceOccupyRspBO = this.fscFinanceOccupyOrReleaseCapitalService.occupyCapital(fscFinanceOccupyCapitalReqBO);
        if (!"0000".equals(fscFinanceOccupyRspBO.getRespCode())) {
            throw new FscBusinessException("190000", "\u5360\u7528\u8d44\u91d1\u8ba1\u5212\u5931\u8d25:" + fscFinanceOccupyRspBO.getRespDesc());
        }
        fscPurchasePushLogPoList.add(this.setPushLog(reqBO.getObjId(), reqBO.getObjNo(), JSON.toJSONString((Object)((Object)fscFinanceOccupyCapitalReqBO)), JSON.toJSONString((Object)((Object)fscFinanceOccupyRspBO)), FscConstants.FscPurchasePushType.FINANCE_CAPITAL));
    }

    private FscPurchasePushLogPo setPushLog(Long objectId, String objectNo, String pushData, String respData, Integer type) {
        FscPurchasePushLogPo fscPurchasePushLogPo = new FscPurchasePushLogPo();
        fscPurchasePushLogPo.setId(Sequence.getInstance().nextId());
        fscPurchasePushLogPo.setObjectId(objectId);
        fscPurchasePushLogPo.setObjectNo(objectNo);
        fscPurchasePushLogPo.setPushData(pushData);
        fscPurchasePushLogPo.setRespData(respData);
        fscPurchasePushLogPo.setType(type);
        fscPurchasePushLogPo.setCreateTime(new Date());
        fscPurchasePushLogPo.setPushStatus(FscConstants.FscPushStatus.SUCCESS);
        return fscPurchasePushLogPo;
    }

    private void addPushLog(List<FscPurchasePushLogPo> fscPurchasePushLogPoList) {
        if (CollectionUtils.isEmpty(fscPurchasePushLogPoList)) {
            log.info("\u8d22\u52a1\u5171\u4eab\u5360\u7528|\u5360\u7528\u6d41\u6c34\u4fe1\u606f|\u65b0\u589e\u63a8\u9001\u65e5\u5fd7\u96c6\u5408\u4e3a\u7a7a");
            return;
        }
        try {
            this.fscPurchasePushLogMapper.insertBatch(fscPurchasePushLogPoList);
        }
        catch (Exception e) {
            log.error("\u8d22\u52a1\u5171\u4eab\u5360\u7528|\u5360\u7528\u6d41\u6c34\u4fe1\u606f|\u65b0\u589e\u63a8\u9001\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
    }

    private FscRefundFinancePO getRefundFinance(Long refundId) {
        FscRefundFinancePO qryFscRefundFinance = new FscRefundFinancePO();
        qryFscRefundFinance.setRefundId(refundId);
        return this.fscRefundFinanceMapper.getModelBy(qryFscRefundFinance);
    }

    private List<FscOrderFinancePO> getOrderFinanceList(Long refundId) {
        return this.fscOrderFinanceMapper.getListByRefundId(refundId);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void saveNeedRollBackLog(FscFinanceOccupyRefundInfoAtomReqBO reqBO, List<FscPurchasePushLogPo> logPoList) {
        try {
            String dataString = JSONObject.toJSONString(logPoList);
            List logPOList = JSONObject.parseArray((String)dataString, FscFinanceRollBackLogPO.class);
            for (FscFinanceRollBackLogPO logPO : logPOList) {
                logPO.setExt1("2");
            }
            this.fscFinanceRollBackLogMapper.insertBatch(logPOList);
        }
        catch (Exception e) {
            log.error("\u5b58\u50a8\u56de\u6eda\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }
}

