/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscFinanceReleasePayInfoAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleasePayInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleasePayInfoAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceReleaseBankReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceReleaseDraftReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceReleaseRspBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceReleaseCapitalBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceReleaseCapitalReqBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceReleaseSupplyReqBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrDraftService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseBankService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseCapitalService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseSupplyService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscContractRelationMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinancePayReduceMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPurchasePushLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceCapitalPlanPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscPurchasePushLogPo;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceReleasePayInfoAtomServiceImpl
implements FscFinanceReleasePayInfoAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceReleasePayInfoAtomServiceImpl.class);
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinanceOccupyOrReleaseBankService fscFinanceOccupyOrReleaseBankService;
    @Autowired
    private FscFinanceOccupyOrDraftService fscFinanceOccupyOrDraftService;
    @Autowired
    private FscContractRelationMapper fscContractRelationMapper;
    @Autowired
    private FscFinancePayReduceMapper fscFinancePayReduceMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscFinanceOccupyOrReleaseCapitalService fscFinanceOccupyOrReleaseCapitalService;
    @Autowired
    private FscFinanceOccupyOrReleaseSupplyService fscFinanceOccupyOrReleaseSupplyService;
    @Autowired
    private FscPurchasePushLogMapper fscPurchasePushLogMapper;

    @Override
    public FscFinanceReleasePayInfoAtomRspBO dealReleasePayInfo(FscFinanceReleasePayInfoAtomReqBO reqBO) {
        FscFinanceReleaseRspBO rspBO;
        ArrayList<FscPurchasePushLogPo> logPoList = new ArrayList<FscPurchasePushLogPo>();
        if (!com.alibaba.excel.util.CollectionUtils.isEmpty(reqBO.getBankExtIds())) {
            FscFinanceReleaseBankReqBO bankReqBO = new FscFinanceReleaseBankReqBO();
            bankReqBO.setGuids(reqBO.getBankExtIds());
            rspBO = this.fscFinanceOccupyOrReleaseBankService.releaseBank(bankReqBO);
            if (!"0000".equals(rspBO.getRespCode())) {
                throw new FscBusinessException("190000", "\u91ca\u653e\u6d41\u6c34\u4fe1\u606f\u5931\u8d25\uff01");
            }
            logPoList.add(this.addPushLog(reqBO.getObjId(), reqBO.getObjNo(), JSONObject.toJSONString((Object)bankReqBO), rspBO.getRespStr(), FscConstants.FscPurchasePushType.FINANCE_BANK_RELEASE));
        }
        if (!com.alibaba.excel.util.CollectionUtils.isEmpty(reqBO.getDraftExtIds())) {
            FscFinanceReleaseDraftReqBO draftReqBO = new FscFinanceReleaseDraftReqBO();
            draftReqBO.setDraftType(FscConstants.FinanceDraftType.RECEIVABLE_DRAFT);
            draftReqBO.setGuids(reqBO.getDraftExtIds());
            rspBO = this.fscFinanceOccupyOrDraftService.releaseDraft(draftReqBO);
            if (!"0000".equals(rspBO.getRespCode())) {
                throw new FscBusinessException("190000", "\u91ca\u653e\u7968\u636e\u4fe1\u606f\u5931\u8d25\uff01");
            }
            logPoList.add(this.addPushLog(reqBO.getObjId(), reqBO.getObjNo(), JSONObject.toJSONString((Object)draftReqBO), rspBO.getRespStr(), FscConstants.FscPurchasePushType.FINANCE_DRAFT_RELEASE));
        }
        if (!com.alibaba.excel.util.CollectionUtils.isEmpty(reqBO.getSupplyExtIds())) {
            FscFinanceReleaseSupplyReqBO supplyReqBO = new FscFinanceReleaseSupplyReqBO();
            supplyReqBO.setGuids(reqBO.getSupplyExtIds());
            rspBO = this.fscFinanceOccupyOrReleaseSupplyService.releaseSupply(supplyReqBO);
            if (!"0000".equals(rspBO.getRespCode())) {
                throw new FscBusinessException("190000", "\u91ca\u653e\u4f9b\u5e94\u94fe\u4fe1\u606f\u5931\u8d25\uff01");
            }
            logPoList.add(this.addPushLog(reqBO.getObjId(), reqBO.getObjNo(), JSONObject.toJSONString((Object)supplyReqBO), rspBO.getRespStr(), FscConstants.FscPurchasePushType.FINANCE_SUPPLY_RELEASE));
        }
        if (!com.alibaba.excel.util.CollectionUtils.isEmpty(reqBO.getReleasePlanList())) {
            FscOrderFinancePO financePO = new FscOrderFinancePO();
            financePO.setFscOrderId(reqBO.getObjId());
            financePO = this.fscOrderFinanceMapper.getModelBy(financePO);
            ArrayList<FscFinanceReleaseCapitalBO> releaseList = new ArrayList<FscFinanceReleaseCapitalBO>(reqBO.getReleasePlanList().size());
            for (FscFinanceCapitalPlanPO planPO : reqBO.getReleasePlanList()) {
                FscFinanceReleaseCapitalBO capitalBO = new FscFinanceReleaseCapitalBO();
                capitalBO.setBillCode(reqBO.getObjNo());
                capitalBO.setBizTypeCode(financePO.getBizTypeCode());
                capitalBO.setGuid(planPO.getCaptialId() + "");
                releaseList.add(capitalBO);
            }
            FscFinanceReleaseCapitalReqBO capitalReqBO = new FscFinanceReleaseCapitalReqBO();
            capitalReqBO.setList(releaseList);
            capitalReqBO.setUnitCode(financePO.getCashUnitCode());
            FscFinanceReleaseRspBO rspBO2 = this.fscFinanceOccupyOrReleaseCapitalService.releaseCapital(capitalReqBO);
            if (!"0000".equals(rspBO2.getRespCode())) {
                throw new FscBusinessException("190000", "\u91ca\u653e\u8d44\u91d1\u8ba1\u5212\u4fe1\u606f\u5931\u8d25\uff01" + rspBO2.getRespDesc());
            }
            logPoList.add(this.addPushLog(reqBO.getObjId(), reqBO.getObjNo(), JSONObject.toJSONString((Object)((Object)capitalReqBO)), rspBO2.getRespStr(), FscConstants.FscPurchasePushType.FINANCE_CAPITAL_RELEASE));
        }
        if (!CollectionUtils.isEmpty(logPoList)) {
            try {
                this.fscPurchasePushLogMapper.insertBatch(logPoList);
            }
            catch (Exception e) {
                log.error("\u5b58\u50a8\u5360\u7528\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        FscFinanceReleasePayInfoAtomRspBO rspBO3 = new FscFinanceReleasePayInfoAtomRspBO();
        rspBO3.setRespCode("0000");
        rspBO3.setRespDesc("\u6210\u529f");
        return rspBO3;
    }

    private FscPurchasePushLogPo addPushLog(Long billId, String billNo, String reqData, String respData, Integer type) {
        FscPurchasePushLogPo logPo = new FscPurchasePushLogPo();
        logPo.setId(Sequence.getInstance().nextId());
        logPo.setCreateTime(new Date());
        logPo.setObjectId(billId);
        logPo.setObjectNo(billNo);
        logPo.setPushData(reqData);
        logPo.setRespData(respData);
        logPo.setPushStatus(FscConstants.FscPushStatus.SUCCESS);
        logPo.setType(type);
        return logPo;
    }
}

