/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.FinanceDraftBO;
import com.tydic.fsc.busibase.external.api.bo.FscQryFinanceDraftReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscQryFinanceDraftRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscQryFinanceDraftService;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.SSLClient;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscQryFinanceDraftServiceImpl
implements FscQryFinanceDraftService {
    private static final Logger log = LoggerFactory.getLogger(FscQryFinanceDraftServiceImpl.class);
    @Value(value="${esb.yc.draft.qry.url:http://172.16.11.136:30000/eip-zcht/service/queryBill}")
    private String draftQryUrl;
    @Value(value="${OPER_ORG_ID}")
    private String operationOrgId;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;
    @Value(value="${DRAFT_NUM:31}")
    private long num;

    @Override
    public FscQryFinanceDraftRspBO qryFinanceDraft(FscQryFinanceDraftReqBO reqBO) {
        String reqData = this.initParam(reqBO);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", reqBO.getToken());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("cipherCode", reqData);
        String returnString = SSLClient.doPost(this.draftQryUrl, paramMap, headerMap);
        log.info("\u4e1a\u8d22\u67e5\u8be2\u6c47\u7968\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)returnString);
        if (StringUtils.isEmpty((Object)returnString)) {
            throw new FscBusinessException("194317", "\u4e1a\u8d22\u67e5\u8be2\u6c47\u7968\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        String data = jsonObject.getString("data");
        FscUnifySettleDecryptionReqBO decryptionReqBO = new FscUnifySettleDecryptionReqBO();
        decryptionReqBO.setData(data);
        FscUnifySettleDecryptionRspBO decryptionRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealParamDecryption(decryptionReqBO);
        if (!decryptionRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u65b0\u4e1a\u8d22\u89e3\u5bc6\u63a5\u53e3\u5931\u8d25\uff1a" + decryptionRspBO.getRespDesc());
        }
        String code = jsonObject.getString("code");
        if (StringUtils.isEmpty((Object)code) || !code.equals("200")) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u65b0\u4e1a\u8d22\u67e5\u6c47\u7968\u63a5\u53e3\u5f02\u5e38\uff1a" + decryptionRspBO.getData());
        }
        JSONObject parseData = JSONObject.parseObject((String)decryptionRspBO.getData());
        JSONArray rows = parseData.getJSONArray("ROWS");
        FscQryFinanceDraftRspBO qryFinanceDraftRspBO = new FscQryFinanceDraftRspBO();
        if (rows != null && rows.size() > 0) {
            List<FinanceDraftBO> list = rows.stream().map(obj -> {
                JSONObject obj1 = (JSONObject)obj;
                FinanceDraftBO bo = new FinanceDraftBO();
                bo.setNum(obj1.getString("NUM"));
                bo.setDraftId(obj1.getString("HEADER_ID"));
                bo.setDraftTypeDis(obj1.getString("BILL_TYPE_DIS"));
                bo.setDraftNumber(obj1.getString("BILL_NUM"));
                bo.setDraftAmount(obj1.getString("FACE_AMOUNT"));
                bo.setDraftDate(obj1.getString("TICKET_DATE"));
                bo.setDueDate(obj1.getString("MATURITY_DATE"));
                bo.setDraftName(obj1.getString("DRAWER_NAME"));
                bo.setInvoiceName(obj1.getString("PAYEE_NAME"));
                bo.setAcceptorName(obj1.getString("ACCEPT_NAME"));
                bo.setAcceptorDate(obj1.getString("ACCEPT_DATE"));
                bo.setOrgName(obj1.getString("PRE_COMPANY"));
                bo.setBillStatusDis(obj1.getString("BILL_STATUS_DIS"));
                return bo;
            }).collect(Collectors.toList());
            qryFinanceDraftRspBO.setRows(list);
            qryFinanceDraftRspBO.setRecordsTotal(Integer.valueOf(parseData.getString("TOTAL")));
        } else {
            qryFinanceDraftRspBO.setRecordsTotal(0);
        }
        qryFinanceDraftRspBO.setPageNo(reqBO.getPageNo());
        qryFinanceDraftRspBO.setRespCode("0000");
        qryFinanceDraftRspBO.setRespCode("0000");
        return qryFinanceDraftRspBO;
    }

    private String initParam(FscQryFinanceDraftReqBO reqBO) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("pageNum", (Object)reqBO.getPageNo());
        jsonObject.put("pageSize", (Object)reqBO.getPageSize());
        jsonObject.put("ORG_ID", (Object)this.operationOrgId);
        jsonObject.put("BILL_STATUS", (Object)"REC");
        if (!StringUtils.isEmpty((Object)reqBO.getDraftNumber())) {
            jsonObject.put("BILL_NUM", (Object)reqBO.getDraftNumber());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getDraftDateStart())) {
            jsonObject.put("TICKET_DATE_START", (Object)reqBO.getDraftDateStart());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getDraftDateEnd())) {
            jsonObject.put("TICKET_DATE_END", (Object)reqBO.getDraftDateEnd());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getDraftAmountStart())) {
            jsonObject.put("FACE_AMOUNT_START", (Object)reqBO.getDraftAmountStart());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getDraftAmountEnd())) {
            jsonObject.put("FACE_AMOUNT_END", (Object)reqBO.getDraftAmountEnd());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getDraftName())) {
            jsonObject.put("DRAWER_NAME", (Object)reqBO.getDraftName());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getInvoiceName())) {
            jsonObject.put("PAYEE_NAME", (Object)reqBO.getInvoiceName());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getAcceptorName())) {
            jsonObject.put("ACCEPT_NAME", (Object)reqBO.getAcceptorName());
        }
        jsonObject.put("MATURITY_DATE_START", (Object)LocalDate.now().plusDays(this.num).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        jsonArray.add((Object)jsonObject);
        log.debug("\u4e1a\u8d22\u67e5\u8be2\u6c47\u7968\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a{}, \u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)jsonArray.toJSONString(), (Object)this.draftQryUrl);
        FscUnifySettleEncryPtionReqBO encryptionReqBO = new FscUnifySettleEncryPtionReqBO();
        encryptionReqBO.setData(jsonArray.toJSONString());
        FscUnifySettleEncryPtionRspBO encryptionRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealArrayEncryption(encryptionReqBO);
        if (!encryptionRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u65b0\u4e1a\u8d22\u52a0\u5bc6\u63a5\u53e3\u5931\u8d25\uff1a" + encryptionRspBO.getRespDesc());
        }
        return encryptionRspBO.getData();
    }
}

