/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.FscReconciliationDataReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscReconciliationDataRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscReconciliationDataService;
import com.tydic.fsc.utils.SSLClient;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscReconciliationDataServiceImpl
implements FscReconciliationDataService {
    private static final Logger log = LoggerFactory.getLogger(FscReconciliationDataServiceImpl.class);
    @Value(value="${CONTRACT_CAPITAL_PLAN_URL:http://172.16.11.136:30000/eip-zcht/apiHandler/getAllMsg}")
    private String url1;

    @Override
    public FscReconciliationDataRspBO getOrderData(FscReconciliationDataReqBO reqBO) {
        JSONObject data = new JSONObject();
        data.put("sqlId", (Object)reqBO.getSqlId());
        JSONObject jsonMap = new JSONObject();
        jsonMap.put("pageNum", (Object)reqBO.getPageNum());
        jsonMap.put("pageSize", (Object)reqBO.getPageSize());
        jsonMap.put("START_DATE()", (Object)reqBO.getSTART_DATE());
        jsonMap.put("END_DATE", (Object)reqBO.getEND_DATE());
        data.put("jsonMap", (Object)jsonMap);
        String s = JSONObject.toJSONString((Object)data);
        log.debug("sqlId\uff1a{},\u83b7\u53d6\u4e1a\u8d22\u5bf9\u8d26\u6570\u636e\u8bf7\u6c42\u62a5\u6587\uff1a{}, \u8bf7\u6c42\u5730\u5740\uff1a{}", new Object[]{reqBO.getSqlId(), s, this.url1});
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", reqBO.getToken());
        String returnString = SSLClient.doPostWithHeadMap(this.url1, s, headerMap);
        log.debug("\u83b7\u53d6\u4e1a\u8d22\u5bf9\u8d26\u6570\u636e\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)returnString);
        FscReconciliationDataRspBO fscReconciliationDataRspBO = new FscReconciliationDataRspBO();
        JSONObject object = JSONObject.parseObject((String)returnString);
        if (object.get((Object)"code").toString().equals("200")) {
            JSONObject value = object.getJSONObject("value");
            this.dealType(value, reqBO.getSqlId());
            fscReconciliationDataRspBO.setData(value.toString());
            fscReconciliationDataRspBO.setTotal(value.getInteger("total"));
            fscReconciliationDataRspBO.setRespCode("0000");
        } else {
            fscReconciliationDataRspBO.setRespCode("190000");
        }
        return fscReconciliationDataRspBO;
    }

    private void dealType(JSONObject value, String sqlId) {
        switch (sqlId) {
            case "50011": {
                value.put("type", (Object)"1");
                break;
            }
            case "50012": {
                value.put("type", (Object)"2");
                break;
            }
            case "50017": {
                value.put("type", (Object)"3");
                break;
            }
            case "50014": {
                value.put("type", (Object)"4");
                break;
            }
            case "50016": {
                value.put("type", (Object)"5");
                break;
            }
            case "50015": {
                value.put("type", (Object)"6");
                break;
            }
            default: {
                log.error("type is not exist");
            }
        }
    }
}

