/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb.finance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscFinanceAttachmentBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceFileUploadReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceFileUploadRspBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceFileUploadService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.HttpUtils;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceFileUploadServiceImpl
implements FscFinanceFileUploadService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceFileUploadServiceImpl.class);
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fscFinanceShareRelatedInterfacesAtomService;
    @Value(value="${finance.upload.url:}")
    private String uploadUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FscFinanceFileUploadRspBO dealFinanceUpload(FscFinanceFileUploadReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getFileList())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u9644\u4ef6\u96c6\u5408fileList\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscFinanceFileUploadRspBO rspBO = new FscFinanceFileUploadRspBO();
        FscFinanceShareTokenRspBO shareToken = this.fscFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
        if (StringUtils.isEmpty((String)shareToken.getToken())) {
            throw new FscBusinessException("198888", "\u83b7\u53d6token\u5931\u8d25\uff1a" + shareToken.getRespDesc());
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", shareToken.getToken());
        String result = null;
        File file = null;
        for (AttachmentBO attachmentBO : reqBO.getFileList()) {
            String fileName = Sequence.getInstance().nextId() + attachmentBO.getAttachmentName();
            HttpUtils.httpDownload((String)attachmentBO.getAttachmentUrl(), (String)fileName);
            try {
                byte[] bytes = FscFinanceFileUploadServiceImpl.getBytes(fileName);
                try {
                    ByteArrayInputStream input = new ByteArrayInputStream(bytes);
                    Throwable throwable = null;
                    try {
                        Object object;
                        file = new File(attachmentBO.getAttachmentName());
                        try {
                            FileOutputStream fos = new FileOutputStream(file);
                            object = null;
                            try {
                                int temp;
                                byte[] bt = new byte[10240];
                                while ((temp = input.read(bt)) != -1) {
                                    fos.write(bt, 0, temp);
                                }
                                attachmentBO.setFile(file);
                            }
                            catch (Throwable throwable2) {
                                object = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (fos == null) continue;
                                if (object != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (Throwable throwable3) {
                                        ((Throwable)object).addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                fos.close();
                            }
                        }
                        catch (Exception e) {
                            rspBO.setRespCode("8888");
                            rspBO.setRespDesc("\u4e0b\u8f7d\u672c\u5730\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff01" + e.getMessage());
                            object = rspBO;
                            if (input == null) return object;
                            if (throwable != null) {
                                try {
                                    input.close();
                                    return object;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    return object;
                                }
                            }
                            input.close();
                            return object;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (input == null) continue;
                        if (throwable != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        input.close();
                    }
                }
                catch (Exception e) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u4e0b\u8f7d\u672c\u5730\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff01" + e.getMessage());
                    return rspBO;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u4e0b\u8f7d\u672c\u5730\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff01" + e.getMessage());
                return rspBO;
            }
        }
        try {
            result = HttpUtils.httpUploadBatch((String)this.uploadUrl, reqBO.getFileList(), headerMap, (Long)reqBO.getObjId(), (Integer)reqBO.getFileType());
            log.debug("\u8d22\u52a1\u5171\u4eab\u6587\u4ef6\u6279\u91cf\u4e0a\u4f20\u51fa\u53c2\uff1a{}", (Object)result);
            rspBO = this.parseBatchResult(result);
            return rspBO;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u6279\u91cf\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3\u5931\u8d25\uff1a" + e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u6279\u91cf\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3\u5931\u8d25\uff01" + e.getMessage());
        }
        finally {
            Iterator<AttachmentBO> iterator = reqBO.getFileList().iterator();
            while (iterator.hasNext()) {
                AttachmentBO attachmentBO;
                attachmentBO = iterator.next();
                if (!attachmentBO.getFile().exists()) {
                    log.debug("\u5220\u9664\u6587\u4ef6\u5931\u8d25:\uff1a{}\u4e0d\u5b58\u5728\uff01", (Object)attachmentBO.getAttachmentName());
                    continue;
                }
                if (!attachmentBO.getFile().isFile()) continue;
                if (attachmentBO.getFile().delete()) {
                    log.debug("\u5220\u9664\u6587\u4ef6{}\u6210\u529f\uff01", (Object)attachmentBO.getAttachmentName());
                    continue;
                }
                log.debug("\u5220\u9664\u6587\u4ef6{}\u5931\u8d25\uff01", (Object)attachmentBO.getAttachmentName());
            }
            return rspBO;
        }
    }

    private FscFinanceFileUploadRspBO parseBatchResult(String result) {
        FscFinanceFileUploadRspBO rspBO = new FscFinanceFileUploadRspBO();
        if (StringUtils.isEmpty((String)result)) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        JSONObject object = JSONObject.parseObject((String)result);
        String code = object.getString("code");
        if (StringUtils.isEmpty((String)code)) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u72b6\u6001\u7801code\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (!"0".equals(code)) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3\u5931\u8d25\uff1a" + object.getString("msg"));
            return rspBO;
        }
        JSONArray jsonArray = object.getJSONArray("data");
        if (jsonArray.isEmpty()) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587data\u4e3a\u7a7a\uff1a");
            return rspBO;
        }
        String respArray = jsonArray.toJSONString();
        List files = JSONObject.parseArray((String)respArray, FscFinanceAttachmentBO.class);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setFileList(files);
        return rspBO;
    }

    public static byte[] getBytes(String filePath) throws IOException {
        File file = new File(filePath);
        byte[] buffer = new byte[(int)file.length()];
        try (FileInputStream fis = new FileInputStream(file);){
            int bytesRead = fis.read(buffer);
            if (bytesRead != buffer.length) {
                throw new IOException("\u53ea\u8bfb\u53d6\u4e86\u90e8\u5206\u6587\u4ef6\u5185\u5bb9\uff0c\u9884\u671f=" + buffer.length + ", \u5b9e\u9645=" + bytesRead);
            }
        }
        catch (Exception e) {
            throw new IOException("\u83b7\u53d6\u6587\u4ef6\u5b57\u8282\u6d41\u5931\u8d25", e.getCause());
        }
        return buffer;
    }
}

