/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb.finance;

import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceOccupyDraftReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceOccupyRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceReleaseDraftReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceReleaseRspBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrDraftService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.SSLClient;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscFinanceOccupyOrDraftServiceImpl
implements FscFinanceOccupyOrDraftService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceOccupyOrDraftServiceImpl.class);
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fscFinanceShareRelatedInterfacesAtomService;
    @Value(value="${finance.occupy.draft.url:}")
    private String occupyDraftUrl;
    @Value(value="${finance.occupy.receivable.draft.url:}")
    private String occupyReceivableDraftUrl;
    @Value(value="${finance.release.draft.url:}")
    private String releaseDraftUrl;
    @Value(value="${finance.release.receivable.draft.url:}")
    private String releaseReceivableDraftUrl;

    @Override
    public FscFinanceOccupyRspBO occupyDraft(FscFinanceOccupyDraftReqBO reqBO) {
        log.debug("\u5360\u7528\u8d22\u52a1\u5171\u4eab\u7968\u636e\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", this.getToken());
        String reqUrl = "";
        reqUrl = FscConstants.FinanceDraftType.DRAFT.equals(reqBO.getDraftType()) ? this.occupyDraftUrl : this.occupyReceivableDraftUrl;
        String respStr = SSLClient.doPostWithHeadMap(reqUrl, JSONObject.toJSONString(reqBO.getDraftList()), headerMap);
        if (StringUtils.isEmpty((CharSequence)respStr)) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u5360\u7528\u7968\u636e\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        log.debug("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u5360\u7528\u7968\u636e\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587:{}", (Object)respStr);
        try {
            return this.parseData(respStr);
        }
        catch (Exception e) {
            throw new FscBusinessException("198888", "\u89e3\u6790\u8d22\u52a1\u5171\u4eab\u5360\u7528\u7968\u636e\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u5931\u8d25:" + respStr);
        }
    }

    private FscFinanceOccupyRspBO parseData(String respStr) {
        FscFinanceOccupyRspBO rspBO = (FscFinanceOccupyRspBO)((Object)JSONObject.parseObject((String)respStr, FscFinanceOccupyRspBO.class));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespStr(respStr);
        if (StringUtils.isEmpty((CharSequence)rspBO.getCode())) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u5360\u7528\u7968\u636e\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u72b6\u6001\u7801code\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (!"0".equals(rspBO.getCode())) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(rspBO.getMsg());
            return rspBO;
        }
        if (CollectionUtils.isEmpty(rspBO.getData())) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u5360\u7528\u7968\u636e\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u6570\u636edata\u4e3a\u7a7a\uff01");
        }
        return rspBO;
    }

    @Override
    public FscFinanceReleaseRspBO releaseDraft(FscFinanceReleaseDraftReqBO reqBO) {
        log.debug("\u91ca\u653e\u8d22\u52a1\u5171\u4eab\u7968\u636e\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", this.getToken());
        String reqUrl = "";
        reqUrl = FscConstants.FinanceDraftType.DRAFT.equals(reqBO.getDraftType()) ? this.releaseDraftUrl : this.releaseReceivableDraftUrl;
        String reqStr = String.join((CharSequence)",", reqBO.getGuids());
        reqUrl = reqUrl + "?guids=" + reqStr;
        String respStr = SSLClient.doGet(reqUrl, headerMap);
        if (StringUtils.isEmpty((CharSequence)respStr)) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u91ca\u653e\u7968\u636e\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        try {
            JSONObject object = JSONObject.parseObject((String)respStr);
            FscFinanceReleaseRspBO rspBO = new FscFinanceReleaseRspBO();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRespStr(respStr);
            if (StringUtils.isEmpty((CharSequence)object.getString("code"))) {
                rspBO.setRespCode("190000");
                rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u91ca\u653e\u7968\u636e\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u72b6\u6001\u7801code\u4e3a\u7a7a\uff01");
                return rspBO;
            }
            if (!"0".equals(object.getString("code"))) {
                rspBO.setRespCode("190000");
                rspBO.setRespDesc(object.getString("msg"));
                return rspBO;
            }
            return rspBO;
        }
        catch (Exception e) {
            throw new FscBusinessException("198888", "\u89e3\u6790\u8d22\u52a1\u5171\u4eab\u91ca\u653e\u7968\u636e\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u5931\u8d25:" + respStr);
        }
    }

    private String getToken() {
        FscFinanceShareTokenRspBO tokenRspBO = this.fscFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
        if (StringUtils.isEmpty((CharSequence)tokenRspBO.getToken())) {
            throw new FscBusinessException("198888", "\u83b7\u53d6\u8d22\u52a1\u5171\u4eabtoken\u5931\u8d25:" + tokenRspBO.getRespDesc());
        }
        return tokenRspBO.getToken();
    }
}

