/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb.finance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.finance.FscFinanceCmVoucherInfoBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinancePushRefundInvoiceReqBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinancePushRefundInvoiceRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinancePushRefundInvoiceService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.SSLClient;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscFinancePushRefundInvoiceServiceImpl
implements FscFinancePushRefundInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePushRefundInvoiceServiceImpl.class);
    @Value(value="${finance.push.refund.invoice.url:}")
    private String refundInvoiceUrl;

    @Override
    public FscFinancePushRefundInvoiceRspBO dealPushRefundInvoice(FscFinancePushRefundInvoiceReqBO reqBO) {
        log.debug("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u9000\u7968\u5355\u5bfc\u5165\u63a5\u53e3\u5165\u53c2:{}", (Object)reqBO.getObject().toJSONString());
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", reqBO.getToken());
        log.debug("\u8bf7\u6c42\u8def\u5f84\uff1a{}", (Object)this.refundInvoiceUrl);
        String respStr = SSLClient.doPostWithHeadMap(this.refundInvoiceUrl, reqBO.getObject().toJSONString(), headerMap);
        if (StringUtils.isEmpty((CharSequence)respStr)) {
            throw new FscBusinessException("198888", "\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u9000\u7968\u5355\u5bfc\u5165\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        log.debug("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u9000\u7968\u5355\u5bfc\u5165\u63a5\u53e3\u54cd\u5e94\u62a5\u6587:{}", (Object)respStr);
        FscFinancePushRefundInvoiceRspBO rspBO = new FscFinancePushRefundInvoiceRspBO();
        rspBO.setRespStr(respStr);
        try {
            JSONObject respObj = JSONObject.parseObject((String)respStr);
            if (StringUtils.isEmpty((CharSequence)respObj.getString("code"))) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u9000\u7968\u5355\u5bfc\u5165\u63a5\u53e3\u54cd\u5e94\u72b6\u6001\u7801code\u4e3a\u7a7a\uff01");
                return rspBO;
            }
            if (!"0".equals(respObj.getString("code"))) {
                String msg = respObj.getString("msg");
                if ("\u5355\u636e\u5df2\u5bfc\u5165\u8d22\u52a1\u5171\u4eab\uff0c\u8bf7\u52ff\u91cd\u590d\u5bfc\u5165".equals(msg)) {
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc(msg);
                } else {
                    rspBO.setRespCode("198888");
                    rspBO.setRespDesc("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u9000\u7968\u5355\u5bfc\u5165\u63a5\u53e3\u8fd4\u56de\u5904\u7406\u5931\u8d25\u4fe1\u606f\uff1a" + msg);
                }
                return rspBO;
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc(respObj.getString("msg"));
            JSONObject respData = respObj.getJSONObject("data");
            rspBO.setFscFinanceCmVoucherInfoBO((FscFinanceCmVoucherInfoBO)JSON.parseObject((String)respData.getString("cmVoucherInfo"), FscFinanceCmVoucherInfoBO.class));
            return rspBO;
        }
        catch (Exception e) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u9000\u7968\u5355\u5bfc\u5165\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u5931\u8d25" + respStr);
            return rspBO;
        }
    }
}

