/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.utils;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryByTjzBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscComRefundListPageQueryByTjzBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscSearchEsSQLRspBO;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class FscBuildEsQrySqlByTjzConditionUtil {
    private static Integer maxPageSize;

    @Value(value="${es.max.page.size:10000}")
    public void setMaxPageSize(Integer maxPageSize) {
        FscBuildEsQrySqlByTjzConditionUtil.maxPageSize = maxPageSize;
    }

    public String buildComOrderEsSqlByTjz(FscComOrderListPageQueryByTjzBusiReqBO reqBO) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((CharSequence)reqBO.getCcProjectCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"ccProjectCode.keyword", (String)("*" + reqBO.getCcProjectCode() + "*")));
        }
        if (Objects.nonNull(reqBO.getShouldPayMethod())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"shouldPayMethod", (Object)reqBO.getShouldPayMethod()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getQryTimeBegin()) || StringUtils.isNotBlank((CharSequence)reqBO.getQryTimeEnd())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"postingDate");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getQryTimeBegin())) {
                rangeQueryBuilder.gte((Object)this.getTime(reqBO.getQryTimeBegin()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getQryTimeEnd())) {
                rangeQueryBuilder.lte((Object)this.getTime(reqBO.getQryTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (!CollectionUtils.isEmpty(reqBO.getOrderFlows())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderFlow", reqBO.getOrderFlows()));
        }
        if (Objects.nonNull(reqBO.getOrderState())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderState", (Object)reqBO.getOrderState()));
        }
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)"ccProjectCode")).mustNot((QueryBuilder)QueryBuilders.termQuery((String)"ccProjectCode", (String)""));
        SortOrder order = SortOrder.DESC;
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        FieldSortBuilder sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date");
        FscSearchEsSQLRspBO fscSearchEsSQLRspBO = new FscSearchEsSQLRspBO();
        fieldSortBuilders.add(sortQueryFirst);
        fscSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        fscSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        fscSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        fscSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(fscSearchEsSQLRspBO);
    }

    public String buildComRefundEsSqlByTjz(FscComRefundListPageQueryByTjzBusiReqBO reqBO) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((CharSequence)reqBO.getCcProjectCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"ccProjectCode.keyword", (String)("*" + reqBO.getCcProjectCode() + "*")));
        }
        if (!CollectionUtils.isEmpty(reqBO.getOrderFlows())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderFlow", reqBO.getOrderFlows()));
        }
        if (reqBO.getRefundStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"refundStatus", (Object)reqBO.getRefundStatus()));
        }
        if (reqBO.getQryTimeBegin() != null || reqBO.getQryTimeEnd() != null) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"postingDate");
            if (reqBO.getQryTimeBegin() != null) {
                rangeQueryBuilder.gte((Object)this.getTime(reqBO.getQryTimeBegin()));
            }
            if (reqBO.getQryTimeEnd() != null) {
                rangeQueryBuilder.lte((Object)this.getTime(reqBO.getQryTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)"ccProjectCode")).mustNot((QueryBuilder)QueryBuilders.termQuery((String)"ccProjectCode", (String)""));
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        FscSearchEsSQLRspBO fscSearchEsSQLRspBO = new FscSearchEsSQLRspBO();
        SortOrder order = SortOrder.DESC;
        FieldSortBuilder sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date");
        fieldSortBuilders.add(sortQueryFirst);
        fscSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        fscSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        fscSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        fscSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(fscSearchEsSQLRspBO);
    }

    private long getTime(String time) {
        long timeStamp;
        try {
            timeStamp = DateUtil.parseDateTime((CharSequence)time).getTime();
        }
        catch (Exception e) {
            timeStamp = Long.parseLong(time);
        }
        return timeStamp;
    }

    private String getQueryString(FscSearchEsSQLRspBO uocSearchEsSQLRspBO) {
        if (uocSearchEsSQLRspBO.getPageNo() <= 0) {
            uocSearchEsSQLRspBO.setPageNo(1);
        }
        JSONObject queryJson = new JSONObject();
        if (maxPageSize < uocSearchEsSQLRspBO.getPageSize()) {
            queryJson.put("size", (Object)maxPageSize);
        } else {
            queryJson.put("size", (Object)uocSearchEsSQLRspBO.getPageSize());
        }
        queryJson.put("from", (Object)(uocSearchEsSQLRspBO.getPageSize() * (uocSearchEsSQLRspBO.getPageNo() - 1)));
        String queryString = uocSearchEsSQLRspBO.getBoolQueryBuilder().toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        String sortString = uocSearchEsSQLRspBO.getSortQuery().toString();
        queryJson.put("sort", (Object)JSON.parseArray((String)sortString));
        return queryJson.toJSONString();
    }
}

