/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.api.UccMallBatchCurrentPriceQryAbilityService;
import com.tydic.commodity.mall.ability.api.UccMallCurrentPriceQryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallBatchCurrentPriceQryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallBatchCurrentPriceQryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallBatchCurrentPriceQryBO;
import com.tydic.commodity.mall.ability.bo.UccMallCommdPriceBO_busi;
import com.tydic.commodity.mall.ability.bo.UccMallCurrentPriceQryReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallCurrentPriceQryRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallJdPriceBO_busi;
import com.tydic.commodity.mall.ability.bo.UccMallNotJdPriceBO_busi;
import com.tydic.commodity.mall.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.mall.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPicMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPriceMapper;
import com.tydic.commodity.mall.po.UccCommodityPo;
import com.tydic.commodity.mall.po.UccEMdmMaterialPO;
import com.tydic.commodity.mall.po.UccMallEMdmCatalogPo;
import com.tydic.commodity.mall.po.UccSkuPicPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.po.UccSkuPricePo;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallBatchCurrentPriceQryAbilityService"})
public class UccMallBatchCurrentPriceQryAbilityServiceImpl
implements UccMallBatchCurrentPriceQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallBatchCurrentPriceQryAbilityServiceImpl.class);
    @Autowired
    private UccMallSkuMapper uccSkuMapper;
    @Autowired
    private UccMallSkuPriceMapper uccMallSkuPriceMapper;
    @Autowired
    private UccMallCurrentPriceQryAbilityService uccMallCurrentPriceQryAbilityService;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccMallCommodityMapper uccMallCommodityMapper;
    @Autowired
    private UccMallSkuPicMapper uccMallSkuPicMapper;
    @Value(value="${PLAN_BATCH_QRY_FLAG}")
    private String planBatchQryFlag;
    private final String FLAG_STRING = "true";
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"qryBatchCurrentPrice"})
    public UccMallBatchCurrentPriceQryAbilityRspBO qryBatchCurrentPrice(@RequestBody UccMallBatchCurrentPriceQryAbilityReqBO reqBO) {
        List<UccMallEMdmCatalogPo> catalogPos;
        List<UccCommodityPo> uccCommodityPos;
        List<UccEMdmMaterialPO> uccEMdmMaterialPOS;
        UccMallBatchCurrentPriceQryAbilityRspBO rspBO = new UccMallBatchCurrentPriceQryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u8981\u67e5\u8be2\u7684\u5355\u54c1id");
            return rspBO;
        }
        ArrayList<UccMallBatchCurrentPriceQryBO> priceQryBOS = new ArrayList<UccMallBatchCurrentPriceQryBO>();
        List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qeryBatchSkus(reqBO.getSkuIds());
        ArrayList<Long> materialIds = new ArrayList<Long>();
        Map<Object, Object> materialIdMap = new HashMap();
        if (CollectionUtils.isEmpty(uccSkuPos)) {
            throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5546\u54c1\u4fe1\u606f");
        }
        materialIds.addAll(uccSkuPos.stream().filter(e -> !StringUtils.isEmpty((Object)e.getMaterialId())).map(e -> Long.valueOf(e.getMaterialId())).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty(materialIds) && !CollectionUtils.isEmpty(uccEMdmMaterialPOS = this.uccEMdmMaterialMapper.batchQryById(materialIds))) {
            materialIdMap = uccEMdmMaterialPOS.stream().collect(Collectors.toMap(UccEMdmMaterialPO::getMaterialId, UccEMdmMaterialPO2 -> UccEMdmMaterialPO2));
        }
        Map<Long, List<UccSkuPo>> skuIdMap = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSkuId));
        Map<Long, List<UccSkuPo>> localSkuShopMap = uccSkuPos.stream().filter(e -> e.getSkuSource() != 2).collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        for (Map.Entry<Long, List<UccSkuPo>> entry : localSkuShopMap.entrySet()) {
            List<UccSkuPo> list = entry.getValue();
            Long shopId = entry.getKey();
            List<Long> skuIds = list.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            List<UccSkuPricePo> uccSkuPricePos = this.uccMallSkuPriceMapper.batchQryPriBySkuIds(skuIds, shopId);
            for (UccSkuPricePo uccSkuPricePo : uccSkuPricePos) {
                UccMallBatchCurrentPriceQryBO bo = new UccMallBatchCurrentPriceQryBO();
                bo.setSkuId(uccSkuPricePo.getSkuId().toString());
                bo.setNewSalePrice(MoneyUtils.haoToYuan(uccSkuPricePo.getSalePrice()));
                bo.setMarketPrice(MoneyUtils.haoToYuan(uccSkuPricePo.getMarketPrice()));
                priceQryBOS.add(bo);
            }
        }
        Map<Long, List<UccSkuPo>> skuShopMap = uccSkuPos.stream().filter(e -> e.getSkuSource() == 2).collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        for (Map.Entry<Long, List<UccSkuPo>> entry : skuShopMap.entrySet()) {
            List<UccSkuPo> pos = entry.getValue();
            Long shopId = entry.getKey();
            List<Long> skuIds = pos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            UccMallCurrentPriceQryReqBO uccMallCurrentPriceQryReqBO = new UccMallCurrentPriceQryReqBO();
            uccMallCurrentPriceQryReqBO.setSkuIds(skuIds);
            uccMallCurrentPriceQryReqBO.setSupplierShopId(shopId);
            if (!StringUtils.isEmpty((Object)this.planBatchQryFlag) && this.planBatchQryFlag.equals("true")) {
                uccMallCurrentPriceQryReqBO.setPlanBatchQryFlag(Integer.valueOf(1));
            }
            log.info("\u8c03\u7528uccMallCurrentPriceQryAbilityService\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uccMallCurrentPriceQryReqBO));
            try {
                UccMallCurrentPriceQryRspBO uccMallCurrentPriceQryRspBO = this.uccMallCurrentPriceQryAbilityService.changeCommdCurrentPrice(uccMallCurrentPriceQryReqBO);
                log.info("\u8c03\u7528uccMallCurrentPriceQryAbilityService\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uccMallCurrentPriceQryRspBO));
                if ("0000".equals(uccMallCurrentPriceQryRspBO.getRespCode())) {
                    UccMallBatchCurrentPriceQryBO bo;
                    UccMallCommdPriceBO_busi commdPriceInfo = uccMallCurrentPriceQryRspBO.getCommdPriceInfo();
                    if (commdPriceInfo == null) {
                        this.failQry(skuIds, priceQryBOS);
                        continue;
                    }
                    if (!CollectionUtils.isEmpty((Collection)commdPriceInfo.getJdPriceInfos())) {
                        for (UccMallJdPriceBO_busi jdPriceInfo : commdPriceInfo.getJdPriceInfos()) {
                            bo = new UccMallBatchCurrentPriceQryBO();
                            BeanUtils.copyProperties((Object)jdPriceInfo, (Object)bo);
                            priceQryBOS.add(bo);
                        }
                        continue;
                    }
                    for (UccMallNotJdPriceBO_busi notJdPriceBOBusi : commdPriceInfo.getNotJdPriceInfo()) {
                        bo = new UccMallBatchCurrentPriceQryBO();
                        BeanUtils.copyProperties((Object)notJdPriceBOBusi, (Object)bo);
                        priceQryBOS.add(bo);
                    }
                    continue;
                }
                this.failQry(skuIds, priceQryBOS);
            }
            catch (Exception e2) {
                log.error("\u8c03\u7528uccMallCurrentPriceQryAbilityService\u62a5\u9519" + e2.getMessage());
                this.failQry(skuIds, priceQryBOS);
            }
        }
        List<Long> list = uccSkuPos.stream().filter(e -> e.getCommodityId() != null).map(UccSkuPo::getCommodityId).collect(Collectors.toList());
        HashMap hashMap = new HashMap();
        if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(uccCommodityPos = this.uccMallCommodityMapper.batchQryCommd(list, null))) {
            Map<Long, UccCommodityPo> map = uccCommodityPos.stream().collect(Collectors.toMap(UccCommodityPo::getCommodityId, UccCommodityPo2 -> UccCommodityPo2));
        }
        List<Long> skuIds = uccSkuPos.stream().filter(e -> e.getSkuId() != null).map(UccSkuPo::getSkuId).collect(Collectors.toList());
        List<UccSkuPicPo> skuPicPos = this.uccMallSkuPicMapper.qeurySkuPicBySkuIdType(skuIds, 1);
        Map<Long, UccSkuPicPo> skuPicPoMap = skuPicPos.stream().collect(Collectors.toMap(UccSkuPicPo::getSkuId, UccSkuPicPo2 -> UccSkuPicPo2));
        for (UccMallBatchCurrentPriceQryBO bo : priceQryBOS) {
            void var11_18;
            UccEMdmMaterialPO uccEMdmMaterialPO;
            if (StringUtils.isEmpty((Object)bo.getSkuId()) || CollectionUtils.isEmpty((Collection)skuIdMap.get(Long.parseLong(bo.getSkuId())))) continue;
            UccSkuPo uccSkuPo = skuIdMap.get(Long.parseLong(bo.getSkuId())).get(0);
            if (!StringUtils.isEmpty((Object)uccSkuPo.getMaterialId()) && (uccEMdmMaterialPO = (UccEMdmMaterialPO)materialIdMap.get(Long.valueOf(uccSkuPo.getMaterialId()))) != null) {
                bo.setCatalogId(uccEMdmMaterialPO.getCatalogId());
                bo.setMaterialCatalogName(uccEMdmMaterialPO.getCatalogName());
                bo.setMaterialId(uccEMdmMaterialPO.getMaterialId());
                bo.setMaterialLongName(uccEMdmMaterialPO.getLongDesc());
                bo.setMaterialName(uccEMdmMaterialPO.getMaterialName());
                bo.setMeasureName(uccEMdmMaterialPO.getMeasure());
            }
            if (!StringUtils.isEmpty((Object)uccSkuPo.getMeasureName())) {
                bo.setMeasureName(uccSkuPo.getMeasureName());
            }
            if (!StringUtils.isEmpty((Object)uccSkuPo.getMeasureName())) {
                bo.setMeasureName(uccSkuPo.getMeasureName());
            }
            bo.setSkuSource(uccSkuPo.getSkuSource());
            bo.setSkuStatus(uccSkuPo.getSkuStatus());
            bo.setCommodityId(uccSkuPo.getCommodityId());
            bo.setSupplierShopId(uccSkuPo.getSupplierShopId());
            bo.setSkuCode(uccSkuPo.getSkuCode());
            bo.setExtSkuId(uccSkuPo.getExtSkuId());
            bo.setDiscountLimitValue(uccSkuPo.getDiscountLimitValue());
            if (bo.getCommodityId() != null && var11_18.containsKey(bo.getCommodityId())) {
                UccCommodityPo uccCommodityPo = (UccCommodityPo)var11_18.get(uccSkuPo.getCommodityId());
                bo.setCommodityCode(uccCommodityPo.getCommodityCode());
                bo.setVendorId(uccCommodityPo.getVendorId());
            }
            if (skuPicPoMap.containsKey(Long.valueOf(bo.getSkuId()))) {
                UccSkuPicPo uccSkuPicPo = skuPicPoMap.get(Long.valueOf(bo.getSkuId()));
                bo.setSkuPicUrl(uccSkuPicPo.getSkuPicUrl());
            }
            bo.setSkuName(uccSkuPo.getSkuName());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuIds()) && !CollectionUtils.isEmpty(catalogPos = this.uccEMdmCatalogMapper.queryBySkuIds(reqBO.getSkuIds()))) {
            Map<Long, List<UccMallEMdmCatalogPo>> skuIdCatalogMap = catalogPos.stream().collect(Collectors.groupingBy(UccMallEMdmCatalogPo::getSkuId));
            for (UccMallBatchCurrentPriceQryBO priceQryBO : priceQryBOS) {
                Long skuId = Long.valueOf(priceQryBO.getSkuId());
                if (!skuIdCatalogMap.keySet().contains(skuId)) continue;
                priceQryBO.setCatalogCode(skuIdCatalogMap.get(skuId).get(0).getCatalogCode());
            }
        }
        rspBO.setPriceQryBOS(priceQryBOS);
        return rspBO;
    }

    private void failQry(List<Long> skuIds, List<UccMallBatchCurrentPriceQryBO> priceQryBOS) {
        for (Long skuId : skuIds) {
            UccMallBatchCurrentPriceQryBO bo = new UccMallBatchCurrentPriceQryBO();
            bo.setSkuId(skuId.toString());
            priceQryBOS.add(bo);
        }
    }
}

