/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.ability.api.UccMallESearchTOCommodityAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallCommodityToEsRspBO;
import com.tydic.commodity.mall.busi.bo.UccMallCommodityToEsBO;
import com.tydic.commodity.mall.config.MallElasticsearchUtil;
import com.tydic.commodity.mall.config.MallEsConfig;
import com.tydic.commodity.mall.dao.UccMallCatRCommdTypeMapper;
import com.tydic.commodity.mall.dao.UccMallCatalogDealMapper;
import com.tydic.commodity.mall.dao.UccMallChannelDealMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityTypeMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.po.UccCatalogConnectCommdTypeDealPO;
import com.tydic.commodity.mall.po.UccCatalogDealPO;
import com.tydic.commodity.mall.po.UccCommodityPo;
import com.tydic.commodity.mall.po.UccCommodityTypePo;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallESearchTOCommodityAbilityService"})
public class UccMallESearchTOCommodityAbilityServiceImpl
implements UccMallESearchTOCommodityAbilityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallESearchTOCommodityAbilityServiceImpl.class);
    @Autowired
    private UccMallCommodityMapper uccMallCommodityMapper;
    @Autowired
    private UccMallChannelDealMapper uccMallChannelDealMapper;
    @Autowired
    private UccMallCatalogDealMapper uccMallCatalogDealMapper;
    @Autowired
    private UccMallCatRCommdTypeMapper uccMallCatRCommdTypeMapper;
    @Autowired
    private UccMallCommodityTypeMapper uccMallCommodityTypeMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;
    @Autowired
    private MallEsConfig mallEsConfig;

    @PostMapping(value={"autoCommodityToEs"})
    public UccMallCommodityToEsRspBO autoCommodityToEs() {
        ArrayList<UccMallCommodityToEsBO> listEs1 = new ArrayList<UccMallCommodityToEsBO>();
        ArrayList uccCommodityPos = new ArrayList();
        List<UccSkuPo> skuPoList = this.uccMallSkuMapper.selectByCommoditys();
        skuPoList.forEach(uccSkuPo -> {
            UccCommodityPo commodity = this.uccMallCommodityMapper.getCommodityById(uccSkuPo.getCommodityId());
            if (null != commodity) {
                uccCommodityPos.add(commodity);
                UccCommodityTypePo commodityTypePo = this.uccMallCommodityTypeMapper.queryPoByCommodityTypeId(commodity.getCommodityTypeId());
                if (null != commodityTypePo) {
                    UccMallCommodityToEsBO esBO = new UccMallCommodityToEsBO();
                    esBO.setCommodityTypeId(commodityTypePo.getCommodityTypeId());
                    esBO.setCommodityTypeName(commodityTypePo.getCommodityTypeName());
                    List<UccCatalogConnectCommdTypeDealPO> catalogList = this.uccMallCatRCommdTypeMapper.queryByCommodityTypeId(commodityTypePo.getCommodityTypeId());
                    for (UccCatalogConnectCommdTypeDealPO po : catalogList) {
                        UccCatalogDealPO uccCatalogDealPO = new UccCatalogDealPO();
                        uccCatalogDealPO.setGuideCatalogId(po.getGuideCatalogId());
                        UccCatalogDealPO uccCatalogDealPO1 = this.uccMallCatalogDealMapper.selectCatalogById(uccCatalogDealPO);
                        esBO.setChannelId(uccCatalogDealPO1.getChannelId());
                    }
                    listEs1.add(esBO);
                }
            }
        });
        Map<Long, List<UccCommodityPo>> collect = uccCommodityPos.stream().collect(Collectors.groupingBy(b -> b.getCommodityTypeId()));
        for (Long commodityTypeId : collect.keySet()) {
            List<UccCommodityPo> esBOS = collect.get(commodityTypeId);
            Integer commodityNum = esBOS.size();
            for (UccMallCommodityToEsBO bo : listEs1) {
                if (!bo.getCommodityTypeId().equals(commodityTypeId)) continue;
                bo.setCommodityNum(commodityNum);
            }
        }
        this.syncCommodityInfoToEs(listEs1);
        UccMallCommodityToEsRspBO rspBO = new UccMallCommodityToEsRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u540c\u6b65\u5546\u54c1\u7c7b\u578b\u5230ES");
        return rspBO;
    }

    private void syncCommodityInfoToEs(List<UccMallCommodityToEsBO> toEsBOList) {
        for (UccMallCommodityToEsBO uccMallCommodityToEsBO : toEsBOList) {
            String jsonStr = JSONObject.toJSONString((Object)uccMallCommodityToEsBO);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            String esId = String.valueOf(uccMallCommodityToEsBO.getCommodityTypeId());
            String id = this.mallElasticsearchUtil.addData(this.mallEsConfig.getSuggestIndexName(), this.mallEsConfig.getSuggestIndexType(), esId, jsonObject);
            if (!StringUtils.isBlank((CharSequence)id)) continue;
            LOGGER.error("\u5546\u54c1\u4fe1\u606f[" + uccMallCommodityToEsBO.getCommodityTypeName() + "|" + uccMallCommodityToEsBO.getCommodityTypeId() + "]\u540c\u6b65\u5931\u8d25!");
        }
    }
}

