/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.mall.ability.api.UccMallSyncShopDownSkuStateService;
import com.tydic.commodity.mall.ability.bo.UccMallSyncShopDownSkuStateReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSyncShopDownSkuStateRspBO;
import com.tydic.commodity.mall.atom.api.InterfaceQrySkuStateService;
import com.tydic.commodity.mall.atom.api.UccMallSyncSceneCommodityToEsAtomService;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuStateReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuStateRsp;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuStateRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.mall.dao.UccMallEstoreSkuDownTempMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPutCirMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierMapper;
import com.tydic.commodity.mall.dao.UccSkuOperationLogMapper;
import com.tydic.commodity.mall.po.SupplierBusiPo;
import com.tydic.commodity.mall.po.UccMallEstoreSkuDownTempPO;
import com.tydic.commodity.mall.po.UccSkuOperationLogPO;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.po.UccSkuPutCirPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallSyncShopDownSkuStateService"})
public class UccMallSyncShopDownSkuStateServiceImpl
implements UccMallSyncShopDownSkuStateService {
    private static final Logger log = LoggerFactory.getLogger(UccMallSyncShopDownSkuStateServiceImpl.class);
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallSupplierMapper supplierMapper;
    @Autowired
    private InterfaceQrySkuStateService interfaceQrySkuStateService;
    @Autowired
    private UccMallEstoreSkuDownTempMapper uccMallEstoreSkuDownTempMapper;
    @Autowired
    private UccMallSkuPutCirMapper uccMallSkuPutCirMapper;
    @Autowired
    private UccMallSyncSceneCommodityToEsAtomService uccMallSyncSceneCommodityToEsAtomService;
    @Autowired
    private UccSkuOperationLogMapper uccSkuOperationLogMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();

    @PostMapping(value={"qryAndSyncDownSku"})
    public UccMallSyncShopDownSkuStateRspBO qryAndSyncDownSku(@RequestBody UccMallSyncShopDownSkuStateReqBO reqBO) {
        UccMallSyncShopDownSkuStateRspBO rspBO = new UccMallSyncShopDownSkuStateRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Assert.notNull((Object)reqBO);
        Assert.notEmpty((Collection)reqBO.getSupplierIds());
        Assert.notNull((Object)reqBO.getPageSize());
        ExecutorService executor = Executors.newFixedThreadPool(reqBO.getSupplierIds().size());
        List futures = reqBO.getSupplierIds().stream().map(supplierId -> CompletableFuture.supplyAsync(() -> this.process((Long)supplierId, reqBO.getPageSize()), executor)).collect(Collectors.toList());
        rspBO.setReturnList(futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
        executor.shutdown();
        return rspBO;
    }

    @PostMapping(value={"downSku"})
    public UccMallSyncShopDownSkuStateRspBO downSku(@RequestBody UccMallSyncShopDownSkuStateReqBO reqBO) {
        UccMallSyncShopDownSkuStateRspBO rspBO = new UccMallSyncShopDownSkuStateRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UccMallEstoreSkuDownTempPO uccMallEstoreSkuDownTempPO = new UccMallEstoreSkuDownTempPO();
        uccMallEstoreSkuDownTempPO.setState(0);
        List<UccMallEstoreSkuDownTempPO> uccMallEstoreSkuDownTempPOS = this.uccMallEstoreSkuDownTempMapper.selectList(uccMallEstoreSkuDownTempPO);
        if (CollectionUtils.isEmpty(uccMallEstoreSkuDownTempPOS)) {
            return rspBO;
        }
        Integer pageSize = reqBO.getPageSize();
        Map<Long, List<UccMallEstoreSkuDownTempPO>> suppleirMap = uccMallEstoreSkuDownTempPOS.stream().collect(Collectors.groupingBy(UccMallEstoreSkuDownTempPO::getSupplierId));
        for (Long suppleirId : suppleirMap.keySet()) {
            List<UccMallEstoreSkuDownTempPO> uccMallEstoreSkuDownTempPOList = suppleirMap.get(suppleirId);
            int count = uccMallEstoreSkuDownTempPOList.size();
            long totalPage = count % pageSize == 0 ? (long)(count / pageSize) : (long)(count / pageSize + 1);
            int total = (int)totalPage;
            List<Long> skuIds = uccMallEstoreSkuDownTempPOS.stream().map(UccMallEstoreSkuDownTempPO::getSkuId).collect(Collectors.toList());
            try {
                if (CollectionUtils.isEmpty(skuIds)) continue;
                this.uccMallSkuMapper.updateOffSkuStatus(skuIds);
                skuIds.forEach(x -> {
                    UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
                    uccSkuPutCirPo.setId(Sequence.getInstance().nextId());
                    uccSkuPutCirPo.setSkuId((Long)x);
                    uccSkuPutCirPo.setState(2);
                    uccSkuPutCirPo.setPreDownTime(new Date());
                    uccSkuPutCirPo.setRealDownTime(new Date());
                    uccSkuPutCirPo.setDownType(2);
                    uccSkuPutCirPo.setRemark("\u7535\u5546\u4e0b\u67b6(\u5b9a\u65f6\u6821\u9a8c\u4e0b\u67b6)");
                    uccSkuPutCirPo.setSupplierShopId(suppleirId);
                    this.uccMallSkuPutCirMapper.addSkuPutCir(uccSkuPutCirPo);
                });
                CompletableFuture.runAsync(() -> {
                    UccMallSyncSceneCommodityToEsReqBO toEsReqBO = new UccMallSyncSceneCommodityToEsReqBO();
                    toEsReqBO.setSkuIds(skuIds);
                    toEsReqBO.setOperType(2);
                    toEsReqBO.setSyncType(4);
                    toEsReqBO.setSingleType(2);
                    this.uccMallSyncSceneCommodityToEsAtomService.syncSceneCommodityToEs(toEsReqBO);
                });
                List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.qryCmsSkuList(skuIds);
                ArrayList<UccSkuOperationLogPO> recordAbilityBOS = new ArrayList<UccSkuOperationLogPO>();
                for (UccSkuPo po : uccSkuPos) {
                    UccSkuOperationLogPO uccSkuOperationLogPO = new UccSkuOperationLogPO();
                    uccSkuOperationLogPO.setSkuId(po.getSkuId());
                    uccSkuOperationLogPO.setCreateOperId("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c");
                    uccSkuOperationLogPO.setCommodityId(po.getCommodityId());
                    uccSkuOperationLogPO.setCreateTime(new Date());
                    uccSkuOperationLogPO.setExtField1("0");
                    uccSkuOperationLogPO.setOperationType(21);
                    uccSkuOperationLogPO.setRemark("\u5b9a\u65f6\u6821\u9a8c\u4e0b\u67b6");
                    uccSkuOperationLogPO.setSkuExtValue("\u5b9a\u65f6\u6821\u9a8c\u4e0b\u67b6");
                    uccSkuOperationLogPO.setBatchId(this.uccBatchSequence.nextId());
                    recordAbilityBOS.add(uccSkuOperationLogPO);
                }
                try {
                    if (!CollectionUtils.isEmpty(recordAbilityBOS)) {
                        this.uccSkuOperationLogMapper.batchInsert(recordAbilityBOS);
                    }
                }
                catch (Exception e) {
                    log.error("\u8be6\u60c5\u51fa\u53d1\u4e0b\u67b6:{}", (Throwable)e);
                }
                this.uccMallEstoreSkuDownTempMapper.updateBatch(uccMallEstoreSkuDownTempPOList, 1);
            }
            catch (Exception e) {
                log.info("\u7535\u5546\u4e0b\u67b6\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        }
        return rspBO;
    }

    @PostMapping(value={"downEstoreSku"})
    public UccMallSyncShopDownSkuStateRspBO downEstoreSku(@RequestBody UccMallSyncShopDownSkuStateReqBO reqBO) {
        UccMallSyncShopDownSkuStateRspBO rspBO = new UccMallSyncShopDownSkuStateRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Assert.notNull((Object)reqBO);
        Assert.notEmpty((Collection)reqBO.getSupplierIds());
        Assert.notNull((Object)reqBO.getPageSize());
        ExecutorService executor = Executors.newFixedThreadPool(reqBO.getSupplierIds().size());
        List futures = reqBO.getSupplierIds().stream().map(supplierId -> CompletableFuture.supplyAsync(() -> this.processJob((Long)supplierId, reqBO.getPageSize()), executor)).collect(Collectors.toList());
        rspBO.setReturnList(futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
        executor.shutdown();
        return rspBO;
    }

    private Map<Long, Integer> processJob(Long supplierId, Integer pageSize) {
        HashMap<Long, Integer> failTotal = new HashMap<Long, Integer>();
        Integer failCount = 0;
        log.error("--------------\u4f9b\u5e94\u5546:" + supplierId + "\u5f00\u59cb\u6267\u884c---------------");
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuSource(2);
        uccSkuPo.setSkuStatus(3);
        uccSkuPo.setSupplierShopId(supplierId);
        Integer count = this.uccMallSkuMapper.qryShopDownSkuForCount(uccSkuPo);
        if (Objects.isNull(count) || 0 == count) {
            failTotal.put(supplierId, failCount);
            return failTotal;
        }
        long totalPage = count % pageSize == 0 ? (long)(count / pageSize) : (long)(count / pageSize + 1);
        int total = (int)totalPage;
        for (int i = 0; i < total; ++i) {
            try {
                uccSkuPo.setPageStart(i == 0 ? 0 : i * pageSize);
                uccSkuPo.setPageEnd(pageSize);
                List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.qryShopDownSkuForLimit(uccSkuPo);
                if (CollectionUtils.isEmpty(uccSkuPos) || 0 == uccSkuPos.size()) continue;
                List<String> extSkuIds = uccSkuPos.stream().map(UccSkuPo::getExtSkuId).collect(Collectors.toList());
                SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(supplierId);
                String supplierCode = supplierBusiPo.getSupplierCode();
                InterfaceSkuStateReqBO interfaceSkuStateReqBO = new InterfaceSkuStateReqBO();
                interfaceSkuStateReqBO.setSupplierId(supplierId);
                interfaceSkuStateReqBO.setSupplierCode(supplierCode);
                interfaceSkuStateReqBO.setExtSkuIds(extSkuIds);
                InterfaceSkuStateRsp interfaceSkuStateRsp = this.interfaceQrySkuStateService.qrySkuStatus(interfaceSkuStateReqBO);
                if (Objects.nonNull((Object)interfaceSkuStateRsp) && "0000".equals(interfaceSkuStateRsp.getRespCode()) && !CollectionUtils.isEmpty(interfaceSkuStateRsp.getSkuStates())) {
                    List<InterfaceSkuStateRspBo> skuStates = interfaceSkuStateRsp.getSkuStates();
                    List estoreExtSkuIds = skuStates.stream().filter(item -> 0 == item.getState()).map(InterfaceSkuStateRspBo::getSku).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(estoreExtSkuIds) || 0 == estoreExtSkuIds.size()) continue;
                    List<Long> downSkuIdList = uccSkuPos.stream().filter(item -> estoreExtSkuIds.contains(item.getExtSkuId())).map(UccSkuPo::getSkuId).collect(Collectors.toList());
                    try {
                        if (CollectionUtils.isEmpty(downSkuIdList)) continue;
                        this.uccMallSkuMapper.updateOffSkuStatus(downSkuIdList);
                        downSkuIdList.forEach(x -> {
                            UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
                            uccSkuPutCirPo.setId(Sequence.getInstance().nextId());
                            uccSkuPutCirPo.setSkuId((Long)x);
                            uccSkuPutCirPo.setState(2);
                            uccSkuPutCirPo.setPreDownTime(new Date());
                            uccSkuPutCirPo.setRealDownTime(new Date());
                            uccSkuPutCirPo.setDownType(2);
                            uccSkuPutCirPo.setRemark("\u7535\u5546\u4e0b\u67b6(\u5b9a\u65f6\u6821\u9a8c\u4e0b\u67b6)");
                            uccSkuPutCirPo.setSupplierShopId(supplierId);
                            this.uccMallSkuPutCirMapper.addSkuPutCir(uccSkuPutCirPo);
                        });
                        CompletableFuture.runAsync(() -> {
                            UccMallSyncSceneCommodityToEsReqBO toEsReqBO = new UccMallSyncSceneCommodityToEsReqBO();
                            toEsReqBO.setSkuIds(downSkuIdList);
                            toEsReqBO.setOperType(2);
                            toEsReqBO.setSyncType(4);
                            toEsReqBO.setSingleType(2);
                            this.uccMallSyncSceneCommodityToEsAtomService.syncSceneCommodityToEs(toEsReqBO);
                        });
                        List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qryCmsSkuList(downSkuIdList);
                        ArrayList<UccSkuOperationLogPO> recordAbilityBOS = new ArrayList<UccSkuOperationLogPO>();
                        for (UccSkuPo po : uccSkuPoList) {
                            UccSkuOperationLogPO uccSkuOperationLogPO = new UccSkuOperationLogPO();
                            uccSkuOperationLogPO.setSkuId(po.getSkuId());
                            uccSkuOperationLogPO.setCreateOperId("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c");
                            uccSkuOperationLogPO.setCommodityId(po.getCommodityId());
                            uccSkuOperationLogPO.setCreateTime(new Date());
                            uccSkuOperationLogPO.setExtField1("0");
                            uccSkuOperationLogPO.setOperationType(21);
                            uccSkuOperationLogPO.setRemark("\u5b9a\u65f6\u6821\u9a8c\u4e0b\u67b6");
                            uccSkuOperationLogPO.setSkuExtValue("\u5b9a\u65f6\u6821\u9a8c\u4e0b\u67b6");
                            uccSkuOperationLogPO.setBatchId(this.uccBatchSequence.nextId());
                            recordAbilityBOS.add(uccSkuOperationLogPO);
                        }
                        try {
                            if (CollectionUtils.isEmpty(recordAbilityBOS)) continue;
                            this.uccSkuOperationLogMapper.batchInsert(recordAbilityBOS);
                        }
                        catch (Exception e) {
                            log.error("\u8be6\u60c5\u51fa\u53d1\u4e0b\u67b6:{}", (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        log.info("\u7535\u5546\u4e0b\u67b6\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                    }
                    continue;
                }
                log.error("-------------------\u4f9b\u5e94\u5546:" + supplierId + "\u7b2c" + i + "\u6279\u6b21\u6267\u884c\u5931\u8d25 qry shop error-------------------------");
                log.error("-------------------\u4f9b\u5e94\u5546:" + supplierId + "\u7b2c" + i + "\u6279\u6b21\u6267\u884c\u5931\u8d25 error info:" + interfaceSkuStateRsp.getResultMessage());
                Integer n = failCount;
                Integer n2 = failCount = Integer.valueOf(failCount + 1);
                continue;
            }
            catch (Exception e) {
                log.error("-------------------\u4f9b\u5e94\u5546:" + supplierId + "\u7b2c" + i + "\u6279\u6b21\u6267\u884c\u5931\u8d25 system error-------------------------");
                log.error("process error:{}", (Throwable)e);
                Integer n = failCount;
                Integer n3 = failCount = Integer.valueOf(failCount + 1);
            }
        }
        failTotal.put(supplierId, failCount);
        log.error("-------------------\u4f9b\u5e94\u5546:" + supplierId + "\u6267\u884c\u5b8c\u6210-------------------------");
        return failTotal;
    }

    private Map<Long, Integer> process(Long supplierId, Integer pageSize) {
        HashMap<Long, Integer> failTotal = new HashMap<Long, Integer>();
        Integer failCount = 0;
        log.error("--------------\u4f9b\u5e94\u5546:" + supplierId + "\u5f00\u59cb\u6267\u884c---------------");
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuSource(2);
        uccSkuPo.setSkuStatus(3);
        uccSkuPo.setSupplierShopId(supplierId);
        Integer count = this.uccMallSkuMapper.qryShopDownSkuForCount(uccSkuPo);
        if (Objects.isNull(count) || 0 == count) {
            failTotal.put(supplierId, failCount);
            return failTotal;
        }
        long totalPage = count % pageSize == 0 ? (long)(count / pageSize) : (long)(count / pageSize + 1);
        int total = (int)totalPage;
        for (int i = 0; i < total; ++i) {
            try {
                uccSkuPo.setPageStart(i == 0 ? 0 : i * pageSize);
                uccSkuPo.setPageEnd(pageSize);
                List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.qryShopDownSkuForLimit(uccSkuPo);
                if (CollectionUtils.isEmpty(uccSkuPos) || 0 == uccSkuPos.size()) continue;
                List<String> extSkuIds = uccSkuPos.stream().map(UccSkuPo::getExtSkuId).collect(Collectors.toList());
                Map<String, List<UccSkuPo>> uccSkuMap = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getExtSkuId));
                SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(supplierId);
                String supplierCode = supplierBusiPo.getSupplierCode();
                String supplierName = supplierBusiPo.getSupplierName();
                InterfaceSkuStateReqBO interfaceSkuStateReqBO = new InterfaceSkuStateReqBO();
                interfaceSkuStateReqBO.setSupplierId(supplierId);
                interfaceSkuStateReqBO.setSupplierCode(supplierCode);
                interfaceSkuStateReqBO.setExtSkuIds(extSkuIds);
                InterfaceSkuStateRsp interfaceSkuStateRsp = this.interfaceQrySkuStateService.qrySkuStatus(interfaceSkuStateReqBO);
                if (Objects.nonNull((Object)interfaceSkuStateRsp) && "0000".equals(interfaceSkuStateRsp.getRespCode()) && !CollectionUtils.isEmpty(interfaceSkuStateRsp.getSkuStates())) {
                    List<InterfaceSkuStateRspBo> skuStates = interfaceSkuStateRsp.getSkuStates();
                    ArrayList<UccMallEstoreSkuDownTempPO> insertList = new ArrayList<UccMallEstoreSkuDownTempPO>();
                    ArrayList<UccMallEstoreSkuDownTempPO> updateList = new ArrayList<UccMallEstoreSkuDownTempPO>();
                    List<UccMallEstoreSkuDownTempPO> uccMallEstoreSkuDownTempPOS = this.uccMallEstoreSkuDownTempMapper.selectList(new UccMallEstoreSkuDownTempPO());
                    Map<Long, List<UccMallEstoreSkuDownTempPO>> skuMap = null;
                    if (!CollectionUtils.isEmpty(uccMallEstoreSkuDownTempPOS)) {
                        skuMap = uccMallEstoreSkuDownTempPOS.stream().collect(Collectors.groupingBy(UccMallEstoreSkuDownTempPO::getSkuId));
                    }
                    for (int j = 0; j < skuStates.size(); ++j) {
                        List<UccMallEstoreSkuDownTempPO> uccMallEstoreSkuDownTempPOS1;
                        InterfaceSkuStateRspBo interfaceSkuStateRspBo = skuStates.get(j);
                        if (0 != interfaceSkuStateRspBo.getState()) continue;
                        List<UccSkuPo> uccSkuPoList = uccSkuMap.get(interfaceSkuStateRspBo.getSku());
                        if (MapUtils.isNotEmpty(skuMap) && !CollectionUtils.isEmpty(uccMallEstoreSkuDownTempPOS1 = skuMap.get(uccSkuPoList.get(0).getSkuId()))) {
                            UccMallEstoreSkuDownTempPO update = new UccMallEstoreSkuDownTempPO();
                            update.setSkuId(uccSkuPoList.get(0).getSkuId());
                            update.setState(0);
                            updateList.add(update);
                            continue;
                        }
                        UccMallEstoreSkuDownTempPO insert = new UccMallEstoreSkuDownTempPO();
                        insert.setSkuId(uccSkuPoList.get(0).getSkuId());
                        insert.setSupplierId(uccSkuPoList.get(0).getSupplierShopId());
                        insert.setSupplierCode(supplierCode);
                        insert.setSupplierName(supplierName);
                        insert.setExtSkuId(interfaceSkuStateRspBo.getSku());
                        insert.setState(0);
                        insert.setOperatorId(0L);
                        insertList.add(insert);
                    }
                    log.error("-------------------\u4f9b\u5e94\u5546:" + supplierId + "\u67e5\u8be2\u6279\u6b21:" + i + "-------------------------");
                    if (!CollectionUtils.isEmpty(insertList)) {
                        log.error("-------------------\u4f9b\u5e94\u5546:" + supplierId + "\u6210\u529f\u65b0\u589e\u6761\u6570:" + insertList.size() + "-------------------------");
                        this.uccMallEstoreSkuDownTempMapper.insertBatch(insertList);
                    }
                    if (CollectionUtils.isEmpty(updateList)) continue;
                    log.error("-------------------\u4f9b\u5e94\u5546:" + supplierId + "\u6210\u529f\u4fee\u6539\u6761\u6570:" + updateList.size() + "-------------------------");
                    this.uccMallEstoreSkuDownTempMapper.updateBatch(updateList, 0);
                    continue;
                }
                log.error("-------------------\u4f9b\u5e94\u5546:" + supplierId + "\u7b2c" + i + "\u6279\u6b21\u6267\u884c\u5931\u8d25 qry shop error-------------------------");
                log.error("-------------------\u4f9b\u5e94\u5546:" + supplierId + "\u7b2c" + i + "\u6279\u6b21\u6267\u884c\u5931\u8d25 error info:" + interfaceSkuStateRsp.getResultMessage());
                Integer n = failCount;
                Integer n2 = failCount = Integer.valueOf(failCount + 1);
                continue;
            }
            catch (Exception e) {
                log.error("-------------------\u4f9b\u5e94\u5546:" + supplierId + "\u7b2c" + i + "\u6279\u6b21\u6267\u884c\u5931\u8d25 system error-------------------------");
                log.error("process error:{}", (Throwable)e);
                Integer n = failCount;
                Integer n3 = failCount = Integer.valueOf(failCount + 1);
            }
        }
        failTotal.put(supplierId, failCount);
        log.error("-------------------\u4f9b\u5e94\u5546:" + supplierId + "\u6267\u884c\u5b8c\u6210-------------------------");
        return failTotal;
    }
}

