/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.mall.ability.api.UccMallCurrentPriceBatchQryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallBatchPriceQryAbilityBo;
import com.tydic.commodity.mall.ability.bo.UccMallCurrentPriceBatchQryBo;
import com.tydic.commodity.mall.ability.bo.UccMallCurrentPriceBatchQryReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallCurrentPriceBatchQryRspBo;
import com.tydic.commodity.mall.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.po.UccCommodityPo;
import com.tydic.commodity.mall.po.UccEMdmMaterialPO;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallCurrentPriceBatchQryAbilityService"})
public class UccMallCurrentPriceBatchQryAbilityServiceImpl
implements UccMallCurrentPriceBatchQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallCurrentPriceBatchQryAbilityServiceImpl.class);
    @Autowired
    private UccMallSkuMapper uccSkuMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccMallCommodityMapper uccMallCommodityMapper;

    @PostMapping(value={"qry"})
    public UccMallCurrentPriceBatchQryRspBo qry(@RequestBody UccMallCurrentPriceBatchQryReqBo reqBo) {
        UccMallCurrentPriceBatchQryRspBo rspBo = new UccMallCurrentPriceBatchQryRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)reqBo.getSkuInfo()) && CollectionUtils.isEmpty((Collection)reqBo.getSkuIds())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u4f20\u5165\u8981\u67e5\u8be2\u7684\u5355\u54c1id");
            return rspBo;
        }
        ArrayList<UccMallCurrentPriceBatchQryBo> priceBatchQryBos = new ArrayList<UccMallCurrentPriceBatchQryBo>();
        if (reqBo.getSkuIds() != null) {
            List skuIds = reqBo.getSkuIds();
            this.packagingProperty(priceBatchQryBos, skuIds);
        } else if (reqBo.getSkuInfo() != null) {
            List<Long> skuIds = reqBo.getSkuInfo().stream().map(UccMallBatchPriceQryAbilityBo::getSkuId).collect(Collectors.toList());
            this.packagingProperty(priceBatchQryBos, skuIds);
        }
        rspBo.setPriceBatchQryBos(priceBatchQryBos);
        log.info("\u6279\u91cf\u5b9e\u65f6\u67e5\u8be2\u4ef7\u683c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)rspBo));
        return rspBo;
    }

    private void packagingProperty(List<UccMallCurrentPriceBatchQryBo> priceBatchQryBos, List<Long> skuIds) {
        List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qeryBatchSkus(skuIds);
        if (!CollectionUtils.isEmpty(uccSkuPos)) {
            List<UccCommodityPo> uccCommodityPos;
            List<UccEMdmMaterialPO> uccEMdmMaterialPOS;
            Set collect = uccSkuPos.stream().filter(e -> !StringUtils.isEmpty((Object)e.getMaterialId())).map(e -> Long.valueOf(e.getMaterialId())).collect(Collectors.toSet());
            ArrayList<Long> materialIds = new ArrayList<Long>();
            Map<Object, Object> materialIdMap = new HashMap();
            materialIds.addAll(collect);
            if (!CollectionUtils.isEmpty(materialIds) && !CollectionUtils.isEmpty(uccEMdmMaterialPOS = this.uccEMdmMaterialMapper.batchQryById(materialIds))) {
                materialIdMap = uccEMdmMaterialPOS.stream().collect(Collectors.toMap(UccEMdmMaterialPO::getMaterialId, UccEMdmMaterialPO2 -> UccEMdmMaterialPO2));
            }
            Map<Long, List<UccSkuPo>> skuMap = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSkuId));
            List<Long> commodityIds = uccSkuPos.stream().filter(e -> e.getCommodityId() != null).map(UccSkuPo::getCommodityId).collect(Collectors.toList());
            Map<Object, Object> commodityIdMap = new HashMap();
            if (!CollectionUtils.isEmpty(commodityIds) && !CollectionUtils.isEmpty(uccCommodityPos = this.uccMallCommodityMapper.batchQryCommd(commodityIds, null))) {
                commodityIdMap = uccCommodityPos.stream().collect(Collectors.toMap(UccCommodityPo::getCommodityId, UccCommodityPo2 -> UccCommodityPo2));
            }
            for (Long skuId : skuIds) {
                List<UccSkuPo> skuPos = skuMap.get(skuId);
                if (CollectionUtils.isEmpty(skuPos)) continue;
                UccMallCurrentPriceBatchQryBo priceBatchQryBo = new UccMallCurrentPriceBatchQryBo();
                priceBatchQryBo.setSkuId(skuId);
                UccSkuPo uccSkuPo = skuPos.get(0);
                priceBatchQryBo.setSupplierShopId(uccSkuPo.getSupplierShopId());
                priceBatchQryBo.setSkuCode(uccSkuPo.getSkuCode());
                priceBatchQryBo.setSpec(uccSkuPo.getSpec());
                priceBatchQryBo.setModel(uccSkuPo.getModel());
                if (uccSkuPo.getCommodityId() != null && commodityIdMap.containsKey(uccSkuPo.getCommodityId())) {
                    UccCommodityPo uccCommodityPo = (UccCommodityPo)commodityIdMap.get(uccSkuPo.getCommodityId());
                    priceBatchQryBo.setCommodityCode(uccCommodityPo.getCommodityCode());
                }
                priceBatchQryBo.setSkuCode(uccSkuPo.getSkuCode());
                priceBatchQryBo.setAgreementId(uccSkuPo.getAgreementId());
                if (!StringUtils.isEmpty((Object)uccSkuPo.getMaterialId()) && materialIdMap.containsKey(Long.valueOf(uccSkuPo.getMaterialId()))) {
                    UccEMdmMaterialPO materialPO = (UccEMdmMaterialPO)materialIdMap.get(Long.valueOf(uccSkuPo.getMaterialId()));
                    priceBatchQryBo.setMaterialCode(materialPO.getMaterialCode());
                }
                if (uccSkuPo.getSkuStatus() != null) {
                    priceBatchQryBo.setSkuStatus(uccSkuPo.getSkuStatus().toString());
                }
                priceBatchQryBo.setBrandId(uccSkuPo.getBrandId());
                priceBatchQryBo.setBrandName(uccSkuPo.getBrandName());
                priceBatchQryBo.setPartNo(uccSkuPo.getPartNo());
                priceBatchQryBo.setTechnicalParam(uccSkuPo.getTechnicalParam());
                priceBatchQryBo.setRemark(uccSkuPo.getRemark());
                priceBatchQryBo.setDiscountLimitValue(uccSkuPo.getDiscountLimitValue());
                priceBatchQryBos.add(priceBatchQryBo);
            }
        }
    }
}

