/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.utils;

import com.tydic.commodity.mall.utils.HSNHttpPoolHelper;
import com.tydic.commodity.mall.utils.HttpRetBean;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;

public class HSHttpHelper {
    private static final Log log = LogFactory.getLog(HSHttpHelper.class);
    private static final boolean isDebugLog = log.isDebugEnabled();

    public static HttpRetBean doUrlPostRequest(URI uri, Header[] headers, byte[] reqBody, String HpartyEnconding, Boolean isHttps) throws ConnectException, IOException, URISyntaxException {
        if (isDebugLog) {
            log.debug((Object)("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5730\u5740\uff1a" + uri));
            log.debug((Object)("\u53d1\u9001\u62a5\u6587\u6570\u636e\u683c\u5f0f\uff1a" + new String(reqBody)));
        }
        return HSHttpHelper.doUrlExecuteRequest((HttpUriRequest)new HttpPost(uri), headers, reqBody, HpartyEnconding, isHttps);
    }

    public static HttpRetBean doUrlGetRequest(URI uri, Header[] headers, String HpartyEnconding, Boolean isHttps) throws ConnectException, IOException, URISyntaxException {
        if (isDebugLog) {
            log.debug((Object)("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5730\u5740\uff1a" + uri));
            log.debug((Object)("\u63a5\u53e3\u62a5\u6587\u6570\u636e\uff1a" + HpartyEnconding));
        }
        return HSHttpHelper.doUrlExecuteRequest((HttpUriRequest)new HttpGet(uri), headers, null, HpartyEnconding, isHttps);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HttpRetBean doUrlExecuteRequest(HttpUriRequest request, Header[] headers, byte[] reqBody, String HpartyEnconding, Boolean isHttps) throws ConnectException, IOException, URISyntaxException {
        HttpRetBean httpRetBean;
        if (headers != null && headers.length > 0) {
            request.setHeaders(headers);
        }
        if (reqBody != null && request instanceof HttpEntityEnclosingRequestBase) {
            ByteArrayEntity entity = new ByteArrayEntity(reqBody);
            entity.setChunked(false);
            ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)entity);
        }
        HttpClient httpClient = null;
        ObjectPool httpClientPool = null;
        try {
            httpClientPool = isHttps != false ? HSNHttpPoolHelper.hsnHttpsObjectPoolBean.getHttpClientPool() : HSNHttpPoolHelper.hsnHttpObjectPoolBean.getHttpClientPool();
            httpClient = (HttpClient)httpClientPool.borrowObject();
            HttpResponse httpResponse = httpClient.execute(request);
            String returnData = null;
            InputStream inputStream = httpResponse.getEntity().getContent();
            returnData = inputStream == null ? null : IOUtils.toString((InputStream)inputStream, (String)HpartyEnconding);
            if (inputStream != null) {
                inputStream.close();
            }
            httpRetBean = new HttpRetBean(httpResponse.getStatusLine().getStatusCode(), httpResponse.getAllHeaders(), returnData);
            if (httpClient == null) return httpRetBean;
        }
        catch (ConnectException e) {
            try {
                request.abort();
                throw e;
                catch (IOException e2) {
                    request.abort();
                    throw e2;
                }
                catch (URISyntaxException e3) {
                    request.abort();
                    throw e3;
                }
                catch (Exception e4) {
                    throw new RuntimeException(request.getURI().toString() + ":" + e4.getMessage(), e4);
                }
            }
            catch (Throwable throwable) {
                if (httpClient == null) throw throwable;
                try {
                    httpClientPool.returnObject(httpClient);
                    throw throwable;
                }
                catch (Exception e5) {
                    log.warn((Object)"HttpClient\u5bf9\u8c61\u5f52\u8fd8\u5931\u8d25", (Throwable)e5);
                }
                throw throwable;
            }
        }
        try {
            httpClientPool.returnObject((Object)httpClient);
            return httpRetBean;
        }
        catch (Exception e) {
            log.warn((Object)"HttpClient\u5bf9\u8c61\u5f52\u8fd8\u5931\u8d25", (Throwable)e);
        }
        return httpRetBean;
    }
}

