/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.atom.api.InterfaceJdAppIntroduceQryService;
import com.tydic.commodity.mall.atom.bo.InterfaceJdAppIntroduceQryReqBo;
import com.tydic.commodity.mall.atom.bo.InterfaceJdAppIntroduceQryRspBo;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.utils.ESBParamUtil;
import com.tydic.commodity.mall.utils.HSHttpHelper;
import com.tydic.commodity.mall.utils.HSNHttpHeader;
import com.tydic.commodity.mall.utils.HttpRetBean;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InterfaceJdAppIntroduceQryServiceImpl
implements InterfaceJdAppIntroduceQryService {
    private static final Logger log = LoggerFactory.getLogger(InterfaceJdAppIntroduceQryServiceImpl.class);
    @Value(value="${app_jd_query_fields:appStyleContent}")
    private String jd_query_fields;
    @Value(value="${ESB_QRY_JD_SKU_APP_INTRODUCE_URL:${ESB_ACCESS_IP}/OSN/api/getDetailStyle/v1}")
    private String ESB_QRY_JD_SKU_APP_INTRODUCE_URL;

    @Override
    public InterfaceJdAppIntroduceQryRspBo qryJdAppIntroduce(InterfaceJdAppIntroduceQryReqBo reqBO) {
        try {
            String reqStr = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.ESB_QRY_JD_SKU_APP_INTRODUCE_URL), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.ESB_QRY_JD_SKU_APP_INTRODUCE_URL + "]");
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u5931\u8d25");
            }
            log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            InterfaceJdAppIntroduceQryRspBo resolveRsp = this.resolveRsp(returnString);
            if (resolveRsp != null) {
                log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString());
            }
            return resolveRsp;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }

    private String initReqStr(InterfaceJdAppIntroduceQryReqBo reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sku", (Object)reqBO.getSkuId());
        jsonObject.put("hsn", (Object)reqBO.getSupplierCode());
        jsonObject.put("queryExts", (Object)this.jd_query_fields);
        return jsonObject.toString();
    }

    private InterfaceJdAppIntroduceQryRspBo resolveRsp(String returnString) {
        InterfaceJdAppIntroduceQryRspBo rspBO = new InterfaceJdAppIntroduceQryRspBo();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setRespCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setRespDesc((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if ("2007".equals(respCode)) {
                    rspBO.setRespDesc("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                } else {
                    rspBO.setRespDesc("\u7535\u5546\u62a5\u9519\uff1a" + rspBO.getRespDesc());
                }
                rspBO.setRespCode("8888");
                return rspBO;
            }
            Object result = rspJsonObject.get((Object)"result");
            if (result != null) {
                JSONObject resultJson = (JSONObject)result;
                rspBO.setResult((String)resultJson.get((Object)"appStyleContent"));
            }
            return rspBO;
        }
        catch (Exception var10) {
            log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

