/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.atom.api.UccMallQryPriceFromLadderPriceAtomService;
import com.tydic.commodity.mall.atom.bo.UccMallQryPriceFromLadderPriceBO;
import com.tydic.commodity.mall.atom.bo.UccMallQryPriceFromLadderPriceReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallQryPriceFromLadderPriceRspBO;
import com.tydic.commodity.mall.dao.UccMallLadderPriceMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPriceMapper;
import com.tydic.commodity.mall.po.UccLadderPricePO;
import com.tydic.commodity.mall.po.UccSkuPricePo;
import com.tydic.commodity.mall.utils.ListCloneUtils;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallQryPriceFromLadderPriceAtomServiceImpl
implements UccMallQryPriceFromLadderPriceAtomService {
    @Autowired
    private UccMallLadderPriceMapper ladderPriceMapper;
    @Autowired
    private UccMallSkuPriceMapper skuPriceMapper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public UccMallQryPriceFromLadderPriceRspBO qryPriceFromLadderPrice(UccMallQryPriceFromLadderPriceReqBO reqBO) {
        UccMallQryPriceFromLadderPriceRspBO rspBO = new UccMallQryPriceFromLadderPriceRspBO();
        List<UccLadderPricePO> uccLadderPricePOList = null;
        try {
            uccLadderPricePOList = ListCloneUtils.clonePOListToBOList(reqBO.getQryPriceFromLadderPriceBOS(), UccLadderPricePO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<UccMallQryPriceFromLadderPriceBO> uccMallQryPriceFromLadderPriceBOS = new ArrayList<UccMallQryPriceFromLadderPriceBO>(reqBO.getQryPriceFromLadderPriceBOS().size());
        if (CollectionUtils.isNotEmpty(uccLadderPricePOList)) {
            List<UccLadderPricePO> ladderPricePOS = this.ladderPriceMapper.selectReturnLadderPriceBySkuId(uccLadderPricePOList);
            Map<Long, List<UccLadderPricePO>> ladderPriceMap = ladderPricePOS.stream().filter(poList -> poList.getSkuId() != null).collect(Collectors.groupingBy(UccLadderPricePO::getSkuId));
            for (UccMallQryPriceFromLadderPriceBO uccMallQryPriceFromLadderPriceBO : reqBO.getQryPriceFromLadderPriceBOS()) {
                UccMallQryPriceFromLadderPriceBO priceFromLadderPriceBO = new UccMallQryPriceFromLadderPriceBO();
                if (ladderPriceMap.containsKey(uccMallQryPriceFromLadderPriceBO.getSkuId())) {
                    List<UccLadderPricePO> pricePOS = ladderPriceMap.get(uccMallQryPriceFromLadderPriceBO.getSkuId());
                    if (pricePOS.get(0).getType() != null && pricePOS.get(0).getType() == 2) {
                        List<UccSkuPricePo> skuPricePos = this.skuPriceMapper.getPricesBySkuId(uccMallQryPriceFromLadderPriceBO.getSkuId());
                        if (!CollectionUtils.isNotEmpty(skuPricePos)) throw new ZTBusinessException("\u5f53\u524d\u5546\u54c1\u6ca1\u6709\u4ef7\u683c\u4fe1\u606f\uff0c\u5355\u54c1id\uff1a" + uccMallQryPriceFromLadderPriceBO.getSkuId());
                        BigDecimal salePrice = MoneyUtils.haoToYuan(skuPricePos.get(0).getSalePrice());
                        BigDecimal saleTotal = uccMallQryPriceFromLadderPriceBO.getPurchaseQuantity().multiply(salePrice);
                        for (UccLadderPricePO pricePO : pricePOS) {
                            if (null == pricePO.getStop() && saleTotal.compareTo(MoneyUtils.haoToYuan(pricePO.getStart())) >= 0) {
                                priceFromLadderPriceBO.setSkuId(uccMallQryPriceFromLadderPriceBO.getSkuId());
                                priceFromLadderPriceBO.setPurchasePrice(MoneyUtils.haoToYuan(pricePO.getPrice()));
                            } else {
                                if (saleTotal.compareTo(MoneyUtils.haoToYuan(pricePO.getStart())) < 0 || saleTotal.compareTo(MoneyUtils.haoToYuan(pricePO.getStop())) > 0) continue;
                                priceFromLadderPriceBO.setSkuId(uccMallQryPriceFromLadderPriceBO.getSkuId());
                                priceFromLadderPriceBO.setPurchasePrice(MoneyUtils.haoToYuan(pricePO.getPrice()));
                            }
                            break;
                        }
                    } else {
                        for (UccLadderPricePO pricePO : pricePOS) {
                            if (null == pricePO.getStop() && uccMallQryPriceFromLadderPriceBO.getPurchaseQuantity().compareTo(MoneyUtils.haoToYuan(pricePO.getStart())) >= 0) {
                                priceFromLadderPriceBO.setSkuId(uccMallQryPriceFromLadderPriceBO.getSkuId());
                                priceFromLadderPriceBO.setPurchasePrice(MoneyUtils.haoToYuan(pricePO.getPrice()));
                            } else {
                                if (uccMallQryPriceFromLadderPriceBO.getPurchaseQuantity().compareTo(MoneyUtils.haoToYuan(pricePO.getStart())) < 0 || uccMallQryPriceFromLadderPriceBO.getPurchaseQuantity().compareTo(MoneyUtils.haoToYuan(pricePO.getStop())) > 0) continue;
                                priceFromLadderPriceBO.setSkuId(uccMallQryPriceFromLadderPriceBO.getSkuId());
                                priceFromLadderPriceBO.setPurchasePrice(MoneyUtils.haoToYuan(pricePO.getPrice()));
                            }
                            break;
                        }
                    }
                } else {
                    List<UccSkuPricePo> skuPricePos = this.skuPriceMapper.getPricesBySkuId(uccMallQryPriceFromLadderPriceBO.getSkuId());
                    if (CollectionUtils.isNotEmpty(skuPricePos)) {
                        priceFromLadderPriceBO.setPurchasePrice(MoneyUtils.haoToYuan(skuPricePos.get(0).getSalePrice()));
                        priceFromLadderPriceBO.setSkuId(uccMallQryPriceFromLadderPriceBO.getSkuId());
                    }
                }
                uccMallQryPriceFromLadderPriceBOS.add(priceFromLadderPriceBO);
            }
        }
        rspBO.setQryPriceFromLadderPriceBOS(uccMallQryPriceFromLadderPriceBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

