/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.tydic.commodity.mall.ability.api.UccCheckSkuCountAbilityService;
import com.tydic.commodity.mall.ability.bo.UccCheckSkuCountReqBo;
import com.tydic.commodity.mall.ability.bo.UccCheckSkuCountReqBoSkuInfo;
import com.tydic.commodity.mall.ability.bo.UccCheckSkuCountRspBo;
import com.tydic.commodity.mall.ability.bo.UccCheckSkuCountRspBoSkuInfo;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccCheckSkuCountAbilityService"})
public class UccCheckSkuCountAbilityServiceImpl
implements UccCheckSkuCountAbilityService {
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Value(value="${sn_cg_stb:100057,428806,437922,}")
    private String snCgStb;
    @Value(value="${gaj_zkh_ofs_xfs_xy:100056,100058,398173,437456,20230900720,100060,}")
    private String gzoxx;
    @Value(value="${jd_dl:100055,100059,}")
    private String jdDl;

    @PostMapping(value={"checkSkuCount"})
    public UccCheckSkuCountRspBo checkSkuCount(@RequestBody UccCheckSkuCountReqBo reqBo) {
        UccCheckSkuCountRspBo rspBo = new UccCheckSkuCountRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        ArrayList<Long> vendor = new ArrayList<Long>();
        for (UccCheckSkuCountReqBoSkuInfo skuInfo : reqBo.getSkuInfo()) {
            if (vendor.contains(skuInfo.getSupplierShopId())) continue;
            vendor.add(skuInfo.getSupplierShopId());
        }
        UccSkuPo skuPo = new UccSkuPo();
        skuPo.setSupplierShopIds(vendor);
        List<UccSkuPo> list = this.uccMallSkuMapper.checkSkuCount(skuPo);
        ArrayList<UccCheckSkuCountRspBoSkuInfo> skuInfo = new ArrayList<UccCheckSkuCountRspBoSkuInfo>();
        for (UccSkuPo uccSkuPo : list) {
            for (UccCheckSkuCountReqBoSkuInfo info : reqBo.getSkuInfo()) {
                if (!uccSkuPo.getSupplierShopId().equals(info.getSupplierShopId())) continue;
                UccCheckSkuCountRspBoSkuInfo boSkuInfo = new UccCheckSkuCountRspBoSkuInfo();
                boSkuInfo.setSkuId(info.getSkuId());
                boSkuInfo.setFlag(Boolean.valueOf(true));
                String[] strings = info.getCount().split("\\|");
                if (this.snCgStb.contains(info.getSupplierShopId() + ",")) {
                    if (uccSkuPo.getCheckSkuCount() >= Integer.parseInt(strings[0]) * 10000) {
                        boSkuInfo.setFlag(Boolean.valueOf(false));
                    }
                } else if (this.gzoxx.contains(info.getSupplierShopId() + ",")) {
                    if (uccSkuPo.getCheckSkuCount() >= Integer.parseInt(strings[1]) * 10000) {
                        boSkuInfo.setFlag(Boolean.valueOf(false));
                    }
                } else if (this.jdDl.contains(info.getSupplierShopId() + ",") && uccSkuPo.getCheckSkuCount() >= Integer.parseInt(strings[2]) * 10000) {
                    boSkuInfo.setFlag(Boolean.valueOf(false));
                }
                skuInfo.add(boSkuInfo);
            }
        }
        rspBo.setSkuInfo(skuInfo);
        return rspBo;
    }
}

