/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.mall.ability.api.UccMallBatchQrySkuStateAbilityService;
import com.tydic.commodity.mall.ability.api.UccMallQrySkuStateAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallBatchQrySkuStateAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallBatchQrySkuStateAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuStateBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuStateReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuStateRspBO;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallBatchQrySkuStateAbilityService"})
public class UccMallBatchQrySkuStateAbilityServiceImpl
implements UccMallBatchQrySkuStateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallBatchQrySkuStateAbilityServiceImpl.class);
    @Autowired
    private UccMallSkuMapper uccSkuMapper;
    @Autowired
    private UccMallQrySkuStateAbilityService uccMallQrySkuStateAbilityService;

    @PostMapping(value={"qryBatchSkuState"})
    public UccMallBatchQrySkuStateAbilityRspBO qryBatchSkuState(@RequestBody UccMallBatchQrySkuStateAbilityReqBO reqBO) {
        UccMallBatchQrySkuStateAbilityRspBO rspBO = new UccMallBatchQrySkuStateAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u8981\u67e5\u8be2\u7684\u5355\u54c1id");
            return rspBO;
        }
        ArrayList<UccMallQrySkuStateBO> rows = new ArrayList<UccMallQrySkuStateBO>();
        List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qeryBatchSkus(reqBO.getSkuIds());
        Map<Long, List<UccSkuPo>> skuShopMap = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        Map<Long, List<UccSkuPo>> skuIdMap = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSkuId));
        for (Map.Entry<Long, List<UccSkuPo>> entry : skuShopMap.entrySet()) {
            List<UccSkuPo> pos = entry.getValue();
            Long shopId = entry.getKey();
            List<Long> skuIds = pos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            UccMallQrySkuStateReqBO uccMallQrySkuStateReqBO = new UccMallQrySkuStateReqBO();
            uccMallQrySkuStateReqBO.setSkuIds(skuIds);
            uccMallQrySkuStateReqBO.setSupplierShopId(shopId);
            log.info("\u8c03\u7528UccMallQrySkuStateAbilityService\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uccMallQrySkuStateReqBO));
            try {
                UccMallQrySkuStateRspBO uccMallQrySkuStateRspBO = this.uccMallQrySkuStateAbilityService.qrySkuState(uccMallQrySkuStateReqBO);
                log.info("\u8c03\u7528UccMallQrySkuStateAbilityService\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uccMallQrySkuStateRspBO));
                if ("0000".equals(uccMallQrySkuStateRspBO.getRespCode())) {
                    List skuStateRspBORows = uccMallQrySkuStateRspBO.getRows();
                    if (!CollectionUtils.isEmpty((Collection)skuStateRspBORows)) {
                        rows.addAll(skuStateRspBORows);
                        continue;
                    }
                    this.failQry(skuIds, shopId, rows);
                    continue;
                }
                this.failQry(skuIds, shopId, rows);
            }
            catch (Exception e) {
                log.error("\u8c03\u7528UccMallQrySkuStateAbilityService\u62a5\u9519" + e.getMessage());
                this.failQry(skuIds, shopId, rows);
            }
        }
        rspBO.setRows(rows);
        return rspBO;
    }

    private void failQry(List<Long> skuIds, Long supplierShopId, List<UccMallQrySkuStateBO> rows) {
        for (Long skuId : skuIds) {
            UccMallQrySkuStateBO bo = new UccMallQrySkuStateBO();
            bo.setSkuId(skuId);
            bo.setSupplierShopId(supplierShopId);
            bo.setStatus("2");
            rows.add(bo);
        }
    }
}

