/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.mall.busi.api.UccMallUpdateSearchGoodBusiService;
import com.tydic.commodity.mall.busi.bo.UccMallDeleteSearchGoodBusiReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallDeleteSearchGoodBusiRspBO;
import com.tydic.commodity.mall.busi.bo.UccMallUpdateSearchGoodAndItemsBusiReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallUpdateSearchGoodAndItemsBusiRspBO;
import com.tydic.commodity.mall.busi.bo.UccMallUpdateSearchGoodBusiReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallUpdateSearchGoodBusiRspBO;
import com.tydic.commodity.mall.busi.bo.UccMallUpdateSearchGoodPurchaseCountBusiReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallUpdateSearchGoodPurchaseCountBusiRspBO;
import com.tydic.commodity.mall.dao.UccSearchGoodExportItemMapper;
import com.tydic.commodity.mall.dao.UccSearchGoodExportMapper;
import com.tydic.commodity.mall.dao.UccSearchGoodItemMapper;
import com.tydic.commodity.mall.dao.UccSearchGoodMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccSearchGoodExportItemPO;
import com.tydic.commodity.mall.po.UccSearchGoodItemPO;
import com.tydic.commodity.mall.po.UccSearchGoodPO;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallUpdateSearchGoodBusiServiceImpl
implements UccMallUpdateSearchGoodBusiService {
    @Autowired
    private UccSearchGoodMapper uccSearchGoodMapper;
    @Autowired
    private UccSearchGoodItemMapper uccSearchGoodItemMapper;
    @Autowired
    private UccSearchGoodExportMapper uccSearchGoodExportMapper;
    @Autowired
    private UccSearchGoodExportItemMapper uccSearchGoodExportItemMapper;

    @Override
    public UccMallUpdateSearchGoodBusiRspBO updateSearchGood(UccMallUpdateSearchGoodBusiReqBO reqBO) {
        UccMallUpdateSearchGoodBusiRspBO rspBO = new UccMallUpdateSearchGoodBusiRspBO();
        if (Objects.isNull(reqBO.getType()) || Objects.isNull(reqBO.getSearchGoodItemId())) {
            throw new BusinessException("8888", "\u4fee\u6539\u7c7b\u578b[type]\u548c\u6279\u91cf\u641c\u7d22\u5546\u54c1\u540d\u79f0id[searchGoodItemId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getSkuId()) && Objects.isNull(reqBO.getRequirement())) {
            throw new BusinessException("8888", "\u9700\u6c42\u63cf\u8ff0[requirement]\u548c\u5355\u54c1id[skuId]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        UccSearchGoodItemPO itemPO = new UccSearchGoodItemPO();
        itemPO.setSearchGoodItemId(reqBO.getSearchGoodItemId());
        List<UccSearchGoodItemPO> list = this.uccSearchGoodItemMapper.getList(itemPO);
        if (CollectionUtils.isEmpty(list)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u4e0d\u5230\u6279\u91cf\u641c\u7d22\u5546\u54c1\u660e\u7ec6\u8868\u6570\u636e\uff01searchGoodItemId:" + JSON.toJSONString((Object)reqBO.getSearchGoodItemId()));
        }
        itemPO.setUpdateOperName(reqBO.getName());
        itemPO.setUpdateOperId(reqBO.getUsername());
        if (reqBO.getType() == 0) {
            itemPO.setRequirement(reqBO.getRequirement());
        } else {
            itemPO.setSkuId(reqBO.getSkuId());
        }
        if (this.uccSearchGoodItemMapper.updateById(itemPO) < 1) {
            throw new BusinessException("8888", "\u4fee\u6539\u6279\u91cf\u641c\u7d22\u5546\u54c1\u660e\u7ec6\u8868\u6570\u636e\u5931\u8d25\uff01itemPO" + JSON.toJSONString((Object)itemPO));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public UccMallDeleteSearchGoodBusiRspBO deleteSearchGood(UccMallDeleteSearchGoodBusiReqBO reqBO) {
        UccMallDeleteSearchGoodBusiRspBO rspBO = new UccMallDeleteSearchGoodBusiRspBO();
        if (Objects.isNull(reqBO.getDelType())) {
            throw new BusinessException("8888", "\u5220\u9664\u7c7b\u578b[delType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getDelType() == 1) {
            if (Objects.isNull(reqBO.getSearchGoodItemIds())) {
                throw new BusinessException("8888", "\u6279\u91cf\u641c\u7d22\u5546\u54c1\u540d\u79f0ids[searchGoodItemIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            List<UccSearchGoodItemPO> list = this.uccSearchGoodItemMapper.getListBySearchGoodItemId(reqBO.getSearchGoodItemIds());
            if (CollectionUtils.isEmpty(list)) {
                throw new BusinessException("8888", "\u67e5\u8be2\u4e0d\u5230\u6279\u91cf\u641c\u7d22\u5546\u54c1\u660e\u7ec6\u8868\u6570\u636e\uff01searchGoodItemIds:" + JSON.toJSONString(reqBO.getSearchGoodItemIds()));
            }
            List<Long> ids = list.stream().map(UccSearchGoodItemPO::getSearchGoodItemId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(ids) || this.uccSearchGoodItemMapper.deleteByIds(ids, reqBO.getName(), reqBO.getUserId()) < 1) {
                throw new BusinessException("8888", "\u6279\u91cf\u5220\u9664\u641c\u7d22\u5546\u54c1\u660e\u7ec6\u8868\u6570\u636e\u5931\u8d25\uff01searchGoodItemIds" + JSON.toJSONString(reqBO.getSearchGoodItemIds()));
            }
        } else {
            if (Objects.isNull(reqBO.getSearchGoodIds())) {
                throw new BusinessException("8888", "\u6279\u91cf\u641c\u7d22\u5546\u54c1\u4e3b\u8868id[searchGoodIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            List<UccSearchGoodPO> list = this.uccSearchGoodMapper.getListBySearchGoodIds(reqBO.getSearchGoodIds());
            if (CollectionUtils.isEmpty(list)) {
                throw new BusinessException("8888", "\u67e5\u8be2\u4e0d\u5230\u6279\u91cf\u641c\u7d22\u5546\u54c1\u4e3b\u8868\u6570\u636e\uff01searchGoodIds:" + JSON.toJSONString(reqBO.getSearchGoodIds()));
            }
            List<Long> ids = list.stream().map(UccSearchGoodPO::getSearchGoodId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(ids) || this.uccSearchGoodMapper.deleteByIds(ids, reqBO.getName(), reqBO.getUserId()) < 1) {
                throw new BusinessException("8888", "\u6279\u91cf\u5220\u9664\u641c\u7d22\u5546\u54c1\u4e3b\u8868\u6570\u636e\u5931\u8d25\uff01searchGoodIds" + JSON.toJSONString(reqBO.getSearchGoodIds()));
            }
            List<UccSearchGoodItemPO> itemPOList = this.uccSearchGoodItemMapper.getListBySearchGoodIds(reqBO.getSearchGoodIds());
            if (CollectionUtils.isEmpty(itemPOList)) {
                throw new BusinessException("8888", "\u67e5\u8be2\u4e0d\u5230\u6279\u91cf\u641c\u7d22\u5546\u54c1\u660e\u7ec6\u8868\u6570\u636e\uff01searchGoodIds:" + JSON.toJSONString(reqBO.getSearchGoodItemIds()));
            }
            List<Long> itemIds = itemPOList.stream().map(UccSearchGoodItemPO::getSearchGoodItemId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(itemIds) || this.uccSearchGoodItemMapper.deleteByIds(itemIds, reqBO.getName(), reqBO.getUserId()) < 1) {
                throw new BusinessException("8888", "\u6279\u91cf\u5220\u9664\u641c\u7d22\u5546\u54c1\u660e\u7ec6\u8868\u6570\u636e\u5931\u8d25\uff01searchGoodItemIds" + JSON.toJSONString(reqBO.getSearchGoodItemIds()));
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public UccMallUpdateSearchGoodPurchaseCountBusiRspBO updateSearchGoodPurchaseCount(UccMallUpdateSearchGoodPurchaseCountBusiReqBO reqBO) {
        UccMallUpdateSearchGoodPurchaseCountBusiRspBO rspBO = new UccMallUpdateSearchGoodPurchaseCountBusiRspBO();
        if (CollectionUtils.isEmpty(reqBO.getSearchGoodItemIds())) {
            throw new BusinessException("8888", "\u641c\u7d22\u5546\u54c1\u660e\u7ec6ids[searchGoodItemIds]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (Objects.isNull(reqBO.getPurchaseCount())) {
            throw new BusinessException("8888", "\u6570\u91cf[purchaseCount]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List<UccSearchGoodItemPO> list = this.uccSearchGoodItemMapper.getListBySearchGoodItemId(reqBO.getSearchGoodItemIds());
        if (CollectionUtils.isEmpty(list)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u4e0d\u5230\u6279\u91cf\u641c\u7d22\u5546\u54c1\u660e\u7ec6\u8868\u6570\u636e\uff01searchGoodIds:" + JSON.toJSONString(reqBO.getSearchGoodItemIds()));
        }
        int count = this.uccSearchGoodItemMapper.updatePurchaseCountBySearchGoodItemIds(reqBO.getSearchGoodItemIds(), reqBO.getPurchaseCount());
        if (count < 1) {
            throw new BusinessException("8888", "\u6279\u91cf\u66f4\u65b0\u641c\u7d22\u5546\u54c1\u660e\u7ec6\u8868\u6570\u636e\u5931\u8d25\uff01searchGoodItemIds" + JSON.toJSONString(reqBO.getSearchGoodItemIds()));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public UccMallUpdateSearchGoodAndItemsBusiRspBO insertSearchGoodAndItems(UccMallUpdateSearchGoodAndItemsBusiReqBO reqBO) {
        UccMallUpdateSearchGoodAndItemsBusiRspBO rspBO = new UccMallUpdateSearchGoodAndItemsBusiRspBO();
        int insertCount = this.uccSearchGoodExportMapper.insert(reqBO.getUccSearchGoodExportPO());
        if (insertCount < 1) {
            throw new BusinessException("8888", "\u63d2\u5165\u6570\u636e\u8868ucc_search_good_export\u5931\u8d25\uff0cUccSearchGoodExportPO" + JSON.toJSONString((Object)reqBO.getUccSearchGoodExportPO()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getUccSearchGoodExportItemPOList())) {
            List<UccSearchGoodExportItemPO> uccSearchGoodItemList = reqBO.getUccSearchGoodExportItemPOList();
            uccSearchGoodItemList.forEach(u -> u.setSearchGoodExportId(reqBO.getUccSearchGoodExportPO().getSearchGoodExportId()));
            int insertBatchCount = this.uccSearchGoodExportItemMapper.insertBatch(uccSearchGoodItemList);
            if (insertBatchCount < 1) {
                throw new BusinessException("8888", "\u6279\u91cf\u63d2\u5165\u6570\u636e\u8868ucc_search_good_export_item\u5931\u8d25\uff0cuccSearchGoodItemList" + JSON.toJSONString(uccSearchGoodItemList));
            }
        }
        rspBO.setSearchGoodExportId(reqBO.getUccSearchGoodExportPO().getSearchGoodExportId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

