/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.atom.api.InterfaceAreaAvailableQryService;
import com.tydic.commodity.mall.atom.api.PebIntfgetJDAddressFromAddressService;
import com.tydic.commodity.mall.atom.bo.InterfaceAreaAvailableCommdBO;
import com.tydic.commodity.mall.atom.bo.InterfaceAreaAvailableQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceAreaAvailableQryRspBO;
import com.tydic.commodity.mall.atom.bo.PebIntfgetJDAddressFromAddressReqBO;
import com.tydic.commodity.mall.atom.bo.PebIntfgetJDAddressFromAddressRspBO;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.utils.ESBParamUtil;
import com.tydic.commodity.mall.utils.HSHttpHelper;
import com.tydic.commodity.mall.utils.HSNHttpHeader;
import com.tydic.commodity.mall.utils.HttpRetBean;
import com.tydic.commodity.mall.utils.PropertiesUtil;
import com.tydic.umc.busi.ability.api.DycQryAreaAbilityService;
import com.tydic.umc.busi.ability.bo.DycQryAreaAbilityReqBo;
import com.tydic.umc.busi.ability.bo.DycQryAreaAbilityRspBo;
import java.net.URI;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uccAreaAvailableQryService")
public class Interfac3AreaAvailableQryServiceImpl
implements InterfaceAreaAvailableQryService {
    private static final Logger log = LoggerFactory.getLogger(Interfac3AreaAvailableQryServiceImpl.class);
    @Autowired
    private DycQryAreaAbilityService dycQryAreaAbilityService;
    @Autowired
    private PebIntfgetJDAddressFromAddressService pebIntfgetJDAddressFromAddressService;
    @Value(value="${jd_area_flag:false}")
    private boolean jdAreaFlag;

    @Override
    public InterfaceAreaAvailableQryRspBO qryAreaAvailableCommd(InterfaceAreaAvailableQryReqBO reqBO) {
        try {
            String reqStr = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_QRY_AREA_LIMIT_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_AREA_LIMIT_URL") + "]");
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u5931\u8d25");
            }
            log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            InterfaceAreaAvailableQryRspBO resolveRsp = this.resolveRsp(returnString);
            if (resolveRsp != null) {
                log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString());
            }
            return resolveRsp;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }

    private String initReqStr(InterfaceAreaAvailableQryReqBO reqBO) {
        if (("jd".equals(reqBO.getSupplierCode()) || "jdFl".equals(reqBO.getSupplierCode())) && this.jdAreaFlag) {
            DycQryAreaAbilityReqBo dycQryAreaAbilityReqBo = new DycQryAreaAbilityReqBo();
            dycQryAreaAbilityReqBo.setProvince(reqBO.getProvince());
            dycQryAreaAbilityReqBo.setCity(reqBO.getCity());
            dycQryAreaAbilityReqBo.setCounty(reqBO.getCounty());
            dycQryAreaAbilityReqBo.setTown(reqBO.getTown());
            DycQryAreaAbilityRspBo dycQryAreaAbilityRspBo = this.dycQryAreaAbilityService.qryAreaStr(dycQryAreaAbilityReqBo);
            if ("0000".equals(dycQryAreaAbilityRspBo.getRespCode()) && !StringUtils.isEmpty((Object)dycQryAreaAbilityRspBo.getAreaStr())) {
                PebIntfgetJDAddressFromAddressReqBO pebIntfgetJDAddressFromAddressReqBO = new PebIntfgetJDAddressFromAddressReqBO();
                pebIntfgetJDAddressFromAddressReqBO.setAddress(dycQryAreaAbilityRspBo.getAreaStr());
                try {
                    PebIntfgetJDAddressFromAddressRspBO pebIntfgetJDAddressFromAddressRspBO = this.pebIntfgetJDAddressFromAddressService.getAddr(pebIntfgetJDAddressFromAddressReqBO);
                    if ("0000".equals(pebIntfgetJDAddressFromAddressRspBO.getRespCode())) {
                        if (pebIntfgetJDAddressFromAddressRspBO.getProvinceId() != null) {
                            reqBO.setProvince((long)pebIntfgetJDAddressFromAddressRspBO.getProvinceId());
                        }
                        if (pebIntfgetJDAddressFromAddressRspBO.getCityId() != null) {
                            reqBO.setCity((long)pebIntfgetJDAddressFromAddressRspBO.getCityId());
                        }
                        if (pebIntfgetJDAddressFromAddressRspBO.getCountyId() != null) {
                            reqBO.setCounty((long)pebIntfgetJDAddressFromAddressRspBO.getCountyId());
                        }
                        if (pebIntfgetJDAddressFromAddressRspBO.getTownId() != null) {
                            reqBO.setTown((long)pebIntfgetJDAddressFromAddressRspBO.getTownId());
                        }
                    }
                }
                catch (Exception e) {
                    log.error("\u8c03\u7528\u4eac\u4e1c\u67e5\u8be2\u5730\u5740\u63a5\u53e3\u62a5\u9519\uff1a" + e.getMessage());
                }
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("skuIds", reqBO.getSkuIds());
        jsonObject.put("province", (Object)reqBO.getProvince());
        jsonObject.put("city", (Object)reqBO.getCity());
        jsonObject.put("county", (Object)reqBO.getCounty());
        jsonObject.put("town", (Object)reqBO.getTown());
        jsonObject.put("hsn", (Object)reqBO.getSupplierCode());
        return jsonObject.toString();
    }

    private InterfaceAreaAvailableQryRspBO resolveRsp(String returnString) {
        InterfaceAreaAvailableQryRspBO rspBO = new InterfaceAreaAvailableQryRspBO();
        ArrayList<InterfaceAreaAvailableCommdBO> list = new ArrayList<InterfaceAreaAvailableCommdBO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setSuccess((Boolean)rspJsonObject.get((Object)"success"));
            rspBO.setResultCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if ("2007".equals(respCode)) {
                    rspBO.setResultMessage("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                } else {
                    rspBO.setResultMessage("\u7535\u5546\u62a5\u9519\uff1a" + rspBO.getResultMessage());
                }
                rspBO.setResultCode("8888");
                return rspBO;
            }
            JSONArray object = rspJsonObject.getJSONArray("result");
            log.info("\u533a\u57df\u9650\u5236\uff1a" + JSON.toJSONString((Object)object));
            if (null != object) {
                for (int i = 0; i < object.size(); ++i) {
                    JSONObject obj = (JSONObject)object.get(i);
                    String jsonStr = JSONObject.toJSONString((Object)obj);
                    if (StringUtils.isEmpty((Object)jsonStr)) continue;
                    InterfaceAreaAvailableCommdBO jsonStringToJavaBean = (InterfaceAreaAvailableCommdBO)JSON.parseObject((String)jsonStr, InterfaceAreaAvailableCommdBO.class);
                    jsonStringToJavaBean.setAreaRestrict((Boolean)obj.get((Object)"isAreaRestrict"));
                    log.info("\u533a\u57df\u9650\u5236\uff1a" + JSON.toJSONString((Object)jsonStringToJavaBean));
                    list.add(jsonStringToJavaBean);
                }
                rspBO.setResult(list);
            }
            return rspBO;
        }
        catch (Exception var10) {
            log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

