/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.atom.api.PebIntfgetJDAddressFromAddressService;
import com.tydic.commodity.mall.atom.bo.PebIntfgetJDAddressFromAddressReqBO;
import com.tydic.commodity.mall.atom.bo.PebIntfgetJDAddressFromAddressRspBO;
import com.tydic.commodity.mall.utils.HSHttpHelper;
import com.tydic.commodity.mall.utils.HSNHttpHeader;
import com.tydic.commodity.mall.utils.HttpRetBean;
import com.tydic.commodity.mall.utils.PropertiesUtil;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PebIntfgetJDAddressFromAddressServiceImpl
implements PebIntfgetJDAddressFromAddressService {
    private static final Logger log = LoggerFactory.getLogger(PebIntfgetJDAddressFromAddressServiceImpl.class);

    @Override
    public PebIntfgetJDAddressFromAddressRspBO getAddr(PebIntfgetJDAddressFromAddressReqBO reqBO) {
        try {
            String reqStr = JSONObject.toJSONString((Object)reqBO);
            String callUrl = PropertiesUtil.getProperty("ESB_JD_ADDR_URL");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(callUrl), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                throw new ZTBusinessException("\u67e5\u8be2\u4eac\u4e1c\u5730\u5740[http_status=" + httpRetBean.getStatus() + "], [http_url=" + callUrl + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new ZTBusinessException("\u67e5\u8be2\u4eac\u4e1c\u5730\u5740\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            return this.resolveRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4eac\u4e1c\u5730\u5740:" + e.getMessage());
            throw new ZTBusinessException("\u67e5\u8be2\u4eac\u4e1c\u5730\u5740\u62a5\u9519" + e);
        }
    }

    private PebIntfgetJDAddressFromAddressRspBO resolveRsp(String returnString) {
        log.info("\u67e5\u8be2\u4eac\u4e1c\u5730\u5740\u8fd4\u56de\u6570\u636e" + returnString);
        PebIntfgetJDAddressFromAddressRspBO addr = new PebIntfgetJDAddressFromAddressRspBO();
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        if (rspJsonObject.getBoolean("success").booleanValue()) {
            JSONObject jsonObject = (JSONObject)rspJsonObject.get((Object)"result");
            addr = (PebIntfgetJDAddressFromAddressRspBO)((Object)JSON.parseObject((String)jsonObject.toJSONString(), PebIntfgetJDAddressFromAddressRspBO.class));
            addr.setRespCode("0000");
            addr.setRespDesc("\u6210\u529f");
            return addr;
        }
        addr.setRespCode((String)rspJsonObject.get((Object)"resultCode"));
        addr.setRespDesc((String)rspJsonObject.get((Object)"resultMessage"));
        return addr;
    }
}

