/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.utils;

import com.tydic.umc.security.utils.HttpClientPool;
import com.tydic.umc.security.utils.HttpClientPoolableObjectFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.http.client.HttpClient;

public class HSNHttpPoolHelper {
    private static final Log log = LogFactory.getLog(HSNHttpPoolHelper.class);
    public static final HttpClientPool httpClientPoolBean;
    public static final HttpClientPool httpsClientPoolBean;
    private static IdleConnectionEvictor idleConnEvictor;
    private static final long minIdleTime = 60000L;
    private static final int maxConn = 1000;
    private static final int maxActive = 1000;

    public static void shutdownTask() {
        try {
            idleConnEvictor.interrupt();
        }
        catch (Exception var2) {
            log.error((Object)("\u5173\u95edidleConnEvictor\u65f6\u51fa\u9519\uff1a" + var2.getMessage()), (Throwable)var2);
        }
        try {
            httpClientPoolBean.close();
            httpsClientPoolBean.close();
        }
        catch (Exception var1) {
            log.error((Object)("\u5173\u95edClientConnectionManager\u65f6\u51fa\u9519\uff1a" + var1.getMessage()), (Throwable)var1);
        }
    }

    public static void reConfigHttpClientConnManager() {
        httpClientPoolBean.setMaxTotal(1000);
        httpsClientPoolBean.setMaxTotal(1000);
    }

    public static long getHttpClientPoolNumActive() {
        return httpClientPoolBean.getNumActive();
    }

    public static long getHttpClientPoolMaxNum() {
        return 1000L;
    }

    private static GenericObjectPoolConfig getObjectPoolConfig() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(5);
        config.setMaxIdle(5);
        config.setMaxWaitMillis(1000L);
        config.setMinIdle(100);
        config.setTestOnBorrow(false);
        config.setTestOnReturn(false);
        config.setTestWhileIdle(false);
        config.setMinEvictableIdleTimeMillis(60000L);
        config.setTimeBetweenEvictionRunsMillis(60000L);
        config.setNumTestsPerEvictionRun(10);
        return config;
    }

    static {
        idleConnEvictor = null;
        AbandonedConfig abandonedConfig = new AbandonedConfig();
        abandonedConfig.setRemoveAbandonedOnMaintenance(true);
        abandonedConfig.setRemoveAbandonedOnBorrow(true);
        abandonedConfig.setRemoveAbandonedTimeout(30);
        GenericObjectPoolConfig config = HSNHttpPoolHelper.getObjectPoolConfig();
        HttpClientPoolableObjectFactory httpClientPoolableObjectFactory = new HttpClientPoolableObjectFactory();
        httpClientPoolBean = new HttpClientPool((PooledObjectFactory<HttpClient>)httpClientPoolableObjectFactory, config, abandonedConfig);
        HttpClientPoolableObjectFactory httpsClientPoolableObjectFactory = new HttpClientPoolableObjectFactory();
        httpsClientPoolBean = new HttpClientPool((PooledObjectFactory<HttpClient>)httpsClientPoolableObjectFactory, config, abandonedConfig);
        idleConnEvictor = new IdleConnectionEvictor();
        idleConnEvictor.start();
    }

    public static class IdleConnectionEvictor
    extends Thread {
        private static final int INTERVAL = 5000;

        public IdleConnectionEvictor() {
            super("HttpClient_IdleConnectionEvictor");
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    IdleConnectionEvictor.sleep(5000L);
                    httpClientPoolBean.setEvictorShutdownTimeoutMillis(60000L);
                    httpsClientPoolBean.setEvictorShutdownTimeoutMillis(60000L);
                }
                catch (InterruptedException var2) {
                    log.info((Object)"IdleConnectionEvictor\u4efb\u52a1\u7ed3\u675f\uff01");
                    break;
                }
                catch (Throwable var3) {
                    log.error((Object)"\u5b9a\u65f6\u5173\u95edhttp\u8fde\u63a5\u51fa\u9519\uff01", var3);
                }
            }
        }
    }
}

