/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.umc.busi.ability.api.UmcNoathUrlAccessAbilityService;
import com.tydic.umc.busi.ability.api.UmcNoathUrlInterceptLogAbilityService;
import com.tydic.umc.busi.ability.api.UmcNoathUrlReleaseAbilityService;
import com.tydic.umc.busi.ability.bo.UmcNoauthUrlAccessAbilityBO;
import com.tydic.umc.busi.ability.bo.UmcNoauthUrlAccessAbilityRspBO;
import com.tydic.umc.busi.ability.bo.UmcNoauthUrlInterceptLogBO;
import com.tydic.umc.general.ability.api.UmcLoginAbilityService;
import com.tydic.umc.general.ability.bo.UmcLoginExpTimeAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcLoginExpTimeAbilityRspBO;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.base.UmcMemInfoHelper;
import com.tydic.umc.security.base.UmcUserDetails;
import com.tydic.umc.security.filter.ParameterRequestWrapper;
import com.tydic.umc.security.jwt.UmcJwt;
import com.tydic.umc.security.jwt.UmcTokenState;
import com.tydic.umc.security.service.GetUserInfoByUserIdService;
import com.tydic.umc.security.utils.IpAddressUtil;
import com.tydic.umc.security.utils.RegexUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.minidev.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Order(value=0x7FFFFFFD)
@Component
public class UmcTokenAuthenticationFilter
extends GenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcTokenAuthenticationFilter.class);
    @Value(value="${static.resources}")
    private String staticResources;
    @Value(value="${noauth.url.resources:127.0.0.1}")
    private String noauthUrlResources;
    @Value(value="${noauth.url.path.resources:url}")
    private String noauthUrlPathResources;
    @Value(value="${noauth.url.enable:true}")
    private String noauthUrlEnable;
    @Value(value="${login.expTime:7200}")
    private Long expTime;
    private static ThreadLocal<Boolean> allowSessionCreation = new ThreadLocal();
    @Autowired
    private GetUserInfoByUserIdService getUserInfoByTokenService;
    @Autowired
    private UmcLoginAbilityService umcLoginAbilityService;
    @Autowired
    private UmcNoathUrlReleaseAbilityService umcNoathUrlReleaseAbilityService;
    @Autowired
    private UmcNoathUrlAccessAbilityService umcNoathUrlAccessAbilityService;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UmcNoathUrlInterceptLogAbilityService umcNoathUrlInterceptLogAbilityService;
    @Value(value="${NOAUTH_REDIS_EXP_TIME:1800}")
    private int noauthRedisExpTime;
    private static final String NOAUTH_URL_ACCESS_KEY = "NOAUTH_URL_ACCESS_KEY";

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        Cookie[] cookies;
        String token = request.getHeader("auth-token");
        if (StringUtils.isEmpty((CharSequence)token) && (cookies = request.getCookies()) != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals("auth-token")) continue;
                token = cookies[i].getValue();
            }
        }
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        com.alibaba.fastjson.JSONObject datajsonObject = new com.alibaba.fastjson.JSONObject();
        LOGGER.debug("\u83b7\u53d6\u5f53\u524dtocken" + token);
        if (token != null) {
            UmcLoginExpTimeAbilityReqBO reqBO = new UmcLoginExpTimeAbilityReqBO();
            reqBO.setToken(token);
            UmcLoginExpTimeAbilityRspBO rspBO = this.umcLoginAbilityService.getLoginExpTime(reqBO);
            Long loginExpTime = 0L;
            LOGGER.debug("\u8c03\u7528\u83b7\u53d6\u5230\u671f\u65f6\u95f4\u670d\u52a1" + JSON.toJSONString((Object)rspBO));
            if ("0000".equals(rspBO.getRespCode())) {
                loginExpTime = rspBO.getExpTime();
                LOGGER.debug("\u83b7\u53d6\u5230\u671f\u65f6\u95f4" + loginExpTime);
            }
            Map<String, Object> resultMap = UmcJwt.validToken(token, loginExpTime);
            UmcTokenState state = UmcTokenState.getTokenState((String)resultMap.get("state"));
            switch (state) {
                case VALID: {
                    JSONObject data = (JSONObject)resultMap.get("data");
                    request.setAttribute("data", (Object)data);
                    String appCode = data.getAsString("appCode");
                    reqBO.setUserId((Long)data.get((Object)"userId"));
                    reqBO.setLoginSource((String)data.get((Object)"loginSource"));
                    this.umcLoginAbilityService.updateLoginExpTime(reqBO);
                    UmcUserDetails user = this.getUserInfoByTokenService.getUserInfoByUserId((Long)data.get((Object)"userId"), token, appCode, request.getRequestURI());
                    if ("0000".equals(user.getRespCode())) {
                        return new UsernamePasswordAuthenticationToken((Object)user.getUserDetails(), (Object)user.getUserDetails().getPassword(), user.getUserDetails().getAuthorities());
                    }
                    datajsonObject.put("respCode", (Object)user.getRespCode());
                    datajsonObject.put("respDesc", (Object)user.getRespDesc());
                    jsonObject.put("data", (Object)datajsonObject);
                    LOGGER.info(user.getRespCode());
                    break;
                }
                case EXPIRED: {
                    datajsonObject.put("respCode", (Object)"AE401");
                    datajsonObject.put("respDesc", (Object)"\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                    jsonObject.put("data", (Object)datajsonObject);
                    break;
                }
                default: {
                    datajsonObject.put("respCode", (Object)"AE401");
                    datajsonObject.put("respDesc", (Object)"\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                    jsonObject.put("data", (Object)datajsonObject);
                    break;
                }
            }
        } else {
            datajsonObject.put("respCode", (Object)"AE401");
            datajsonObject.put("respDesc", (Object)"\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            jsonObject.put("data", (Object)datajsonObject);
        }
        if ("AE403".equals(datajsonObject.getString("respCode"))) {
            response.setStatus(403);
        } else {
            response.setStatus(401);
        }
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        jsonObject.put("code", (Object)"1");
        jsonObject.put("message", (Object)"\u5931\u8d25");
        String jsonString = JSON.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
        out.write(jsonString);
        out.close();
        return null;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        ServletRequest requestWrapper = null;
        String url = request.getRequestURI();
        boolean needToken = true;
        Boolean isNoauth = Boolean.FALSE;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.staticResources})) {
            String[] split;
            for (String staticResource : split = this.staticResources.split(";")) {
                if (!RegexUtils.wildcardEquals(staticResource, url)) continue;
                needToken = false;
            }
        }
        if (RegexUtils.wildcardEquals("**/**/users/signup/**", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/noauth/**", url)) {
            needToken = false;
            isNoauth = Boolean.TRUE;
        }
        if (RegexUtils.wildcardEquals("**/**/**/noauth/**", url)) {
            needToken = false;
            isNoauth = Boolean.TRUE;
        }
        if (RegexUtils.wildcardEquals("**/**/api/token/get", url)) {
            needToken = false;
        }
        if (this.noauthUrlEnable.equals("true") && isNoauth.booleanValue()) {
            this.checkNoauthIp(request, url);
        }
        allowSessionCreation.set(true);
        if (needToken) {
            Authentication auth = this.attemptAuthentication(request, response);
            if (auth == null) {
                return;
            }
            allowSessionCreation.set(false);
            SecurityContextHolder.getContext().setAuthentication(auth);
            requestWrapper = this.parameterRequest(request.getHeader("auth-token"), request, response);
        }
        if (requestWrapper == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            LOGGER.debug("UmcUserInfoWrapperFilter---1\uff1a");
        } else {
            LOGGER.debug("UmcUserInfoWrapperFilter---2\uff1a");
            chain.doFilter(requestWrapper, (ServletResponse)response);
        }
    }

    private void checkNoauthIp(HttpServletRequest request, String requestUrl) {
        LOGGER.debug("checkNoauthIp requestUrl:{}", (Object)requestUrl);
        List umcNoauthUrlAccessAbilityBOS = null;
        Object o = this.cacheClient.get(NOAUTH_URL_ACCESS_KEY);
        if (Objects.isNull(o)) {
            UmcNoauthUrlAccessAbilityRspBO umcNoauthUrlAccessAbilityRspBO = this.umcNoathUrlAccessAbilityService.listByParam(new UmcNoauthUrlAccessAbilityBO());
            umcNoauthUrlAccessAbilityBOS = umcNoauthUrlAccessAbilityRspBO.getRspBOs();
            if (umcNoauthUrlAccessAbilityBOS.isEmpty()) {
                throw new ZTBusinessException("\u672a\u9274\u6743\u914d\u7f6e\u8868\u6570\u636e\u4e3a\u7a7a:" + request);
            }
            this.cacheClient.set(NOAUTH_URL_ACCESS_KEY, (Object)umcNoauthUrlAccessAbilityBOS, this.noauthRedisExpTime);
        } else {
            umcNoauthUrlAccessAbilityBOS = JSON.parseArray((String)JSON.toJSONString((Object)o), UmcNoauthUrlAccessAbilityBO.class);
        }
        String ipAddress = IpAddressUtil.getIpAddress(request);
        Map<String, List<UmcNoauthUrlAccessAbilityBO>> urlMap = umcNoauthUrlAccessAbilityBOS.stream().collect(Collectors.groupingBy(UmcNoauthUrlAccessAbilityBO::getUrl));
        List<UmcNoauthUrlAccessAbilityBO> umcNoauthUrlAccessAbilityBOList = urlMap.get(requestUrl);
        if (CollectionUtils.isEmpty(umcNoauthUrlAccessAbilityBOList)) {
            this.logger.error((Object)("\u8be5\u8bbf\u95ee\u8def\u5f84\u672a\u914d\u7f6e\u9274\u6743\u8868, \u8def\u5f84: " + requestUrl));
            try {
                UmcNoauthUrlInterceptLogBO umcNoauthUrlInterceptLogBO = new UmcNoauthUrlInterceptLogBO();
                umcNoauthUrlInterceptLogBO.setInterceptType(Integer.valueOf(1));
                umcNoauthUrlInterceptLogBO.setRequestIp(ipAddress);
                umcNoauthUrlInterceptLogBO.setUrl(requestUrl);
                umcNoauthUrlInterceptLogBO.setCreateTime(new Date());
                umcNoauthUrlInterceptLogBO.setIsDeleted(Integer.valueOf(0));
                this.umcNoathUrlInterceptLogAbilityService.insert(umcNoauthUrlInterceptLogBO);
            }
            catch (Exception e) {
                this.logger.error((Object)("\u65b0\u589e\u62e6\u622a\u975e\u9274\u6743\u63a5\u53e3\u65e5\u5fd7\u5f02\u5e38\uff1a" + e));
            }
            throw new ZTBusinessException("\u5f53\u524d\u8bbf\u95ee\u8def\u5f84\u7981\u6b62\u8bbf\u95ee\uff0c\u5982\u9700\u8981\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\uff1a" + requestUrl);
        }
        UmcNoauthUrlAccessAbilityBO umcNoauthUrlAccessAbilityBO = umcNoauthUrlAccessAbilityBOList.get(0);
        String requestIp = umcNoauthUrlAccessAbilityBO.getRequestIp();
        if (StringUtils.isBlank((CharSequence)requestIp)) {
            return;
        }
        String[] split = requestIp.split(";");
        boolean noauthBool = true;
        for (String staticResource : split) {
            if (!ipAddress.startsWith(staticResource)) continue;
            noauthBool = false;
            break;
        }
        if (noauthBool) {
            try {
                UmcNoauthUrlInterceptLogBO umcNoauthUrlInterceptLogBO = new UmcNoauthUrlInterceptLogBO();
                umcNoauthUrlInterceptLogBO.setInterceptType(Integer.valueOf(2));
                umcNoauthUrlInterceptLogBO.setRequestIp(ipAddress);
                umcNoauthUrlInterceptLogBO.setUrl(requestUrl);
                umcNoauthUrlInterceptLogBO.setCreateTime(new Date());
                umcNoauthUrlInterceptLogBO.setIsDeleted(Integer.valueOf(0));
                this.umcNoathUrlInterceptLogAbilityService.insert(umcNoauthUrlInterceptLogBO);
            }
            catch (Exception e) {
                this.logger.error((Object)("\u65b0\u589e\u62e6\u622a\u975e\u9274\u6743\u63a5\u53e3\u65e5\u5fd7\u5f02\u5e38\uff1a" + e));
            }
            throw new ZTBusinessException("\u975e\u6cd5\u6765\u6e90ip\u8bbf\u95ee:" + ipAddress);
        }
    }

    private ServletRequest parameterRequest(String token, HttpServletRequest request, HttpServletResponse response) {
        UmcMemInfoBO userInfo = UmcMemInfoHelper.getCurrentUser();
        ParameterRequestWrapper requestWrapper = null;
        if (userInfo != null) {
            if (LOGGER.isDebugEnabled()) {
                // empty if block
            }
            if (userInfo.getUserId() != null && request instanceof HttpServletRequest) {
                LOGGER.debug("UmcUserInfoWrapperFilter---\u81ea\u5b9a\u4e49\u5305\u88c5\u5668\uff1a");
                requestWrapper = new ParameterRequestWrapper(request);
            }
        }
        LOGGER.debug("UmcUserInfoWrapperFilter---requestWrapper\uff1a");
        return requestWrapper;
    }

    public static boolean isAllowSessionCreation() {
        return allowSessionCreation.get();
    }
}

