/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.utils;

import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class HttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtil.class);
    private static final String CHARSET = "utf-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, Map<String, String> header) {
        String result = null;
        CloseableHttpClient httpClient = HttpClientUtil.createHttpClient();
        HttpGet httpGet = new HttpGet(url);
        if (!CollectionUtils.isEmpty(header)) {
            for (String key : header.keySet()) {
                httpGet.addHeader(key, header.get(key));
            }
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(2000).setSocketTimeout(3000).setConnectTimeout(2000).build();
        httpGet.setConfig(requestConfig);
        try {
            HttpEntity resEntity;
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)CHARSET);
            }
        }
        catch (Exception ex) {
            log.error("HTTP\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)ex);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (Exception e) {
                log.error("\u5173\u95edHttpClient\u5f02\u5e38:{}", (Throwable)e);
            }
        }
        return result;
    }

    private static CloseableHttpClient createHttpClient() {
        try {
            SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((chain, authType) -> true).build();
            return HttpClientBuilder.create().setSSLContext(sslContext).build();
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efaHttpClient\u5931\u8d25", e);
        }
    }
}

