/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.mq.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfCreatePurchaseOrderAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfEnterpriseOrgDetailAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfGoodsListDelAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfMemDetailQueryAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQryAgreementSkuByPageAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQueryParentOrgNotDepartmentAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfWalletConsumeAbilityService;
import com.tydic.uoc.busibase.busi.bo.AgreementSkuBO;
import com.tydic.uoc.busibase.busi.bo.EnterpriseOrgDetailReqBO;
import com.tydic.uoc.busibase.busi.bo.EnterpriseOrgDetailRspBO;
import com.tydic.uoc.busibase.busi.bo.MemDetailQueryReqBO;
import com.tydic.uoc.busibase.busi.bo.MemDetailQueryRspBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfCreatePurchaseOrderHeader;
import com.tydic.uoc.busibase.busi.bo.PebIntfCreatePurchaseOrderReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfCreatePurchaseOrderRspBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfCreatePurchaseOrderWsInterface;
import com.tydic.uoc.busibase.busi.bo.QryAgreementSkuByPageReqBO;
import com.tydic.uoc.busibase.busi.bo.QryAgreementSkuByPageRspBO;
import com.tydic.uoc.busibase.busi.bo.SettlementModeExceptFscBO;
import com.tydic.uoc.busibase.busi.bo.SettlementModeExceptFscQryListReqBO;
import com.tydic.uoc.busibase.busi.bo.WalletConsumeReqBO;
import com.tydic.uoc.busibase.busi.bo.WalletConsumeRspBO;
import com.tydic.uoc.common.ability.api.plan.PebExtPlanIdxSyncAbilityService;
import com.tydic.uoc.common.ability.bo.OrdSaleRspBO;
import com.tydic.uoc.common.ability.bo.PebExtAgreementSkuInfo;
import com.tydic.uoc.common.ability.bo.PebExtAgreementSubmitOrderSaleItemRspBO;
import com.tydic.uoc.common.ability.bo.plan.PebPlanIdxSyncAbilityReqBO;
import com.tydic.uoc.common.atom.api.UocPebUniCallIntfAtomService;
import com.tydic.uoc.common.atom.api.UocQrySaleOrderAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.QrySaleReqBO;
import com.tydic.uoc.common.atom.bo.UnicallInterfaceDefBO;
import com.tydic.uoc.common.atom.bo.UocPebUniCallIntfReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.PebExtFieldInBusiService;
import com.tydic.uoc.common.busi.api.UocPebOrderCancellationBusiService;
import com.tydic.uoc.common.busi.bo.FieldValueBO;
import com.tydic.uoc.common.busi.bo.OrdInterLogBO;
import com.tydic.uoc.common.busi.bo.PebExtFieldInReqBO;
import com.tydic.uoc.common.busi.bo.PebExtFieldInRspBO;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationReqBO;
import com.tydic.uoc.common.busi.bo.UocPebOrderCancellationReqBO;
import com.tydic.uoc.common.comb.api.UocPebAgainAddShippingCartCombService;
import com.tydic.uoc.common.comb.api.UocSyncStatisticsInfoCombService;
import com.tydic.uoc.common.comb.bo.PebExtOrdIdxSyncReqBO;
import com.tydic.uoc.common.comb.bo.UocPebAgainAddShippingCartReqBO;
import com.tydic.uoc.common.comb.bo.UocSyncStatisticsInfoCombReqBO;
import com.tydic.uoc.common.utils.XmlDateUtil;
import com.tydic.uoc.dao.OrdEcpPlanItemMapper;
import com.tydic.uoc.dao.OrdEcpPlanMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPlanDao;
import com.tydic.uoc.dao.OrdPlanItemDao;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPlanItemPO;
import com.tydic.uoc.po.OrdPlanPO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocAccountPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class PebZoneCreateOrderConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private Logger logger = LoggerFactory.getLogger(PebZoneCreateOrderConsumer.class);
    @Autowired
    private UocQrySaleOrderAtomService saleOrderAtomService;
    @Autowired
    private UocPebUniCallIntfAtomService uocPebUniCallIntfAtomService;
    @Autowired
    private UocPebOrderCancellationBusiService uocPebOrderCancellationBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Resource(name="dealZoneDealAutomaticTaskMsgProvider")
    private ProxyMessageProducer dealZoneDealAutomaticTaskMsgProvider;
    @Value(value="${UOC_ZONE_DEAL_AUTO_TASK_TOPIC}")
    private String taskTopic;
    @Value(value="${UOC_ZONE_DEAL_AUTO_TASK_TAG}")
    private String taskTag;
    @Autowired
    private PebIntfCreatePurchaseOrderAbilityService pebIntfCreatePurchaseOrderAbilityService;
    @Autowired
    private OrdEcpPlanMapper ordEcpPlanMapper;
    @Autowired
    private OrdEcpPlanItemMapper ordEcpPlanItemMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Value(value="${ecp.jgbh:dzsc}")
    private String jgbh;
    @Value(value="${ecp.sqbh:dzsc201907zssq}")
    private String sqbh;
    @Value(value="ecp.jzcglx:0")
    private String jzcglx;
    @Autowired
    private UocPebAgainAddShippingCartCombService uocPebAgainAddShippingCartCombService;
    @Autowired
    private PebIntfMemDetailQueryAbilityService pebIntfMemDetailQueryAbilityService;
    @Autowired
    private PebExtFieldInBusiService pebExtFieldInBusiService;
    @Value(value="${busiMode:0}")
    private String initBusiMode;
    @Autowired
    private UocSyncStatisticsInfoCombService uocSyncStatisticsInfoCombService;
    @Autowired
    private PebIntfWalletConsumeAbilityService pebIntfWalletConsumeAbilityService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private PebIntfQryAgreementSkuByPageAbilityService pebIntfQryAgreementSkuByPageAbilityService;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private PebIntfGoodsListDelAbilityService pebIntfGoodsListDelAbilityService;
    @Value(value="${staff.welfare.pay.config.enable:false}")
    private boolean payConfig;
    @Value(value="${UOC_NOTIFY_ORDER_TOPIC}")
    private String notifyTopic;
    @Value(value="${UOC_NOTIFY_ORDER_TAG}")
    private String notifyTag;
    @Resource(name="notifyOrderMsgProvider")
    private ProxyMessageProducer notifyOrderMsgProvider;
    @Autowired
    private OrdPlanItemDao ordPlanItemDao;
    @Autowired
    private OrdPlanDao ordPlanDao;
    @Autowired
    private PebIntfQueryParentOrgNotDepartmentAbilityService pebIntfQueryParentOrgNotDepartmentAbilityService;
    @Value(value="${needDate:30}")
    private Long needDate;
    @Autowired
    private PebExtPlanIdxSyncAbilityService pebExtPlanIdxSyncAbilityService;
    @Autowired
    private PebIntfEnterpriseOrgDetailAbilityService pebIntfEnterpriseOrgDetailAbilityService;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        try {
            PebExtAgreementSubmitOrderSaleItemRspBO submit = (PebExtAgreementSubmitOrderSaleItemRspBO)JSON.parseObject((String)proxyMessage.getContent(), PebExtAgreementSubmitOrderSaleItemRspBO.class);
            this.logger.debug("\u8ba2\u5355\u4e0b\u5355\u6d88\u8d39\u8005\u5165\u53c2" + JSON.toJSONString((Object)submit));
            QrySaleReqBO qrySaleReqBO = new QrySaleReqBO();
            qrySaleReqBO.setSaleId(Long.valueOf(submit.getSaleOrderId()));
            qrySaleReqBO.setOrderId(submit.getOrderId());
            OrdSaleRspBO saleRspBO = this.saleOrderAtomService.qry(qrySaleReqBO);
            UocPebUniCallIntfReqBO callIntfReqBO = new UocPebUniCallIntfReqBO();
            UnicallInterfaceDefBO interfaceDefBO = new UnicallInterfaceDefBO();
            interfaceDefBO.setIsAllowException(Integer.valueOf(1));
            interfaceDefBO.setInterCode("PcChargebacksRequest");
            interfaceDefBO.setInterMethod("dealEBConfirmOrder");
            interfaceDefBO.setInterType(Integer.valueOf(1));
            interfaceDefBO.setInterDesc("\u7ed3\u7b97\u4e2d\u5fc3\u6263\u6b3e");
            callIntfReqBO.setInterfaceDef(interfaceDefBO);
            callIntfReqBO.setOrderId(submit.getOrderId());
            callIntfReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            callIntfReqBO.setObjId(saleRspBO.getSaleVoucherId());
            this.uocPebUniCallIntfAtomService.dealUniCallIntf(callIntfReqBO);
            HashMap<String, String> map = new HashMap<String, String>();
            boolean flag = this.getBusiMode(submit, saleRspBO, map);
            if (!flag) {
                this.uocPebOrdIdxSync(submit);
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            try {
                this.pebIntfGoodsListDelAbilityService.delGoodsList(submit.getGoodsListDelReqBO());
            }
            catch (Exception e) {
                this.logger.debug("\u5220\u9664\u8d2d\u7269\u8f66\u5931\u8d25" + e);
            }
            flag = this.sendErp(saleRspBO, submit);
            try {
                this.run(saleRspBO);
            }
            catch (Exception e) {
                this.logger.error("\u72b6\u6001\u53d8\u66f4\u5f02\u5e38!", (Throwable)e);
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            this.uocPebOrdIdxSync(submit);
            this.saveAddPrice(submit);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u4e0b\u5355\u6d88\u8d39\u5931\u8d25" + e);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private String getEmpCod(Long userId) {
        MemDetailQueryReqBO reqBO = new MemDetailQueryReqBO();
        reqBO.setUserIdWeb(userId);
        MemDetailQueryRspBO rspBO = this.pebIntfMemDetailQueryAbilityService.memDetailQuery(reqBO);
        if (rspBO.getUmcMemDetailInfoAbilityRspBO() == null) {
            return null;
        }
        return rspBO.getUmcMemDetailInfoAbilityRspBO().getOccupation();
    }

    private void saveAddPrice(PebExtAgreementSubmitOrderSaleItemRspBO rspBO) {
        QryAgreementSkuByPageReqBO reqBO = new QryAgreementSkuByPageReqBO();
        reqBO.setAgreementId(((PebExtAgreementSkuInfo)rspBO.getSaleOrderItemList().get(0)).getAgrId());
        reqBO.setPageQueryFlag(Boolean.valueOf(false));
        QryAgreementSkuByPageRspBO pageRspBO = this.pebIntfQryAgreementSkuByPageAbilityService.qryAgreementSkuByPage(reqBO);
        if ("0000".equals(pageRspBO.getRespCode()) && CollectionUtils.isNotEmpty((Collection)pageRspBO.getRows())) {
            OrdItemPO ordItemPo = new OrdItemPO();
            ordItemPo.setOrderId(rspBO.getOrderId());
            List ordItemList = this.ordItemMapper.getList(ordItemPo);
            Map<Long, AgreementSkuBO> map = pageRspBO.getRows().stream().collect(Collectors.toMap(AgreementSkuBO::getAgreementSkuId, a -> a));
            for (PebExtAgreementSkuInfo skuInfo : rspBO.getSaleOrderItemList()) {
                for (OrdItemPO itemPo : ordItemList) {
                    if (!skuInfo.getSkuId().equals(itemPo.getSkuId())) continue;
                    AgreementSkuBO skuBO = map.get(skuInfo.getAgreementDetailsId());
                    if (skuBO == null) {
                        return;
                    }
                    OrdItemPO update = new OrdItemPO();
                    update.setOrderId(itemPo.getOrderId());
                    update.setOrdItemId(itemPo.getOrdItemId());
                    if (skuBO.getMarkupRate() == null) continue;
                    update.setTaxId(skuBO.getTaxCatalog());
                    update.setLmSubOrderId(skuBO.getMarkupRate().toString());
                    this.ordItemMapper.updateById(update);
                }
            }
        }
    }

    private void saveLog(Long orderId, Long saleId, String in, String out, String code, String errCode) {
        if (StringUtils.isBlank((CharSequence)in)) {
            in = "in";
        }
        if (StringUtils.isBlank((CharSequence)out)) {
            out = "out";
        }
        OrdInterLogBO logBO = new OrdInterLogBO();
        logBO.setErrDetail("1");
        logBO.setFlowFlag(Integer.valueOf(1));
        logBO.setInContent(in);
        logBO.setInterCode(code);
        logBO.setInterSn("1");
        logBO.setCallCount(Integer.valueOf(1));
        logBO.setCallState("1");
        logBO.setCreateLoginId("1");
        logBO.setCallTime(new Date());
        logBO.setErrCode(errCode);
        logBO.setOutContent(out);
        logBO.setRetTime(new Date());
        logBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        logBO.setOrderId(orderId);
        logBO.setObjId(saleId);
        PebExtFieldInReqBO reqBO = new PebExtFieldInReqBO();
        reqBO.setLog(logBO);
        try {
            this.pebExtFieldInBusiService.dealSaveLog(reqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean sendErp(OrdSaleRspBO saleRspBO, PebExtAgreementSubmitOrderSaleItemRspBO submit) {
        if (submit.getErp() == null || !submit.getErp().booleanValue()) {
            return true;
        }
        String occ = this.getEmpCod(submit.getUserId());
        OrdStakeholderPO stakeholderPO = new OrdStakeholderPO();
        stakeholderPO.setOrderId(saleRspBO.getOrderId());
        stakeholderPO = this.ordStakeholderMapper.getModelBy(stakeholderPO);
        EnterpriseOrgDetailReqBO queryReqBO = new EnterpriseOrgDetailReqBO();
        queryReqBO.setOrgIdWeb(Long.valueOf(stakeholderPO.getPurAccountOwnId()));
        EnterpriseOrgDetailRspBO orgQueryRspBO = this.pebIntfEnterpriseOrgDetailAbilityService.queryEnterpriseOrgByDetail(queryReqBO);
        if (!orgQueryRspBO.getRespCode().equals("0000") || orgQueryRspBO.getUmcEnterpriseOrgAbilityBO() == null) {
            String str = null;
            str = !orgQueryRspBO.getRespCode().equals("0000") ? "\u67e5\u8be2\u4e1a\u52a1\u5b9e\u4f53\u5931\u8d25\u3002" + orgQueryRspBO.getRespDesc() : "\u67e5\u8be2\u4e1a\u52a1\u5b9e\u4f53\u4e0d\u5b58\u5728";
            this.cancel(saleRspBO, str);
        }
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(saleRspBO.getOrderId());
        List list = this.ordItemMapper.getList(ordItemPO);
        ArrayList<Long> itemIds = new ArrayList<Long>();
        for (OrdItemPO itemPO : list) {
            itemIds.add(itemPO.getPlanItemId());
        }
        List planItemPOS = this.ordPlanItemDao.getListByIds(itemIds);
        OrdPlanPO planPO = new OrdPlanPO();
        this.logger.info("getModelBy\u5165\u53c2\uff1aplanItemPOS.get(0).getPlanId()=" + ((OrdPlanItemPO)planItemPOS.get(0)).getPlanId());
        planPO.setPlanId(((OrdPlanItemPO)planItemPOS.get(0)).getPlanId());
        planPO = this.ordPlanDao.getModelBy(planPO);
        int flag = 0;
        UocAccountPO uocAccountPO = new UocAccountPO();
        List uocAccountPOList = this.ordPlanDao.getAccountList(uocAccountPO);
        if (!uocAccountPOList.isEmpty()) {
            System.out.println("\u662f\u5426\u4f20\u542b\u7a0e\u4ef7uocAccountPOList:" + uocAccountPOList.toString());
            for (UocAccountPO uocAccountPO1 : uocAccountPOList) {
                System.out.println("\u662f\u5426\u4f20\u542b\u7a0e\u4ef7uocAccountPO1:" + uocAccountPO1);
                if (!(uocAccountPO1.getAccountId() + "").equals(planPO.getPurchaserAccount())) continue;
                flag = 1;
                break;
            }
        }
        System.out.println("\u662f\u5426\u4f20\u542b\u7a0e\u4ef7flag:" + flag);
        Map<Long, OrdPlanItemPO> map = planItemPOS.stream().collect(Collectors.toMap(OrdPlanItemPO::getPlanItemId, a -> a));
        PebIntfCreatePurchaseOrderReqBO reqBO = new PebIntfCreatePurchaseOrderReqBO();
        PebIntfCreatePurchaseOrderWsInterface wsInterface = new PebIntfCreatePurchaseOrderWsInterface();
        reqBO.setWsinterface(wsInterface);
        ArrayList<PebIntfCreatePurchaseOrderHeader> header = new ArrayList<PebIntfCreatePurchaseOrderHeader>(list.size());
        wsInterface.setHeader(header);
        HashSet<Long> set = new HashSet<Long>();
        for (OrdItemPO itemPO : list) {
            set.add(itemPO.getTax());
        }
        if (set.size() > 1) {
            this.cancel(saleRspBO, "\u5546\u54c1\u7a0e\u7387\u4e0d\u540c\uff0c\u4e0d\u5141\u8bb8\u4e0b\u5355");
            return false;
        }
        for (OrdItemPO itemPO : list) {
            this.logger.info("OrdItemPO::list\uff1aitemPO.getOrdItemId().toString()=" + itemPO.getOrdItemId().toString());
            PebIntfCreatePurchaseOrderHeader purchaseOrderHeader = new PebIntfCreatePurchaseOrderHeader();
            purchaseOrderHeader.setSourceLineId(itemPO.getOrdItemId().toString());
            purchaseOrderHeader.setSourceOrderNumber(saleRspBO.getSaleVoucherNo());
            purchaseOrderHeader.setAgentId(Long.valueOf(occ));
            purchaseOrderHeader.setOrgId(Long.valueOf(orgQueryRspBO.getUmcEnterpriseOrgAbilityBO().getErpOrgCode()));
            purchaseOrderHeader.setOrganizationId(Long.valueOf(planPO.getStockOrgId()));
            this.logger.info("OrdItemPO::list\uff1aitemPO.getLmOrderId()=" + itemPO.getPlanItemId());
            OrdPlanItemPO planItemPO = map.get(itemPO.getPlanItemId());
            this.logger.info("OrdItemPO::list\uff1aplanItemPO.getErpLineId()=" + planItemPO.getErpLineId());
            purchaseOrderHeader.setItemNumber(planItemPO.getSkuMaterialId());
            purchaseOrderHeader.setQuantity(Double.valueOf(itemPO.getPurchaseCount().doubleValue()));
            try {
                BigDecimal price = itemPO.getTax() == null ? new BigDecimal(0.16) : new BigDecimal((float)itemPO.getTax().longValue() / 100.0f);
                BigDecimal djs = new BigDecimal(itemPO.getSalePrice()).divide(new BigDecimal(10000));
                BigDecimal taxA = price.add(BigDecimal.ONE);
                BigDecimal bud = djs.multiply(price).divide(taxA, 8, RoundingMode.HALF_UP);
                if (0 == flag) {
                    purchaseOrderHeader.setPrice(djs.subtract(bud));
                } else {
                    purchaseOrderHeader.setPrice(djs);
                }
            }
            catch (Exception e) {
                return false;
            }
            purchaseOrderHeader.setNeedDate(XmlDateUtil.convertToXMLGregorianCalendar((Date)new Date(System.currentTimeMillis() + this.needDate * 24L * 60L * 60L * 1000L)).toString());
            purchaseOrderHeader.setSupplier(this.proNo(String.valueOf(planItemPO.getSkuSupplierId())));
            purchaseOrderHeader.setSupplier(planItemPO.getSkuSupplierName());
            purchaseOrderHeader.setVendorName("\u4e2d\u7164\u4fe1\u606f\u6280\u672f\uff08\u5317\u4eac\uff09\u6709\u9650\u516c\u53f8");
            purchaseOrderHeader.setSourcePlanLineId(String.valueOf(planItemPO.getPlanItemId()));
            purchaseOrderHeader.setOrderTax(itemPO.getTax().toString());
            if (planItemPO.getSkuMaterialName() == null) {
                purchaseOrderHeader.setYgItemDes(planItemPO.getSkuName());
            } else {
                purchaseOrderHeader.setYgItemDes(planItemPO.getSkuName());
            }
            this.logger.info("\u65b0\u8865\u5145ERP\u8ba1\u5212\u884cID\u5b57\u6bb5\uff1aplanItemPO.getErpLineId()=" + planItemPO.getErpLineId());
            if (planItemPO.getErpLineId() != null) {
                this.logger.info("\u5b57\u6bb5\u503c\u4e0e\u8ba1\u5212\u660e\u7ec6ID\u662f\u5426\u76f8\u540c\uff1aplanItemPO.getErpLineId()=" + planItemPO.getErpLineId());
                this.logger.info("\u5b57\u6bb5\u503c\u4e0e\u8ba1\u5212\u660e\u7ec6ID\u662f\u5426\u76f8\u540c\uff1aplanItemPO.getPlanItemId()=" + planItemPO.getPlanItemId());
                if (planItemPO.getErpLineId().longValue() != planItemPO.getPlanItemId().longValue()) {
                    purchaseOrderHeader.setErpSchLineId(planItemPO.getErpLineId() + "");
                }
            }
            header.add(purchaseOrderHeader);
        }
        try {
            this.logger.info("\u540c\u6b65erp\u7cfb\u7edf\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
            PebIntfCreatePurchaseOrderRspBO pebIntfCreatePurchaseOrderRspBO = this.pebIntfCreatePurchaseOrderAbilityService.puchaserOrder(reqBO);
            this.logger.info("\u540c\u6b65erp\u7cfb\u7edf\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)pebIntfCreatePurchaseOrderRspBO));
            this.saveExt(saleRspBO.getOrderId(), pebIntfCreatePurchaseOrderRspBO.getPoNumber(), ((PebIntfCreatePurchaseOrderHeader)header.get(0)).getOrgId().toString());
            this.saveLog(saleRspBO.getOrderId(), saleRspBO.getSaleVoucherId(), JSON.toJSONString((Object)reqBO), JSON.toJSONString((Object)pebIntfCreatePurchaseOrderRspBO), "\u4e0b\u5355\u540c\u6b65erp\u7cfb\u7edf", pebIntfCreatePurchaseOrderRspBO.getRespCode());
            if (!"0000".equals(pebIntfCreatePurchaseOrderRspBO.getRespCode())) {
                this.cancel(saleRspBO, "\u540c\u6b65erp\u7cfb\u7edf\u5931\u8d25" + pebIntfCreatePurchaseOrderRspBO.getRespDesc());
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error("erp\u4e0b\u5355\u5931\u8d25" + e);
            this.cancel(saleRspBO, "\u540c\u6b65erp\u7cfb\u7edf\u5931\u8d25,\u80fd\u529b\u5e73\u53f0\u62a5\u9519" + e.getMessage());
            return false;
        }
        return true;
    }

    private void checkPlan(Long orderId) {
        try {
            OrdPlanItemPO planItemPO = new OrdPlanItemPO();
            planItemPO.setBuyOrderId(orderId);
            List list = this.ordPlanItemDao.getList(planItemPO);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            for (OrdPlanItemPO itemPO : list) {
                if (PebExtConstant.PlanStatus.PASS.toString().equals(itemPO.getStatus())) continue;
                OrdPlanItemPO ordPlanItemBO = new OrdPlanItemPO();
                ordPlanItemBO.setStatus(PebExtConstant.PlanStatus.PASS.toString());
                ordPlanItemBO.setUsedCount(BigDecimal.ZERO);
                ordPlanItemBO.setDeleteOrder(Integer.valueOf(1));
                ordPlanItemBO.setOrderId(itemPO.getOrderId());
                ordPlanItemBO.setPlanItemId(itemPO.getPlanItemId());
                this.ordPlanItemDao.updateById(ordPlanItemBO);
                PebPlanIdxSyncAbilityReqBO idxSyncCombReqBO = new PebPlanIdxSyncAbilityReqBO();
                idxSyncCombReqBO.setIsUpdateGoods(Boolean.valueOf(true));
                idxSyncCombReqBO.setObjType(PebExtConstant.OBJ_TYPE.PLAN);
                idxSyncCombReqBO.setObjId(itemPO.getPlanId());
                idxSyncCombReqBO.setOrderId(itemPO.getOrderId());
                idxSyncCombReqBO.setIsAll(Boolean.valueOf(false));
                this.pebExtPlanIdxSyncAbilityService.dealOrdIdxSync(idxSyncCombReqBO);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String proNo(String supplierId) {
        if (supplierId.equals(OrderPropertiesUtil.getProperty((String)"SUPPLIER_EHSY_ID"))) {
            return OrderPropertiesUtil.getProperty((String)"SUPPLIER_EHSY_ID_ERP");
        }
        if (supplierId.equals(OrderPropertiesUtil.getProperty((String)"SUPPLIER_SUNING_ID"))) {
            return OrderPropertiesUtil.getProperty((String)"SUPPLIER_SUNING_ID_ERP");
        }
        if (supplierId.equals(OrderPropertiesUtil.getProperty((String)"SUPPLIER_JD_ID"))) {
            return OrderPropertiesUtil.getProperty((String)"UPPLIER_JD_ID_ERP");
        }
        if (supplierId.equals(OrderPropertiesUtil.getProperty((String)"SUPPLIER_DELI_ID"))) {
            return OrderPropertiesUtil.getProperty((String)"SUPPLIER_DELI_ID_ERP");
        }
        if (supplierId.equals(OrderPropertiesUtil.getProperty((String)"SUPPLIER_GRAINER_ID"))) {
            return OrderPropertiesUtil.getProperty((String)"SUPPLIER_GRAINER_ID_ERP");
        }
        if (supplierId.equals(OrderPropertiesUtil.getProperty((String)"SUPPLIER_ZKH_ID"))) {
            return OrderPropertiesUtil.getProperty((String)"SUPPLIER_ZKH_ID_ERP");
        }
        return supplierId;
    }

    private boolean wallet(PebExtAgreementSubmitOrderSaleItemRspBO reqBO, OrdSaleRspBO saleRspBO) {
        if (reqBO.getFl() != null && !reqBO.getFl().booleanValue()) {
            return true;
        }
        WalletConsumeReqBO walletConsumeReqBO = new WalletConsumeReqBO();
        walletConsumeReqBO.setConsumeAmount(reqBO.getFee());
        walletConsumeReqBO.setCheckFlag(Integer.valueOf(0));
        walletConsumeReqBO.setOrderId(reqBO.getOrderId().toString());
        walletConsumeReqBO.setMemId(reqBO.getMemId());
        walletConsumeReqBO.setWalletType(Integer.valueOf(5));
        walletConsumeReqBO.setActivityCode(reqBO.getActiveId());
        WalletConsumeRspBO rspBO = this.pebIntfWalletConsumeAbilityService.walletConsume(walletConsumeReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            this.cancel(saleRspBO, "\u6263\u51cf\u79ef\u5206\u5931\u8d25" + rspBO.getRespCode());
            return false;
        }
        return true;
    }

    private boolean getBusiMode(PebExtAgreementSubmitOrderSaleItemRspBO rspBO, OrdSaleRspBO saleRspBO, Map<String, String> map) {
        String busiMode = this.initBusiMode;
        SettlementModeExceptFscQryListReqBO listReqBO = new SettlementModeExceptFscQryListReqBO();
        ArrayList<SettlementModeExceptFscBO> fscBoS = new ArrayList<SettlementModeExceptFscBO>();
        SettlementModeExceptFscBO fscBO = new SettlementModeExceptFscBO();
        fscBO.setExceptOrgId(rspBO.getOrgId());
        fscBO.setSubType("1");
        fscBO.setContractId(rspBO.getAgrId());
        fscBO.setSupplierNo(rspBO.getGoodsSupplierId());
        fscBoS.add(fscBO);
        listReqBO.setSettlementModeExceptFscQryListBoList(fscBoS);
        PebExtFieldInReqBO pebExtFieldInReqBO = new PebExtFieldInReqBO();
        pebExtFieldInReqBO.setObjType(UocCoreConstant.OBJ_TYPE.ORDER);
        pebExtFieldInReqBO.setObjId(rspBO.getOrderId());
        pebExtFieldInReqBO.setOrderId(rspBO.getOrderId());
        ArrayList<FieldValueBO> fieldValueBoS = new ArrayList<FieldValueBO>();
        FieldValueBO valueBO = new FieldValueBO();
        valueBO.setFieldValue(busiMode);
        valueBO.setFieldCode("busiMode");
        valueBO.setFieldName("\u4ea4\u6613\u6a21\u5f0f");
        fieldValueBoS.add(valueBO);
        pebExtFieldInReqBO.setExtFieldList(fieldValueBoS);
        this.pebExtFieldInBusiService.dealCoreExtFieldIn(pebExtFieldInReqBO);
        map.put("busiMode", busiMode);
        return true;
    }

    private void cancel(OrdSaleRspBO saleRspBO, String desc) {
        UocPebOrderCancellationReqBO cancelReqBO = new UocPebOrderCancellationReqBO();
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("auditFlag", "1");
        cancelReqBO.setSaleVoucherId(saleRspBO.getSaleVoucherId());
        cancelReqBO.setFailCode("8888");
        cancelReqBO.setOrderId(saleRspBO.getOrderId());
        cancelReqBO.setIsRefund(Boolean.valueOf(false));
        cancelReqBO.setProcParam(map);
        cancelReqBO.setIsVal(Boolean.valueOf(false));
        cancelReqBO.setMemId(Long.valueOf(0L));
        cancelReqBO.setUsername("\u7cfb\u7edf");
        cancelReqBO.setUserId(Long.valueOf(0L));
        cancelReqBO.setCancelDesc(desc);
        cancelReqBO.setCancelReson(desc);
        cancelReqBO.setDealCode("ACTPEB014");
        cancelReqBO.setIsRefund(Boolean.valueOf(false));
        this.updateOrder(saleRspBO.getOrderId());
        this.uocPebOrderCancellationBusiService.dealPebOrderCancellation(cancelReqBO);
        this.checkPlan(saleRspBO.getOrderId());
    }

    private void updateOrder(Long orderId) {
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(orderId);
        orderPO.setProcState("8888");
        this.orderMapper.updateById(orderPO);
    }

    private void addCart(Long orderId, Long saleId, Long userId) {
        UocPebAgainAddShippingCartReqBO reqBO = new UocPebAgainAddShippingCartReqBO();
        reqBO.setOrderId(orderId);
        reqBO.setSaleVoucherId(saleId);
        reqBO.setUserId(userId);
        try {
            this.uocPebAgainAddShippingCartCombService.againAddShippingCart(reqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveExt(Long orderId, String erpOrderId, String erpOrgId) {
        PebExtFieldInReqBO pebExtFieldInReqBO = new PebExtFieldInReqBO();
        pebExtFieldInReqBO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        pebExtFieldInReqBO.setObjId(orderId);
        pebExtFieldInReqBO.setOrderId(orderId);
        ArrayList<FieldValueBO> list = new ArrayList<FieldValueBO>();
        FieldValueBO fieldValueBO = new FieldValueBO();
        fieldValueBO.setFieldCode("erpOrgId");
        fieldValueBO.setFieldValue(erpOrgId);
        fieldValueBO.setFieldName("erp\u7ec4\u7ec7\u673a\u6784");
        list.add(fieldValueBO);
        FieldValueBO erpPurNoBO = new FieldValueBO();
        erpPurNoBO.setFieldCode("erpOrderNo");
        erpPurNoBO.setFieldValue(erpOrderId);
        erpPurNoBO.setFieldName("erp\u8ba2\u5355\u7f16\u53f7");
        list.add(erpPurNoBO);
        pebExtFieldInReqBO.setExtFieldList(list);
        FieldValueBO rePur = new FieldValueBO();
        rePur.setFieldCode("isRepurchase");
        rePur.setFieldValue("0");
        rePur.setFieldName("\u662f\u5426\u5df2\u7ecf\u91cd\u65b0\u91c7\u8d2d");
        list.add(rePur);
        pebExtFieldInReqBO.setExtFieldList(list);
        PebExtFieldInRspBO rspBO = this.pebExtFieldInBusiService.dealCoreExtFieldIn(pebExtFieldInReqBO);
    }

    private void saveExt(Long orderId, String val) {
        PebExtFieldInReqBO pebExtFieldInReqBO = new PebExtFieldInReqBO();
        pebExtFieldInReqBO.setObjId(orderId);
        pebExtFieldInReqBO.setObjType(UocCoreConstant.OBJ_TYPE.ORDER);
        pebExtFieldInReqBO.setOrderId(orderId);
        ArrayList<FieldValueBO> fieldValueBOS = new ArrayList<FieldValueBO>();
        FieldValueBO valueBO = new FieldValueBO();
        valueBO.setFieldValue(val);
        valueBO.setFieldCode("isSuccess");
        valueBO.setFieldName("\u662f\u5426\u63a8\u9001\u5916\u90e8\u63a5\u53e3\u6210\u529f");
        fieldValueBOS.add(valueBO);
        pebExtFieldInReqBO.setExtFieldList(fieldValueBOS);
        this.pebExtFieldInBusiService.dealCoreExtFieldIn(pebExtFieldInReqBO);
    }

    private void run(OrdSaleRspBO saleRspBO) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(saleRspBO.getSaleVoucherId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOrderId(saleRspBO.getOrderId());
        processRunReqBO.setOperId("1");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("checkFlag", "2");
        processRunReqBO.setVariables(map);
        UocProcessRunRspBO rspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (rspBO.getAuto() != null && rspBO.getAuto().booleanValue()) {
            UocGeneralCirculationReqBO circulationReqBO = new UocGeneralCirculationReqBO();
            circulationReqBO.setActionCode("ACTPEB019");
            circulationReqBO.setObjId(saleRspBO.getSaleVoucherId());
            circulationReqBO.setOrderId(saleRspBO.getOrderId());
            circulationReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            this.dealZoneDealAutomaticTaskMsgProvider.send(new ProxyMessage(this.taskTopic, this.taskTag, JSONObject.toJSONString((Object)circulationReqBO)));
        }
    }

    private void uocPebOrdIdxSync(PebExtAgreementSubmitOrderSaleItemRspBO rspBO) {
        PebExtOrdIdxSyncReqBO reqBO = new PebExtOrdIdxSyncReqBO();
        reqBO.setObjId(Long.valueOf(rspBO.getSaleOrderId()));
        reqBO.setOrderId(rspBO.getOrderId());
        reqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        reqBO.setIsStatistics(Boolean.valueOf(false));
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)reqBO)));
        UocSyncStatisticsInfoCombReqBO syncStatisticsInfoCombReqBO = new UocSyncStatisticsInfoCombReqBO();
        syncStatisticsInfoCombReqBO.setOrderId(rspBO.getOrderId());
        syncStatisticsInfoCombReqBO.setSaleVoucherId(Long.valueOf(rspBO.getSaleOrderId()));
        syncStatisticsInfoCombReqBO.setIsLess(Boolean.valueOf(false));
        this.uocSyncStatisticsInfoCombService.syncStatisticsInfo(syncStatisticsInfoCombReqBO);
    }
}

