/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.agreement.ability.api.AgrQryAgreementSkuByPageAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSkuByPageAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSkuByPageAbilityRspBO;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.enums.PpcPlanStatus;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.busi.api.PebIntfEnterpriseOrgDetailAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfMemDetailQueryAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQryAgreementDetailsAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQueryActivityDetailAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfSgOrgAmountDeductAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfWalletConsumeAbilityService;
import com.tydic.uoc.busibase.busi.bo.EnterpriseOrgDetailReqBO;
import com.tydic.uoc.busibase.busi.bo.EnterpriseOrgDetailRspBO;
import com.tydic.uoc.busibase.busi.bo.MemDetailQueryReqBO;
import com.tydic.uoc.busibase.busi.bo.MemDetailQueryRspBO;
import com.tydic.uoc.busibase.busi.bo.QryAgreementDetailsReqBO;
import com.tydic.uoc.busibase.busi.bo.QryAgreementDetailsRspBO;
import com.tydic.uoc.busibase.busi.bo.QueryActivityDetailReqBO;
import com.tydic.uoc.busibase.busi.bo.QueryActivityDetailRspBO;
import com.tydic.uoc.busibase.busi.bo.WalletConsumeReqBO;
import com.tydic.uoc.busibase.busi.bo.WalletConsumeRspBO;
import com.tydic.uoc.common.ability.bo.AgreementSettlementBO;
import com.tydic.uoc.common.ability.bo.PebExtAgreementSkuInfo;
import com.tydic.uoc.common.ability.bo.SkuInfoRspBO;
import com.tydic.uoc.common.ability.bo.UocCoreActiveReqBO;
import com.tydic.uoc.common.ability.bo.UocOrdAgreementBO;
import com.tydic.uoc.common.atom.api.PebExtQrySkuInfoAndPriceAtomService;
import com.tydic.uoc.common.atom.api.UocCheckSupplierBreakContractAtomService;
import com.tydic.uoc.common.atom.api.UocProInspectionConfigAtomService;
import com.tydic.uoc.common.atom.bo.PebExtQrySkuInfoAndPriceReqBO;
import com.tydic.uoc.common.atom.bo.PebExtQrySkuInfoAndPriceRspBO;
import com.tydic.uoc.common.atom.bo.PebExtSaleOrderInfoIntfceReqBO;
import com.tydic.uoc.common.atom.bo.SaleOrderItemIntfceBO;
import com.tydic.uoc.common.atom.bo.UocCheckSupplierBreakContractAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCheckSupplierBreakContractAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocProQryInspectionConfigReqBo;
import com.tydic.uoc.common.atom.bo.UocProQryInspectionConfigRspBo;
import com.tydic.uoc.dao.OrdEcpPlanMapper;
import com.tydic.uoc.dao.PlanDiversionMapper;
import com.tydic.uoc.zone.ability.bo.PebExtAgreementCreateOrderReqBO;
import com.tydic.uoc.zone.ability.bo.PebExtAgreementCreateOrderRspBO;
import com.tydic.uoc.zone.busi.api.PebZoneCreateOrderCheckBusiService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebZoneCreateOrderCheckBusiServiceImpl
implements PebZoneCreateOrderCheckBusiService {
    private Logger logger = LoggerFactory.getLogger(PebZoneCreateOrderCheckBusiServiceImpl.class);
    @Autowired
    private PebExtQrySkuInfoAndPriceAtomService uocPebQrySkuInfoAndPriceAtomService;
    @Autowired
    private PebIntfQryAgreementDetailsAbilityService pebIntfQryAgreementDetailsAbilityService;
    private static final Byte AGR_YES = 4;
    @Value(value="${zone.ship.maxTime:15}")
    private String maxShipTime;
    @Autowired
    private PebIntfEnterpriseOrgDetailAbilityService pebIntfEnterpriseOrgDetailAbilityService;
    @Autowired
    private PebIntfMemDetailQueryAbilityService pebIntfMemDetailQueryAbilityService;
    @Autowired
    private OrdEcpPlanMapper ordEcpPlanMapper;
    @Autowired
    private PebIntfSgOrgAmountDeductAbilityService pebIntfSgOrgAmountDeductAbilityService;
    @Value(value="${busiMode:0}")
    private String busiMode;
    @Autowired
    private PebIntfWalletConsumeAbilityService pebIntfWalletConsumeAbilityService;
    @Autowired
    private PebIntfQueryActivityDetailAbilityService pebIntfQueryActivityDetailAbilityService;
    @Value(value="${staff.welfare.pay.config.enable:false}")
    private boolean payConfig;
    @Autowired
    private UocProInspectionConfigAtomService uocProInspectionConfigAtomService;
    @Autowired
    UocCheckSupplierBreakContractAtomService uocCheckSupplierBreakContractAtomService;
    @Autowired
    private PlanDiversionMapper planDiversionMapper;
    @Autowired
    private AgrQryAgreementSkuByPageAbilityService agrQryAgreementSkuByPageAbilityService;

    @Override
    public PebExtAgreementCreateOrderRspBO dealPebZoneCreateOrder(PebExtAgreementCreateOrderReqBO reqBO) {
        PebExtAgreementCreateOrderRspBO rspBO = new PebExtAgreementCreateOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        HashSet<Long> supIds = new HashSet<Long>();
        this.act(reqBO);
        this.qryAgr(reqBO);
        Integer isGoods = 1;
        if (isGoods.equals(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getItemType())) {
            PebExtQrySkuInfoAndPriceReqBO pebExtQrySkuInfoAndPriceReqBO = this.buildQrySkuInfoAndPriceParam(reqBO, supIds);
            PebExtQrySkuInfoAndPriceRspBO pebExtQrySkuInfoAndPriceRspBO = this.uocPebQrySkuInfoAndPriceAtomService.qrySkuInfoAndPrice(pebExtQrySkuInfoAndPriceReqBO);
            if (!"0000".equals(pebExtQrySkuInfoAndPriceRspBO.getRespCode())) {
                throw new UocProBusinessException("100001", "\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u548c\u4ef7\u683c\u6821\u9a8c\u5931\u8d25" + pebExtQrySkuInfoAndPriceRspBO.getRespDesc());
            }
            HashMap<Long, BigDecimal> plan = new HashMap<Long, BigDecimal>();
            this.dealSkuInfo(pebExtQrySkuInfoAndPriceRspBO.getSkuInfoMapList(), reqBO, plan);
        } else {
            ArrayList<Long> agrItemIds = new ArrayList<Long>();
            for (PebExtAgreementSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
                agrItemIds.add(skuInfo.getAgrItemId());
            }
            AgrQryAgreementSkuByPageAbilityReqBO abilityReqBO = new AgrQryAgreementSkuByPageAbilityReqBO();
            abilityReqBO.setPageNo(Integer.valueOf(1));
            abilityReqBO.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
            abilityReqBO.setAgreementSkuIds(agrItemIds);
            AgrQryAgreementSkuByPageAbilityRspBO abilityRspBO = this.agrQryAgreementSkuByPageAbilityService.qryAgreementSkuByPage(abilityReqBO);
            if (!"0000".equals(abilityRspBO.getRespCode())) {
                throw new UocProBusinessException("100001", "\u534f\u8bae\u4fe1\u606f\u67e5\u8be2\u5931\u8d25" + abilityRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
                throw new UocProBusinessException("100001", "\u534f\u8bae\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            }
            this.dealAgrItem(abilityRspBO.getRows(), reqBO, supIds);
        }
        rspBO.setSup(supIds);
        this.valStatus(reqBO);
        return rspBO;
    }

    private void dealAgrItem(List<AgrAgreementSkuBO> agreementSkuBOS, PebExtAgreementCreateOrderReqBO reqBO, Set<Long> supIds) {
        Map<Long, AgrAgreementSkuBO> map = agreementSkuBOS.stream().collect(Collectors.toMap(AgrAgreementSkuBO::getAgreementSkuId, i -> i));
        for (PebExtAgreementSkuInfo item : reqBO.getSaleOrderItemList()) {
            AgrAgreementSkuBO skuBO = map.get(item.getAgrItemId());
            if (skuBO == null) {
                throw new UocProBusinessException("100001", "\u7269\u6599\uff1a" + item.getSkuMaterialId() + "\u672a\u67e5\u8be2\u5230\u534f\u8bae\u660e\u7ec6");
            }
            supIds.add(Long.valueOf(item.getGoodsSupplierId()));
            supIds.add(Long.valueOf(item.getSupplier()));
            item.setSkuSalePrice(new BigDecimal(skuBO.getSalePrice() / 100L * 100L));
            item.setSkuAgreementPrice(new BigDecimal(skuBO.getBuyPrice() / 100L * 100L));
            item.setTaxCode(skuBO.getTaxCatalog());
            item.setTax(Long.valueOf(skuBO.getTaxRate().longValue()));
            item.setMeasureName(skuBO.getMeasureName());
            item.setTexture(skuBO.getTexture());
            item.setModel(skuBO.getModel());
            item.setFigure(skuBO.getFigure());
            item.setSpec(skuBO.getSpec());
            if (skuBO.getSupplyCycle() != null) {
                item.setArrivalTime(String.valueOf(skuBO.getSupplyCycle()));
            } else {
                item.setArrivalTime(this.maxShipTime);
            }
            item.setBrandId(skuBO.getCatalogId());
            item.setAddCoefficient(new BigDecimal(skuBO.getMarkupRate()));
            item.setSkuSupplierId(skuBO.getVendorId());
            item.setSkuSupplierName(skuBO.getVendorName());
            item.setSkuCurrencyType("CNY");
            item.setSkuBrandName(skuBO.getBrandName());
            item.setSkuCommodityTypeId(skuBO.getCommodityTypeId());
            item.setSkuCommodityTypeName(skuBO.getCommodityTypeName());
            item.setInspectionExcessPercent(Integer.valueOf(0));
            BigDecimal itemFee = item.getPurchaseCount().multiply(item.getSkuSalePrice());
            item.setTotalPrice(itemFee);
        }
    }

    private void act(PebExtAgreementCreateOrderReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getActiveBOList())) {
            return;
        }
        QueryActivityDetailReqBO detailReqBO = new QueryActivityDetailReqBO();
        detailReqBO.setActiveId(Long.valueOf(((UocCoreActiveReqBO)reqBO.getActiveBOList().get(0)).getActiveId()));
        QueryActivityDetailRspBO detailRspBO = this.pebIntfQueryActivityDetailAbilityService.queryActiveDetailNew(detailReqBO);
        if (!"0000".equals(detailRspBO.getRespCode())) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u6d3b\u52a8\u5931\u8d25" + detailRspBO.getRespDesc());
        }
        if (detailRspBO.getActivityDetailInfoBO() == null) {
            throw new UocProBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u6d3b\u52a8");
        }
        if (detailRspBO.getActivityDetailInfoBO().getActivityBo() == null) {
            throw new UocProBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u6d3b\u52a8");
        }
        Integer status = 4;
        if (!status.equals(detailRspBO.getActivityDetailInfoBO().getActivityBo().getActiveStatus())) {
            throw new UocProBusinessException("100001", "\u60a8\u6240\u53c2\u4e0e\u7684\u6d3b\u52a8\u5df2\u5931\u6548\uff0c\u8bf7\u77e5\u6653");
        }
        if (StringUtils.isBlank((CharSequence)((UocCoreActiveReqBO)reqBO.getActiveBOList().get(0)).getTypeName())) {
            ((UocCoreActiveReqBO)reqBO.getActiveBOList().get(0)).setTypeName(detailRspBO.getActivityDetailInfoBO().getActivityBo().getActiveField2Str());
        }
        reqBO.setActiveNo(detailRspBO.getActivityDetailInfoBO().getActivityBo().getActiveCode());
        reqBO.setActiveStartTime(detailRspBO.getActivityDetailInfoBO().getActivityBo().getStartTime());
        reqBO.setActiveEndTime(detailRspBO.getActivityDetailInfoBO().getActivityBo().getEndTime());
    }

    private void check(PebExtAgreementCreateOrderReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getActiveBOList())) {
            return;
        }
        WalletConsumeReqBO walletConsumeReqBO = new WalletConsumeReqBO();
        walletConsumeReqBO.setMemId(reqBO.getMemId());
        walletConsumeReqBO.setWalletType(Integer.valueOf(5));
        walletConsumeReqBO.setConsumeAmount(reqBO.getTotalAmount());
        walletConsumeReqBO.setCheckFlag(Integer.valueOf(1));
        walletConsumeReqBO.setActivityCode(((UocCoreActiveReqBO)reqBO.getActiveBOList().get(0)).getActiveId());
        WalletConsumeRspBO rspBO = this.pebIntfWalletConsumeAbilityService.walletConsume(walletConsumeReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException(rspBO.getRespCode(), rspBO.getRespDesc());
        }
    }

    private void checkSupplierBreakContract(Set<String> supIds) {
        UocCheckSupplierBreakContractAtomReqBO supplierBreakContractAtomReqBO = new UocCheckSupplierBreakContractAtomReqBO();
        supplierBreakContractAtomReqBO.setSupplierIds(supIds);
        UocCheckSupplierBreakContractAtomRspBO atomRspBO = this.uocCheckSupplierBreakContractAtomService.checkSupplierBreakContract(supplierBreakContractAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new UocProBusinessException("102105", atomRspBO.getRespDesc());
        }
    }

    private void qryAgr(PebExtAgreementCreateOrderReqBO reqBO) {
        for (PebExtAgreementSkuInfo agreementSkuInfo : reqBO.getSaleOrderItemList()) {
            QryAgreementDetailsReqBO agreementDetailsReqBO = new QryAgreementDetailsReqBO();
            agreementDetailsReqBO.setAgreementId(agreementSkuInfo.getAgrId());
            QryAgreementDetailsRspBO qryAgreementDetailsRspBO = this.pebIntfQryAgreementDetailsAbilityService.qryAgreementDetails(agreementDetailsReqBO);
            this.logger.debug("\u534f\u8bae\u67e5\u8be2\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)qryAgreementDetailsRspBO));
            if (!"0000".equals(qryAgreementDetailsRspBO.getRespCode())) {
                throw new UocProBusinessException("100001", "\u534f\u8bae\u67e5\u8be2\u51fa\u9519" + qryAgreementDetailsRspBO.getRespDesc());
            }
            if (qryAgreementDetailsRspBO.getAgrAgreementBO() == null) {
                throw new UocProBusinessException("100001", "\u534f\u8bae\uff1a" + agreementSkuInfo.getPlaAgreeMentCode() + "\u4e0d\u5b58\u5728");
            }
            UocOrdAgreementBO agreementBO = (UocOrdAgreementBO)JSON.parseObject((String)JSON.toJSONString((Object)qryAgreementDetailsRspBO.getAgrAgreementBO()), UocOrdAgreementBO.class);
            if (!AGR_YES.equals(agreementBO.getAgreementStatus())) {
                throw new UocProBusinessException("100001", "\u534f\u8bae\uff1a" + agreementSkuInfo.getPlaAgreeMentCode() + "\u672a\u542f\u7528");
            }
            if (agreementBO.getSupplierId() != null) {
                EnterpriseOrgDetailReqBO queryReqBO = new EnterpriseOrgDetailReqBO();
                queryReqBO.setOrgIdWeb(agreementBO.getVendorDepartmentId());
                EnterpriseOrgDetailRspBO detailRspBO = this.pebIntfEnterpriseOrgDetailAbilityService.queryEnterpriseOrgByDetail(queryReqBO);
                if (!detailRspBO.getRespCode().equals("0000")) {
                    throw new UocProBusinessException("102105", "\u67e5\u8be2\u4f9b\u5e94\u5546\u673a\u6784\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + detailRspBO.getRespDesc());
                }
                if (detailRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
                    agreementBO.setVendorContactWay(detailRspBO.getUmcEnterpriseOrgAbilityBO().getPhone());
                    agreementBO.setVendorContactPerson(detailRspBO.getUmcEnterpriseOrgAbilityBO().getLinkMan());
                    agreementBO.setVendorContactAddress(detailRspBO.getUmcEnterpriseOrgAbilityBO().getAddress());
                }
            }
            if (agreementBO.getProducerId() != null) {
                MemDetailQueryReqBO detailQueryReqBO = new MemDetailQueryReqBO();
                detailQueryReqBO.setMemId(agreementBO.getProducerId());
                MemDetailQueryRspBO detailQueryRspBO = this.pebIntfMemDetailQueryAbilityService.memDetailQuery(detailQueryReqBO);
                if ("0000".equals(detailQueryRspBO.getRespCode()) && detailQueryRspBO.getUmcMemDetailInfoAbilityRspBO() != null) {
                    agreementBO.setProducerPhone(detailQueryRspBO.getUmcMemDetailInfoAbilityRspBO().getRegMobile());
                }
            }
            agreementSkuInfo.setExtField2(qryAgreementDetailsRspBO.getAgrAgreementBO().getExtField2());
            agreementSkuInfo.setExtField3(qryAgreementDetailsRspBO.getAgrAgreementBO().getExtField3());
            agreementSkuInfo.setExtField1(qryAgreementDetailsRspBO.getAgrAgreementBO().getExtField1());
            agreementSkuInfo.setExtField1Str(qryAgreementDetailsRspBO.getAgrAgreementBO().getExtField1Str());
            if (agreementBO.getPrePaySup() == null) {
                agreementBO.setPrePaySup(BigDecimal.ZERO);
            }
            if (agreementBO.getVerPaySup() == null) {
                agreementBO.setVerPaySup(BigDecimal.ZERO);
            }
            if (agreementBO.getPilPaySup() == null) {
                agreementBO.setPilPaySup(BigDecimal.ZERO);
            }
            if (agreementBO.getQuaPaySup() == null) {
                agreementBO.setQuaPaySup(BigDecimal.ZERO);
            }
            if (qryAgreementDetailsRspBO.getAgrAgreementBO().getAgreementMode() != null) {
                agreementSkuInfo.setAgreementMode(String.valueOf(qryAgreementDetailsRspBO.getAgrAgreementBO().getAgreementMode()));
            }
            agreementSkuInfo.setAgreementBO(agreementBO);
            if (!ObjectUtil.isEmpty((Object)qryAgreementDetailsRspBO.getAgrAgreementBO().getContractId())) {
                reqBO.setContractId(qryAgreementDetailsRspBO.getAgrAgreementBO().getContractId());
            }
            if (CollectionUtils.isNotEmpty((Collection)agreementBO.getPaymentMethod())) {
                reqBO.setPayType(null);
                if (UocCoreConstant.TradeMode.TRADE_MODEL.equals(agreementBO.getTradeMode())) {
                    for (AgreementSettlementBO agreementSettlementBO : agreementBO.getPaymentMethod()) {
                        if (!"2".equals(agreementSettlementBO.getSettlementObject())) continue;
                        reqBO.setPayType(Integer.valueOf(agreementSettlementBO.getSettlementType()));
                    }
                } else if (UocCoreConstant.TradeMode.MATCHMAKING_MODE.equals(agreementBO.getTradeMode())) {
                    for (AgreementSettlementBO agreementSettlementBO : agreementBO.getPaymentMethod()) {
                        if (!"1".equals(agreementSettlementBO.getSettlementObject())) continue;
                        reqBO.setPayType(Integer.valueOf(agreementSettlementBO.getSettlementType()));
                    }
                }
                if (null != reqBO.getPayType()) continue;
                throw new UocProBusinessException("100001", "\u672a\u5339\u914d\u7b26\u5408\u7684\u534f\u8bae\u4ed8\u6b3e\u65b9\u5f0f\u4fe1\u606f");
            }
            throw new UocProBusinessException("100001", "\u534f\u8bae\u4ed8\u6b3e\u65b9\u5f0f\u4fe1\u606f\u4e3a\u7a7a");
        }
    }

    private void dealSkuInfo(List<Map<Long, Object>> skuInfoMapList, PebExtAgreementCreateOrderReqBO reqBO, Map<Long, BigDecimal> plan) {
        ArrayList<PebExtAgreementSkuInfo> saleOrderItemList = new ArrayList<PebExtAgreementSkuInfo>(reqBO.getSaleOrderItemList().size());
        long total = 0L;
        ArrayList<String> soldOut = new ArrayList<String>();
        ArrayList<String> inventoryShortage = new ArrayList<String>();
        HashSet<String> comTypeSet = new HashSet<String>();
        for (Map<Long, Object> map : skuInfoMapList) {
            Collection<Object> values = map.values();
            for (Object value : values) {
                SkuInfoRspBO skuInfoRspBO = (SkuInfoRspBO)value;
                if (skuInfoRspBO == null || ObjectUtil.isEmpty((Object)skuInfoRspBO.getSkuCommodityTypeId())) continue;
                comTypeSet.add(skuInfoRspBO.getSkuCommodityTypeId().toString());
            }
        }
        ArrayList commodityTypeList = new ArrayList(comTypeSet);
        UocProQryInspectionConfigReqBo qryInspectionBo = new UocProQryInspectionConfigReqBo();
        qryInspectionBo.setBusiType(Integer.valueOf(Integer.parseInt("1")));
        qryInspectionBo.setCommodityTypes(commodityTypeList);
        UocProQryInspectionConfigRspBo uocProQryInspectionConfigRspBo = this.uocProInspectionConfigAtomService.qryInspection(qryInspectionBo);
        Map commodityTypes = uocProQryInspectionConfigRspBo.getCommodityTypes();
        for (PebExtAgreementSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
            for (Map<Long, Object> map : skuInfoMapList) {
                SkuInfoRspBO rspBO = (SkuInfoRspBO)map.get(Long.valueOf(skuInfo.getSkuId()));
                if (rspBO == null || !skuInfo.getSkuId().equals(rspBO.getSkuId())) continue;
                BigDecimal itemFee = skuInfo.getPurchaseCount().multiply(rspBO.getSkuSalePrice());
                skuInfo.setTotalPrice(itemFee);
                PebExtAgreementSkuInfo pebExtThirdSupplierSkuInfo = this.copy(rspBO, skuInfo, reqBO);
                saleOrderItemList.add(pebExtThirdSupplierSkuInfo);
                Integer inspectionPercent = (Integer)commodityTypes.get(rspBO.getSkuCommodityTypeId().toString());
                if (inspectionPercent != null && inspectionPercent > 0) {
                    pebExtThirdSupplierSkuInfo.setInspectionExcessPercent(inspectionPercent);
                } else {
                    pebExtThirdSupplierSkuInfo.setInspectionExcessPercent(Integer.valueOf(0));
                }
                if (rspBO.getSoldNumber() == null || rspBO.getSoldNumber().compareTo(new BigDecimal(-1)) == 0) continue;
                if (rspBO.getSoldNumber().compareTo(BigDecimal.ZERO) == 0) {
                    soldOut.add(rspBO.getSkuId());
                    continue;
                }
                if (rspBO.getSoldNumber().compareTo(skuInfo.getPurchaseCount()) >= 0) continue;
                inventoryShortage.add(rspBO.getSkuId());
            }
        }
        reqBO.setSaleOrderItemList(saleOrderItemList);
    }

    private PebExtAgreementSkuInfo copy(SkuInfoRspBO source, PebExtAgreementSkuInfo skuInfo, PebExtAgreementCreateOrderReqBO reqBO) {
        PebExtAgreementSkuInfo agreementSkuInfo = new PebExtAgreementSkuInfo();
        BeanUtils.copyProperties((Object)source, (Object)agreementSkuInfo);
        agreementSkuInfo.setSkuMaterialId(skuInfo.getSkuMaterialId());
        agreementSkuInfo.setSkuMaterialName(skuInfo.getSkuMaterialName());
        agreementSkuInfo.setSkuMaterialTypeId(skuInfo.getSkuMaterialTypeId());
        agreementSkuInfo.setSkuMaterialTypeName(skuInfo.getSkuMaterialTypeName());
        agreementSkuInfo.setPurchaseCount(skuInfo.getPurchaseCount());
        agreementSkuInfo.setPurchType(skuInfo.getPurchType());
        agreementSkuInfo.setAgreementBO(skuInfo.getAgreementBO());
        agreementSkuInfo.setAgrId(skuInfo.getAgrId());
        agreementSkuInfo.setTotalPrice(skuInfo.getTotalPrice());
        agreementSkuInfo.setComparisonGoodsNo(skuInfo.getComparisonGoodsNo());
        agreementSkuInfo.setGoodsSupplierId(skuInfo.getGoodsSupplierId());
        agreementSkuInfo.setPlanItemId(skuInfo.getPlanItemId());
        agreementSkuInfo.setChannel(skuInfo.getChannel());
        agreementSkuInfo.setPlanId(skuInfo.getPlanId());
        agreementSkuInfo.setExtField1(skuInfo.getExtField1());
        agreementSkuInfo.setExtField1Str(skuInfo.getExtField1Str());
        agreementSkuInfo.setExtField2(skuInfo.getExtField2());
        agreementSkuInfo.setExtField3(skuInfo.getExtField3());
        agreementSkuInfo.setAgreementMode(skuInfo.getAgreementMode());
        agreementSkuInfo.setSkuMaterialFee(skuInfo.getSkuMaterialFee());
        agreementSkuInfo.setSkuMaterialTotalFee(skuInfo.getSkuMaterialTotalFee());
        agreementSkuInfo.setSkuMaterialCount(skuInfo.getSkuMaterialCount());
        agreementSkuInfo.setSkuMaterialBrand(skuInfo.getSkuMaterialBrand());
        agreementSkuInfo.setSkuMaterialRemark(skuInfo.getSkuMaterialRemark());
        agreementSkuInfo.setPlanId(skuInfo.getPlanId());
        agreementSkuInfo.setPlanItemId(skuInfo.getPlanItemId());
        agreementSkuInfo.setPlanItemNo(skuInfo.getPlanItemNo());
        agreementSkuInfo.setSupplier(skuInfo.getSupplier());
        agreementSkuInfo.setSupplierName(skuInfo.getSupplierName());
        agreementSkuInfo.setSupplierNo(skuInfo.getSupplierNo());
        agreementSkuInfo.setAddrJc(skuInfo.getAddrJc());
        agreementSkuInfo.setItemType(skuInfo.getItemType());
        agreementSkuInfo.setOrganizationId(skuInfo.getOrganizationId());
        agreementSkuInfo.setOrganizationName(skuInfo.getOrganizationName());
        agreementSkuInfo.setSupplierErpNo(skuInfo.getSupplierErpNo());
        agreementSkuInfo.setSupplier(skuInfo.getSupplier());
        agreementSkuInfo.setSupplierNo(skuInfo.getSupplierNo());
        agreementSkuInfo.setVendorSiteId(skuInfo.getVendorSiteId());
        agreementSkuInfo.setVendorSiteName(skuInfo.getVendorSiteName());
        agreementSkuInfo.setB2bsiteId(skuInfo.getB2bsiteId());
        agreementSkuInfo.setAddrJc(skuInfo.getAddrJc());
        agreementSkuInfo.setSkuMaterialLongDesc(skuInfo.getSkuMaterialLongDesc());
        agreementSkuInfo.setSkuMaterialUnit(skuInfo.getSkuMaterialUnit());
        return agreementSkuInfo;
    }

    private PebExtQrySkuInfoAndPriceReqBO buildQrySkuInfoAndPriceParam(PebExtAgreementCreateOrderReqBO reqBO, Set<Long> supIds) {
        PebExtQrySkuInfoAndPriceReqBO pebExtQrySkuInfoAndPriceReqBO = new PebExtQrySkuInfoAndPriceReqBO();
        pebExtQrySkuInfoAndPriceReqBO.setParentOrgIdIn(reqBO.getParentOrgIdIn());
        pebExtQrySkuInfoAndPriceReqBO.setRootOrgIdIn(reqBO.getRootOrgIdIn());
        pebExtQrySkuInfoAndPriceReqBO.setUserId(reqBO.getUserId());
        pebExtQrySkuInfoAndPriceReqBO.setPurchaseAccountId(reqBO.getUserId());
        pebExtQrySkuInfoAndPriceReqBO.setOrgIdIn(reqBO.getOrgIdIn());
        pebExtQrySkuInfoAndPriceReqBO.setUseCount(Boolean.valueOf(true));
        pebExtQrySkuInfoAndPriceReqBO.setSettlementModeList(reqBO.getSettlementModeList());
        pebExtQrySkuInfoAndPriceReqBO.setCompanyId(reqBO.getCompanyId());
        pebExtQrySkuInfoAndPriceReqBO.setIsprofess(reqBO.getIsprofess());
        pebExtQrySkuInfoAndPriceReqBO.setPsDiscountRate(reqBO.getPsDiscountRate());
        pebExtQrySkuInfoAndPriceReqBO.setOrderType(reqBO.getOrderType());
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList()) && !this.payConfig) {
            pebExtQrySkuInfoAndPriceReqBO.setCompanyId(null);
            pebExtQrySkuInfoAndPriceReqBO.setIsprofess(null);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAddressInfo().getReceiverCountyId())) {
            pebExtQrySkuInfoAndPriceReqBO.setCounty(Long.valueOf(reqBO.getAddressInfo().getReceiverCountyId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAddressInfo().getReceiverProvinceId())) {
            pebExtQrySkuInfoAndPriceReqBO.setProvince(Long.valueOf(reqBO.getAddressInfo().getReceiverProvinceId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAddressInfo().getReceiverCityId())) {
            pebExtQrySkuInfoAndPriceReqBO.setCity(Long.valueOf(reqBO.getAddressInfo().getReceiverCityId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAddressInfo().getReceiverTownId())) {
            pebExtQrySkuInfoAndPriceReqBO.setTown(Long.valueOf(reqBO.getAddressInfo().getReceiverTownId()));
        } else {
            pebExtQrySkuInfoAndPriceReqBO.setTown(Long.valueOf(0L));
        }
        ArrayList<PebExtSaleOrderInfoIntfceReqBO> saleOrderInfoList = new ArrayList<PebExtSaleOrderInfoIntfceReqBO>();
        Map<Long, List<PebExtAgreementSkuInfo>> skuInfo = reqBO.getSaleOrderItemList().stream().collect(Collectors.groupingBy(SkuInfoRspBO::getAgrId));
        for (Long key : skuInfo.keySet()) {
            ArrayList<SaleOrderItemIntfceBO> saleOrderItemList = new ArrayList<SaleOrderItemIntfceBO>();
            for (PebExtAgreementSkuInfo goods : skuInfo.get(key)) {
                supIds.add(Long.valueOf(goods.getGoodsSupplierId()));
                supIds.add(Long.valueOf(goods.getSupplier()));
                SaleOrderItemIntfceBO itemIntfceBO = new SaleOrderItemIntfceBO();
                itemIntfceBO.setSkuId(goods.getSkuId());
                itemIntfceBO.setSkuSalePrice(goods.getSkuSalePrice());
                itemIntfceBO.setSupplierShopId(goods.getSupplierShopId());
                itemIntfceBO.setSpuId(goods.getSpuId());
                itemIntfceBO.setPurchaseCount(goods.getPurchaseCount());
                itemIntfceBO.setCount(goods.getPurchaseCount());
                saleOrderItemList.add(itemIntfceBO);
            }
            PebExtSaleOrderInfoIntfceReqBO saleOrderInfoIntfceReqBO = new PebExtSaleOrderInfoIntfceReqBO();
            saleOrderInfoIntfceReqBO.setCheckPrice(Boolean.valueOf(false));
            saleOrderInfoIntfceReqBO.setGoodsSupplierId(Long.valueOf(skuInfo.get(key).get(0).getGoodsSupplierId()));
            saleOrderInfoIntfceReqBO.setSaleOrderItemList(saleOrderItemList);
            saleOrderInfoList.add(saleOrderInfoIntfceReqBO);
        }
        pebExtQrySkuInfoAndPriceReqBO.setSaleOrderInfoList(saleOrderInfoList);
        return pebExtQrySkuInfoAndPriceReqBO;
    }

    private void valStatus(PebExtAgreementCreateOrderReqBO reqBO) {
        ArrayList<Long> itemIds = new ArrayList<Long>();
        for (PebExtAgreementSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
            itemIds.add(skuInfo.getPlanId());
        }
        if (itemIds.size() == 0) {
            return;
        }
        List planItemPOS = this.planDiversionMapper.selectListByPlanId(itemIds);
        planItemPOS.forEach(ordPlanItemPO -> {
            if (!PpcPlanStatus.PROTOCOL_TO_ORDER.getCode().equals(ordPlanItemPO.getPlanStatus()) && !PpcPlanStatus.COMMODITY_TO_ORDER.getCode().equals(ordPlanItemPO.getPlanStatus())) {
                throw new UocProBusinessException("8888", ordPlanItemPO.getScheduleNo() + "\u5bf9\u5e94\u8ba1\u5212\u72b6\u6001\u4e0d\u80fd\u4e0b\u5355");
            }
            for (PebExtAgreementSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
                BigDecimal count = ordPlanItemPO.getQuantity().subtract(ordPlanItemPO.getPackageQty()).subtract(ordPlanItemPO.getOrderQty());
                if (!skuInfo.getPlanId().equals(ordPlanItemPO.getPlanId())) continue;
                skuInfo.setPlanItemNo(ordPlanItemPO.getScheduleNo());
                skuInfo.setLineId(ordPlanItemPO.getLineId());
                skuInfo.setPlanSource(ordPlanItemPO.getSource());
                if (skuInfo.getPurchaseCount().compareTo(count) > 0) {
                    throw new UocProBusinessException("8888", ordPlanItemPO.getScheduleNo() + "\u4e0b\u5355\u6570\u91cf\u5927\u4e8e\u8ba1\u5212\u5269\u4f59\u91cf");
                }
                if (skuInfo.getPurchaseCount().compareTo(count) == 0) {
                    skuInfo.setIsUpdatePlan(Long.valueOf(1L));
                    continue;
                }
                skuInfo.setIsUpdatePlan(Long.valueOf(0L));
            }
        });
    }
}

