/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.umc.supplier.ability.api.UmcSupplierInfoQryListAbilityService;
import com.tydic.umc.supplier.ability.bo.UmcSupplierInfoBO;
import com.tydic.umc.supplier.ability.bo.UmcSupplierInfoQryListAbilityReqBO;
import com.tydic.umc.supplier.ability.bo.UmcSupplierInfoQryListAbilityRspBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfEnterpriseOrgDetailAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQryEnterpriseAccountDetailAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQryOrgEffAccountAbilityService;
import com.tydic.uoc.busibase.busi.bo.EnterpriseOrgDetailReqBO;
import com.tydic.uoc.busibase.busi.bo.EnterpriseOrgDetailRspBO;
import com.tydic.uoc.busibase.busi.bo.QryEnterpriseAccountDetailReqBO;
import com.tydic.uoc.busibase.busi.bo.QryEnterpriseAccountDetailRspBO;
import com.tydic.uoc.busibase.busi.bo.QryOrgEffAccountReqBO;
import com.tydic.uoc.busibase.busi.bo.QryOrgEffAccountRspBO;
import com.tydic.uoc.common.ability.bo.EnterpriseAccountBO;
import com.tydic.uoc.common.ability.bo.GoodsInfoIdBO;
import com.tydic.uoc.common.ability.bo.GoodsListDelReqBO;
import com.tydic.uoc.common.ability.bo.PebExtAgreementSkuInfo;
import com.tydic.uoc.common.ability.bo.PebExtAgreementSubmitOrderSaleItemRspBO;
import com.tydic.uoc.common.ability.bo.PlanDiversionSyncReqBO;
import com.tydic.uoc.common.ability.bo.SkuInfoRspBO;
import com.tydic.uoc.common.ability.bo.UocCoreActiveReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.zone.ability.bo.PebExtAgreementCreateOrderReqBO;
import com.tydic.uoc.zone.ability.bo.PebExtAgreementCreateOrderRspBO;
import com.tydic.uoc.zone.busi.api.PebExtAgreementCreateOrderBusiService;
import com.tydic.uoc.zone.busi.api.PebZoneCreateOrderCheckBusiService;
import com.tydic.uoc.zone.comb.api.PebExtAgreementCreateOrderCombService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebExtAgreementCreateOrderCombServiceImpl
implements PebExtAgreementCreateOrderCombService {
    @Autowired
    private PebZoneCreateOrderCheckBusiService pebZoneCreateOrderCheckBusiService;
    private static final Logger log = LoggerFactory.getLogger(PebExtAgreementCreateOrderCombServiceImpl.class);
    @Value(value="${personal.account}")
    private Long personalAccountId;
    @Autowired
    private PebIntfQryOrgEffAccountAbilityService pebIntfQryOrgEffAccountAbilityService;
    @Autowired
    private PebExtAgreementCreateOrderBusiService pebExtAgreementCreateOrderBusiService;
    @Autowired
    private PebIntfQryEnterpriseAccountDetailAbilityService pebIntfQryEnterpriseAccountDetailAbilityService;
    @Resource(name="uocZoneCreateOrderMsgProvider")
    private ProxyMessageProducer uocCreateOrderMsgProvider;
    @Value(value="${UOC_ZONE_ORDER_CREATE_TOPIC}")
    private String topic;
    @Value(value="${UOC_ZONE_ORDER_CREATE_TAG}")
    private String tag;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${PLAN_DIVERSION_SYNC_TOPIC:PLAN_DIVERSION_SYNC_TOPIC}")
    private String planDiversionSyncTopic;
    @Value(value="${PLAN_DIVERSION_SYNC_TAG:*}")
    private String planTag;
    @Resource(name="planDiversionSyncMsgProvider")
    private ProxyMessageProducer planDiversionSyncMsgProvider;
    @Autowired
    private PebIntfEnterpriseOrgDetailAbilityService pebIntfEnterpriseOrgDetailAbilityService;
    @Autowired
    private UmcSupplierInfoQryListAbilityService umcSupplierInfoQryListAbilityService;

    @Override
    public PebExtAgreementCreateOrderRspBO dealPebExtAgreementCreateOrder(PebExtAgreementCreateOrderReqBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderSource())) {
            reqBO.setOrderSource(UocConstant.ORDER_SOURCE.SINGLE_PRODUCT.toString());
        }
        reqBO.setErp(Boolean.valueOf(false));
        EnterpriseAccountBO umcEnterpriseAccountBO = this.qryEnterpriseAccountDetail(reqBO);
        reqBO.setPurchaserAccountOrgId(umcEnterpriseAccountBO.getOrgId());
        reqBO.setProfessionalOrganizationId(umcEnterpriseAccountBO.getDeliveryCenterId());
        reqBO.setProPhone(umcEnterpriseAccountBO.getTelephone());
        reqBO.setPurchaserAccount(umcEnterpriseAccountBO.getAccountId());
        reqBO.setPurchaserAccountName(umcEnterpriseAccountBO.getAccountName());
        EnterpriseOrgDetailReqBO detailReqBO = new EnterpriseOrgDetailReqBO();
        detailReqBO.setOrgIdWeb(umcEnterpriseAccountBO.getDeliveryCenterId());
        EnterpriseOrgDetailRspBO detailRspBO = this.pebIntfEnterpriseOrgDetailAbilityService.queryEnterpriseOrgByDetail(detailReqBO);
        if (!"0000".equals(detailRspBO.getRespCode())) {
            throw new UocProBusinessException("103028", "\u67e5\u8be2\u8fd0\u8425\u5355\u4f4d\u5931\u8d25" + detailRspBO.getRespDesc());
        }
        if (detailRspBO.getUmcEnterpriseOrgAbilityBO() == null) {
            throw new UocProBusinessException("103028", "\u67e5\u8be2\u8fd0\u8425\u5355\u4f4d\u4e3a\u7a7a");
        }
        reqBO.setProPath(detailRspBO.getUmcEnterpriseOrgAbilityBO().getOrgTreePath());
        reqBO.setProCode(detailRspBO.getUmcEnterpriseOrgAbilityBO().getOrgCode());
        reqBO.setProOrgName(detailRspBO.getUmcEnterpriseOrgAbilityBO().getOrgName());
        reqBO.setProRealName(detailRspBO.getUmcEnterpriseOrgAbilityBO().getLinkMan());
        EnterpriseAccountBO enterpriseAccountBO = this.qryOrgEffAccount(umcEnterpriseAccountBO);
        if (enterpriseAccountBO != null) {
            reqBO.setProAccount(enterpriseAccountBO.getAccountId());
        }
        reqBO.setEnterpriseAccountBO(umcEnterpriseAccountBO);
        PebExtAgreementCreateOrderRspBO rspBO = this.pebZoneCreateOrderCheckBusiService.dealPebZoneCreateOrder(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        List<UmcSupplierInfoBO> sup = this.qrySup(new ArrayList<Long>(rspBO.getSup()));
        Map<Long, UmcSupplierInfoBO> map = sup.stream().collect(Collectors.toMap(UmcSupplierInfoBO::getSupplierId, i -> i));
        reqBO.setProcKey("cnnc_el_sale_order_master_order_status");
        Map<Long, List<PebExtAgreementSkuInfo>> skuInfo = reqBO.getSaleOrderItemList().stream().collect(Collectors.groupingBy(SkuInfoRspBO::getAgrId));
        ArrayList<PebExtAgreementSubmitOrderSaleItemRspBO> submitOrderSaleItem = new ArrayList<PebExtAgreementSubmitOrderSaleItemRspBO>();
        rspBO.setSubmitOrderSaleItem(submitOrderSaleItem);
        this.create(submitOrderSaleItem, skuInfo, reqBO, rspBO, map);
        for (PebExtAgreementSubmitOrderSaleItemRspBO tempBo : submitOrderSaleItem) {
            Boolean success = tempBo.getSuccess();
            String failMsg = tempBo.getFailMsg();
            if (success == null || success.booleanValue()) continue;
            rspBO = (PebExtAgreementCreateOrderRspBO)UocProRspBoUtil.failed((String)failMsg, PebExtAgreementCreateOrderRspBO.class);
            return rspBO;
        }
        return rspBO;
    }

    private void create(List<PebExtAgreementSubmitOrderSaleItemRspBO> submitOrderSaleItem, Map<Long, List<PebExtAgreementSkuInfo>> splitGoods, PebExtAgreementCreateOrderReqBO reqBO, PebExtAgreementCreateOrderRspBO rspBO, Map<Long, UmcSupplierInfoBO> map) {
        for (Long key : splitGoods.keySet()) {
            List<PebExtAgreementSkuInfo> goods = splitGoods.get(key);
            reqBO.setPayType(goods.get(0).getPayType());
            this.createOrder(submitOrderSaleItem, goods, reqBO, rspBO, map);
        }
    }

    private void createOrder(List<PebExtAgreementSubmitOrderSaleItemRspBO> submitOrderSaleItem, List<PebExtAgreementSkuInfo> goods, PebExtAgreementCreateOrderReqBO reqBO, PebExtAgreementCreateOrderRspBO rspBO, Map<Long, UmcSupplierInfoBO> map) {
        reqBO.setSaleOrderItemList(goods);
        reqBO.setPrOrderId(rspBO.getOrderId());
        reqBO.setAgreementBO(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getAgreementBO());
        UmcSupplierInfoBO supplierInfoBO = map.get(Long.valueOf(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getGoodsSupplierId()));
        if (supplierInfoBO == null) {
            PebExtAgreementSubmitOrderSaleItemRspBO itemRspBO = new PebExtAgreementSubmitOrderSaleItemRspBO();
            itemRspBO.setGoodSupplierName(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSupplierName());
            itemRspBO.setGoodsSupplierId(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSkuSupplierId());
            itemRspBO.setSuccess(Boolean.valueOf(false));
            itemRspBO.setFailMsg("\u67e5\u8be2\u4f9b\u8d27\u65b9\u4e3a\u7a7a");
            return;
        }
        reqBO.setSupRelaMobile(reqBO.getAgreementBO().getVendorPhone());
        reqBO.setSupRelaName(reqBO.getAgreementBO().getVendorContact());
        reqBO.setExtField5(supplierInfoBO.getSupplierCode());
        UmcSupplierInfoBO infoBO = map.get(Long.valueOf(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSupplier()));
        if (PebExtConstant.YES.equals(reqBO.getIsPersonal())) {
            if (infoBO != null) {
                ((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).setSupplierTel(infoBO.getPhoneNumber());
                ((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).setSupplierMan(infoBO.getConsignerName());
                ((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).setSupplierErpNo(infoBO.getErpOrgCode());
                ((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).setSupplierName(infoBO.getSupplierName());
                ((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).setSupplierNo(infoBO.getSupplierCode());
            }
        } else {
            ((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).setSupplierTel(infoBO.getPhoneNumber());
            ((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).setSupplierMan(infoBO.getConsignerName());
            ((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).setSupplierErpNo(infoBO.getErpOrgCode());
            ((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).setSupplierName(infoBO.getSupplierName());
            ((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).setSupplierNo(infoBO.getSupplierCode());
        }
        PebExtAgreementCreateOrderRspBO orderRspBO = this.pebExtAgreementCreateOrderBusiService.dealPebExtAgreementCreateOrder(reqBO);
        PebExtAgreementSubmitOrderSaleItemRspBO itemRspBO = new PebExtAgreementSubmitOrderSaleItemRspBO();
        if (!"0000".equals(orderRspBO.getRespCode())) {
            itemRspBO.setGoodSupplierName(orderRspBO.getGoodSupplierName());
            itemRspBO.setGoodsSupplierId(orderRspBO.getGoodsSupplierId());
            itemRspBO.setSuccess(Boolean.valueOf(false));
            itemRspBO.setFailMsg(orderRspBO.getRespDesc());
        } else {
            BeanUtils.copyProperties((Object)orderRspBO, (Object)itemRspBO);
            itemRspBO.setIsPreOrder(Integer.valueOf(0));
            itemRspBO.setUserId(reqBO.getUserId());
            itemRspBO.setErp(reqBO.getErp());
            itemRspBO.setOrgId(reqBO.getOrgId());
            itemRspBO.setWarantty(reqBO.getAgreementBO().getWarantty());
            itemRspBO.setToken(reqBO.getToken());
            itemRspBO.setOrderId(orderRspBO.getOrderId());
            itemRspBO.setSaleOrderId(orderRspBO.getSaleOrderId());
            itemRspBO.setTotalfee(reqBO.getTotalAmount().divide(new BigDecimal(10000)));
            itemRspBO.setFee(itemRspBO.getTotalfee());
            itemRspBO.setSaleOrderItemList(reqBO.getSaleOrderItemList());
            itemRspBO.setCreateName(reqBO.getCreateName());
            itemRspBO.setEcpPurType(reqBO.getEcpPurType());
            itemRspBO.setCompanyId(reqBO.getCompanyId());
            itemRspBO.setAgrId(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getAgrId());
            itemRspBO.setMemId(reqBO.getMemId());
            itemRspBO.setMemUserType(reqBO.getMemUserType());
            itemRspBO.setIsPersonal(reqBO.getIsPersonal());
            itemRspBO.setContractType(reqBO.getAgreementBO().getContractType());
            itemRspBO.setSubmit(reqBO.getSubmit());
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList())) {
                itemRspBO.setActiveId(((UocCoreActiveReqBO)reqBO.getActiveBOList().get(0)).getActiveId());
                itemRspBO.setFl(Boolean.valueOf(true));
            } else {
                itemRspBO.setFl(Boolean.valueOf(false));
            }
            GoodsListDelReqBO goodsListDelReqBO = new GoodsListDelReqBO();
            ArrayList<GoodsInfoIdBO> goodsInfoIdAbilityBOList = new ArrayList<GoodsInfoIdBO>();
            goodsListDelReqBO.setGoodsInfoList(goodsInfoIdAbilityBOList);
            goodsListDelReqBO.setMemberId(String.valueOf(reqBO.getUserId()));
            for (PebExtAgreementSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
                GoodsInfoIdBO goodsInfoIdBO = new GoodsInfoIdBO();
                goodsInfoIdBO.setSkuId(skuInfo.getSkuId());
                goodsInfoIdAbilityBOList.add(goodsInfoIdBO);
            }
            itemRspBO.setGoodsListDelReqBO(goodsListDelReqBO);
            this.uocCreateOrderMsgProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)itemRspBO)));
            UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
            combReqBO.setOrderId(itemRspBO.getOrderId());
            combReqBO.setObjId(Long.valueOf(itemRspBO.getSaleOrderId()));
            combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
            combReqBO.setIsStatistics(Boolean.valueOf(false));
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
            if (CollectionUtils.isNotEmpty((Collection)orderRspBO.getPlanIds())) {
                PlanDiversionSyncReqBO syncReqBO = new PlanDiversionSyncReqBO();
                syncReqBO.setPlanIds(orderRspBO.getPlanIds());
                this.planDiversionSyncMsgProvider.send(new ProxyMessage(this.planDiversionSyncTopic, this.planTag, JSON.toJSONString((Object)syncReqBO)));
            }
        }
        submitOrderSaleItem.add(itemRspBO);
    }

    private List<UmcSupplierInfoBO> qrySup(List<Long> supId) {
        UmcSupplierInfoQryListAbilityReqBO reqBO = new UmcSupplierInfoQryListAbilityReqBO();
        reqBO.setSupplierIds(supId);
        UmcSupplierInfoQryListAbilityRspBO rspBO = this.umcSupplierInfoQryListAbilityService.supplierInfoQryListByIds(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException("103028", "\u67e5\u8be2\u4f9b\u5e94\u5546\u5931\u8d25" + rspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            throw new UocProBusinessException("103028", "\u67e5\u8be2\u4f9b\u5e94\u5546\u4e3a\u7a7a");
        }
        return rspBO.getRows();
    }

    private EnterpriseAccountBO qryOrgEffAccount(EnterpriseAccountBO enterpriseAccountBO) {
        QryOrgEffAccountReqBO qryOrgEffAccountReqBO = new QryOrgEffAccountReqBO();
        qryOrgEffAccountReqBO.setOrgIdWeb(enterpriseAccountBO.getDeliveryCenterId());
        log.debug("\u67e5\u8be2\u5e73\u53f0\u5546\u4fe1\u606f\u8c03\u7528" + JSON.toJSONString((Object)qryOrgEffAccountReqBO));
        QryOrgEffAccountRspBO rspBO = this.pebIntfQryOrgEffAccountAbilityService.qryOrgEffAccount(qryOrgEffAccountReqBO);
        log.debug("\u67e5\u8be2\u5e73\u53f0\u5546\u4fe1\u606f\u8c03\u7528" + JSON.toJSONString((Object)rspBO));
        if (CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            return null;
        }
        return (EnterpriseAccountBO)rspBO.getRows().get(0);
    }

    private EnterpriseAccountBO qryEnterpriseAccountDetail(PebExtAgreementCreateOrderReqBO reqBO) {
        QryEnterpriseAccountDetailReqBO account = new QryEnterpriseAccountDetailReqBO();
        if (!PebExtConstant.YES.equals(reqBO.getIsPersonal())) {
            account.setOrgCode(reqBO.getBuynerNo());
        } else {
            account.setAccountId(this.personalAccountId);
        }
        try {
            log.debug("\u8d26\u5957\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)account));
            QryEnterpriseAccountDetailRspBO rspBO = this.pebIntfQryEnterpriseAccountDetailAbilityService.qryEnterpriseAccountDetail(account);
            log.debug("\u8d26\u5957\u4fe1\u606f\u56de\u53c2\uff1a" + JSON.toJSONString((Object)rspBO));
            if (!"0000".equals(rspBO.getRespCode())) {
                throw new UocProBusinessException("103028", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u5931\u8d25" + rspBO.getRespDesc());
            }
            EnterpriseAccountBO accountBO = rspBO.getUmcEnterpriseAccountBO();
            if (accountBO == null) {
                throw new UocProBusinessException("103028", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u8be6\u60c5\u7ed3\u679c\u4e3a\u7a7a");
            }
            return accountBO;
        }
        catch (Exception e) {
            throw new UocProBusinessException("103028", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u5931\u8d25" + e.getMessage());
        }
    }
}

