/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.mq.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.commodity.base.bo.UccEMdmMaterialBO;
import com.tydic.commodity.common.ability.api.UccThematerialsearchAbilityService;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityRspBO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfgetOrderSchemeItemService;
import com.tydic.uoc.busibase.busi.bo.FzSchemeBO;
import com.tydic.uoc.busibase.busi.bo.GetOrderSchemeReqBO;
import com.tydic.uoc.busibase.busi.bo.GetOrderSchemeRspBO;
import com.tydic.uoc.busibase.busi.bo.SchemeItemBO;
import com.tydic.uoc.dao.UocOrdContractPackageMapper;
import com.tydic.uoc.dao.UocOrdGoodsTempMapper;
import com.tydic.uoc.po.UocOrdContractPackagePO;
import com.tydic.uoc.po.UocOrdGoodsTempPO;
import com.tydic.uoc.zone.ability.bo.UocOrdContractPackageTaskCreateGoodsTempReqBO;
import com.tydic.uoc.zone.busi.api.UocOrdContractPackageBusiService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

public class UocDealGoodsTempConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    @Autowired
    private UocOrdContractPackageBusiService uocOrdContractPackageBusiService;
    @Autowired
    private UocOrdContractPackageMapper uocOrdContractPackageMapper;
    private static final Logger log = LoggerFactory.getLogger(UocDealGoodsTempConsumer.class);
    @Autowired
    private PebIntfgetOrderSchemeItemService pebIntfgetOrderSchemeItemService;
    @Autowired
    private UocOrdGoodsTempMapper uocOrdGoodsTempMapper;
    @Autowired
    private UccThematerialsearchAbilityService uccThematerialsearchAbilityService;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Value(value="${UOC_DEAL_GOODS_COUNT:500}")
    private Integer dealCount;
    @Value(value="${UOC_DEAL_GOODS_COUNT_MAX:100000}")
    private Integer maxCount;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            log.debug("\u5f02\u6b65\u5904\u7406goodsTemp\u6d88\u8d39\u8005\u5f00\u59cb------");
            UocOrdContractPackageTaskCreateGoodsTempReqBO reqBO = (UocOrdContractPackageTaskCreateGoodsTempReqBO)JSON.parseObject((String)message.getContent(), UocOrdContractPackageTaskCreateGoodsTempReqBO.class);
            log.debug("\u5f02\u6b65\u5904\u7406goodsTemp\u6d88\u8d39\u8005\u5165\u53c2------" + reqBO.toString());
            UocOrdContractPackagePO uocOrdContractPackagePo = new UocOrdContractPackagePO();
            uocOrdContractPackagePo.setId(reqBO.getId());
            uocOrdContractPackagePo.setItemType(reqBO.getItemType());
            uocOrdContractPackagePo.setPackageCode(reqBO.getPackageCode());
            UocOrdContractPackagePO po = this.uocOrdContractPackageMapper.getModelBy(uocOrdContractPackagePo);
            if (po == null) {
                throw new RuntimeException("\u67e5\u8be2\u91c7\u8d2d\u8ba1\u5212\u4efb\u52a1\u5355\u5931\u8d25!");
            }
            Boolean flag = true;
            Integer pageSize = this.dealCount;
            Integer totalRecord = this.maxCount;
            int page = totalRecord / pageSize;
            int ys = totalRecord % pageSize;
            if (ys > 0) {
                ++page;
            }
            if (po.getItemState() != 1 && po.getItemState() != 0 && flag.booleanValue()) {
                UocOrdContractPackagePO failUpdatePo = new UocOrdContractPackagePO();
                failUpdatePo.setId(reqBO.getId());
                failUpdatePo.setItemState(Integer.valueOf(0));
                failUpdatePo.setFaileReason("\u91c7\u8d2d\u8ba1\u5212\u4efb\u52a1\u5355\u4e0d\u5904\u4e8e\u52a0\u8f7d\u4e2d\u6216\u8005\u52a0\u8f7d\u5931\u8d25\u72b6\u6001!");
                this.uocOrdContractPackageMapper.updateById(failUpdatePo);
                flag = false;
            }
            if (flag.booleanValue()) {
                Boolean delFlag = true;
                String buyerType = reqBO.getItemType() == 1 ? "XY_CAI" : "DS_CG";
                GetOrderSchemeReqBO fzReqBO = new GetOrderSchemeReqBO();
                fzReqBO.setOrderType("1");
                fzReqBO.setPackageCode(reqBO.getPackageCode());
                for (int i = 1; i <= page; ++i) {
                    fzReqBO.setPage(Integer.valueOf(i));
                    fzReqBO.setPageSize(pageSize);
                    fzReqBO.setBuyerType(buyerType);
                    fzReqBO.setToken(reqBO.getToken());
                    GetOrderSchemeRspBO fzRspBO = this.pebIntfgetOrderSchemeItemService.cancelPurchaseOrder(fzReqBO);
                    log.info("\u5f02\u6b65\u5904\u7406goodsTemp\u6d88\u8d39\u8005\u5165\u53c2------" + fzRspBO.toString());
                    if (!"0000".equals(fzRspBO.getRespCode())) {
                        UocOrdContractPackagePO failUpdatePo = new UocOrdContractPackagePO();
                        failUpdatePo.setId(reqBO.getId());
                        failUpdatePo.setItemState(Integer.valueOf(0));
                        failUpdatePo.setFaileReason(fzRspBO.getRespDesc());
                        this.uocOrdContractPackageMapper.updateById(failUpdatePo);
                        return ProxyConsumerStatus.CONSUME_SUCCESS;
                    }
                    if (po.getItemState() == 0 && delFlag.booleanValue()) {
                        UocOrdGoodsTempPO uocOrdGoodsTempPO = new UocOrdGoodsTempPO();
                        uocOrdGoodsTempPO.setOrderId(po.getId());
                        this.uocOrdGoodsTempMapper.delete(uocOrdGoodsTempPO);
                        delFlag = false;
                    }
                    if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)fzRspBO.getData()) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)((FzSchemeBO)fzRspBO.getData().get(0)).getItemResultVoList())) {
                        log.debug("\u5f02\u6b65\u5904\u7406goodsTemp\u6d88\u8d39\u8005\u5206\u6279\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\u7ed3\u675f\u5faa\u73af------");
                        UocOrdGoodsTempPO record = new UocOrdGoodsTempPO();
                        record.setOrderId(po.getId());
                        List UocOrdGoodsTempList = this.uocOrdGoodsTempMapper.selectByCondition(record);
                        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)UocOrdGoodsTempList)) {
                            UocOrdContractPackagePO failUpdatePo = new UocOrdContractPackagePO();
                            failUpdatePo.setId(reqBO.getId());
                            failUpdatePo.setItemState(Integer.valueOf(0));
                            failUpdatePo.setFaileReason("\u6ca1\u6709\u7b26\u5408\u8981\u6c42\u7684\u660e\u7ec6\u6570\u636e");
                            this.uocOrdContractPackageMapper.updateById(failUpdatePo);
                            break;
                        }
                        UocOrdContractPackagePO updatePo = new UocOrdContractPackagePO();
                        updatePo.setId(po.getId());
                        updatePo.setItemState(Integer.valueOf(2));
                        this.uocOrdContractPackageMapper.updateById(updatePo);
                        break;
                    }
                    ArrayList<UocOrdGoodsTempPO> addList = new ArrayList<UocOrdGoodsTempPO>();
                    UocOrdGoodsTempPO record = new UocOrdGoodsTempPO();
                    record.setOrderId(po.getId());
                    List UocOrdGoodsTempList = this.uocOrdGoodsTempMapper.selectByCondition(record);
                    List<Object> outObjItemIdList = new ArrayList();
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)UocOrdGoodsTempList)) {
                        outObjItemIdList = UocOrdGoodsTempList.stream().map(UocOrdGoodsTempPO::getOutObjItemId).collect(Collectors.toList());
                    }
                    for (SchemeItemBO schemeItemBO : ((FzSchemeBO)fzRspBO.getData().get(0)).getItemResultVoList()) {
                        UocOrdGoodsTempPO target = new UocOrdGoodsTempPO();
                        this.translate(schemeItemBO, target, po, reqBO);
                        if (outObjItemIdList.contains(target.getOutObjItemId()) || "000000".equals(target.getSkuMaterialId().substring(target.getSkuMaterialId().length() - 6))) continue;
                        addList.add(target);
                    }
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty(addList)) {
                        this.getMaterial(addList, true);
                        this.uocOrdGoodsTempMapper.insertBatch(addList);
                    }
                    UocOrdContractPackagePO updatePo = new UocOrdContractPackagePO();
                    updatePo.setId(po.getId());
                    updatePo.setTotalPage(fzRspBO.getTotalPage());
                    updatePo.setRecordsTotal(fzRspBO.getTotalRecord());
                    int endTotal = ((FzSchemeBO)fzRspBO.getData().get(0)).getItemResultVoList().size();
                    updatePo.setEndTotal(Integer.valueOf(endTotal));
                    this.uocOrdContractPackageMapper.updatePage(updatePo);
                }
            }
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5f02\u6b65\u5904\u7406goodsTemp\u6d88\u8d39\u8005\u6d88\u8d39\u5931\u8d25" + e.getMessage());
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
    }

    void translate(SchemeItemBO item, UocOrdGoodsTempPO tempPO, UocOrdContractPackagePO po, UocOrdContractPackageTaskCreateGoodsTempReqBO reqBO) {
        tempPO.setOrderId(po.getId());
        tempPO.setTempId(Long.valueOf(this.idUtil.nextId()));
        tempPO.setSkuMaterialId(item.getItemCode());
        tempPO.setSkuMaterialName(item.getItemName());
        tempPO.setUnitName(item.getItemUnit());
        tempPO.setPurchaseCount(item.getCanOrderNum());
        tempPO.setZljsyq(item.getQtr());
        tempPO.setSkuMaterialRemark(item.getRowRemark());
        tempPO.setPlanId(item.getDycPlanItemId());
        tempPO.setOutObjItemId(item.getSchemeItemId());
        tempPO.setOrganizationId(item.getDecCompanyCode());
        tempPO.setOrganizationName(item.getDecCompanyName());
        tempPO.setSupplier(po.getExt1());
        tempPO.setSkuSupplierName(po.getExt2());
        tempPO.setSupplierShopId(Long.valueOf(Long.parseLong(po.getExt1())));
        tempPO.setSkuSupplierId(Long.valueOf(Long.parseLong(po.getExt1())));
        tempPO.setTempId(Long.valueOf(this.idUtil.nextId()));
        tempPO.setCreateTime(new Date());
        tempPO.setUpdateTime(new Date());
        tempPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        tempPO.setUpdateOperId(String.valueOf(reqBO.getUserId()));
        tempPO.setTax(Long.valueOf(item.getTax().longValue()));
        tempPO.setNakePrice(new BigDecimal(item.getNotaxPrice()).setScale(10, RoundingMode.HALF_UP));
        BigDecimal salePrice = new BigDecimal(item.getTax()).divide(new BigDecimal(100)).add(new BigDecimal(1)).multiply(new BigDecimal(item.getNotaxPrice())).setScale(10, RoundingMode.HALF_UP);
        BigDecimal totalSalePrice = salePrice.multiply(tempPO.getPurchaseCount()).setScale(10, RoundingMode.HALF_UP);
        BigDecimal totalNakePrice = tempPO.getNakePrice().multiply(tempPO.getPurchaseCount()).setScale(10, RoundingMode.HALF_UP);
        BigDecimal taxPrice = totalSalePrice.subtract(totalNakePrice);
        tempPO.setSalePrice(salePrice);
        tempPO.setTotalSalePrice(totalSalePrice);
        tempPO.setTotalNakePrice(totalNakePrice);
        tempPO.setTaxPrice(taxPrice);
    }

    private void getMaterial(List<UocOrdGoodsTempPO> tempList, boolean qry) {
        HashSet<String> code = new HashSet<String>();
        ArrayList<String> materialCodes = new ArrayList<String>();
        for (UocOrdGoodsTempPO skuInfo : tempList) {
            materialCodes.add(skuInfo.getSkuMaterialId());
            code.add(skuInfo.getSkuMaterialId());
            if (!StringUtils.isNotBlank((CharSequence)skuInfo.getSkuMaterialId()) || !skuInfo.getSkuMaterialId().endsWith("000000")) continue;
            throw new UocProBusinessException("100030", "\u901a\u7528\u7269\u6599\u4e0d\u80fd\u4e0b\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7269\u6599");
        }
        UccThematerialsearchAbilityReqBO uccThematerialsearchAbilityReqBO = new UccThematerialsearchAbilityReqBO();
        uccThematerialsearchAbilityReqBO.setMaterialCodes(materialCodes);
        uccThematerialsearchAbilityReqBO.setPageNo(1);
        uccThematerialsearchAbilityReqBO.setPageSize(99999);
        log.debug("\u67e5\u8be2\u7269\u6599\u7f16\u7801:" + JSON.toJSONString((Object)uccThematerialsearchAbilityReqBO));
        UccThematerialsearchAbilityRspBO rspBO = this.uccThematerialsearchAbilityService.dealUccThematerialsearch(uccThematerialsearchAbilityReqBO);
        log.debug("\u67e5\u8be2\u7269\u6599\u7f16\u7801:");
        if (rspBO.getRespCode().equals("0000") && CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            throw new UocProBusinessException("100030", ((Object)code).toString() + "\u7f3a\u5c11\u7269\u8d44\u4fe1\u606f\u65e0\u6cd5\u4e0b\u5355\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u4eba\u5458");
        }
        ArrayList<String> mCode = new ArrayList<String>();
        List eMdmMaterialBOS = JSONArray.parseArray((String)JSON.toJSONString((Object)rspBO.getRows()), UccEMdmMaterialBO.class);
        for (UccEMdmMaterialBO uccEMdmMaterialBO : eMdmMaterialBOS) {
            mCode.add(uccEMdmMaterialBO.getMaterialCode());
        }
        String desc = null;
        for (String m : code) {
            if (mCode.contains(m)) continue;
            desc = m + ",";
        }
        if (StringUtils.isNotBlank(desc)) {
            throw new UocProBusinessException("100030", "\u3010" + desc + "\u3011\u7f3a\u5c11\u7269\u8d44\u4fe1\u606f\u65e0\u6cd5\u4e0b\u5355\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u4eba\u5458");
        }
        for (UccEMdmMaterialBO uccEMdmMaterialBO : eMdmMaterialBOS) {
            for (UocOrdGoodsTempPO skuInfo : tempList) {
                if (!uccEMdmMaterialBO.getMaterialCode().equals(skuInfo.getSkuMaterialId())) continue;
                if (StringUtils.isNotBlank((CharSequence)uccEMdmMaterialBO.getSpec())) {
                    skuInfo.setSpec(uccEMdmMaterialBO.getSpec());
                }
                if (StringUtils.isNotBlank((CharSequence)uccEMdmMaterialBO.getModel())) {
                    skuInfo.setModel(uccEMdmMaterialBO.getModel());
                }
                skuInfo.setCateCode(uccEMdmMaterialBO.getCatalogCode());
                skuInfo.setCateName(uccEMdmMaterialBO.getCatalogName());
                if (StringUtils.isBlank((CharSequence)skuInfo.getSkuMaterialName())) {
                    if (StringUtils.isNotBlank((CharSequence)uccEMdmMaterialBO.getLongDesc())) {
                        skuInfo.setSkuMaterialName(uccEMdmMaterialBO.getLongDesc());
                    } else {
                        skuInfo.setSkuMaterialName(uccEMdmMaterialBO.getMaterialName());
                    }
                }
                if (StringUtils.isBlank((CharSequence)skuInfo.getUnitName())) {
                    skuInfo.setUnitName(uccEMdmMaterialBO.getMeasure());
                }
                skuInfo.setExt8(uccEMdmMaterialBO.getMaterialName());
            }
        }
    }
}

