/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.uoc.base.bo.UocOrdItemFlBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.CommUtils;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfSgOrgAmountDeductAbilityService;
import com.tydic.uoc.busibase.busi.bo.SgOrgAmountDeductReqBO;
import com.tydic.uoc.busibase.busi.bo.SgOrgAmountDeductRspBO;
import com.tydic.uoc.common.ability.bo.AccessoryBO;
import com.tydic.uoc.common.ability.bo.AgrAgreementSettlementDetailBO;
import com.tydic.uoc.common.ability.bo.AgreementSettlementBO;
import com.tydic.uoc.common.ability.bo.CommodityAttrRspBO;
import com.tydic.uoc.common.ability.bo.EnterpriseAccountBO;
import com.tydic.uoc.common.ability.bo.PebExtAddressInfoIntfceReqBO;
import com.tydic.uoc.common.ability.bo.PebExtAgreementSkuInfo;
import com.tydic.uoc.common.ability.bo.PebOrderAuditInfoBO;
import com.tydic.uoc.common.ability.bo.UocCoreActiveReqBO;
import com.tydic.uoc.common.atom.api.UocCoreCreateLogisticsRelaAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreateOrderAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreatePayOrderAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreateSaleOrderAtomService;
import com.tydic.uoc.common.atom.bo.AtomUocCoreCreateOrderReqBO;
import com.tydic.uoc.common.atom.bo.CommonCenterFieldValueBO;
import com.tydic.uoc.common.atom.bo.OrdGoodsAttrBO;
import com.tydic.uoc.common.atom.bo.OrdGoodsBO;
import com.tydic.uoc.common.atom.bo.UocCoreAddOrdSaleCouponInfoBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateLogisticsRelaReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateLogisticsRelaRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreatePayOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreatePayOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateSaleOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateSaleOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocOrderGoodsGiftBO;
import com.tydic.uoc.common.atom.bo.UocOrderItemBO;
import com.tydic.uoc.common.atom.bo.UocOrderPayItemBO;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomRspBo;
import com.tydic.uoc.common.atom.impl.UocProGetVoucherNoAtomService;
import com.tydic.uoc.dao.ConfSupplierMapper;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdInvoiceMapper;
import com.tydic.uoc.dao.OrdItemMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPayConfMapper;
import com.tydic.uoc.dao.OrdPlanItemDao;
import com.tydic.uoc.dao.PayConfDetailMapper;
import com.tydic.uoc.dao.PlanDiversionMapper;
import com.tydic.uoc.dao.TrackNoMapper;
import com.tydic.uoc.dao.UocOrdHistoryMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.ConfSupplierPO;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdInvoicePO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPayConfPO;
import com.tydic.uoc.po.OrdPlanItemPO;
import com.tydic.uoc.po.PayConfDetailPO;
import com.tydic.uoc.po.PlanDiversionInfo;
import com.tydic.uoc.po.TrackNoPO;
import com.tydic.uoc.po.UocOrdHistoryPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import com.tydic.uoc.zone.ability.bo.PebExtAgreementCreateOrderReqBO;
import com.tydic.uoc.zone.ability.bo.PebExtAgreementCreateOrderRspBO;
import com.tydic.uoc.zone.busi.api.PebExtAgreementCreateOrderBusiService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebExtAgreementCreateOrderBusiServiceImpl
implements PebExtAgreementCreateOrderBusiService {
    private Logger log = LoggerFactory.getLogger(PebExtAgreementCreateOrderBusiServiceImpl.class);
    @Autowired
    private UocCoreCreateOrderAtomService uocCoreCreateOrderAtomService;
    @Autowired
    private UocCoreCreateLogisticsRelaAtomService uocCoreCreateLogisticsRelaTionAtomService;
    @Autowired
    private UocCoreCreateSaleOrderAtomService uocCoreCreateSaleOrderAtomService;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private UocCoreCreatePayOrderAtomService uocCoreCreatePayOrderAtomService;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private PebIntfSgOrgAmountDeductAbilityService pebIntfSgOrgAmountDeductAbilityService;
    @Autowired
    private OrdItemMapMapper ordItemMapMapper;
    @Autowired
    private OrdInvoiceMapper ordInvoiceMapper;
    @Value(value="${uoc.saveJdOrgId:false}")
    private Boolean saveJdOrgId;
    @Autowired
    private ConfSupplierMapper confSupplierMapper;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private PayConfDetailMapper payConfDetailMapper;
    @Autowired
    private OrdPlanItemDao ordPlanItemDao;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private PlanDiversionMapper planDiversionMapper;
    @Value(value="${uoc.jgb:100096}")
    private String jgb;
    @Value(value="${uoc.jgbName:\u65b9\u5fe0}")
    private String jgbName;
    @Value(value="${uoc.jgbPhone:18600660183}")
    private String jgbPhone;
    @Value(value="${uoc.dzsw:100100}")
    private String dzsw;
    @Value(value="${uoc.dzswName:\u674e\u56fd\u6d9b}")
    private String dzswName;
    @Value(value="${uoc.dzswPhone:13259762813}")
    private String dzswPhone;
    @Value(value="${zone.ship.maxTime:15}")
    private String maxShipTime;
    @Value(value="${uoc.cy.use:true}")
    private Boolean use;
    @Autowired
    private UocOrdHistoryMapper uocOrdHistoryMapper;
    @Autowired
    private TrackNoMapper trackNoMapper;
    @Autowired
    private UocProGetVoucherNoAtomService uocProGetVoucherNoAtomService;

    @Override
    public PebExtAgreementCreateOrderRspBO dealPebExtAgreementCreateOrder(PebExtAgreementCreateOrderReqBO reqBO) {
        List ordItemList;
        Long limit;
        PebExtAgreementCreateOrderRspBO rspBO = new PebExtAgreementCreateOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        reqBO.setPreFee(new BigDecimal(0));
        Long orderId = null;
        orderId = reqBO.getOrderId() != null ? reqBO.getOrderId() : Long.valueOf(this.idUtil.nextId());
        UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = this.buildLogisticsRelaTionParam(orderId, reqBO.getAddressInfo());
        UocCoreCreateLogisticsRelaRspBO uocCoreCreateLogisticsRelaRspBO = this.uocCoreCreateLogisticsRelaTionAtomService.dealCoreCreateLogisticsRela(uocCoreCreateLogisticsRelaReqBO);
        if (!"0000".equals(uocCoreCreateLogisticsRelaRspBO.getRespCode())) {
            throw new UocProBusinessException("102107", uocCoreCreateLogisticsRelaRspBO.getRespDesc());
        }
        Long contactId = uocCoreCreateLogisticsRelaRspBO.getContactId();
        UocCoreCreateSaleOrderReqBO uocCoreCreateSaleOrderReqBO = this.buildCreateSaleOrderParam(reqBO, orderId, contactId);
        uocCoreCreateSaleOrderReqBO.setProcKey(reqBO.getProcKey());
        Long saleFee = uocCoreCreateSaleOrderReqBO.getSaleFee();
        Long skuSupplierId = ((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSkuSupplierId();
        String supplierName = ((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSkuSupplierName();
        ConfSupplierPO qrySup = new ConfSupplierPO();
        qrySup.setSupNo(skuSupplierId);
        qrySup.setLimitStatus(Integer.valueOf(0));
        ConfSupplierPO modelBy = this.confSupplierMapper.getModelBy(qrySup);
        if (modelBy != null && (limit = modelBy.getOrderLimit()) != null && limit > 0L && limit > saleFee) {
            String money = null;
            try {
                money = UocMoneyUtil.Long2BigDecimal((Long)limit).toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw new UocProBusinessException("102107", supplierName + "\u4e0b\u7684\u8ba2\u5355\u4e0d\u6ee1\u8db3" + money + "\u5143\uff0c\u4e0d\u5141\u8bb8\u4e0b\u5355\u3002");
        }
        UocCoreCreateSaleOrderRspBO uocCoreCreateSaleOrderRspBO = this.uocCoreCreateSaleOrderAtomService.dealCoreCreateSaleOrder(uocCoreCreateSaleOrderReqBO);
        if (!"0000".equals(uocCoreCreateSaleOrderRspBO.getRespCode())) {
            throw new UocProBusinessException("102107", uocCoreCreateSaleOrderRspBO.getRespDesc());
        }
        OrdItemPO ordItemPo = new OrdItemPO();
        ordItemPo.setOrderId(orderId);
        try {
            ordItemList = this.ordItemMapper.getList(ordItemPo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102107", "\u67e5\u8be2\u9500\u552e\u660e\u7ec6\u5931\u8d25!");
        }
        UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO = this.buildCreatePayOrderParam(orderId, reqBO, ordItemList, uocCoreCreateSaleOrderRspBO.getSaleVoucherId());
        UocCoreCreatePayOrderRspBO uocCoreCreatePayOrderRspBO = this.uocCoreCreatePayOrderAtomService.dealCoreCreatePayOrder(uocCoreCreatePayOrderReqBO);
        if (!"0000".equals(uocCoreCreatePayOrderRspBO.getRespCode())) {
            throw new UocProBusinessException("102107", uocCoreCreatePayOrderRspBO.getRespDesc());
        }
        AtomUocCoreCreateOrderReqBO uocCoreCreateOrderReqBO = this.buildCreateOrderParam(orderId, reqBO, uocCoreCreateSaleOrderReqBO);
        UocCoreCreateOrderRspBO uocCoreCreateOrderRspBO = this.uocCoreCreateOrderAtomService.dealCoreCreateOrder(uocCoreCreateOrderReqBO);
        if (!"0000".equals(uocCoreCreateOrderRspBO.getRespCode())) {
            throw new UocProBusinessException("102107", uocCoreCreateOrderRspBO.getRespDesc());
        }
        this.zmInfo(orderId, reqBO);
        ArrayList<Long> planIds = new ArrayList<Long>();
        this.updatePlan(reqBO, planIds);
        this.saveAccessory(reqBO, orderId);
        this.saveExt(reqBO, orderId, ordItemList);
        rspBO.setSaleOrderCode(uocCoreCreateSaleOrderReqBO.getSaleVoucherNo());
        rspBO.setSaleOrderId(String.valueOf(uocCoreCreateSaleOrderRspBO.getSaleVoucherId()));
        rspBO.setStatusName(uocCoreCreateSaleOrderRspBO.getSaleStateStr());
        rspBO.setGoodSupplierName(reqBO.getAgreementBO().getSupplierName());
        rspBO.setGoodsSupplierId(uocCoreCreateOrderReqBO.getSupId());
        rspBO.setOrderId(orderId);
        rspBO.setPlanIds(planIds);
        this.saveInvoice(reqBO, orderId, uocCoreCreateSaleOrderRspBO.getSaleVoucherId());
        this.savePayConfInfo(reqBO, rspBO);
        this.history(reqBO, ordItemList, uocCoreCreateSaleOrderReqBO.getSaleVoucherNo(), orderId);
        return rspBO;
    }

    private void history(PebExtAgreementCreateOrderReqBO reqBO, List<OrdItemPO> ordItemList, String orderNo, Long orderId) {
        ArrayList<UocOrdHistoryPO> list = new ArrayList<UocOrdHistoryPO>();
        OrdGoodsPO goodsPO = new OrdGoodsPO();
        goodsPO.setOrderId(orderId);
        List goodsPOS = this.ordGoodsMapper.getList(goodsPO);
        for (OrdItemPO itemPO : ordItemList) {
            UocOrdHistoryPO historyPO = new UocOrdHistoryPO();
            historyPO.setId(Long.valueOf(this.idUtil.nextId()));
            historyPO.setCreateOrgName(reqBO.getOrgName());
            historyPO.setCreateOrgNo(reqBO.getOrgCodeIn());
            historyPO.setCreateUserName(reqBO.getName());
            historyPO.setCreateUserNo(reqBO.getCreateName());
            historyPO.setItemCount(itemPO.getPurchaseCount());
            for (OrdGoodsPO skuInfo : goodsPOS) {
                if (!skuInfo.getOrdItemId().equals(itemPO.getOrdItemId())) continue;
                historyPO.setMaterialCode(skuInfo.getSkuMaterialId());
                historyPO.setModel(skuInfo.getModel());
                historyPO.setSpec(skuInfo.getSpec());
                historyPO.setExt1(skuInfo.getSkuMaterialTypeId());
                historyPO.setExt2(skuInfo.getSkuMaterialTypeName());
                break;
            }
            if (itemPO.getTax() == null) {
                itemPO.setTax(Long.valueOf(0L));
            }
            historyPO.setMaterialDesc(itemPO.getExtField2());
            historyPO.setExt3(String.valueOf(itemPO.getTax()));
            try {
                historyPO.setSalePrice(itemPO.getSaleDecimalPrice());
                BigDecimal tax = new BigDecimal(itemPO.getTax() + "").divide(new BigDecimal("100"), 2, 4);
                tax = BigDecimal.ONE.add(tax);
                historyPO.setNakePrice(historyPO.getSalePrice().divide(tax, 8, 4));
            }
            catch (Exception exception) {
                // empty catch block
            }
            historyPO.setOrderId(itemPO.getOrderId());
            historyPO.setOrdItemId(itemPO.getOrdItemId());
            historyPO.setOrderNo(orderNo);
            historyPO.setSupNum(reqBO.getExtField5());
            historyPO.setSupName(reqBO.getAgreementBO().getVendorName());
            historyPO.setUnitName(itemPO.getUnitName());
            historyPO.setExt4(reqBO.getOrderSource());
            list.add(historyPO);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            this.uocOrdHistoryMapper.insertBatch(list);
        }
    }

    private void zmInfo(Long orderId, PebExtAgreementCreateOrderReqBO reqBO) {
        Integer isHt;
        Integer my;
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)zmInfoPO);
        zmInfoPO.setOrderId(orderId);
        zmInfoPO.setErpStatus(PebExtConstant.ErpStatus.NOT);
        zmInfoPO.setSupplier(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSupplier());
        zmInfoPO.setSupplierTel(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSupplierTel());
        zmInfoPO.setSupplierMan(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSupplierMan());
        zmInfoPO.setSupplierName(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSupplierName());
        zmInfoPO.setSupplierNo(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSupplierNo());
        zmInfoPO.setSupplierErpNo(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSupplierErpNo());
        zmInfoPO.setVendorSiteId(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getVendorSiteId());
        zmInfoPO.setVendorSiteName(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getVendorSiteName());
        zmInfoPO.setB2bsiteId(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getB2bsiteId());
        zmInfoPO.setAddrJc(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getAddrJc());
        zmInfoPO.setOrderPurType(reqBO.getPurType());
        zmInfoPO.setExt3(reqBO.getPurchaserAccountOrgId().toString());
        if (reqBO.getAgreementBO().getContractType() != null && reqBO.getAgreementBO().getContractType() == 12) {
            zmInfoPO.setIsJsXy(PebExtConstant.YES);
        }
        if ((my = Integer.valueOf(2)).equals(reqBO.getAgreementBO().getTradeMode())) {
            zmInfoPO.setPurType("\u6267\u884c\u534f\u8bae");
        } else {
            zmInfoPO.setPurType("\u76f4\u63a5\u91c7\u8d2d");
            if (this.jgb.equals(reqBO.getAgreementBO().getProfessionalOrgId())) {
                zmInfoPO.setSupplierMan(this.jgbName);
                zmInfoPO.setSupplierTel(this.jgbPhone);
            }
            if (this.dzsw.equals(reqBO.getAgreementBO().getProfessionalOrgId())) {
                zmInfoPO.setSupplierMan(this.dzswName);
                zmInfoPO.setSupplierTel(this.dzswPhone);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAgreementBO().getPurchaseTypeStr())) {
            zmInfoPO.setPurType(reqBO.getAgreementBO().getPurchaseTypeStr());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getAuditInfo())) {
            for (PebOrderAuditInfoBO infoBO : reqBO.getAuditInfo()) {
                if (!"M001102".equals(infoBO.getType())) continue;
                zmInfoPO.setExt1(infoBO.getProcKey());
            }
        }
        if ((isHt = Integer.valueOf(1)).equals(reqBO.getIsHt())) {
            zmInfoPO.setExt5("1");
        } else {
            zmInfoPO.setExt5("2");
        }
        this.uocOrdZmInfoMapper.insert(zmInfoPO);
    }

    private void updatePlan(PebExtAgreementCreateOrderReqBO reqBO, List<Long> planIds) {
        if (PebExtConstant.YES.equals(reqBO.getPlanHt())) {
            for (PebExtAgreementSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
                PlanDiversionInfo info = new PlanDiversionInfo();
                info.setPlanId(skuInfo.getPlanId());
                info.setOrderQty(skuInfo.getPurchaseCount());
                if (skuInfo.getIsUpdatePlan() == null) {
                    skuInfo.setIsUpdatePlan(Long.valueOf(0L));
                }
                if (1L == skuInfo.getIsUpdatePlan()) {
                    info.setPlanStatus("104");
                }
                info.setAgreementQty(skuInfo.getPurchaseCount());
                info.setCommodityQty(BigDecimal.ZERO);
                planIds.add(info.getPlanId());
                this.planDiversionMapper.updateCount(info);
            }
            return;
        }
        if (((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getPlanId() == null) {
            return;
        }
        for (PebExtAgreementSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
            PlanDiversionInfo info = new PlanDiversionInfo();
            info.setPlanId(skuInfo.getPlanId());
            if (PebExtConstant.OrderType.CX_AGR.equals(reqBO.getOrderType())) {
                info.setCommodityQty(BigDecimal.ZERO);
                info.setAgreementQty(skuInfo.getPurchaseCount());
            } else if (PebExtConstant.OrderType.CX_AGR_GOODS.equals(reqBO.getOrderType())) {
                info.setCommodityQty(skuInfo.getPurchaseCount());
                info.setAgreementQty(BigDecimal.ZERO);
            }
            info.setOrderQty(skuInfo.getPurchaseCount());
            if (skuInfo.getIsUpdatePlan() == null) {
                skuInfo.setIsUpdatePlan(Long.valueOf(0L));
            }
            if (1L == skuInfo.getIsUpdatePlan()) {
                info.setPlanStatus("104");
            }
            planIds.add(info.getPlanId());
            this.planDiversionMapper.updateCount(info);
        }
    }

    private void updatePlan(List<OrdItemPO> ordItemList, String code) {
        for (OrdItemPO itemPO : ordItemList) {
            OrdPlanItemPO update = new OrdPlanItemPO();
            update.setUsedCount(itemPO.getPurchaseCount());
            update.setStatus(PebExtConstant.PlanStatus.USED.toString());
            update.setBuyOrderId(itemPO.getOrderId());
            update.setBuyOrderNo(code);
            update.setPlanItemId(itemPO.getPlanItemId());
            update.setSkuAgreementPrice(itemPO.getPurchasePrice());
            update.setSkuSalePrice(itemPO.getSalePrice());
            this.ordPlanItemDao.updateById(update);
        }
    }

    private void saveInvoice(PebExtAgreementCreateOrderReqBO reqBO, Long orderId, Long saleId) {
        if (reqBO.getInvoiceBO() != null) {
            Long contactId;
            if (reqBO.getInvoiceAddressInfo() != null) {
                UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = this.buildLogisticsRelaTionParam(orderId, reqBO.getInvoiceAddressInfo());
                UocCoreCreateLogisticsRelaRspBO uocCoreCreateLogisticsRelaRspBO = this.uocCoreCreateLogisticsRelaTionAtomService.dealCoreCreateLogisticsRela(uocCoreCreateLogisticsRelaReqBO);
                if (!"0000".equals(uocCoreCreateLogisticsRelaRspBO.getRespCode())) {
                    throw new UocProBusinessException("102107", uocCoreCreateLogisticsRelaRspBO.getRespDesc());
                }
                contactId = uocCoreCreateLogisticsRelaRspBO.getContactId();
            } else {
                contactId = saleId;
            }
            Long id = this.idUtil.nextId();
            OrdInvoicePO ordInvoicePO = new OrdInvoicePO();
            ordInvoicePO.setInvoiceUrl(reqBO.getInvoiceBO().getInvoiceUrl());
            ordInvoicePO.setBankAccount(reqBO.getInvoiceBO().getBankAccount());
            ordInvoicePO.setBuyerName(reqBO.getInvoiceBO().getBuyerName());
            ordInvoicePO.setCompanyAddress(reqBO.getInvoiceBO().getCompanyAddress());
            ordInvoicePO.setDepositBank(reqBO.getInvoiceBO().getDepositBank());
            ordInvoicePO.setFixPhone(reqBO.getInvoiceBO().getFixPhone());
            ordInvoicePO.setInvoiceNo(reqBO.getInvoiceBO().getInvoiceNo());
            ordInvoicePO.setInvoiceSn(reqBO.getInvoiceBO().getInvoiceSn());
            ordInvoicePO.setInvoiceType(reqBO.getInvoiceBO().getInvoiceType());
            ordInvoicePO.setRelaEmail(reqBO.getInvoiceBO().getRelaEmail());
            ordInvoicePO.setRelaPhone(reqBO.getInvoiceBO().getRelaPhone());
            ordInvoicePO.setOrderId(orderId);
            ordInvoicePO.setId(id);
            ordInvoicePO.setSaleVoucherId(contactId);
            ordInvoicePO.setOutInvoiceId(reqBO.getInvoiceBO().getUmcInvoiceId());
            ordInvoicePO.setInvoceCategory(reqBO.getInvoiceBO().getInvoceCategory());
            this.ordInvoiceMapper.insert(ordInvoicePO);
        }
    }

    private void editOrgAmount(PebExtAgreementCreateOrderReqBO reqBO) {
        SgOrgAmountDeductReqBO sgOrgAmountDeductReqBO = new SgOrgAmountDeductReqBO();
        sgOrgAmountDeductReqBO.setAmount(reqBO.getTotalAmount().divide(new BigDecimal(10000)).toString());
        sgOrgAmountDeductReqBO.setOrgId(reqBO.getOrgId());
        sgOrgAmountDeductReqBO.setBalanceType(PebExtConstant.BalanceType.ND);
        sgOrgAmountDeductReqBO.setOperType("2");
        SgOrgAmountDeductRspBO sgOrgAmountDeductRspBO = this.pebIntfSgOrgAmountDeductAbilityService.editOrgAmount(sgOrgAmountDeductReqBO);
        if (!("2".equals(reqBO.getMemUserType()) || "1".equals(reqBO.getMemUserType()) || "0000".equals(sgOrgAmountDeductRspBO.getRespCode()))) {
            throw new UocProBusinessException("102107", sgOrgAmountDeductRspBO.getRespDesc());
        }
    }

    private void saveExt(PebExtAgreementCreateOrderReqBO reqBO, Long orderId, List<OrdItemPO> ordItemList) {
        ArrayList<OrdExtMapPO> list = new ArrayList<OrdExtMapPO>();
        OrdExtMapPO payBusiType = new OrdExtMapPO();
        payBusiType.setId(Long.valueOf(this.idUtil.nextId()));
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList())) {
            payBusiType.setFieldValue("3");
        } else {
            payBusiType.setFieldValue(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getAgreementMode());
        }
        payBusiType.setFieldName("\u4e1a\u52a1\u7c7b\u578b");
        payBusiType.setFieldCode("payBusiType");
        payBusiType.setOrderId(orderId);
        payBusiType.setObjId(orderId);
        payBusiType.setObjType(UocConstant.OBJ_TYPE.ORDER);
        list.add(payBusiType);
        this.build("purUserNo", "\u91c7\u8d2d\u5458\u7f16\u7801", reqBO.getPurUserNo(), orderId, list);
        this.build("purUserName", "\u91c7\u8d2d\u5458\u540d\u79f0", reqBO.getPurUserName(), orderId, list);
        this.build("erpAgrNo", "\u91c7\u8d2d\u534f\u8bae\u7f16\u7801", reqBO.getErpAgrNo(), orderId, list);
        this.build("erpAgrName", "\u91c7\u8d2d\u534f\u8bae\u540d\u79f0", reqBO.getErpAgrName(), orderId, list);
        this.build("erpAgrId", "\u91c7\u8d2d\u534f\u8baeid", reqBO.getErpAgrId(), orderId, list);
        this.build("adjustType", "\u8c03\u4ef7\u65b9\u5f0f", reqBO.getAdjustType(), orderId, list);
        this.build("contractType", "\u5408\u540c\u7c7b\u578b", reqBO.getAgreementBO().getContractType() + "", orderId, list);
        this.build("createType", "\u5408\u540c\u8ba2\u5355\u4e0b\u5355\u65b9\u5f0f", reqBO.getCreateType(), orderId, list);
        if (list.size() > 0) {
            this.ordExtMapMapper.insertBatch(list);
        }
    }

    private void build(String key, String name, String val, Long orderId, List<OrdExtMapPO> list) {
        OrdExtMapPO extMapPO = new OrdExtMapPO();
        extMapPO.setId(Long.valueOf(this.idUtil.nextId()));
        extMapPO.setFieldValue(val);
        extMapPO.setFieldCode(key);
        extMapPO.setFieldName(name);
        extMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        extMapPO.setObjId(orderId);
        extMapPO.setOrderId(orderId);
        list.add(extMapPO);
    }

    private void saveAccessory(PebExtAgreementCreateOrderReqBO reqBO, Long orderId) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
            return;
        }
        ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>(reqBO.getAccessoryList().size());
        for (AccessoryBO accessoryBO : reqBO.getAccessoryList()) {
            OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordAccessoryPO.setCreateTime(new Date());
            ordAccessoryPO.setOrderId(orderId);
            ordAccessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.TYPE_AFTER_ORTHER);
            ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.ORDER);
            ordAccessoryPO.setAccessoryName(accessoryBO.getAccessoryName());
            ordAccessoryPO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
            ordAccessoryPO.setAccessoryId(accessoryBO.getAccessoryId());
            ordAccessoryPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            ordAccessoryPO.setObjectId(orderId);
            ordAccessoryPO.setRemark("CREATE_ORDER");
            list.add(ordAccessoryPO);
        }
        this.ordAccessoryMapper.insertBatch(list);
    }

    private AtomUocCoreCreateOrderReqBO buildCreateOrderParam(Long orderId, PebExtAgreementCreateOrderReqBO reqBO, UocCoreCreateSaleOrderReqBO uocCoreCreateSaleOrderReqBO) {
        AtomUocCoreCreateOrderReqBO uocCoreCreateOrderReqBO = new AtomUocCoreCreateOrderReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uocCoreCreateOrderReqBO);
        uocCoreCreateOrderReqBO.setPlanHt(reqBO.getPlanHt());
        if (!this.dzsw.equals(reqBO.getAgreementBO().getProfessionalOrgId())) {
            uocCoreCreateOrderReqBO.setOperationArea(null);
            uocCoreCreateOrderReqBO.setOperationAreaStr(null);
            reqBO.setOperationArea(null);
            reqBO.setOperationAreaStr(null);
        }
        if (reqBO.getIsTax() == null) {
            uocCoreCreateOrderReqBO.setExt4("0");
        } else {
            uocCoreCreateOrderReqBO.setExt4(reqBO.getIsTax() + "");
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getLoginSource())) {
            uocCoreCreateOrderReqBO.setExtField2(reqBO.getLoginSource());
        }
        if (((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getContractId() != null) {
            uocCoreCreateOrderReqBO.setExtField3(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getContractId().toString());
        }
        uocCoreCreateOrderReqBO.setUserId(reqBO.getUserId());
        uocCoreCreateOrderReqBO.setOrgId(reqBO.getOrgId());
        uocCoreCreateOrderReqBO.setUserType(reqBO.getMemUserType());
        uocCoreCreateOrderReqBO.setCompanyId(reqBO.getCompanyId());
        uocCoreCreateOrderReqBO.setCompanyName(reqBO.getCompanyName());
        uocCoreCreateOrderReqBO.setOrderName(reqBO.getOrderName());
        if (reqBO.getOrgLevel() != null) {
            uocCoreCreateOrderReqBO.setOrgLevel(reqBO.getOrgLevel());
        }
        uocCoreCreateOrderReqBO.setOrderId(orderId);
        uocCoreCreateOrderReqBO.setOrderNo(CommUtils.long2String((Long)orderId));
        Integer isGoods = 1;
        if (PebExtConstant.YES.equals(reqBO.getIsPersonal())) {
            if (CollectionUtils.isEmpty((Collection)((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getItemFlBOList())) {
                uocCoreCreateOrderReqBO.setIndividuallyPayType(Integer.valueOf(1));
                uocCoreCreateOrderReqBO.setOrderType(PebExtConstant.OrderType.GC);
            } else {
                uocCoreCreateOrderReqBO.setOrderType(PebExtConstant.OrderType.FL);
                if (uocCoreCreateSaleOrderReqBO.getTotalIntegralFee() != null && uocCoreCreateSaleOrderReqBO.getSaleFee() - uocCoreCreateSaleOrderReqBO.getTotalIntegralFee() > 0L) {
                    uocCoreCreateOrderReqBO.setIndividuallyPayType(Integer.valueOf(3));
                } else {
                    uocCoreCreateOrderReqBO.setIndividuallyPayType(Integer.valueOf(2));
                }
            }
        } else if (isGoods.equals(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getItemType())) {
            uocCoreCreateOrderReqBO.setOrderType(PebExtConstant.OrderType.CX_AGR_GOODS);
        } else {
            uocCoreCreateOrderReqBO.setOrderType(PebExtConstant.OrderType.CX_AGR);
        }
        reqBO.setOrderType(uocCoreCreateOrderReqBO.getOrderType());
        uocCoreCreateOrderReqBO.setPayType(String.valueOf(reqBO.getPayType()));
        Long saleFee = MoneyUtil.b2L((BigDecimal)reqBO.getTotalAmount());
        uocCoreCreateOrderReqBO.setSaleFee(saleFee);
        uocCoreCreateOrderReqBO.setCreateOperId(CommUtils.long2String((Long)reqBO.getUserId()));
        uocCoreCreateOrderReqBO.setOrderDesc(reqBO.getComment());
        uocCoreCreateOrderReqBO.setPurId(CommUtils.long2String((Long)reqBO.getOrgId()));
        uocCoreCreateOrderReqBO.setPurName(reqBO.getOrgName());
        uocCoreCreateOrderReqBO.setPurAccount(String.valueOf(reqBO.getPurchaserAccount()));
        uocCoreCreateOrderReqBO.setPurAccountName(reqBO.getPurchaserAccountName());
        uocCoreCreateOrderReqBO.setPurPlaceOrderId(String.valueOf(reqBO.getUserId()));
        uocCoreCreateOrderReqBO.setPurPlaceOrderName(reqBO.getUsername());
        uocCoreCreateOrderReqBO.setPurOrgId(CommUtils.long2String((Long)reqBO.getOrgId()));
        uocCoreCreateOrderReqBO.setPurOrgPath(reqBO.getOrgPath());
        uocCoreCreateOrderReqBO.setSupId(reqBO.getAgreementBO().getVendorId());
        uocCoreCreateOrderReqBO.setSupName(reqBO.getAgreementBO().getVendorName());
        uocCoreCreateOrderReqBO.setProId(CommUtils.long2String((Long)reqBO.getProfessionalOrganizationId()));
        uocCoreCreateOrderReqBO.setPurAccountOwnId(CommUtils.long2String((Long)reqBO.getPurchaserAccountOrgId()));
        EnterpriseAccountBO accountBO = reqBO.getEnterpriseAccountBO();
        if (accountBO != null) {
            uocCoreCreateOrderReqBO.setPurAccountName(accountBO.getAccountName());
            uocCoreCreateOrderReqBO.setPurAccountOwnName(accountBO.getAccountName());
        }
        uocCoreCreateOrderReqBO.setPurMobile(reqBO.getCellphone());
        uocCoreCreateOrderReqBO.setPurRelaMobile(reqBO.getCellphone());
        uocCoreCreateOrderReqBO.setPurRelaName(reqBO.getUsername());
        uocCoreCreateOrderReqBO.setProName(reqBO.getProOrgName());
        uocCoreCreateOrderReqBO.setProAccountOwnName(reqBO.getProPath());
        uocCoreCreateOrderReqBO.setProRelaName(reqBO.getProRealName());
        uocCoreCreateOrderReqBO.setProAccountRelaMobile(reqBO.getProPhone());
        if (reqBO.getProAccount() != null) {
            uocCoreCreateOrderReqBO.setProAccount(String.valueOf(reqBO.getProAccount()));
        }
        uocCoreCreateOrderReqBO.setProDeliveryId(String.valueOf(reqBO.getAgreementBO().getProducerId()));
        uocCoreCreateOrderReqBO.setProDeliveryName(reqBO.getAgreementBO().getProducerName());
        uocCoreCreateOrderReqBO.setPurLogName(reqBO.getCreateName());
        return uocCoreCreateOrderReqBO;
    }

    private UocCoreCreatePayOrderReqBO buildCreatePayOrderParam(Long orderId, PebExtAgreementCreateOrderReqBO reqBO, List<OrdItemPO> ordItemPOS, Long saleOrderId) {
        UocCoreCreatePayOrderReqBO payOrderReqBO = new UocCoreCreatePayOrderReqBO();
        payOrderReqBO.setPayVoucherNo(DateUtils.dateToStr((Date)new Date(), (String)"yyyyMMdd") + orderId);
        payOrderReqBO.setOrderId(orderId);
        payOrderReqBO.setObjId(saleOrderId);
        payOrderReqBO.setObjType(UocConstant.ORDER_TYPE.SALE_ORDER);
        payOrderReqBO.setInterType(PecConstant.PAY_FLAG);
        if (reqBO.getPayTypeIn() != null) {
            payOrderReqBO.setPayType(reqBO.getPayTypeIn());
        } else {
            payOrderReqBO.setPayType(reqBO.getPayType());
        }
        payOrderReqBO.setFeeType(PecConstant.FEE_TYPE_SALE);
        try {
            payOrderReqBO.setTotalFee(Long.valueOf(reqBO.getTotalAmount().longValue()));
            payOrderReqBO.setPreFee(Long.valueOf(reqBO.getPreFee().longValue()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102107", "\u603b\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        try {
            if (reqBO.getActPrice() == null) {
                reqBO.setActPrice(BigDecimal.ZERO);
            }
            if (reqBO.getReducedPrice() == null) {
                reqBO.setReducedPrice(BigDecimal.ZERO);
            }
            Long disPrice = MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getReducedPrice());
            Long actFee = MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getActPrice());
            Long totalPrice = payOrderReqBO.getTotalFee();
            payOrderReqBO.setReduceFee(disPrice);
            payOrderReqBO.setActFee(actFee);
            payOrderReqBO.setTotalFee(totalPrice);
            payOrderReqBO.setPayFee(payOrderReqBO.getTotalFee());
        }
        catch (Exception e) {
            throw new UocProBusinessException("102107", "\u603b\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        if (payOrderReqBO.getPayFee().equals(payOrderReqBO.getRedEnvelopeFee())) {
            payOrderReqBO.setPayTime(new Date());
            payOrderReqBO.setPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
        } else {
            payOrderReqBO.setPayState(UocConstant.PAY_ORDER_STATUS.UNPAID);
        }
        payOrderReqBO.setCreateOperId(CommUtils.long2String((Long)reqBO.getUserId()));
        ArrayList<UocOrderPayItemBO> uocOrderPayItemBOList = new ArrayList<UocOrderPayItemBO>();
        OrdItemPO ordItemPO = null;
        UocOrderPayItemBO uocOrderPayItemBO = null;
        Iterator<OrdItemPO> iterator = ordItemPOS.iterator();
        while (iterator.hasNext()) {
            OrdItemPO ordItemPO1;
            ordItemPO = ordItemPO1 = iterator.next();
            uocOrderPayItemBO = new UocOrderPayItemBO();
            uocOrderPayItemBO.setPayObjType(PecConstant.PAY_OBJ_TYPE_SALE_ORDER_ITEM);
            uocOrderPayItemBO.setPurchaseCount(ordItemPO.getPurchaseCount());
            uocOrderPayItemBO.setOrdItemId(ordItemPO.getOrdItemId());
            uocOrderPayItemBO.setPayObjId(ordItemPO.getOrdItemId());
            uocOrderPayItemBO.setCurrencyType(ordItemPO.getCurrencyType());
            uocOrderPayItemBO.setPayCount(ordItemPO.getPurchaseCount());
            uocOrderPayItemBO.setUnitName(ordItemPO.getUnitName());
            uocOrderPayItemBO.setSalePrice(ordItemPO.getSalePrice());
            uocOrderPayItemBO.setPurchasePrice(ordItemPO.getPurchasePrice());
            uocOrderPayItemBO.setTotalFee(ordItemPO.getTotalSaleFee());
            uocOrderPayItemBO.setRedEnvelopeFee(ordItemPO.getRedEnvelopeFee());
            uocOrderPayItemBO.setReduceFee(ordItemPO.getDisPrice());
            if (ordItemPO.getDisPrice() == null) {
                ordItemPO.setDisPrice(Long.valueOf(0L));
            }
            if (ordItemPO.getActShareFee() == null) {
                ordItemPO.setActShareFee(Long.valueOf(0L));
            }
            uocOrderPayItemBO.setPayFee(ordItemPO.getPreFee());
            uocOrderPayItemBO.setActFee(ordItemPO.getActShareFee());
            uocOrderPayItemBO.setPreFee(ordItemPO.getPreFee());
            uocOrderPayItemBO.setTotalPurchaseDecimalPrice(ordItemPO.getTotalPurchaseDecimalPrice());
            uocOrderPayItemBO.setTotalSaleDecimalPrice(ordItemPO.getTotalSaleDecimalPrice());
            uocOrderPayItemBO.setSaleDecimalPrice(ordItemPO.getSaleDecimalPrice());
            uocOrderPayItemBO.setPurchaseDecimalPrice(ordItemPO.getPurchaseDecimalPrice());
            uocOrderPayItemBOList.add(uocOrderPayItemBO);
        }
        payOrderReqBO.setUocOrderPayItemList(uocOrderPayItemBOList);
        return payOrderReqBO;
    }

    private UocCoreCreateSaleOrderReqBO buildCreateSaleOrderParam(PebExtAgreementCreateOrderReqBO reqBO, Long orderId, Long contactId) {
        UocCoreCreateSaleOrderReqBO uocCoreCreateSaleOrderReqBO = new UocCoreCreateSaleOrderReqBO();
        uocCoreCreateSaleOrderReqBO.setExt4(reqBO.getErpStorage());
        if (reqBO.getAgreementBO().getAgreementSrc() != null && reqBO.getAgreementBO().getAgreementSrc() == 2) {
            uocCoreCreateSaleOrderReqBO.setExt2(reqBO.getAgreementBO().getEntAgreementCode());
        }
        uocCoreCreateSaleOrderReqBO.setExt5(reqBO.getAgreementBO().getProfessionalOrgId());
        ArrayList<UocOrderItemBO> uocOrderItemList = new ArrayList<UocOrderItemBO>();
        Long purchaseFee = 0L;
        BigDecimal totalAm = BigDecimal.ZERO;
        BigDecimal totalPre = BigDecimal.ZERO;
        Long serPrice = 0L;
        BigDecimal actFee = BigDecimal.ZERO;
        if (null != reqBO.getAgreementBO().getServiceRate() && reqBO.getAgreementBO().getServiceRate() > 0.0) {
            BigDecimal serviceRate = BigDecimal.valueOf(reqBO.getAgreementBO().getServiceRate());
            serPrice = serviceRate.multiply(new BigDecimal(10000)).longValue();
        }
        for (PebExtAgreementSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
            CommonCenterFieldValueBO valueBO;
            UocOrderItemBO uocOrderItemBO = new UocOrderItemBO();
            BeanUtils.copyProperties((Object)skuInfo, (Object)uocOrderItemBO);
            uocOrderItemBO.setInspectionExcessPercent(skuInfo.getInspectionExcessPercent());
            if (!ObjectUtil.isEmpty((Object)skuInfo.getPlanItemNo())) {
                uocOrderItemBO.setPlanItemNo(skuInfo.getPlanItemNo());
            }
            uocOrderItemBO.setSerPrice(serPrice);
            uocOrderItemBO.setTempId(skuInfo.getTempId());
            if (CollectionUtils.isNotEmpty((Collection)skuInfo.getItemFlBOList())) {
                BigDecimal fee = BigDecimal.ZERO;
                for (UocOrdItemFlBO flBO : skuInfo.getItemFlBOList()) {
                    fee = fee.add(flBO.getFee());
                    flBO.setOrderId(orderId);
                    flBO.setRetrunFee(BigDecimal.ZERO);
                    actFee = actFee.add(flBO.getFee());
                }
                try {
                    skuInfo.setIntegralFee(fee);
                    uocOrderItemBO.setIntegralFee(MoneyUtils.BigDecimal2Long((BigDecimal)fee));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                uocOrderItemBO.setItemFlBOList(skuInfo.getItemFlBOList());
            }
            uocOrderItemBO.setItemType(PecConstant.ORD_SALE_ITEM_TYPE_SKU);
            uocOrderItemBO.setTax(skuInfo.getTax());
            uocOrderItemBO.setSkuId(skuInfo.getSkuId());
            uocOrderItemBO.setSkuItemId(skuInfo.getItemId());
            uocOrderItemBO.setSkuName(skuInfo.getSkuName());
            uocOrderItemBO.setTaxId(skuInfo.getTaxCode());
            uocOrderItemBO.setSkuSimpleName(skuInfo.getSkuSupplierName());
            uocOrderItemBO.setSupNo(String.valueOf(skuInfo.getGoodsSupplierId()));
            uocOrderItemBO.setSupplierShopId(skuInfo.getSupplierShopId());
            if (skuInfo.getAgrItemId() == null) {
                uocOrderItemBO.setExtField1(String.valueOf(skuInfo.getAgreementDetailsId()));
            } else {
                uocOrderItemBO.setExtField1(String.valueOf(skuInfo.getAgrItemId()));
            }
            if (StringUtils.isNotBlank((CharSequence)skuInfo.getSkuMaterialLongDesc())) {
                uocOrderItemBO.setExtField2(skuInfo.getSkuMaterialLongDesc());
            } else {
                uocOrderItemBO.setExtField2(skuInfo.getSkuMaterialName());
            }
            uocOrderItemBO.setExtField3(skuInfo.getSkuMaterialUnit());
            if (PebExtConstant.YES.equals(reqBO.getIsPushErp())) {
                uocOrderItemBO.setExtField4("0");
            } else {
                uocOrderItemBO.setExtField4("4");
            }
            uocOrderItemBO.setExtField5("0");
            uocOrderItemBO.setPlanId(skuInfo.getPlanId());
            uocOrderItemBO.setPlanItemNo(skuInfo.getPlanItemNo());
            uocOrderItemBO.setExtField6(skuInfo.getExtField6());
            uocOrderItemBO.setExtField7(skuInfo.getExtField7());
            Long skuSalePrice = 0L;
            Long skupurchasePrice = 0L;
            Long skuSaleFee = 0L;
            Long skuPurchaseFee = 0L;
            Long redEnvelopeFee = 0L;
            Long disPricel = 0L;
            try {
                skuSalePrice = MoneyUtils.BigDecimalToLong((BigDecimal)skuInfo.getSkuSalePrice());
                skupurchasePrice = MoneyUtils.BigDecimalToLong((BigDecimal)skuInfo.getSkuAgreementPrice());
                BigDecimal divide = skuInfo.getSkuSalePrice().multiply(skuInfo.getPurchaseCount());
                skuSaleFee = MoneyUtils.BigDecimalToLong((BigDecimal)divide);
                BigDecimal multiply = skuInfo.getSkuAgreementPrice().multiply(skuInfo.getPurchaseCount());
                skuPurchaseFee = MoneyUtils.BigDecimalToLong((BigDecimal)multiply);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UocProBusinessException("102107", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38!");
            }
            if (skuInfo.getAddCoefficient() != null) {
                uocOrderItemBO.setMarkUpRate(Double.valueOf(skuInfo.getAddCoefficient().doubleValue()));
            }
            uocOrderItemBO.setSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)skuInfo.getSkuSalePrice()));
            uocOrderItemBO.setSupAccount(skuInfo.getPurchaseSchemePacketNo());
            uocOrderItemBO.setPurchaseDecimalPrice(MoneyUtil.b2B((BigDecimal)skuInfo.getSkuAgreementPrice()));
            uocOrderItemBO.setTotalSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)skuInfo.getSkuSalePrice()).multiply(skuInfo.getPurchaseCount()).setScale(2, 4));
            uocOrderItemBO.setTotalPurchaseDecimalPrice(MoneyUtil.b2B((BigDecimal)skuInfo.getSkuAgreementPrice()).multiply(skuInfo.getPurchaseCount()).setScale(2, 4));
            try {
                purchaseFee = purchaseFee + MoneyUtils.BigDecimal2Long((BigDecimal)uocOrderItemBO.getTotalPurchaseDecimalPrice());
                totalAm = totalAm.add(uocOrderItemBO.getTotalSaleDecimalPrice());
            }
            catch (Exception e) {
                // empty catch block
            }
            uocOrderItemBO.setPreFee(skuInfo.getIsUpdatePlan());
            uocOrderItemBO.setRedEnvelopeFee(redEnvelopeFee);
            uocOrderItemBO.setDisPrice(disPricel);
            uocOrderItemBO.setRedEnvelopeFee(redEnvelopeFee);
            if (StringUtils.isBlank((CharSequence)skuInfo.getArrivalTime())) {
                uocOrderItemBO.setArrivalTime(this.maxShipTime);
            } else {
                uocOrderItemBO.setArrivalTime(skuInfo.getArrivalTime());
            }
            uocOrderItemBO.setSalePrice(skuSalePrice);
            uocOrderItemBO.setPurchasePrice(skupurchasePrice);
            uocOrderItemBO.setTotalSaleFee(skuSaleFee);
            uocOrderItemBO.setTotalPurchaseFee(skuPurchaseFee);
            uocOrderItemBO.setCurrencyType(skuInfo.getSkuCurrencyType());
            uocOrderItemBO.setRecvAddr(skuInfo.getComparisonGoodsNo());
            uocOrderItemBO.setUnitName(skuInfo.getMeasureName());
            uocOrderItemBO.setSettleUnit(skuInfo.getSettlementUnit());
            if (StringUtils.isNotBlank((CharSequence)skuInfo.getSettlementUnit())) {
                uocOrderItemBO.setSalesUnitRate(skuInfo.getSalesUnitRate());
            }
            uocOrderItemBO.setPurchaseCount(skuInfo.getPurchaseCount());
            ArrayList uocOrderItemEwBOList = new ArrayList();
            uocOrderItemBO.setUocOrderItemEwList(uocOrderItemEwBOList);
            ArrayList<UocOrderGoodsGiftBO> uocOrderGoodsGiftBOList = new ArrayList<UocOrderGoodsGiftBO>();
            List orderSaleGiftList = skuInfo.getUocOrderGoodsGiftBOList();
            if (!CollectionUtils.isEmpty((Collection)orderSaleGiftList)) {
                UocOrderGoodsGiftBO orderGoodsGiftBO = null;
                for (Object goodsGiftBO : orderSaleGiftList) {
                    orderGoodsGiftBO = new UocOrderGoodsGiftBO();
                    orderGoodsGiftBO.setGiftSkuId(goodsGiftBO.getGiftSkuId());
                    orderGoodsGiftBO.setGiftNum(Integer.valueOf(goodsGiftBO.getGiftNum().intValue()));
                    orderGoodsGiftBO.setGiftType(goodsGiftBO.getGiftType());
                    uocOrderGoodsGiftBOList.add(orderGoodsGiftBO);
                }
            }
            uocOrderItemBO.setUocOrderGoodsGiftList(uocOrderGoodsGiftBOList);
            OrdGoodsBO ordGoodsBO = new OrdGoodsBO();
            ordGoodsBO.setTotalPurchaseDecimalPrice(uocOrderItemBO.getTotalPurchaseDecimalPrice());
            ordGoodsBO.setTotalSaleDecimalPrice(uocOrderItemBO.getTotalSaleDecimalPrice());
            ordGoodsBO.setSaleDecimalPrice(uocOrderItemBO.getSaleDecimalPrice());
            ordGoodsBO.setPurchaseDecimalPrice(uocOrderItemBO.getPurchaseDecimalPrice());
            BeanUtils.copyProperties((Object)skuInfo, (Object)ordGoodsBO);
            ordGoodsBO.setSupplierShopName(skuInfo.getSupplierShopName());
            ordGoodsBO.setSkuDetail(skuInfo.getSkuDetail());
            ordGoodsBO.setSkuId(skuInfo.getSkuId() + "");
            ordGoodsBO.setSkuName(skuInfo.getSkuName());
            ordGoodsBO.setSkuSupplierId(skuInfo.getSkuSupplierId());
            ordGoodsBO.setSkuSupplierName(skuInfo.getSkuSupplierName());
            ordGoodsBO.setSkuMaterialId(skuInfo.getSkuMaterialId());
            ordGoodsBO.setSkuMaterialName(skuInfo.getSkuMaterialName());
            ordGoodsBO.setSkuExtSkuId(skuInfo.getSkuExtSkuId());
            ordGoodsBO.setSkuItemId(skuInfo.getItemId());
            ordGoodsBO.setSkuUpcCode(skuInfo.getSkuUpcCode());
            ordGoodsBO.setSkuCommodityTypeId(skuInfo.getSkuCommodityTypeId());
            ordGoodsBO.setSkuLocation(skuInfo.getSkuLocation());
            ordGoodsBO.setSkuMainPicUrl(skuInfo.getSkuMainPicUrl());
            ordGoodsBO.setSkuDetail(skuInfo.getSkuDetail());
            ordGoodsBO.setSkuSaleArea(skuInfo.getSkuSaleArea());
            ordGoodsBO.setSkuStatus(skuInfo.getSkuStatus());
            if (StringUtils.isNotBlank((CharSequence)skuInfo.getBrandId())) {
                ordGoodsBO.setSkuBrandId(CommUtils.string2Long((String)skuInfo.getBrandId()));
            }
            ordGoodsBO.setSkuBrandName(skuInfo.getSkuBrandName());
            ordGoodsBO.setSkuIsSupplierAgreement(skuInfo.getSkuIsSupplierAgreement());
            try {
                ordGoodsBO.setSkuMarketPrice(MoneyUtils.BigDecimalToLong((BigDecimal)skuInfo.getSkuMarketPrice()));
                ordGoodsBO.setSkuAgreementPrice(MoneyUtils.BigDecimalToLong((BigDecimal)skuInfo.getSkuAgreementPrice()));
                ordGoodsBO.setSkuMemberPrice(MoneyUtils.BigDecimalToLong((BigDecimal)skuInfo.getSkuMemberPrice()));
                ordGoodsBO.setSkuSalePrice(MoneyUtils.BigDecimalToLong((BigDecimal)skuInfo.getSkuSalePrice()));
            }
            catch (Exception e) {
                throw new UocProBusinessException("102107", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38!");
            }
            ordGoodsBO.setSkuCurrencyType(skuInfo.getSkuCurrencyType());
            ordGoodsBO.setSupplierShopId(skuInfo.getSupplierShopId());
            ArrayList<OrdGoodsAttrBO> ordGoodsAttrBOList = new ArrayList<OrdGoodsAttrBO>();
            if (CollectionUtils.isNotEmpty((Collection)skuInfo.getCommodityAttrList())) {
                Object goodsGiftBO;
                goodsGiftBO = skuInfo.getCommodityAttrList().iterator();
                while (goodsGiftBO.hasNext()) {
                    CommodityAttrRspBO commodityAttrRspBO = (CommodityAttrRspBO)goodsGiftBO.next();
                    OrdGoodsAttrBO ordGoodsAttrBO = new OrdGoodsAttrBO();
                    ordGoodsAttrBO.setSkuCommodityId(commodityAttrRspBO.getSkuCommodityId());
                    ordGoodsAttrBO.setSkuCommodityPropGrpId(commodityAttrRspBO.getSkuCommodityPropGrpId());
                    ordGoodsAttrBO.setSkuCommoditySpecId(commodityAttrRspBO.getSkuCommoditySpecId());
                    ordGoodsAttrBO.setSkuPropName(commodityAttrRspBO.getSkuPropName());
                    ordGoodsAttrBO.setSkuPropShowName(commodityAttrRspBO.getSkuPropShowName());
                    ordGoodsAttrBO.setSkuPropValue(commodityAttrRspBO.getSkuPropValue());
                    ordGoodsAttrBO.setSkuPropValueListId(commodityAttrRspBO.getSkuPropValueListId());
                    ordGoodsAttrBOList.add(ordGoodsAttrBO);
                }
                if (skuInfo.getServenRejectAllow() != null && skuInfo.getServenRejectAllow().equals(PecConstant.SERVEN_REJECT_ALLOW)) {
                    OrdGoodsAttrBO ordGoodsAttrBO = new OrdGoodsAttrBO();
                    ordGoodsAttrBO.setSkuCommodityId(skuInfo.getSpuId());
                    ordGoodsAttrBO.setSkuCommodityPropGrpId(null);
                    ordGoodsAttrBO.setSkuCommoditySpecId(null);
                    ordGoodsAttrBO.setSkuPropName("\u4e03\u5929\u9000\u6362");
                    ordGoodsAttrBO.setSkuPropShowName("\u4e03\u5929\u9000\u6362");
                    ordGoodsAttrBO.setSkuPropValue("\u4e03\u5929\u9000\u6362");
                    ordGoodsAttrBO.setSkuPropValueListId(null);
                    ordGoodsAttrBOList.add(ordGoodsAttrBO);
                }
            }
            ordGoodsBO.setOrdGoodsAttrBOList(ordGoodsAttrBOList);
            if (StringUtils.isBlank((CharSequence)skuInfo.getWzRemark())) {
                ordGoodsBO.setSkuMaterialRemark(skuInfo.getMaterialRemark());
            } else {
                ordGoodsBO.setSkuMaterialRemark(skuInfo.getWzRemark());
            }
            ordGoodsBO.setMaterialBj(skuInfo.getPartNo());
            if (StringUtils.isBlank((CharSequence)skuInfo.getZlRequire())) {
                ordGoodsBO.setExt1(skuInfo.getTechnicalParam());
            } else {
                ordGoodsBO.setExt1(skuInfo.getZlRequire());
            }
            ordGoodsBO.setExt4(skuInfo.getPlanItemCode());
            ordGoodsBO.setExt6(skuInfo.getPlanItemName());
            uocOrderItemBO.setOrdGoodsBO(ordGoodsBO);
            uocOrderItemBO.setSpuId(skuInfo.getSpuId() + "");
            uocOrderItemBO.setOrganizationId(skuInfo.getOrganizationId());
            uocOrderItemBO.setOrganizationName(skuInfo.getOrganizationName());
            uocOrderItemBO.setOrganizationCode(skuInfo.getOrganizationCode());
            uocOrderItemBO.setPlanItemId(skuInfo.getLineId());
            if (skuInfo.getPlanId() != null) {
                uocOrderItemBO.setPlanId(skuInfo.getPlanId());
            }
            ArrayList<CommonCenterFieldValueBO> uocOrderItemFiledList = new ArrayList<CommonCenterFieldValueBO>();
            if (!CollectionUtils.isEmpty((Collection)uocOrderItemBO.getUocOrderItemFiledList())) {
                BeanUtils.copyProperties((Object)uocOrderItemBO.getUocOrderItemFiledList(), uocOrderItemFiledList);
            }
            if (skuInfo.getInboundPath() != null) {
                valueBO = new CommonCenterFieldValueBO();
                valueBO.setFieldValue(skuInfo.getInboundPath());
                valueBO.setFieldCode("inboundPath");
                valueBO.setFieldName("\u5165\u5e93\u8def\u5f84");
                uocOrderItemFiledList.add(valueBO);
            }
            if (skuInfo.getInboundPathId() != null) {
                valueBO = new CommonCenterFieldValueBO();
                valueBO.setFieldValue(skuInfo.getInboundPathId());
                valueBO.setFieldCode("inboundPathId");
                valueBO.setFieldName("\u5165\u5e93\u8def\u5f84-\u6620\u5c04\u540e\u5e93\u5b58\u7ec4\u7ec7id");
                uocOrderItemFiledList.add(valueBO);
            }
            uocOrderItemBO.setUocOrderItemFiledList(uocOrderItemFiledList);
            uocOrderItemList.add(uocOrderItemBO);
        }
        reqBO.setTotalAmount(totalAm);
        BeanUtils.copyProperties((Object)reqBO, (Object)uocCoreCreateSaleOrderReqBO);
        String giveTime = ((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getGiveTime();
        if (StringUtils.isNotBlank((CharSequence)giveTime)) {
            uocCoreCreateSaleOrderReqBO.setGiveTime(giveTime);
        }
        Integer[] tyep = new Integer[]{21, 20, 13, 12, 11, 9, 22};
        List<Integer> cy = Arrays.asList(tyep);
        boolean flag = true;
        if (cy.contains(reqBO.getAgreementBO().getContractType())) {
            flag = false;
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateType()) && !"1".equals(reqBO.getCreateType())) {
            flag = false;
        }
        if (!flag) {
            if (this.use.booleanValue()) {
                reqBO.setProcKey("cnnc_ht_sale_order_master_order_status");
            }
            uocCoreCreateSaleOrderReqBO.setOrderSource("4");
        } else {
            uocCoreCreateSaleOrderReqBO.setOrderSource(reqBO.getOrderSource());
        }
        uocCoreCreateSaleOrderReqBO.setAgreementBO(reqBO.getAgreementBO());
        uocCoreCreateSaleOrderReqBO.setSaleVoucherNo(this.buildNo("YG", "SALE_ORDER_NO", uocCoreCreateSaleOrderReqBO.getOrderSource(), reqBO));
        uocCoreCreateSaleOrderReqBO.setPurchaseNo(uocCoreCreateSaleOrderReqBO.getSaleVoucherNo());
        uocCoreCreateSaleOrderReqBO.setOrderId(orderId);
        uocCoreCreateSaleOrderReqBO.setOrderLevel(Integer.valueOf(2));
        reqBO.setOrderSource(uocCoreCreateSaleOrderReqBO.getOrderSource());
        uocCoreCreateSaleOrderReqBO.setPurchaseType(Integer.valueOf(reqBO.getOrderSource()));
        uocCoreCreateSaleOrderReqBO.setIsDispatch(PecConstant.IS_DISPATCH_YES);
        Long base = 0L;
        Long remote = 0L;
        Long total = 0L;
        Long saleFee = 0L;
        try {
            total = MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getTatleTransportationFee());
            saleFee = MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getTotalAmount());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102107", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38!");
        }
        if (total == null) {
            total = 0L;
        }
        uocCoreCreateSaleOrderReqBO.setBaseTransFee(base);
        uocCoreCreateSaleOrderReqBO.setRemoteTransFee(remote);
        uocCoreCreateSaleOrderReqBO.setTotalTransFee(total);
        uocCoreCreateSaleOrderReqBO.setOldTotalTransFee(total);
        uocCoreCreateSaleOrderReqBO.setSaleFee(saleFee);
        uocCoreCreateSaleOrderReqBO.setContactId(contactId);
        uocCoreCreateSaleOrderReqBO.setAccNbr(reqBO.getAddressInfo().getReceiverMobileNumber());
        uocCoreCreateSaleOrderReqBO.setProvinceId(reqBO.getAddressInfo().getReceiverProvinceId());
        uocCoreCreateSaleOrderReqBO.setCityId(reqBO.getAddressInfo().getReceiverCityId());
        uocCoreCreateSaleOrderReqBO.setAreaId(reqBO.getAddressInfo().getReceiverCountyId());
        uocCoreCreateSaleOrderReqBO.setAddress(reqBO.getAddressInfo().getReceiverAddress());
        uocCoreCreateSaleOrderReqBO.setPurchaseFee(purchaseFee);
        uocCoreCreateSaleOrderReqBO.setUocOrderItemList(uocOrderItemList);
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList())) {
            ArrayList<UocCoreAddOrdSaleCouponInfoBO> list = new ArrayList<UocCoreAddOrdSaleCouponInfoBO>();
            for (UocCoreActiveReqBO activeReqBO : reqBO.getActiveBOList()) {
                UocCoreAddOrdSaleCouponInfoBO infoBO = new UocCoreAddOrdSaleCouponInfoBO();
                infoBO.setCouponGranter("");
                infoBO.setCouponName(activeReqBO.getActiveName());
                infoBO.setCouponNo(activeReqBO.getActiveId());
                infoBO.setCouponValue(uocCoreCreateSaleOrderReqBO.getSaleFee());
                infoBO.setTypeName(activeReqBO.getTypeName());
                infoBO.setCouponGranter(reqBO.getActiveNo());
                infoBO.setType("11111");
                infoBO.setCouponGranter(reqBO.getActiveNo());
                list.add(infoBO);
            }
            uocCoreCreateSaleOrderReqBO.setUocCoreAddOrdSaleCouponInfoBOList(list);
            uocCoreCreateSaleOrderReqBO.setTotalIntegralFee(uocCoreCreateSaleOrderReqBO.getSaleFee());
            uocCoreCreateSaleOrderReqBO.setTotalUsedIntegral(uocCoreCreateSaleOrderReqBO.getSaleFee());
        }
        try {
            uocCoreCreateSaleOrderReqBO.setTotalIntegralFee(MoneyUtils.BigDecimal2Long((BigDecimal)actFee));
        }
        catch (Exception exception) {
            // empty catch block
        }
        uocCoreCreateSaleOrderReqBO.setTotalUsedIntegral(uocCoreCreateSaleOrderReqBO.getTotalIntegralFee());
        uocCoreCreateSaleOrderReqBO.setAgreementMode(Integer.valueOf(Integer.parseInt(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getAgreementMode())));
        uocCoreCreateSaleOrderReqBO.setModelSettle(reqBO.getAgreementBO().getTradeMode());
        uocCoreCreateSaleOrderReqBO.setContractId(reqBO.getContractId());
        if (UocConstant.ORDER_SOURCE.CONTRACT.toString().equals(uocCoreCreateSaleOrderReqBO.getOrderSource()) && reqBO.getContractId() == null && StringUtils.isNotBlank((CharSequence)reqBO.getAgreementBO().getAgreementId())) {
            uocCoreCreateSaleOrderReqBO.setContractId(Long.valueOf(reqBO.getAgreementBO().getAgreementId()));
        }
        return uocCoreCreateSaleOrderReqBO;
    }

    private UocCoreCreateLogisticsRelaReqBO buildLogisticsRelaTionParam(Long orderId, PebExtAddressInfoIntfceReqBO addressInfoIntfceBO) {
        UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = new UocCoreCreateLogisticsRelaReqBO();
        uocCoreCreateLogisticsRelaReqBO.setOrderId(orderId);
        uocCoreCreateLogisticsRelaReqBO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        uocCoreCreateLogisticsRelaReqBO.setContactTown(addressInfoIntfceBO.getReceiverTown());
        uocCoreCreateLogisticsRelaReqBO.setContactTownId(addressInfoIntfceBO.getReceiverTownId());
        uocCoreCreateLogisticsRelaReqBO.setContactAddress(addressInfoIntfceBO.getReceiverAddress());
        uocCoreCreateLogisticsRelaReqBO.setContactCompany(addressInfoIntfceBO.getReceiverCompany());
        uocCoreCreateLogisticsRelaReqBO.setContactFixPhone(addressInfoIntfceBO.getReceiverFixPhone());
        uocCoreCreateLogisticsRelaReqBO.setContactMobile(addressInfoIntfceBO.getReceiverMobileNumber());
        uocCoreCreateLogisticsRelaReqBO.setContactName(addressInfoIntfceBO.getReceiverName());
        uocCoreCreateLogisticsRelaReqBO.setContactEmail(addressInfoIntfceBO.getReceiverEmail());
        uocCoreCreateLogisticsRelaReqBO.setContactCountryName(addressInfoIntfceBO.getReceiverCountryName());
        uocCoreCreateLogisticsRelaReqBO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        uocCoreCreateLogisticsRelaReqBO.setContactProvinceName(addressInfoIntfceBO.getReceiverProvinceName());
        uocCoreCreateLogisticsRelaReqBO.setContactProvinceId(addressInfoIntfceBO.getReceiverProvinceId());
        uocCoreCreateLogisticsRelaReqBO.setContactCityName(addressInfoIntfceBO.getReceiverCityName());
        uocCoreCreateLogisticsRelaReqBO.setContactCityId(addressInfoIntfceBO.getReceiverCityId());
        uocCoreCreateLogisticsRelaReqBO.setContactCountyName(addressInfoIntfceBO.getReceiverCountyName());
        return uocCoreCreateLogisticsRelaReqBO;
    }

    private String buildNo(String start, String voucherNoKey, String orderSource, PebExtAgreementCreateOrderReqBO reqBO) {
        UocProGetVoucherNoAtomRspBo voucherNoRsp;
        UocProGetVoucherNoAtomReqBo getBo = new UocProGetVoucherNoAtomReqBo();
        getBo.setVoucherNoKey(voucherNoKey);
        getBo.setBuynerNo(reqBO.getBuynerNo());
        getBo.setOrgId(reqBO.getCompanyId());
        Integer my = 2;
        if (my.equals(reqBO.getAgreementBO().getTradeMode())) {
            getBo.setOrderType(Integer.valueOf(1));
        } else {
            getBo.setOrderType(Integer.valueOf(2));
        }
        if (PebExtConstant.YES.equals(reqBO.getIsPersonal())) {
            getBo.setOrderSource("6");
            getBo.setOrderType(null);
        } else if (my.equals(reqBO.getAgreementBO().getTradeMode())) {
            getBo.setOrderSource("7");
            getBo.setOrderType(null);
        } else {
            getBo.setOrderSource(orderSource);
        }
        if (UocConstant.ORDER_SOURCE.CONTRACT.toString().equals(orderSource)) {
            if (StringUtils.isNotBlank((CharSequence)reqBO.getAgreementBO().getTrackNo())) {
                return this.contract(reqBO.getAgreementBO().getTrackNo(), 1);
            }
            getBo.setOrderSource(orderSource);
        }
        if (!"0000".equals((voucherNoRsp = this.uocProGetVoucherNoAtomService.getVoucherNo(getBo)).getRespCode())) {
            throw new UocProBusinessException("102107", voucherNoRsp.getRespDesc());
        }
        if (!voucherNoRsp.isVoucherGenerated()) {
            return this.buildNo(start);
        }
        return voucherNoRsp.getVoucherNo();
    }

    private String contract(String trackNo, int count) {
        String no = null;
        TrackNoPO po = new TrackNoPO();
        po.setTrackNo(trackNo);
        po = this.trackNoMapper.selectOne(po);
        if (po == null) {
            po = new TrackNoPO();
            po.setTrackNo(trackNo);
            po.setNum(Integer.valueOf(1));
            try {
                this.trackNoMapper.insert(po);
                no = po.getTrackNo() + "-" + po.getNum();
            }
            catch (Exception e) {
                if (count > 6) {
                    throw new UocProBusinessException("8888", "\u751f\u6210\u8ba2\u5355\u7f16\u53f7\u5931\u8d25");
                }
                count += count;
                no = this.contract(trackNo, count);
            }
        } else {
            try {
                po.setNum(Integer.valueOf(po.getNum() + 1));
                this.trackNoMapper.insert(po);
                no = po.getTrackNo() + "-" + po.getNum();
            }
            catch (Exception e) {
                if (count > 6) {
                    throw new UocProBusinessException("8888", "\u751f\u6210\u8ba2\u5355\u7f16\u53f7\u5931\u8d25");
                }
                count += count;
                no = this.contract(trackNo, count);
            }
        }
        return no;
    }

    private String buildNo(String start) {
        String date = DateUtils.dateToStr((Date)new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        return start + date + time.substring(time.length() - 6);
    }

    private void savePayConfInfo(PebExtAgreementCreateOrderReqBO reqBO, PebExtAgreementCreateOrderRspBO rspBO) {
        ArrayList<OrdPayConfPO> payConfPOS;
        ArrayList<PayConfDetailPO> detailPOList = new ArrayList<PayConfDetailPO>();
        if (UocCoreConstant.TradeMode.TRADE_MODEL.equals(reqBO.getAgreementBO().getTradeMode())) {
            payConfPOS = new ArrayList<OrdPayConfPO>(2);
            for (AgreementSettlementBO agreementSettlementBO : reqBO.getAgreementBO().getPaymentMethod()) {
                OrdPayConfPO payConfPO = new OrdPayConfPO();
                payConfPO.setId(Long.valueOf(this.idUtil.nextId()));
                payConfPO.setOrderId(rspBO.getOrderId());
                if ("1".equals(agreementSettlementBO.getSettlementObject())) {
                    payConfPO.setPayType(Integer.valueOf(agreementSettlementBO.getSettlementType()));
                    payConfPO.setUserType(UocCoreConstant.UserType.PRO);
                } else {
                    payConfPO.setPayType(reqBO.getPayType());
                    payConfPO.setUserType(UocCoreConstant.UserType.PUR);
                }
                if ("2".equals(String.valueOf(payConfPO.getPayType()))) {
                    if ("3".equals(agreementSettlementBO.getPayMethod())) {
                        payConfPO.setVerPaySup(new BigDecimal(100));
                    } else if ("2".equals(agreementSettlementBO.getPayMethod())) {
                        payConfPO.setPilPaySup(new BigDecimal(100));
                    }
                    if ("2".equals(agreementSettlementBO.getAssign())) {
                        payConfPO.setPayRule(Integer.valueOf(2));
                        payConfPO.setPaymentDays(Integer.valueOf(agreementSettlementBO.getSettlementDate()));
                    } else {
                        payConfPO.setPayRule(Integer.valueOf(1));
                        payConfPO.setPayAccountDay(Integer.valueOf(agreementSettlementBO.getSettlementDate()));
                    }
                } else {
                    payConfPO.setPrePaySup(agreementSettlementBO.getPrePay());
                    payConfPO.setVerPaySup(agreementSettlementBO.getComPay());
                    payConfPO.setPilPaySup(agreementSettlementBO.getTryPay());
                    payConfPO.setQuaPaySup(agreementSettlementBO.getQuaPay());
                }
                if (null == payConfPO.getPrePayFee()) {
                    payConfPO.setPrePayFee(Long.valueOf(0L));
                }
                payConfPO.setVerPayFee(Long.valueOf(0L));
                payConfPO.setPilPayFee(Long.valueOf(0L));
                payConfPO.setQuaPayFee(Long.valueOf(0L));
                payConfPO.setPilPayFee(Long.valueOf(0L));
                if (null != reqBO.getAgreementBO().getWarantty()) {
                    payConfPO.setWarantty(reqBO.getAgreementBO().getWarantty());
                }
                payConfPO.setIsPushQua(Integer.valueOf(0));
                payConfPO.setTime(new Date());
                payConfPO.setPayBreakScale(BigDecimal.ZERO);
                if ("2".equals(agreementSettlementBO.getPayMethod())) {
                    payConfPO.setPayAccountDayRule(Integer.valueOf(2));
                    payConfPO.setPayNodeRule(Integer.valueOf(2));
                } else if ("3".equals(agreementSettlementBO.getPayMethod())) {
                    payConfPO.setPayAccountDayRule(Integer.valueOf(3));
                    payConfPO.setPayNodeRule(Integer.valueOf(3));
                } else {
                    payConfPO.setPayAccountDayRule(Integer.valueOf(1));
                    payConfPO.setPayNodeRule(Integer.valueOf(1));
                }
                if (CollectionUtils.isNotEmpty((Collection)agreementSettlementBO.getDetailList())) {
                    for (AgrAgreementSettlementDetailBO bo : agreementSettlementBO.getDetailList()) {
                        PayConfDetailPO detailPO = new PayConfDetailPO();
                        detailPO.setId(Long.valueOf(this.idUtil.nextId()));
                        detailPO.setOrderId(rspBO.getOrderId());
                        detailPO.setPayConfId(payConfPO.getId());
                        detailPO.setPayType(bo.getMoneyType());
                        detailPO.setExt1(bo.getPanelPointName());
                        detailPO.setExt2(bo.getMoneyTypeStr());
                        if (StringUtils.isNotBlank((CharSequence)bo.getPanelPointCode())) {
                            detailPO.setPayNode(Integer.valueOf(Integer.parseInt(bo.getPanelPointCode())));
                        }
                        detailPO.setPayPercent(bo.getPayPercent());
                        detailPO.setPayDays(bo.getDays());
                        detailPOList.add(detailPO);
                    }
                }
                payConfPOS.add(payConfPO);
            }
        } else {
            payConfPOS = new ArrayList(1);
            for (AgreementSettlementBO agreementSettlementBO : reqBO.getAgreementBO().getPaymentMethod()) {
                OrdPayConfPO payConfPO = new OrdPayConfPO();
                if (!"1".equals(agreementSettlementBO.getSettlementObject())) continue;
                payConfPO.setId(Long.valueOf(this.idUtil.nextId()));
                payConfPO.setOrderId(rspBO.getOrderId());
                if ("1".equals(agreementSettlementBO.getSettlementObject())) {
                    payConfPO.setPayType(Integer.valueOf(agreementSettlementBO.getSettlementType()));
                    payConfPO.setUserType(UocCoreConstant.UserType.PUR);
                }
                if ("2".equals(String.valueOf(payConfPO.getPayType()))) {
                    if ("3".equals(agreementSettlementBO.getPayMethod())) {
                        payConfPO.setVerPaySup(new BigDecimal(100));
                    } else if ("2".equals(agreementSettlementBO.getPayMethod())) {
                        payConfPO.setPilPaySup(new BigDecimal(100));
                    }
                    if ("2".equals(agreementSettlementBO.getAssign())) {
                        payConfPO.setPayRule(Integer.valueOf(2));
                        payConfPO.setPaymentDays(Integer.valueOf(agreementSettlementBO.getSettlementDate()));
                    } else {
                        payConfPO.setPayRule(Integer.valueOf(1));
                        payConfPO.setPayAccountDay(Integer.valueOf(agreementSettlementBO.getSettlementDate()));
                    }
                } else {
                    payConfPO.setPrePaySup(agreementSettlementBO.getPrePay());
                    payConfPO.setVerPaySup(agreementSettlementBO.getComPay());
                    payConfPO.setPilPaySup(agreementSettlementBO.getTryPay());
                    payConfPO.setQuaPaySup(agreementSettlementBO.getQuaPay());
                }
                if (null != reqBO.getAgreementBO().getWarantty()) {
                    payConfPO.setWarantty(reqBO.getAgreementBO().getWarantty());
                }
                payConfPO.setIsPushQua(Integer.valueOf(0));
                payConfPO.setTime(new Date());
                payConfPO.setPayBreakScale(BigDecimal.ZERO);
                if ("2".equals(agreementSettlementBO.getPayMethod())) {
                    payConfPO.setPayAccountDayRule(Integer.valueOf(2));
                    payConfPO.setPayNodeRule(Integer.valueOf(2));
                } else if ("3".equals(agreementSettlementBO.getPayMethod())) {
                    payConfPO.setPayAccountDayRule(Integer.valueOf(3));
                    payConfPO.setPayNodeRule(Integer.valueOf(3));
                } else {
                    payConfPO.setPayAccountDayRule(Integer.valueOf(1));
                    payConfPO.setPayNodeRule(Integer.valueOf(1));
                }
                if (CollectionUtils.isNotEmpty((Collection)agreementSettlementBO.getDetailList())) {
                    for (AgrAgreementSettlementDetailBO bo : agreementSettlementBO.getDetailList()) {
                        PayConfDetailPO detailPO = new PayConfDetailPO();
                        detailPO.setId(Long.valueOf(this.idUtil.nextId()));
                        detailPO.setPayConfId(payConfPO.getId());
                        detailPO.setOrderId(rspBO.getOrderId());
                        detailPO.setPayType(bo.getMoneyType());
                        detailPO.setExt1(bo.getPanelPointName());
                        detailPO.setExt2(bo.getMoneyTypeStr());
                        if (StringUtils.isNotBlank((CharSequence)bo.getPanelPointCode())) {
                            detailPO.setPayNode(Integer.valueOf(Integer.parseInt(bo.getPanelPointCode())));
                        }
                        detailPO.setPayPercent(bo.getPayPercent());
                        detailPO.setPayDays(bo.getDays());
                        detailPOList.add(detailPO);
                    }
                }
                payConfPOS.add(payConfPO);
                break;
            }
        }
        this.ordPayConfMapper.insertBatch(payConfPOS);
        if (detailPOList.size() > 0) {
            this.payConfDetailMapper.insertBatch(detailPOList);
        }
    }
}

